/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************//*!
 * @file      lcd.c
 * @version   1.0.3.0
 * @date      Jan-22-2015
 * @brief     LCD controller (LCD) driver source code.
 *            optimized for TWR-KM34Z75M board  
 ******************************************************************************/
#include "common.h"
#include "slcd.h"

/******************************************************************************
 * data type definitions                                                      *
 ******************************************************************************/
static LCD_CALLBACK volatile pCallbackLCD=NULL;

/******************************************************************************
 * interrupt functions prototype                                              *
 ******************************************************************************/
void slcd_isr (void);

/******************************************************************************
 * local variable                                                             *
 ******************************************************************************/
uint8 LCD_CharPosition;

/******************************************************************************
 * Public functions definitions                                               *
 ******************************************************************************/
#if defined(__ICCARM__)
  #pragma diag_suppress=Pa082
#endif

void LCD_Init (tLCD lcd, tLCD_FP lcd_fp, tLCD_BP lcd_bp, tLCD_CP lcd_cp, 
               uint8 ip, LCD_CALLBACK pCallback)
{
  if (pCallback) { pCallbackLCD = pCallback; NVIC_SetIsr(INT_LCD,ip);} 
  /* Low power select                                                         */
  MCG_C1      |= MCG_C2_LP_MASK;              
  /* Enable LCD controller pins                                               */
  LCD_PENL     = lcd_fp.PENL;
  LCD_PENH     = lcd_fp.PENH;
  /* Enable LCD backplane controller pins                                     */
  LCD_BPENL    = lcd_bp.BPENL;
  LCD_BPENH    = lcd_bp.BPENH;
  /* Assign back planes  - 0 is BP1, 1 is BP2 etc                             */
  LCD_WF3TO0   = lcd_cp.WF0TO0;        
  LCD_WF7TO4   = lcd_cp.WF7TO4;        
  LCD_WF11TO8  = lcd_cp.WF11TO8;        
  LCD_WF15TO12 = lcd_cp.WF15TO12;        
  LCD_WF19TO16 = lcd_cp.WF19TO16;        
  LCD_WF23TO20 = lcd_cp.WF23TO20;        
  LCD_WF27TO24 = lcd_cp.WF27TO24;        
  LCD_WF31TO28 = lcd_cp.WF31TO28;        
  LCD_WF35TO32 = lcd_cp.WF35TO32;        
  LCD_WF39TO36 = lcd_cp.WF39TO36;        
  LCD_WF43TO40 = lcd_cp.WF43TO40;        
  LCD_WF47TO44 = lcd_cp.WF47TO44;        
  LCD_WF51TO48 = lcd_cp.WF51TO48;        
  LCD_WF55TO52 = lcd_cp.WF55TO52;        
  LCD_WF59TO56 = lcd_cp.WF59TO56;        
  LCD_WF63TO60 = lcd_cp.WF63TO60;        
  /* LCD controller control register setting                                  */
  LCD_AR       = lcd.AR;
  LCD_FDCR     = lcd.FDCR;
  LCD_GCR     |= lcd.GCR;
  /* LCD controller enable                                                    */
  LCD_GCR     |= LCD_GCR_LCDEN_MASK;
}

void LCD_GOTO (uint8 charPos) 
{ 
  LCD_CharPosition =  charPos; 
}

void LCD_Write_Segments(tLCD_CP lcd_cp )
{
  
  LCD_WF3TO0   = lcd_cp.WF0TO0;        
  LCD_WF7TO4   = lcd_cp.WF7TO4;        
  LCD_WF11TO8  = lcd_cp.WF11TO8;        
  LCD_WF15TO12 = lcd_cp.WF15TO12;        
  LCD_WF19TO16 = lcd_cp.WF19TO16;        
  LCD_WF23TO20 = lcd_cp.WF23TO20;        
  LCD_WF27TO24 = lcd_cp.WF27TO24;        
  LCD_WF31TO28 = lcd_cp.WF31TO28;        
  LCD_WF35TO32 = lcd_cp.WF35TO32;        
  LCD_WF39TO36 = lcd_cp.WF39TO36;        
  LCD_WF43TO40 = lcd_cp.WF43TO40;        
  LCD_WF47TO44 = lcd_cp.WF47TO44;        
  LCD_WF51TO48 = lcd_cp.WF51TO48;        
  LCD_WF55TO52 = lcd_cp.WF55TO52;        
  LCD_WF59TO56 = lcd_cp.WF59TO56;        
  LCD_WF63TO60 = lcd_cp.WF63TO60;        
}  

/******************************************************************************
 * interrupt functions definitions                                            *
 ******************************************************************************/
#if defined(__ICCARM__)
  #pragma diag_suppress=Pa082
#endif
__weak void slcd_isr (void)
{
  register uint32 tmp;
  
  if (pCallbackLCD != (LCD_CALLBACK)NULL) 
  {
      
      tmp = (LCD_AR & (LCD_AR_BLINK_MASK|LCD_AR_ALT_MASK|LCD_AR_BLANK_MASK|    \
                       LCD_AR_BMODE_MASK|LCD_AR_BRATE_MASK) );
    
      /* process LCD_AR_LCDIF interrupt                                       */
      if (tmp == LCD_AR_LCDIF_MASK)
      {
        pCallbackLCD (LCD_LCDIF_CALLBACK);
        LCD_AR   |= LCD_AR_LCDIF_MASK;                            
      }
    
      tmp = (LCD_FDSR & LCD_FDSR_FDCNT_MASK );
    
      /* process LCD_FDSR_FDCF interrupt                                      */
      if (tmp == LCD_FDSR_FDCF_MASK)
      {
        pCallbackLCD (LCD_FDCF_CALLBACK);
        LCD_FDSR |= LCD_FDSR_FDCF_MASK;                            
      }

  } 
}