/*****************************************************************************
 * (c) Copyright 2010-2012, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************//*!
 * @file      spi.c
 * @version   1.0.3.0
 * @date      Mar-12-2013
 * @brief     SPI driver source code.
 *
******************************************************************************/

#include "spi_flash.h"

struct macronix_spi_flash_params {
    uint16_t idcode;
    uint16_t block_num;
    const uint8_t *name;
};

static const struct macronix_spi_flash_params macronix_spi_flash_table[] = {
    {
        .idcode = 0x2017,
        .block_num = 128,
        .name = "MX25L6406EM2I-12G",
    },
};

int32_t spi_flash_init_macronix(struct spi_flash *flash, uint8_t *idcode)
{
    const struct macronix_spi_flash_params *params;
    uint32_t i;
    uint16_t id = idcode[2] | idcode[1] << 8;

    for (i = 0; i < ARRAY_SIZE(macronix_spi_flash_table); i++)
    {
        params = &macronix_spi_flash_table[i];
        if (params->idcode == id)
            break;
    }

    if (i == ARRAY_SIZE(macronix_spi_flash_table))
    {
        SF_DEBUG("SF: Unsupported Macronix ID!\r\n");
        return 1;
    }

    flash->page_size = 256;
    flash->sector_size = 256 * 16 * 16;
    flash->size = flash->sector_size * params->block_num;

    /* For read-only flash, need to clear BP */
    spi_flash_write_status(0);

    return 0;
}
