/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/

#ifndef __METERING_CONST_H__
#define __METERING_CONST_H__

#include "metering_modules.h"

volatile tMETERING_CONFIG_FLASH_DATA metering_cfg_data =
{
    /* basic power meter configuration data                                   */
    METER_SN,             /* Electricity meter serial number                  */
    1,                    /* tarif T1=1,T2=2,T3=3 and T4=4                    */ 
    0,                    /* number of pulses index for Wh generation   5k    */
    0,                    /* number of pulses index for VARh generation 5k    */ 
    48,                   /* VREFH trimming value                             */
    3,                    /* VREFL trimming value                             */
    /* pre-calibration data - user/measured inputs                            */  
    {
        CAL_VOLT,             /* preset calibration voltage [Vrms]                */
        0.0,                  /* measured voltage [Vrms]                          */
        CAL_CURR,             /* preset calibration current [Arms]                */
        0.0,                  /* measured current [Arms]                          */
        0.0,                 /* preset calibration angle [rad] = 0 degrees      */
        0.0,                  /* measured angle between voltage and current [rad] */
        0.0,                  /* measured active power [W]                        */
        0.0,                  /* measured reactive power [VAR]                    */
        FRAC32(-1.0),         /* measured maximum voltage- for offset calculation */
        FRAC32( 1.0),         /* measured minimum voltage- for offset calculation */
        FRAC32(-1.0),         /* measured maximum current- for offset calculation */
        FRAC32( 1.0),         /* measured minimum current- for offset calculation */
    },
    {
        CAL_VOLT,             /* preset calibration voltage [Vrms]                */
        0.0,                  /* measured voltage [Vrms]                          */
        CAL_CURR,             /* preset calibration current [Arms]                */
        0.0,                  /* measured current [Arms]                          */
        0.0,                 /* preset calibration angle [rad] = 0 degrees      */
        0.0,                  /* measured angle between voltage and current [rad] */
        0.0,                  /* measured active power [W]                        */
        0.0,                  /* measured reactive power [VAR]                    */
        FRAC32(-1.0),         /* measured maximum voltage- for offset calculation */
        FRAC32( 1.0),         /* measured minimum voltage- for offset calculation */
        FRAC32(-1.0),         /* measured maximum current- for offset calculation */
        FRAC32( 1.0),         /* measured minimum current- for offset calculation */
    },
    {
        CAL_VOLT,             /* preset calibration voltage [Vrms]                */
        0.0,                  /* measured voltage [Vrms]                          */
        CAL_CURR,             /* preset calibration current [Arms]                */
        0.0,                  /* measured current [Arms]                          */
        0.0,                 /* preset calibration angle [rad] = 0 degrees      */
        0.0,                  /* measured angle between voltage and current [rad] */
        0.0,                  /* measured active power [W]                        */
        0.0,                  /* measured reactive power [VAR]                    */
        FRAC32(-1.0),         /* measured maximum voltage- for offset calculation */
        FRAC32( 1.0),         /* measured minimum voltage- for offset calculation */
        FRAC32(-1.0),         /* measured maximum current- for offset calculation */
        FRAC32( 1.0),         /* measured minimum current- for offset calculation */
    },
#if POWER_METERING_ENABLE_LOAD_CALIB_DATA
    /* post-calibration data - calculated phase delay, offsets and gains      */
    {
        0,                    /* AFE ch0 CT delay angle flag */
#if POWER_METERING_USE_PDB_TRIGGER_ADC
        /* The duration between two afe triggers is about 2 * 61.44 / 6.144 = 20us
         * The adc need to be triggered after afe, so this value better to be
         * set to (2 * 61.44 / 6.144) * (BUS_CLK / 1000000) = 480
         */
        1,                    /* AFE ch0 vs SAR ch0 delay in modulator clocks     */
#elif POWER_METERING_USE_AFE_TRIGGER_ADC
        1,
#else
        1,
#endif
        0l,                    /* Angel */
        0l,                   /* current measurement offset (AFE ch1)             */
        FRAC32(-1.0),         /* current measurement gain (AFE ch1)               */
        0l,                   /* voltage measurement offset (AFE ch3)             */
        FRAC32(-1.0),         /* voltage measurement gain (AFE ch3)               */
    },
    {
        0,                    /* AFE ch1 CT delay angle flag */
#if POWER_METERING_USE_PDB_TRIGGER_ADC
        /* The duration between two afe triggers is about 2 * 61.44 / 6.144 = 20us
         * The adc need to be triggered after afe, so this value better to be
         * set to (2 * 61.44 / 6.144) * (BUS_CLK / 1000000) = 480
         */
        (POWER_METERING_PDB_CONT + 20),                    /* AFE ch1 vs SAR ch1 delay in modulator clocks     */
#elif POWER_METERING_USE_AFE_TRIGGER_ADC
        1,
#else
        1,
#endif
        0,                    /* Angel */
        0l,                   /* current measurement offset (AFE ch1)             */
        FRAC32(-1.0),         /* current measurement gain (AFE ch1)               */
        0l,                   /* voltage measurement offset (AFE ch3)             */
        FRAC32(-1.0),         /* voltage measurement gain (AFE ch3)               */
    },
    {
        0,                    /* AFE ch2 CT delay angle flag */
#if POWER_METERING_USE_PDB_TRIGGER_ADC
        /* The duration between two afe triggers is about 2 * 61.44 / 6.144 = 20us
         * The adc need to be triggered after afe, so this value better to be
         * set to (2 * 61.44 / 6.144) * (BUS_CLK / 1000000) = 480
         */
        (POWER_METERING_PDB_CONT * 2 + 20),                    /* AFE ch2 vs SAR ch2 delay in modulator clocks     */
#elif POWER_METERING_USE_AFE_TRIGGER_ADC
        1,
#else
        1,
#endif
        0,                   /* Angel */
        0l,                   /* current measurement offset (AFE ch1)             */
        FRAC32(-1.0),         /* current measurement gain (AFE ch1)               */
        0l,                   /* voltage measurement offset (AFE ch3)             */
        FRAC32(-1.0),         /* voltage measurement gain (AFE ch3)               */
    },
    /* configuration flag                                                     */
    CALI_FLAG_DEFAULT         /* 0xffff=read default configuration data           */
#else 
    /* real value */
    /* post-calibration data - calculated phase delay, offsets and gains      */
    {
        1,                      /* AFE ch0 CT delay angle flag */
        0x078F,                 /* AFE ch0 vs SAR ch0 delay in modulator clocks     */
        0,
        0,                      /* Angel */
        0xFFFFF6D4,             /* current measurement offset (AFE ch1)             */
        0x8D96326F,             /* current measurement gain (AFE ch1)               */
        0xFFDA8000,             /* voltage measurement offset (AFE ch3)             */
        0x85F277A2,             /* voltage measurement gain (AFE ch3)               */
    },
    {
        1,			/* AFE ch1 CT delay angle flag */
        0x07CD,                 /* AFE ch1 vs SAR ch1 delay in modulator clocks     */
        0,
        0,                      /* Angel */
        0xFFFFC1F7,             /* current measurement offset (AFE ch1)             */
        0x8D9793E4,             /* current measurement gain (AFE ch1)               */
        0xFFDAB600,             /* voltage measurement offset (AFE ch3)             */
        0x860D6C27,             /* voltage measurement gain (AFE ch3)               */
    },
    {
        1,			/* AFE ch2 CT delay angle flag */
        0x0809,                 /* AFE ch2 vs SAR ch2 delay in modulator clocks     */
        0,
        0,                      /* Angel */
        0x00005772,             /* current measurement offset (AFE ch1)             */
        0x8E0C737C,             /* current measurement gain (AFE ch1)               */
        0xFFDA8480,             /* voltage measurement offset (AFE ch3)             */
        0x85F314AB,             /* voltage measurement gain (AFE ch3)               */
    },
    /* configuration flag                                                     */
    CALI_FLAG_FIN               /* 0xffff=read default configuration data           */
#endif
};

const tMETERING_RUNTIME_DATA metering_runtime_initdata = 
{
    /* Basic power meter configuration data                                   */
    0l,                   /* active energy counter                            */ 
    0l,                   /* reactive energy counter                          */ 
    0,                    /* hardfault didn't occur                           */
    /* configuration flag                                                     */
    POWER_METERING_RUNTIME_DATA_VALID_FLAG                /* 0x5555=configuration valid                       */
};

/* Buid data and time formatting                                              */
#define _SEC_   ((__TIME__[6]==' '?0:__TIME__[6]-'0')*10+(__TIME__[7]-'0'))
#define _MIN_   ((__TIME__[3]==' '?0:__TIME__[3]-'0')*10+(__TIME__[4]-'0'))
#define _HOUR_  ((__TIME__[0]==' '?0:__TIME__[0]-'0')*10+(__TIME__[1]-'0'))
#define _DAY_   ((__DATE__[4]==' '?0:__DATE__[4]-'0')*10+(__DATE__[5]-'0'))
#define _MON_   (__DATE__[2] == 'n' ? 1                                       \
                :__DATE__[2] == 'b' ? 2                                       \
                :__DATE__[2] == 'r' ? (__DATE__[0] == 'M' ? 3 : 4)            \
                :__DATE__[2] == 'y' ? 5                                       \
                :__DATE__[2] == 'n' ? 6                                       \
                :__DATE__[2] == 'l' ? 7                                       \
                :__DATE__[2] == 'g' ? 8                                       \
                :__DATE__[2] == 'p' ? 9                                       \
                :__DATE__[2] == 't' ? 10                                      \
                :__DATE__[2] == 'v' ? 11 : 12)
#define _YEAR_  ((((__DATE__[7]-'0')*10+(__DATE__[8] -'0'))*10+               \
                   (__DATE__[9]-'0'))*10+(__DATE__[10]-'0'))
#define BUILD_DATE_TIME(t)                                                    \
{                                                                             \
  t.sec = _SEC_; t.min = _MIN_; t.hour = _HOUR_; t.day = _DAY_;               \
  t.mon = _MON_; t.year= _YEAR_;                                              \
}

#endif
