/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the metering functions using afe and adc
*/

#ifndef __METERING_FUNC_H__
#define __METERING_FUNC_H__

#include <stdint.h>

typedef enum
{
    METERING_STATUS_RUNNING,
    METERING_STATUS_STOPPING,
    METERING_STATUS_STOPPED
} tMETERING_Status_Flag;

int32_t metering_func_get_cur_p_q_total(double *p, double *q);
int32_t metering_func_get_cur_v_i_ph(double *v, double *i, uint32_t ph);
int32_t metering_func_get_cur_p_q_s_ph(double *p, double *q, double *s, uint32_t ph);
int32_t metering_func_init(void);
int32_t metering_func_set_hardfault_flag(void);
int32_t metering_func_vlpr_get_cur_i(double *i, uint32_t ph);
int32_t metering_func_stop_metering(void);
tMETERING_Status_Flag metering_func_get_status(void);
int32_t metering_func_hardware_init(void);
int32_t metering_func_vlpr_hardware_init(void);

#endif /* __METERING_FUNC_H__ */ 