/******************************************************************************
* (c) Copyright 2010-2015, Freescale Semiconductor Inc.
* ALL RIGHTS RESERVED.
***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "meterlib_cfg.h"
#include "drivers.h"
#include "fraclib.h"
//#include "meterlib.h"
//#include "meterliblp.h"
#include <stdint.h>
#include <string.h>

/*
This file implements the metering functions using afe and adc
*/

/******************************************************************************
* static data definitions
******************************************************************************/
/* this variable is stored in non-initialized ram                             */

#if 0
static tMETERING_Calib_Data_1PH *pcalib_data_ph1 = NULL;
static tMETERING_Calib_Data_1PH *pcalib_data_ph2 = NULL;
static tMETERING_Calib_Data_1PH *pcalib_data_ph3 = NULL;
#endif

static volatile frac32 u24_samplePh1, u24_samplePh2, u24_samplePh3,
                       i24_samplePh1, i24_samplePh2, i24_samplePh3;

static volatile double I_RMS_Ph1, I_RMS_Ph2, I_RMS_Ph3;
static volatile int32_t phrase_rotate;
#if 0
static volatile tMETERLIB3PH_DATA mlib_vlpr = METERLIB3PH_DATA_HILB_REMEZ_50HZ_VLPR;
#endif
/******************************************************************************
* callback function definitions
******************************************************************************/
static int32_t metering_func_vlpr_reset_variable(void)
{
    i24_samplePh1 = i24_samplePh2 = i24_samplePh3 = 0;

    return 0;
}

/* VLPR metering */
static void metering_func_vlpr_afe_ch0_callback(AFE_CH_CALLBACK_TYPE type, int32 result)
{
    if (type == COC_CALLBACK) 
    {
        i24_samplePh1 = AFE_ChRead(CH0);
    }
}

static void metering_func_vlpr_afe_ch1_callback(AFE_CH_CALLBACK_TYPE type, int32 result)
{
    if (type == COC_CALLBACK) 
    {
        i24_samplePh2 = AFE_ChRead(CH1);
    }
}

static void metering_func_vlpr_afe_ch2_callback(AFE_CH_CALLBACK_TYPE type, int32 result)
{
    if (type == COC_CALLBACK) 
    {
        i24_samplePh3 = AFE_ChRead(CH2);
        SWISR_HandlerFreqCall (0, 1200, 1200);
    }
}

static void metering_func_vlpr_auxcalc_swisr0_callback(void)
{ 
#if POWER_METERING_ENABLE_VREF_COMP
    vref_comp_update_cablib_cfg((tMETERING_CONFIG_FLASH_DATA *)&metering_cfg_data);
#endif

    SWISR_HandlerFreqCall(1, 1200, 4);
}

static void metering_func_vlpr_read_result_swisr1_callback(void)
{
#if 0
    METERLIB3PH_ReadIRMS((tMETERLIB3PH_DATA*)&mlib,
      			(double *)&I_RMS_Ph1,
                        (double *)&I_RMS_Ph2, 
                        (double *)&I_RMS_Ph3);
#endif
    /* Refresh watchdog Timer                                                   */
    WDOG_WriteRefreshSeq();
}

int32_t metering_func_vlpr_hardware_init(void)
{
    metering_func_vlpr_reset_variable();

    slcd_disp_set_num1_area(SLCD_DISP_VOL_CUR_PH1);

    /* VREF module must be initialized after SIM module                         */
    //vref_init((tMETERING_CONFIG_FLASH_DATA *)&metering_cfg_data);
  
    /* Software callbacks                                                       */
    SWISR_HandlerInit(0, PRI_LVL2, metering_func_vlpr_auxcalc_swisr0_callback);
    SWISR_HandlerInit(1, PRI_LVL3, metering_func_vlpr_read_result_swisr1_callback);

    /* When set, this bit enables the PLL in VLP modes. */
    SIM_CtrlPLLVLP(TRUE);
    /* clear LP bit, PLL not disabled,enable in bypass mode(BLPI-->FBI) */
    FLL_CtrlLP(FALSE);
    
    /* AFE module                                                               */
    SIM_SelAfePllClk(SIM_MCG_PLL_CLK);
    /* AFE sample rate = 768Khz / 1024 = 1200Hz(~166.7us), AFE channels delay = 2 * 70 / 6.144 = 22.768us */
    AFE_ChInit(CH0,
                AFE_CH_SWTRG_CCM_PGAOFF_CONFIG(DEC_OSR1024),
                (0 * POWER_METERING_SAR_CONT),
                PRI_LVL1,
                (AFE_CH_CALLBACK)metering_func_vlpr_afe_ch0_callback);
    AFE_ChInit (CH1,
                AFE_CH_SWTRG_CCM_PGAOFF_CONFIG(DEC_OSR1024),
                (2 * POWER_METERING_SAR_CONT),
                PRI_LVL1,
                (AFE_CH_CALLBACK)metering_func_vlpr_afe_ch1_callback);
    AFE_ChInit (CH2, 
                AFE_CH_SWTRG_CCM_PGAOFF_CONFIG(DEC_OSR1024), 
                (4 * POWER_METERING_SAR_CONT),
                PRI_LVL1,
                (AFE_CH_CALLBACK)metering_func_vlpr_afe_ch2_callback);
    /* PLL = 32768 Hz * 375 = 12288000 */
    /* AFE low power mode */
    AFE_Init(AFE_MODULE_LPM_RJFORMAT_CONFIG(AFE_PLL_CLK, AFE_DIV16, 12.288e6));

    AFE_SwTrigger(CH0 | CH1 | CH2);

    return 0;
}

int32_t metering_func_vlpr_get_cur_i(double *i, uint32_t ph)
{
    switch (ph)
    {
    case 0:
        *i = I_RMS_Ph1;
        break;
    case 1:
        *i = I_RMS_Ph2;
        break;
    case 2:
        *i = I_RMS_Ph3;
        break;
    default:
        return -1;
        break;
    }
  
    return 0;
}

/******************************************************************************
* End of module                                                              *
******************************************************************************/
