/**************************************************************************
* Copyright (c) 2015 Freescale Semiconductor;
* All Rights Reserved                       
*************************************************************************** 
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
***************************************************************************/
/**************************************************************************************
 * Filter-Based Metering Library Configuration File, Created: Thu Oct 29 13:48:33 2015
 **************************************************************************************
 * @TAGNAME       = METERLIB3PH_DATA_HILB_REMEZ_50HZ
 * @LOCKED        =         0
 * @FSAMPLE       =      1200
 * @DFACTOR       =         1
 * @IMAX          =  170.0000
 * @UMAX          =  525.0000
 * @FREQ          =        50
 * @COUNTERS_RES  =     10000
 * @PWR_THRESHOLD =    0.5000
 * @I_STARTING    =    0.0200
 * @APWR_OFS      =    0.0000
 * @RPWR_OFS      =    0.0000
 * @ENERGY_ATT    =    0.0000
 * @IMP_PER_KWH   =     50000
 * @IMP_PER_KVARH =     50000
 * @HPF_FCUT      =    3.0000
 * @LPF1_FCUT     =    5.0000
 * @LPF2_FCUT     =    3.0000
 * @KWIN_BETA     =    6.0672
 * @KWIN_GAIN     =    1.0000
 * @FIR_TAPS_CHG  =         0
 * @FIR_FREQ_MOD  =         0
 * @CUR_SENSOR    =         1
 * @LIB_TYPE      =         3
 * @MATH_TYPE     =         1
 * @KWH_ONLY      =         0
 * @MCU_CORE      =         1
 **************************************************************************************/

#ifndef __METERLIB_CFG_H
#define __METERLIB_CFG_H

/**************************************************************************************
 * General parameters and scaling coefficients
 **************************************************************************************/
#define POWER_METER            3PH     /*!< Power meter topology                      */
#define CURRENT_SENSOR   PROPORTIONAL  /*!< Current sensor output characteristic      */
#define LIBRARY_PREFIX    METERLIB     /*!< Library prefix; high-performance library  */

/* I_MAX, U_MAX, CAL_CURR, CAL_VOLT: depend on hw design
 *
 *	How to set the I_MAX?
 *		Sample current used SD ADC.
 *		From the datasheet, when PGA off, max Differential input range is 500mV.
 *		so V+ max = 250mv. Sample resistance is 4.7 (like R44)
 *		U = I * R, set K is CT ratio.
 *		Umax = 0.25V = (Imax * R / K),
 *		so Imax = 0.25 * K / R, 
 *		here K = 2500, R = 3.9, so Imax = 160.26A.
 *		any measured current value must less than I_MAX, so add some margin,
 *		set I_MAX = 170A.
 *
 *	How to set the U_MAX?
 *		It is a bit complex.
 *		Sample voltage used SAR ADC and Vref = 1.2V
 *		see power board, Rt is total resistance of source side.
 *		Rs is sample resistance, e.g. Rs = R42.
 *		one side of Rs is Vref/2, another side is Vadc( like SAR_AD8, VA_COMP)
 *
 *		Rt = P_R1 + P_R2 + P_R4 + P_R5 + P_R6 + P_R7 = 840K
 *		Rs = 1000.
 *
 *		current = (Vin - Vadc) / Rt = (Vadc - Vref/2) / Rs
 *		so 
 *			Vadc = Vref/2 + (Vin * Rs / Rt)
 *
 *		set K = Rt/Rs, Vadc max is Vref.
 *		So
 *			Vref = Vref/2 + (VINmax / K)
 *			VINmax = (Vref / 2) * ( Rt / Rs)
 *
 *		VINmax = (1.2 / 2) * (840K/1000) = 504
 *		add some margin, so set
 *			U_MAX = 525
 * */
#define I_MAX                 110.000  /*!< Maximal current I-peak in amperes         */
#define U_MAX                 800.000  /*!< Maximal voltage U-peak in volts           */
#define F_NOM                      50  /*!< Nominal frequency in Hz                   */
#define COUNTER_RES            400     /*!< Resolution of energy counters in inc/kWh  */
#define IMP_PER_KWH             50000  /*!< Impulses per kWh                          */
#define IMP_PER_KVARH           50000  /*!< Impulses per kVARh                        */
#define DECIM_FACTOR                1  /*!< Auxiliary calculations decimation factor  */
#define KWH_CALC_FREQ        1200.000  /*!< Sample frequency in Hz                    */
#define KVARH_CALC_FREQ      1200.000  /*!< Sample frequency in Hz                    */
/**************************************************************************************
 * Filter-based metering algorithm configuration structure
 **************************************************************************************/
#define METERLIB3PH_DATA_HILB_REMEZ_50HZ                                              \
{                                                                                     \
  U_MAX,                                                                              \
  I_MAX,                                                                              \
  FRAC32(((+0.5000)/(U_MAX*I_MAX/2.0))),                                              \
  FRAC32((+0.00350)/I_MAX),                                                           \
  1,                                                                                  \
  {{0l,0l,0l},{0l,0l,0l}},{{0l,0l,0l},{0l,0l,0l}},{{0l,0l,0l},{0l,0l,0l}},            \
  {{FRAC32(+0.99921521804155),FRAC32(-0.99921521804155),FRAC32(-0.99843043608309)}},  \
  {{FRAC32(+0.13165249758740),FRAC32(+0.13165249758740),FRAC32(-1.0)}},               \
  {{0l,0ll},{0l,0ll}},                                                                \
  {0l,0ll},                                                                           \
  {{0l,0ll},{0l,0ll}},                                                                \
  {{0l,0ll},{0l,0ll}},                                                                \
  {0l,0ll},                                                                           \
  {{0l,0ll},{0l,0ll}},                                                                \
  {{0l,0ll},{0l,0ll}},                                                                \
  {0l,0ll},                                                                           \
  {{0l,0ll},{0l,0ll}},                                                                \
  {  49,                                                                              \
    {                                                                                 \
      FRAC32(0.0),FRAC32(-0.00073728465714),FRAC32(0.0),FRAC32(-0.00196750272687),    \
      FRAC32(0.0),FRAC32(-0.00411945802255),FRAC32(0.0),FRAC32(-0.00756839142185),    \
      FRAC32(0.0),FRAC32(-0.01278720365088),FRAC32(0.0),FRAC32(-0.02040684105768),    \
      FRAC32(0.0),FRAC32(-0.03136483560542),FRAC32(0.0),FRAC32(-0.04728105184137),    \
      FRAC32(0.0),FRAC32(-0.07151114503989),FRAC32(0.0),FRAC32(-0.11276139617420),    \
      FRAC32(0.0),FRAC32(-0.20318408017719),FRAC32(0.0),FRAC32(-0.63356345988777),    \
      FRAC32(0.0),FRAC32(+0.63356345988777),FRAC32(0.0),FRAC32(+0.20318408017719),    \
      FRAC32(0.0),FRAC32(+0.11276139617420),FRAC32(0.0),FRAC32(+0.07151114503989),    \
      FRAC32(0.0),FRAC32(+0.04728105184137),FRAC32(0.0),FRAC32(+0.03136483560542),    \
      FRAC32(0.0),FRAC32(+0.02040684105768),FRAC32(0.0),FRAC32(+0.01278720365088),    \
      FRAC32(0.0),FRAC32(+0.00756839142185),FRAC32(0.0),FRAC32(+0.00411945802255),    \
      FRAC32(0.0),FRAC32(+0.00196750272687),FRAC32(0.0),FRAC32(+0.00073728465714),    \
      FRAC32(0.0)                                                                     \
    },                                                                                \
     25,                                                                              \
    {                                                                                 \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(-1.0)                                                                    \
    }                                                                                 \
  },                                                                                  \
  {                                                                                   \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,  \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l            \
    },                                                                                \
    0ll,                                                                              \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l      \
    },                                                                                \
    0l                                                                                \
  },                                                                                  \
  {                                                                                   \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,  \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l            \
    },                                                                                \
    0ll,                                                                              \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l      \
    },                                                                                \
    0l                                                                                \
  },                                                                                  \
  {                                                                                   \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,  \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l            \
    },                                                                                \
    0ll,                                                                              \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l      \
    },                                                                                \
    0l                                                                                \
  },                                                                                  \
  {  24,{0,0,0},{0,0,0}},                                                             \
  {                                                                                   \
    {FRAC32(+0.00130728645170),FRAC32(+0.00130728645170),FRAC32(-0.99738542709660)},  \
    {FRAC32(+0.00130728645170),FRAC32(+0.00130728645170),FRAC32(-0.99738542709660)},  \
  },                                                                                  \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {                                                                                   \
    FRAC48((+0.0000/(U_MAX*I_MAX))),FRAC32(+1.0000),  METERLIB_KWH_DR(   10000),      \
    {0ll,0ll,0ll},0ll,0l,FRAC16(-1.0),                                                \
    {FRAC32(+0.00779293629195),FRAC32(+0.00779293629195),FRAC32(-0.98441412741610)},  \
    {0ll,0ll,0ll},{0ll,0ll,0ll}                                                       \
  },                                                                                  \
  {                                                                                   \
    FRAC48((+0.0000/(U_MAX*I_MAX))),FRAC32(+1.0000),METERLIB_KVARH_DR(   10000),      \
    {0ll,0ll,0ll},0ll,0l,FRAC16(-1.0),                                                \
    {FRAC32(+0.00779293629195),FRAC32(+0.00779293629195),FRAC32(-0.98441412741610)},  \
    {0ll,0ll,0ll},{0ll,0ll,0ll}                                                       \
  }                                                                                   \
}

#define METERLIB3PH_DATA_HILB_REMEZ_50HZ_VLPR                                         \
{                                                                                     \
  U_MAX,                                                                              \
  I_MAX,                                                                              \
  FRAC32(((+0.5000)/(U_MAX*I_MAX/2.0))),                                              \
  FRAC32((+0.0035)/I_MAX),                                                            \
  1,                                                                                  \
  {{0l,0l,0l},{0l,0l,0l}},{{0l,0l,0l},{0l,0l,0l}},{{0l,0l,0l},{0l,0l,0l}},            \
  {{FRAC32(+0.99220706370805),FRAC32(-0.99220706370805),FRAC32(-0.98441412741610)}},  \
  {{FRAC32(+0.13165249758740),FRAC32(+0.13165249758740),FRAC32(-1.0)}},               \
  {{0l,0ll},{0l,0ll}},                                                                \
  {0l,0ll},                                                                           \
  {{0l,0ll},{0l,0ll}},                                                                \
  {{0l,0ll},{0l,0ll}},                                                                \
  {0l,0ll},                                                                           \
  {{0l,0ll},{0l,0ll}},                                                                \
  {{0l,0ll},{0l,0ll}},                                                                \
  {0l,0ll},                                                                           \
  {{0l,0ll},{0l,0ll}},                                                                \
  {  49,                                                                              \
    {                                                                                 \
      FRAC32(0.0),FRAC32(-0.00073728465714),FRAC32(0.0),FRAC32(-0.00196750272687),    \
      FRAC32(0.0),FRAC32(-0.00411945802255),FRAC32(0.0),FRAC32(-0.00756839142185),    \
      FRAC32(0.0),FRAC32(-0.01278720365088),FRAC32(0.0),FRAC32(-0.02040684105768),    \
      FRAC32(0.0),FRAC32(-0.03136483560542),FRAC32(0.0),FRAC32(-0.04728105184137),    \
      FRAC32(0.0),FRAC32(-0.07151114503989),FRAC32(0.0),FRAC32(-0.11276139617420),    \
      FRAC32(0.0),FRAC32(-0.20318408017719),FRAC32(0.0),FRAC32(-0.63356345988777),    \
      FRAC32(0.0),FRAC32(+0.63356345988777),FRAC32(0.0),FRAC32(+0.20318408017719),    \
      FRAC32(0.0),FRAC32(+0.11276139617420),FRAC32(0.0),FRAC32(+0.07151114503989),    \
      FRAC32(0.0),FRAC32(+0.04728105184137),FRAC32(0.0),FRAC32(+0.03136483560542),    \
      FRAC32(0.0),FRAC32(+0.02040684105768),FRAC32(0.0),FRAC32(+0.01278720365088),    \
      FRAC32(0.0),FRAC32(+0.00756839142185),FRAC32(0.0),FRAC32(+0.00411945802255),    \
      FRAC32(0.0),FRAC32(+0.00196750272687),FRAC32(0.0),FRAC32(+0.00073728465714),    \
      FRAC32(0.0)                                                                     \
    },                                                                                \
     25,                                                                              \
    {                                                                                 \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),FRAC16(0.0),        \
      FRAC16(-1.0)                                                                    \
    }                                                                                 \
  },                                                                                  \
  {                                                                                   \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,  \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l            \
    },                                                                                \
    0ll,                                                                              \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l      \
    },                                                                                \
    0l                                                                                \
  },                                                                                  \
  {                                                                                   \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,  \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l            \
    },                                                                                \
    0ll,                                                                              \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l      \
    },                                                                                \
    0l                                                                                \
  },                                                                                  \
  {                                                                                   \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,  \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l            \
    },                                                                                \
    0ll,                                                                              \
    {                                                                                 \
      0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l,0l      \
    },                                                                                \
    0l                                                                                \
  },                                                                                  \
  {  24,{0,0,0},{0,0,0}},                                                             \
  {                                                                                   \
    {FRAC32(+0.01292156453916),FRAC32(+0.01292156453916),FRAC32(-0.97415687092168)},  \
    {FRAC32(+0.01292156453916),FRAC32(+0.01292156453916),FRAC32(-0.97415687092168)},  \
  },                                                                                  \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {0ll,0ll,0l,0ll},                                                                   \
  {                                                                                   \
    FRAC48((+0.0000/(U_MAX*I_MAX))),FRAC32(+1.0000),  METERLIB_KWH_DR(   10000),      \
    {0ll,0ll,0ll},0ll,0l,FRAC16(-1.0),                                                \
    {FRAC32(+0.00779293629195),FRAC32(+0.00779293629195),FRAC32(-0.98441412741610)},  \
    {0ll,0ll,0ll},{0ll,0ll,0ll}                                                       \
  },                                                                                  \
  {                                                                                   \
    FRAC48((+0.0000/(U_MAX*I_MAX))),FRAC32(+1.0000),METERLIB_KVARH_DR(   10000),      \
    {0ll,0ll,0ll},0ll,0l,FRAC16(-1.0),                                                \
    {FRAC32(+0.00779293629195),FRAC32(+0.00779293629195),FRAC32(-0.98441412741610)},  \
    {0ll,0ll,0ll},{0ll,0ll,0ll}                                                       \
  }                                                                                   \
}

#endif /* __METERLIBCFG_H */
