/******************************************************************************
*
* (c) Copyright 2015, Freescale Semiconductor Inc.
*
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      rs485_parse.h
*
* @author    Freescale
*
* @version   1.0.0.0
*
* @date      Mar-13-2015
*
* @brief     Header file containing RS485 protocol
*
******************************************************************************/
#ifndef __RS485_PARSE_H
#define __RS485_PARSE_H

#include <string.h>

/* MAX input character number */
#define RS485_PARSE_CTRL_PIN               PIN1
#define RS485_PARSE_UART_TX_PIN            PIN2
#define RS485_PARSE_UART_RX_PIN            PIN3

/* PTK1 GPIO function as TX/RX control bit */
/* PTK1 configured output and output 0(default is Receiver) */
#define RS485_PARSE_CTRL_PIN_INIT()                                             \
        {                                                                       \
            PORT_Init(PORTA, PORT_MODULE_ALT1_MODE, RS485_PARSE_CTRL_PIN);      \
            GPIO_Init(GPIOA, GPIO_OUT_LOGIC0_MODE,  RS485_PARSE_CTRL_PIN);      \
        }

#define RS485_PARSE_IO_PIN_INIT()                                               \
        {                                                                       \
            PORT_Init (PORTA, PORT_MODULE_ALT2_MODE,                            \
                       RS485_PARSE_UART_RX_PIN | RS485_PARSE_UART_TX_PIN);      \
        }

#define RS485_PARSE_SET_TO_RECEIVER()                                           \
        {                                                                       \
            GPIO_Clr(GPIOA, RS485_PARSE_CTRL_PIN);                              \
        }

#define RS485_PARSE_SET_TO_TRANSMITER()                                         \
        {                                                                       \
            GPIO_Set(GPIOA, RS485_PARSE_CTRL_PIN);                              \
        }

int32_t rs485_parse_init(void);
int32_t rs485_parse_deinit(void);

#endif
