/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include <string.h>
#include <stdio.h>

/*
    This file implements spi flash access functions
*/
static void sf_access_ss_ctrl(SS_CONTROL ss_pin)
{
    if (ss_pin == SS_SET)
    {
        SF_ACCESS_CS_PIN_SET();
    }
    else if (ss_pin == SS_CLEAR)
    {
        SF_ACCESS_CS_PIN_CLR();
    }
}

int32_t sf_access_init(void)
{
    /* SPI1_PCS0, SPI1_MISO, SPI1_MOSI, SPI1_SCK */
    SF_ACCESS_SPI_CS_PIN_INIT();
    SF_ACCESS_SPI_MISO_INIT();
    SF_ACCESS_SPI_MOSI_INIT();
    SF_ACCESS_SPI_SCK_INIT();

    /* spi init */
    /* BaudRateDivisor = (SPPR + 1)  2^(SPR + 1) */
    SPI_Init(SPI1, SPI_MODULE_8B_POLL_CONFIG(POWER_METERING_SF_SPI_SPPR, POWER_METERING_SF_SPI_SPR), NULL, PRI_LVL1, NULL);

    /* spi flash init */
    spi_flash_init(sf_access_ss_ctrl, SPI1_CommByte);

    return 0;
}

int32_t sf_access_deinit(void)
{
    return 0;
}

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/