/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the RTC function for 1Hz compensation and tamper detection
*/

#ifndef __SF_ACCESS_H__
#define __SF_ACCESS_H__

#include "metering_modules.h"
#include <stdint.h>

/* PTH6 */
#define SF_CS_PIN       PIN6
#define SF_MISO_PIN     PIN1
#define SF_MOSI_PIN     PIN0
#define SF_SCK_PIN      PIN7

/* CS pin is initilized as gpio to be controlled manually */
#define SF_ACCESS_SPI_CS_PIN_INIT()                                             \
        {                                                                       \
            PORT_Init(PORTH, PORT_MODULE_ALT1_MODE, SF_CS_PIN);                 \
            GPIO_Init(GPIOH, GPIO_OUT_LOGIC1_MODE, SF_CS_PIN);                  \
        }

#define SF_ACCESS_SPI_MISO_INIT()                                               \
        {                                                                       \
            PORT_Init(PORTI, PORT_MODULE_ALT5_MODE, SF_MISO_PIN);               \
        }

#define SF_ACCESS_SPI_MOSI_INIT()                                               \
        {                                                                       \
            PORT_Init(PORTI, PORT_MODULE_ALT5_MODE, SF_MOSI_PIN);               \
        }

#define SF_ACCESS_SPI_SCK_INIT()                                                \
        {                                                                       \
            PORT_Init(PORTH, PORT_MODULE_ALT3_MODE, SF_SCK_PIN);                \
        }

#define SF_ACCESS_CS_PIN_SET()  GPIO_Set(GPIOH, SF_CS_PIN)
#define SF_ACCESS_CS_PIN_CLR()  GPIO_Clr(GPIOH, SF_CS_PIN)

int32_t sf_access_init(void);
int32_t sf_access_deinit(void);

#endif /* __SF_ACCESS_H__ */ 