/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include "slcd_engine/slcd_engine.h"
#include <string.h>
#include <math.h>
#include <stdio.h>

static tSLCD_Engine slcd_disp_engine;
static tSLCD_Disp_Meaning slcd_disp_mean = SLCD_DISP_KWA_KVAR_TOT;
static int32_t slcd_refresh_flag = 0;

static uint8_t slcd_disp_gpio_seg_pin[SLCD_PIN_NUM] =
{
    29, 28, 26, 47, 24, 45, 59, 57, 55, 54, 20, 18, 16, 14, 12, 10,
    8,  53, 6,  4,  2,  3,  5,  52, 7,  9,  11, 13, 15, 17, 19, 56
};

#if 0
static uint8_t slcd_disp_gpio_com_pin[SLCD_BACKPLANE_NUM] =
{
    58, 44, 23, 46, 25, 27, 31, 50
};
#endif

static int32_t slcd_disp_set_reg(int32_t lcd_pin, uint8_t pin_val, uint8_t pin_mask, int32_t on)
{
    uint8_t gpio_pin = 0;

    /* lcd _pin starts from 1 */
    gpio_pin = slcd_disp_gpio_seg_pin[lcd_pin - 1];

    SegmentsOFF(gpio_pin, pin_mask);
    if (on)
        SegmentsON(gpio_pin, pin_val);

    return 0;
}

static int32_t slcd_disp_pinmux_deinit(void)
{
    /* LCD2 - LCD29 */
    /* LCD2 - LCD6 */
    PORT_Init(PORTF, PORT_MODULE_ALT1_MODE,
              PIN3 | PIN4 | PIN5 | PIN6 | PIN7);
    GPIO_Init(GPIOF, GPIO_OUT_LOGIC0_MODE,
              PIN3 | PIN4 | PIN5 | PIN6 | PIN7);

    /* LCD7 - LCD20 */
    PORT_Init(PORTG, PORT_MODULE_ALT1_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6 | PIN7);
    GPIO_Init(GPIOG, GPIO_OUT_LOGIC0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6 | PIN7);
    
    PORT_Init(PORTH, PORT_MODULE_ALT1_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5);
    GPIO_Init(GPIOH, GPIO_OUT_LOGIC0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5);
    
    /* LCD23 - LCD29 */
    PORT_Init(PORTA, PORT_MODULE_ALT1_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6);
    GPIO_Init(GPIOA, GPIO_OUT_LOGIC0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6);

    /* LCD31 */
    PORT_Init(PORTB, PORT_MODULE_ALT1_MODE, PIN0);
    GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE,  PIN0);

    /* LCD44 - LCD47 */
    PORT_Init(PORTI, PORT_MODULE_ALT1_MODE,
              PIN4 | PIN5 | PIN6 | PIN7);
    GPIO_Init(GPIOI, GPIO_OUT_LOGIC0_MODE,
              PIN4 | PIN5 | PIN6 | PIN7);

    /* LCD50 */
    PORT_Init(PORTA, PORT_MODULE_ALT1_MODE, PIN2);
    GPIO_Init(GPIOA, GPIO_OUT_LOGIC0_MODE,  PIN2);

    /* LCD52 - LCD59 */
    PORT_Init(PORTA, PORT_MODULE_ALT1_MODE, PIN7);
    GPIO_Init(GPIOA, GPIO_OUT_LOGIC0_MODE,  PIN7);
    PORT_Init(PORTA, PORT_MODULE_ALT1_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6);
    GPIO_Init(GPIOA, GPIO_OUT_LOGIC0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6);

    /* Backlight */
    SLCD_BACKLIGHT_INIT();
    
    return 0;
}

static int32_t slcd_disp_pinmux_init(void)
{
    /* LCD2 - LCD29 */
    /* LCD2 - LCD6 */
    PORT_Init(PORTF, PORT_MODULE_ALT0_MODE,
              PIN3 | PIN4 | PIN5 | PIN6 | PIN7);

    /* LCD7 - LCD20 */
    PORT_Init(PORTG, PORT_MODULE_ALT0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6 | PIN7);
    
    PORT_Init(PORTH, PORT_MODULE_ALT0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5);
    
    /* LCD23 - LCD29 */
    PORT_Init(PORTA, PORT_MODULE_ALT0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6);

    /* LCD31 */
    PORT_Init(PORTB, PORT_MODULE_ALT0_MODE, PIN0);

    /* LCD44 - LCD47 */
    PORT_Init(PORTI, PORT_MODULE_ALT0_MODE,
              PIN4 | PIN5 | PIN6 | PIN7);

    /* LCD50 */
    PORT_Init(PORTA, PORT_MODULE_ALT0_MODE, PIN2);

    /* LCD52 - LCD59 */
    PORT_Init(PORTA, PORT_MODULE_ALT0_MODE, PIN7);
    PORT_Init(PORTA, PORT_MODULE_ALT0_MODE,
              PIN0 | PIN1 | PIN2 | PIN3 | PIN4 | PIN5 | PIN6);

    /* Backlight */
    SLCD_BACKLIGHT_INIT();
    
    return 0;
}

static int32_t slcd_disp_double_to_int(double real, uint32_t *sign_val, uint32_t *int_val, uint32_t *frag_val)
{
    if (real < 0)
    {
        *sign_val = 1;
        real = fabs(real);
    }

    *int_val = (uint32_t)real;
    real -= *int_val;
    real *= 1000;
    *frag_val = (uint32_t)real;

    return 0;
}

static int32_t slcd_disp_num_pos2_9(double disp_val)
{
    uint32_t int_val = 0, frac_val = 0, sign_val = 0;
    uint32_t ten_thousand_val = 0, thousand_val = 0,
             hundred_val = 0, decimal_val = 0, tmp_val = 0;

    if ((disp_val > 99999.999) || (disp_val < -99999.999))
        return -1;

    /* This function will display number from number pos 2 to number pos 9 */
    /* This display will have 4 decimals, so DP5 is on */
    slcd_disp_double_to_int(disp_val, &sign_val, &int_val, & frac_val);

    /* Show or clear negtive icon */
    if (sign_val)
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S53);
    else
        SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S53);

    /* Show DP5, point */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_DP6);

    /* Show integer part */
    /* % is slow, so avoid using it */
    ten_thousand_val = int_val / 10000;
    tmp_val      = int_val - ten_thousand_val * 10000;
    thousand_val = tmp_val / 1000;
    tmp_val      = tmp_val - thousand_val * 1000;
    hundred_val  = tmp_val / 100;
    tmp_val      = tmp_val - hundred_val * 100;
    decimal_val  = tmp_val / 10;
    tmp_val      = tmp_val - decimal_val * 10;

    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS2);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS3);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS4);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS5);
    /* Pos 6 is single, don't need to be cleared */
    //SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS6);
    if (int_val >= 10000)
        SLCD_Engine_Show_Num(&slcd_disp_engine, ten_thousand_val, NUM_POS2);

    if (int_val >= 1000)
        SLCD_Engine_Show_Num(&slcd_disp_engine, thousand_val, NUM_POS3);

    if (int_val >= 100)
        SLCD_Engine_Show_Num(&slcd_disp_engine, hundred_val, NUM_POS4);

    if (int_val >= 10)
        SLCD_Engine_Show_Num(&slcd_disp_engine, decimal_val, NUM_POS5);

    SLCD_Engine_Show_Num(&slcd_disp_engine, tmp_val, NUM_POS6);

    /* Show fragment part */
    hundred_val  = frac_val / 100;
    tmp_val      = frac_val - hundred_val * 100;
    decimal_val  = tmp_val / 10;
    tmp_val      = tmp_val - decimal_val * 10;

    SLCD_Engine_Show_Num(&slcd_disp_engine, hundred_val, NUM_POS7);
    SLCD_Engine_Show_Num(&slcd_disp_engine, decimal_val, NUM_POS8);
    SLCD_Engine_Show_Num(&slcd_disp_engine, tmp_val, NUM_POS9);

    return 0;
}

static int32_t slcd_disp_num_pos10_17(double disp_val)
{
    uint32_t int_val = 0, frac_val = 0, sign_val = 0;
    uint32_t ten_thousand_val = 0, thousand_val = 0,
             hundred_val = 0, decimal_val = 0, tmp_val = 0;

    if ((disp_val > 99999.999) || (disp_val < -99999.999))
        return -1;

    /* This function will display number from number pos 2 to number pos 9 */
    /* This display will have 4 decimals, so DP5 is on */
    slcd_disp_double_to_int(disp_val, &sign_val, &int_val, & frac_val);

    /* Show or clear negtive icon */
    if (sign_val)
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_10G);
    else
        SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_10G);

    /* Show DP5, point */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_DP12);

    /* Show integer part */
    /* % is slow, so avoid using it */
    ten_thousand_val = int_val / 10000;
    tmp_val      = int_val - ten_thousand_val * 10000;
    thousand_val = tmp_val / 1000;
    tmp_val      = tmp_val - thousand_val * 1000;
    hundred_val  = tmp_val / 100;
    tmp_val      = tmp_val - hundred_val * 100;
    decimal_val  = tmp_val / 10;
    tmp_val      = tmp_val - decimal_val * 10;

    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS11);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS12);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS13);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS14);
    if (int_val >= 10000)
        SLCD_Engine_Show_Num(&slcd_disp_engine, ten_thousand_val, NUM_POS11);

    if (int_val >= 1000)
        SLCD_Engine_Show_Num(&slcd_disp_engine, thousand_val, NUM_POS12);

    if (int_val >= 100)
        SLCD_Engine_Show_Num(&slcd_disp_engine, hundred_val, NUM_POS13);

    if (int_val >= 10)
        SLCD_Engine_Show_Num(&slcd_disp_engine, decimal_val, NUM_POS14);

    SLCD_Engine_Show_Num(&slcd_disp_engine, tmp_val, NUM_POS15);

    /* Show fragment part */
    hundred_val  = frac_val / 100;
    tmp_val      = frac_val - hundred_val * 100;
    decimal_val  = tmp_val / 10;

    SLCD_Engine_Show_Num(&slcd_disp_engine, hundred_val, NUM_POS16);
    SLCD_Engine_Show_Num(&slcd_disp_engine, decimal_val, NUM_POS17);

    return 0;
}

int32_t slcd_disp_show_cali_fin(void)
{
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S91);

    return 0;
}

int32_t slcd_disp_show_smart_card_detected(int32_t succ, int32_t on)
{
    if (on)
    {
        /* Show Card reading successfully */
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S92);
        if (succ)
            SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S94);
        else
            SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S95);
    }
    else
    {
        SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S92);
        SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S94);
        SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S95);
    }

    return 0;
}

static int32_t slcd_disp_show_basic_info(void)
{
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S6);
    /* Display 3 phrase */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S64);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S65);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S66);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S69);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S71);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S73);

    return 0;
}

static int32_t slcd_disp_show_voltage_current_icon(void)
{
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S38);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S43);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S44);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S59);
    //SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S60);

    return 0;
}

static int32_t slcd_disp_show_ph_icon(uint32_t ph)
{
    switch(ph)
    {
    case 0:
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S64);
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S69);
        break;
    case 1:
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S65);
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S71);
        break;
    case 2:
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S66);
        SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S73);
        break;
    }

    return 0;
}

static int32_t slcd_disp_show_kwar_kvar_icon(void)
{
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S16);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S45);
    /* Show kWA icon */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S15);
    /* Show kvar icon */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_S14);
    return 0;
}

static int32_t slcd_disp_show_power_icon(void)
{
    slcd_disp_show_kwar_kvar_icon();
    /* Display 3 phrase */
    slcd_disp_show_ph_icon(0);
    slcd_disp_show_ph_icon(1);
    slcd_disp_show_ph_icon(2);

    return 0;
}

int32_t slcd_disp_get_refresh_flag(void)
{
    return slcd_refresh_flag;
}

int32_t slcd_disp_set_refresh_flag(int32_t flag)
{
    slcd_refresh_flag = flag;

    return 0;
}

int32_t slcd_disp_refresh_vlpr(void)
{
    double tmp0 = 0.0, tmp1 = 0.0;

    switch (slcd_disp_mean)
    {
    case SLCD_DISP_VOL_CUR_PH1:
        metering_func_get_cur_v_i_ph(&tmp0, &tmp1, 0);
        /* Show number */
        slcd_disp_num_pos2_9(tmp1);
        break;
    case SLCD_DISP_VOL_CUR_PH2:
        metering_func_get_cur_v_i_ph(&tmp0, &tmp1, 1);
        /* Show number */
        slcd_disp_num_pos2_9(tmp1);
        break;
    case SLCD_DISP_VOL_CUR_PH3:
        metering_func_get_cur_v_i_ph(&tmp0, &tmp1, 2);
        /* Show number */
        slcd_disp_num_pos2_9(tmp1);
        break;
    default:
        NOP();
        break;
    }

    return 0;
}

int32_t slcd_disp_refresh(void)
{
    double tmp0 = 0.0, tmp1 = 0.0, tmp2 = 0.0;

    switch (slcd_disp_mean)
    {
    case SLCD_DISP_KWA_KVAR_TOT:
        metering_func_get_cur_p_q_total(&tmp0, &tmp1);
        break;
    case SLCD_DISP_KWA_KVAR_PH1:
        metering_func_get_cur_p_q_s_ph(&tmp0, &tmp1, &tmp2, 0);
        break;
    case SLCD_DISP_KWA_KVAR_PH2:
        metering_func_get_cur_p_q_s_ph(&tmp0, &tmp1, &tmp2, 1);
        break;
    case SLCD_DISP_KWA_KVAR_PH3:
        metering_func_get_cur_p_q_s_ph(&tmp0, &tmp1, &tmp2, 2);
        break;
    case SLCD_DISP_VOL_CUR_PH1:
        metering_func_get_cur_v_i_ph(&tmp0, &tmp1, 0);
        break;
    case SLCD_DISP_VOL_CUR_PH2:
        metering_func_get_cur_v_i_ph(&tmp0, &tmp1, 1);
        break;
    case SLCD_DISP_VOL_CUR_PH3:
        metering_func_get_cur_v_i_ph(&tmp0, &tmp1, 2);
        break;
    default:
        NOP();
        break;
    }
    /* Show number */
    slcd_disp_num_pos2_9(tmp0);
    slcd_disp_num_pos10_17(tmp1);

    return 0;
}

int32_t slcd_disp_get_num1_area(void)
{
    return (int32_t)slcd_disp_mean;
}

int32_t slcd_disp_set_num1_area(int32_t disp_mean)
{
    slcd_disp_mean = (tSLCD_Disp_Meaning)disp_mean;

    return 0;
}

int32_t slcd_disp_change_num1_area(tSLCD_Disp_Meaning disp_mean)
{
    if (disp_mean > SLCD_DISP_LAST)
        slcd_disp_mean = SLCD_DISP_KWA_KVAR_TOT;
    else
        slcd_disp_mean = disp_mean;

    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S14);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S15);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S16);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S38);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S43);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S44);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S45);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S59);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S60);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S64);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S65);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S66);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S69);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S71);
    SLCD_Engine_Clear_Icon(&slcd_disp_engine, ICON_S73);

    switch (slcd_disp_mean)
    {
    case SLCD_DISP_KWA_KVAR_TOT:
        slcd_disp_show_power_icon();
        break;
    case SLCD_DISP_KWA_KVAR_PH1:
        slcd_disp_show_kwar_kvar_icon();
        slcd_disp_show_ph_icon(0);
        break;
    case SLCD_DISP_KWA_KVAR_PH2:
        slcd_disp_show_kwar_kvar_icon();
        slcd_disp_show_ph_icon(1);
        break;
    case SLCD_DISP_KWA_KVAR_PH3:
        slcd_disp_show_kwar_kvar_icon();
        slcd_disp_show_ph_icon(2);
        break;
    case SLCD_DISP_VOL_CUR_PH1:
        slcd_disp_show_voltage_current_icon();
        slcd_disp_show_ph_icon(0);
        break;
    case SLCD_DISP_VOL_CUR_PH2:
        slcd_disp_show_voltage_current_icon();
        slcd_disp_show_ph_icon(1);
        break;
    case SLCD_DISP_VOL_CUR_PH3:
        slcd_disp_show_voltage_current_icon();
        slcd_disp_show_ph_icon(2);
        break;
    default:
        break;
    }

    slcd_disp_refresh();

    return 0;
}

int32_t slcd_disp_show_all(void)
{
    LCD_Write_Segments(LCD_ALL_SEGMENTS_ON_METERING);

    return 0;
}

int32_t slcd_disp_clear_all(void)
{
    LCD_Write_Segments(LCD_ALL_SEGMENTS_OFF_METERING);

    return 0;
}

int32_t slcd_disp_backlight_ctrl(int32_t on)
{
    if (on)
        SLCD_BACKLIGHT_ON();
    else
        SLCD_BACKLIGHT_OFF();

    return 0;
}

int32_t slcd_disp_show_run_cnt(void)
{
    static int32_t run_counter = 1;
    int32_t tmp_val = run_counter / 10;

    SLCD_Engine_Show_Num(&slcd_disp_engine, (run_counter - tmp_val * 10), NUM_POS19);
    SLCD_Engine_Show_Num(&slcd_disp_engine, tmp_val, NUM_POS18);
    /* Run counter will be shown on NUM POS 18 and 19 */
    if (++run_counter > 60)
        run_counter = 1;
    return 0;
}

int32_t slcd_disp_init(void)
{
    slcd_disp_pinmux_init();

    LCD_Init(LCD_CHARGEPUMP_EN_SOURCE_ALT_BACKPLANES_8,                       \
            LCD_FRONT_PLANE_PINS_METERING, LCD_BACK_PLANE_PINS_METERING,       \
            LCD_ASSIGN_BACK_PLANES_METERING, 0, NULL);

    memset(&slcd_disp_engine, 0, sizeof(tSLCD_Engine));
    SLCD_Engine_Init(&slcd_disp_engine, slcd_disp_set_reg);

    slcd_disp_clear_all();
    slcd_disp_show_basic_info();
    slcd_disp_change_num1_area(SLCD_DISP_KWA_KVAR_TOT);

    /* Use iRTC 1Hz for display */
    /* iRTC is initilized in rtc_comp.c. Here we only need to enable 1Hz interrupt */
    IRTC_EnableIsr(IRTC_1HZ_MASK);

    return 0;
}

int32_t slcd_disp_deinit(void)
{
    slcd_disp_pinmux_deinit();

    IRTC_DisableIsr(IRTC_1HZ_MASK);

    return 0;
}

#if POWER_METERING_ENABLE_ESD_TEST_MODE
int32_t slcd_disp_show_reset_source(void)
{
    uint16_t tmp16 = 0;
    uint8_t  tmp8  = 0, i = 0;

    /* Reset source will be show on NumPos 10, 11, 12, 13 */
    /* NumPos 10 and 11 shows SRS0, NumPos 12 and 13 shows SRS1 */
    /* tmp16 = ((uint16)RCM_SRS0|(((uint16)RCM_SRS1)<<8))  */
    tmp16 = RCM_GetResetSrc();

    /* Num Pos 2 - 9 will display RCM_SRS0 */
    tmp8 = tmp16 & 0xff;
    for (i = 0; i < 8; ++i)
    {
        if ((tmp8 >> i) & 0x1)
            SLCD_Engine_Show_Num(&slcd_disp_engine, 1, NUM_POS9 - i);
        else
            SLCD_Engine_Show_Num(&slcd_disp_engine, 0, NUM_POS9 - i);
    }

    tmp8 = tmp16 >> 8;
    for (i = 0; i < 8; ++i)
    {
        if ((tmp8 >> i) & 0x1)
            SLCD_Engine_Show_Num(&slcd_disp_engine, 1, NUM_POS17 - i);
        else
            SLCD_Engine_Show_Num(&slcd_disp_engine, 0, NUM_POS17 - i);
    }

    return 0;
}

int32_t slcd_display_show_hardfault(void)
{
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS2);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS3);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS4);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS5);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS6);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS7);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS8);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS9);

    /* Show HF at number pos 2 - 9 */
    /* Show H */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2G);

    /* Show F */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3G);

    /* Show H */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4G);

    /* Show F */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5G);

    /* Show H */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6G);

    /* Show F */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7G);

    /* Show H */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8G);

    /* Show F */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9G);

    return 0;
}

int32_t slcd_display_show_nmi(void)
{
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS2);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS3);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS4);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS5);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS6);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS7);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS8);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS9);

    /* Show n */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2G);
    
    /* Show m */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3D);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3G);

    /* Show I */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4F);

    /* Show n */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5G);
    
    /* Show m */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6D);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6G);

    /* Show I */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7F);
    
    /* Show n */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8G);
    
    /* Show m */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9D);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9G);

    return 0;
}

int32_t slcd_display_show_tamper(void)
{
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS2);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS3);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS4);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS5);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS6);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS7);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS8);
    SLCD_Engine_Clear_Num(&slcd_disp_engine, NUM_POS9);

    /* Show t */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_2G);
    
    /* Show m */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3D);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_3G);

    /* Show P */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_4G);

    /* Show R */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_5G);
    
    /* Show t */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_6G);
    
    /* Show m */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7D);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_7G);

    /* Show P */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_8G);

    /* Show R */
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9A);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9B);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9C);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9E);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9F);
    SLCD_Engine_Show_Icon(&slcd_disp_engine, ICON_9G);

    return 0;
}

#endif

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/
