/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
/*
    This file implements the slcd display functions
*/

#ifndef __SLCD_DISP_H__
#define __SLCD_DISP_H__

#include "metering_modules.h"
#include <stdint.h>

#define SLCD_BACKLIGHT_PIN          PIN1

#define SLCD_BACKLIGHT_INIT()                                                   \
            {                                                                   \
                PORT_Init(PORTB, PORT_MODULE_ALT1_MODE, SLCD_BACKLIGHT_PIN);    \
                GPIO_Init(GPIOB, GPIO_OUT_LOGIC0_MODE,  SLCD_BACKLIGHT_PIN);    \
            }
#define SLCD_BACKLIGHT_ON()             GPIO_Set(GPIOB, SLCD_BACKLIGHT_PIN)
#define SLCD_BACKLIGHT_OFF()            GPIO_Clr(GPIOB, SLCD_BACKLIGHT_PIN)
#define SLCD_BACKLIGHT_STATUS()         (FGPIOB_PDOR & SLCD_BACKLIGHT_PIN)

typedef enum
{
    SLCD_DISP_KWA_KVAR_TOT,
    SLCD_DISP_KWA_KVAR_PH1,
    SLCD_DISP_KWA_KVAR_PH2,
    SLCD_DISP_KWA_KVAR_PH3,
    SLCD_DISP_VOL_CUR_PH1,
    SLCD_DISP_VOL_CUR_PH2,
    SLCD_DISP_VOL_CUR_PH3,
    SLCD_DISP_LAST = SLCD_DISP_VOL_CUR_PH3
} tSLCD_Disp_Meaning;

int32_t slcd_disp_show_cali_fin(void);
int32_t slcd_disp_show_smart_card_detected(int32_t succ, int32_t on);
int32_t slcd_disp_get_refresh_flag(void);
int32_t slcd_disp_set_refresh_flag(int32_t flag);
int32_t slcd_disp_refresh(void);
int32_t slcd_disp_refresh_vlpr(void);
int32_t slcd_disp_init(void);
int32_t slcd_disp_deinit(void);
int32_t slcd_disp_change_num1_area(tSLCD_Disp_Meaning disp_mean);
int32_t slcd_disp_get_num1_area(void);
int32_t slcd_disp_set_num1_area(int32_t disp_mean);
int32_t slcd_disp_show_all(void);
int32_t slcd_disp_clear_all(void);
int32_t slcd_disp_backlight_ctrl(int32_t on);
int32_t slcd_disp_show_run_cnt(void);
#if POWER_METERING_ENABLE_ESD_TEST_MODE
int32_t slcd_disp_show_reset_source(void);
int32_t slcd_display_show_hardfault(void);
int32_t slcd_display_show_nmi(void);
int32_t slcd_display_show_tamper(void);
#endif

#endif /* __SLCD_DISP_H__ */ 