/*
 * Copyright (c) 2013-2015, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "slcd_engine.h"
#include <stdio.h>
#include <stdint.h>

int32_t SLCD_Engine_Clear_Num(tSLCD_Engine *slcd_engine, int32_t pos)
{
    uint8_t slcd_pin = 0, pin_val = 0;
    const uint16_t **ppSLCD_NumPos = SLCD_NumPos[pos];
    const uint16_t *pSLCD_NumPosNVal = NULL;

    if (pos < 0 || pos >= NUM_POSEND)
        return -1;

    /* A number is comprised of several bytes' value */
    for (pSLCD_NumPosNVal = ppSLCD_NumPos[8]; *pSLCD_NumPosNVal != 0;
         pSLCD_NumPosNVal++)
    {
        slcd_pin = *pSLCD_NumPosNVal >> 8;
        pin_val = *pSLCD_NumPosNVal & 0xff;
        slcd_engine->slcd_set_pin_func(slcd_pin, pin_val, pin_val, 0);
    }
    
    return 0;
}

int32_t SLCD_Engine_Show_Num(tSLCD_Engine *slcd_engine,
                                int32_t num, int32_t pos)
{
    uint8_t slcd_pin = 0, pin_val = 0, pin_mask = 0;
    const uint16_t **ppSLCD_NumPos = SLCD_NumPos[pos];
    const uint16_t *pSLCD_NumPosNVal = NULL;
    const uint16_t *pSLCD_NumPos8Mask = NULL; /* 8 is mask value */

    if (pos < 0 || pos >= NUM_POSEND)
        return -1;

    /* A number is comprised of several bytes' value */
    for (pSLCD_NumPosNVal = ppSLCD_NumPos[num], pSLCD_NumPos8Mask = ppSLCD_NumPos[8];
         *pSLCD_NumPosNVal != 0;
         pSLCD_NumPosNVal++, pSLCD_NumPos8Mask++)
    {
        slcd_pin = *pSLCD_NumPosNVal >> 8;
        pin_val = *pSLCD_NumPosNVal & 0xff;
        pin_mask = *pSLCD_NumPos8Mask & 0xff;
        slcd_engine->slcd_set_pin_func(slcd_pin, pin_val, pin_mask, 1);
    }
    
    return 0;
}

int32_t SLCD_Engine_Show_Icon(tSLCD_Engine *slcd_engine, int32_t icon_pos)
{
    int32_t slcd_pin = 0, pin_val = 0;
    uint16_t pos_val = SLCD_Icon[icon_pos];

    if (icon_pos < 0 || icon_pos >= ICON_END)
        return -1;

    slcd_pin = pos_val >> 8;
    pin_val = pos_val & 0xff;
    slcd_engine->slcd_set_pin_func(slcd_pin, pin_val, pin_val, 1);
    
    return 0;
}

int32_t SLCD_Engine_Clear_Icon(tSLCD_Engine *slcd_engine, int32_t icon_pos)
{
    uint8_t slcd_pin = 0, pin_val = 0;
    uint16_t pos_val = SLCD_Icon[icon_pos];

    if (icon_pos < 0 || icon_pos >= ICON_END)
        return -1;

    slcd_pin = pos_val >> 8;
    pin_val = pos_val & 0xff;
    slcd_engine->slcd_set_pin_func(slcd_pin, pin_val, pin_val, 0);
    
    return 0;
}

int32_t SLCD_Engine_Init(tSLCD_Engine *slcd_engine, SLCD_SET_PIN_FUNC pslcd_hw_handler)
{
    slcd_engine->slcd_set_pin_func = pslcd_hw_handler;
    
    return 0;
}
/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/
