/******************************************************************************
 * (c) Copyright 2010-2015, Freescale Semiconductor Inc.
 * ALL RIGHTS RESERVED.
 ***************************************************************************/
#include "common.h"
#include "metering_modules.h"
#include "drivers.h"
#include <string.h>
#include <stdio.h>

/*
    This file implements uart callback functions
*/
static int32_t uart_handler_smart_card_evt(UART_CALLBACK_TYPE type, int32 status)
{
#if POWER_METERING_SMART_CARD_SUPPORT
    smart_card_iso7816_evt_hdl(type, status);
#endif
    return 0;
}

static int32_t uart_handler_rs485_evt(UART_CALLBACK_TYPE type, int32 status)
{
    uint8_t tmp = 0;

    switch (type)
    {
    case UART_TX_CALLBACK:
        NOP();
        break;
    case UART_RX_CALLBACK:
        tmp = UART_GetChar(UART0);
        rs485_shell_getc(tmp);
        break;
    case UART_ER_CALLBACK:
        NOP();
        break;
    case UART_EDG_CALLBACK:
        NOP();
        break;
    default:
        break;
    }

    return 0;
}

static int32_t uart_handler_irda_evt(UART_CALLBACK_TYPE type, int32 status)
{
    return 0;
}

static int32_t uart_handler_esam_evt(UART_CALLBACK_TYPE type, int32 status)
{
    return 0;
}

static void uart_handler_evt_callback(UART_CALLBACK_SRC module, UART_CALLBACK_TYPE type, 
                           int32_t status)
{
    switch (module)
    {
    case UART0_CALLBACK:
        /* UART0 is RS485 */
        uart_handler_rs485_evt(type, status);
        break;
    case UART1_CALLBACK:
        /* UART1 is smart card */
        uart_handler_smart_card_evt(type, status);
        break;
    case UART2_CALLBACK:
        /* UART2 is IRDA */
        uart_handler_irda_evt(type, status);
        break;
    case UART3_CALLBACK:
        /* UART3 is ESAM */
        uart_handler_esam_evt(type, status);
        break;
    default:
        break;
    }
}

int32_t uart_handler_init(void)
{
    UART_InstallCallback (UART0_UART1, PRI_LVL2, uart_handler_evt_callback);

    return 0;
}

/******************************************************************************
 * End of module                                                              *
 ******************************************************************************/