#include "drivers.h"
#include "debug_console.h"
#include <stdint.h>
#include <stdio.h>

void main (void)
{
  /* enable clocks to all on chip peripherals                                 */
  SIM_Init (SIM_MODULE_ALL_PERIPH_ON_CONFIG);

  /* route core clock to PTF7                                                 */
  SIM_SelClkout (CLKOUT_SRC2);
  PORT_Init (PORTF,PORT_MODULE_ALT3_MODE,PIN7);
  
  /* clock mode 1:1:1, 24MHz                                                  */
  SIM_SetClkMode (SYSCLK_MODE0); 
  SIM_SetClkDiv  (SYSCLK_DIV1);  
  FLL_Init  (FLL_MODULE_FEE_24MHZ_CONFIG);


  /* debug uart pin init */
  PORT_Init (PORTI, PORT_MODULE_ALT2_MODE, PIN6 | PIN7);
  dbg_console_init(9600, 24e6);
  
  printf("Hello, KM!\r\n");

  while(1);
}
