/*! *********************************************************************************
* \addtogroup FSCI_HOST_BLE
* @{
********************************************************************************** */
/*!
* Copyright(c) 2015, Freescale Semiconductor, Inc.
* All rights reserved.
*
* \file fsci_ble_gatt_db_app_types.c
* This is a source file for FSCI Host BLE management.
*
* Redistribution and use in source and binary forms, with or without modification,
* are permitted provided that the following conditions are met:
*
* o Redistributions of source code must retain the above copyright notice, this list
*   of conditions and the following disclaimer.
*
* o Redistributions in binary form must reproduce the above copyright notice, this
*   list of conditions and the following disclaimer in the documentation and/or
*   other materials provided with the distribution.
*
* o Neither the name of Freescale Semiconductor, Inc. nor the names of its
*   contributors may be used to endorse or promote products derived from this
*   software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
*(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/************************************************************************************
*************************************************************************************
* Include
*************************************************************************************
************************************************************************************/

#include "fsci_ble_gatt_db_app_types.h"

/************************************************************************************
*************************************************************************************
* Private constants & macros
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private type definitions
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Private functions prototypes
*************************************************************************************
************************************************************************************/

/************************************************************************************
*************************************************************************************
* Public functions
*************************************************************************************
************************************************************************************/

void fsciBleGattDbAppGetCharPresFormatFromBuffer(gattDbCharPresFormat_t* pCharPresFormat, uint8_t** ppBuffer)
{
    fsciBleGetUint8ValueFromBuffer(pCharPresFormat->format, *ppBuffer);
    fsciBleGetUint8ValueFromBuffer(pCharPresFormat->exponent, *ppBuffer);
    fsciBleGetUint16ValueFromBuffer(pCharPresFormat->unitUuid16, *ppBuffer);
    fsciBleGetUint8ValueFromBuffer(pCharPresFormat->ns, *ppBuffer);
    fsciBleGetUint16ValueFromBuffer(pCharPresFormat->description, *ppBuffer);
}


void fsciBleGattDbAppGetBufferFromCharPresFormat(gattDbCharPresFormat_t* pCharPresFormat, uint8_t** ppBuffer)
{
    fsciBleGetBufferFromUint8Value(pCharPresFormat->format, *ppBuffer);
    fsciBleGetBufferFromUint8Value(pCharPresFormat->exponent, *ppBuffer);
    fsciBleGetBufferFromUint16Value(pCharPresFormat->unitUuid16, *ppBuffer);
    fsciBleGetBufferFromUint8Value(pCharPresFormat->ns, *ppBuffer);
    fsciBleGetBufferFromUint16Value(pCharPresFormat->description, *ppBuffer);  
}

/************************************************************************************
*************************************************************************************
* Private functions
*************************************************************************************
************************************************************************************/

/*! *********************************************************************************
* @}
********************************************************************************** */
