/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "Scrambler.h"

/*******************************************************************************
 * Code
 ******************************************************************************/
 
void Whiten(Whitener_config_t *whitenerConfig, uint8_t *pBuff, uint8_t buffLength)
{
    uint32_t initialState = (whitenerConfig->whitenInit << (32 - whitenerConfig->whitenSize));
    uint32_t polyValue = (whitenerConfig->whitenPoly << (32 - whitenerConfig->whitenSize));
    uint32_t currentValue = 0;
    
    for (uint16_t i = whitenerConfig->whitenStartOffset; i < buffLength - whitenerConfig->whitenEndOffset; i++)
    {
        currentValue = pBuff[i];
            
        if (whitenerConfig->whitenPolyType == 0)
        {
            for (uint8_t j = 0; j < 8; j++)
            {
                if (initialState & 0x80000000U)
                {
                    initialState = (initialState << 1);
                    initialState ^= polyValue;
                        
                    if (whitenerConfig->whitenRefIn == gWhitenRefInput)
                    {
                        currentValue = currentValue ^ (0x80 >> j);
                    }
                    else
                    {
                        currentValue = currentValue ^ (0x1 << j);
                    }
                }
                else
                {
                    initialState = initialState << 1;
                }
            }                          
        }
            
        pBuff[i] = currentValue;
        }    
}