/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "main.h"
#include "timer.h"

volatile uint16_t cycle_counter;

#if defined(MCU_MK21DN512) || defined(MCU_MK21DX256)
    #define full_range 356 /* (0xFFFFFF / 48000000 * 1000) */
#elif defined(MCU_MKW40Z160) || defined(MCU_MKW41Z512)
    #define full_range 524 /* (0xFFFFFF / 32000000 * 1000) */
#else
    #define full_range 800 /* (0xFFFFFF / 20971520 * 1000) */
#endif

void StartTimer()
{
    /* make sure we dont count while before resetting the values */
    StopTimer();
    /* set maximum range */
    SYST_RVR = 0xFFFFFF;
    /* reset cycle counter */
    cycle_counter = 0;
    /* reset counter */
    SYST_CVR = 0;
    /* enable the module and start counting */
    SYST_CSR = (SysTick_CSR_CLKSOURCE_MASK | SysTick_CSR_ENABLE_MASK | SysTick_CSR_TICKINT_MASK);
}
void StopTimer()
{
    /* disable the module */
    SYST_CSR &= (~SysTick_CSR_ENABLE_MASK);
}
/* returns elapsed miliseconds */
uint32_t GetElapsedTime()
{
    return cycle_counter * full_range + ((10000 - ((unsigned long long)SYST_CVR * 10000 / 0xFFFFFF)) / (10000 / full_range));
}
void SysTickHandler(void)
{
    cycle_counter++;
}
