	#define ONLINE_SKC1 0x753F924E
	#define ONLINE_SKC2 0x8AC06DB1  
	#define CONCURRENT 0x80000000
	#define SEQUENTIAL 0x00000000
	#define NLBIST 4
	#define NMBIST 47

#include "typedefs.h"
#include "MPC5746R_501.h"
int i,mbist_algo;
			
	uint32_t LBIST_PCS[] = {2150, 2000, 2100, 2750}; 
	uint32_t LBIST_MISRELSW[4][4] = {
		{0xFDC31B19, 0xd8e3627d, 0x4A32B225, 0xEED3E3B7},   //config0 - MISR for Memories scan chains bypassed for Rainier2B
		{0xFDC31B19, 0xd8e3627d, 0x4A32B225, 0xEED3E3B7},   //config1 - MISR for Memories scan chains bypassed for Rainier2B
		{0xFDC31B19, 0xd8e3627d, 0x4A32B225, 0xEED3E3B7},   //
		{0xFDC31B19, 0xd8e3627d, 0x4A32B225, 0xEED3E3B7}};  //
	uint32_t LBIST_MISREHSW[4][4] = {
		{0x18F2A1F5, 0xac001775, 0x765D7C3D, 0xB489FD55},   //config0 - MISR for Memories scan chains bypassed for Rainier2B
		{0x18F2A1F5, 0xac001775, 0x765D7C3D, 0xB489FD55},   //config1 - MISR for Memories scan chains bypassed for Rainier2B
		{0x18F2A1F5, 0xac001775, 0x765D7C3D, 0xB489FD55},   //
		{0x18F2A1F5, 0xac001775, 0x765D7C3D, 0xB489FD55}};  //
void BIST (void)
    {

		//MC_CGM.AC[6].AC_SC.B.SELCTL = 0x2;   //PLL0  
		//MC_CGM.AC[6].AC_DC0.B.DE=1;         
		//MC_CGM.AC[6].AC_DC0.B.DIV=0x31;
		//SIUL2.MSCR[145].R = 0x31090007;

		mbist_algo = 2;   // AUTO


		STCU2.SKC.R = ONLINE_SKC1;
		STCU2.SKC.R = ONLINE_SKC2;

		STCU2.CFG.B.WRP = 0; //In case write protection is enabled
		
		/* program LBIST registers $*/
		for(i=0;i<NMBIST;i++){
			STCU2.SKC.R = ONLINE_SKC2;	
			STCU2.MB_CTRL[i].R = CONCURRENT | (16+i+1)<<24;
			
		}


		STCU2.MB_CTRL[NMBIST-1].R = 0x00000000; /*PTR to LBIST0*/
		
		for(i=0;i<NLBIST-1;i++)
		{
			STCU2.SKC.R = ONLINE_SKC2; 		
			STCU2.LB[i].CTRL.R = SEQUENTIAL | ((i+1)<<24) | 0x3000F;
			STCU2.LB[i].PCS.R  = LBIST_PCS[i];
			STCU2.LB[i].MISRELSW.R = LBIST_MISRELSW[0][i];
			STCU2.LB[i].MISREHSW.R = LBIST_MISREHSW[0][i];
		}
		STCU2.LB[NLBIST-1].CTRL.R = 0x7F03000F;
		STCU2.LB[NLBIST-1].PCS.R  = LBIST_PCS[NLBIST-1];
		STCU2.LB[NLBIST-1].MISRELSW.R = LBIST_MISRELSW[0][NLBIST-1];
		STCU2.LB[NLBIST-1].MISREHSW.R = LBIST_MISREHSW[0][NLBIST-1];

		STCU2.SKC.R = ONLINE_SKC2;


				STCU2.SKC.R = ONLINE_SKC2;
		
		if(mbist_algo == 0 )
		    STCU2.CFG.R = 0x10FF0010;
		else if(mbist_algo == 1)
		    STCU2.CFG.R = 0x10000000;
		else
		    STCU2.CFG.R = 0x10000008;
		STCU2.WDG.R = 0xFFFFFFFF;
		STCU2.LBRMSW.R = 0xF;


		//STCU2.SKC.R = ONLINE_SKC1;		
		STCU2.SKC.R = ONLINE_SKC2;
		/* start online STCU */
		
		STCU2.RUNSW.R = 0x301;                //IRQ disable  (enable 0xf01)
		while (STCU2.RUNSW.R == 0x301);/* wait for online mode completion */
}




