/****************************************************************************************************/
/**
\file       ADC.h
\brief      
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010      
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	*/
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	*/
/* product.                                                                                      	*/
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connection with product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Module definition against multiple inclusion
*****************************************************************************************************/
#ifndef __APP_ADC_H
#define __APP_ADC_H

#define ADC_CHANNELS_USED       2
/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"
#include "FslTypes.h"
/*****************************************************************************************************
* Declaration of project wide TYPES
*****************************************************************************************************/
/** This struct contains all the ADC global variables */
typedef struct tADC
{
	UINT16 gu16LatestResult[4];
	UINT8  gu8ActualChannel;
	UINT8  gu8Status;
};

typedef struct tADCChannel
{
	UINT16 u16CompareValue1;
	UINT16 u16CompareValue2;
	UINT8  u8Channel;
	UINT8  u8Control1;
	UINT8  u8Control2;
};

typedef enum
{
    ADC_CONVERSION_COMPLETE,
    ADC_SAMPLES_FULL,
    ADC_IN_PROGRESS,
}eADC;

/*****************************************************************************************************
* Definition of project wide VARIABLES
*****************************************************************************************************/
extern struct tADCChannel sADCChannels[ADC_CHANNELS_USED];
extern struct tADC sADC;
/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
#define ADC_STOP(ControlRegister)			ADCSC1##ControlRegister## = ADCSC1##ControlRegister##_ADCHA_MASK
#define ADC_CONVERT_CHANNEL(Index)			ADCSC1A = ADCSC1A_AIENA_MASK | sADCChannels[Index].u8Channel

#define ADC_CONVERT_CONTINUOUS_CHANNEL(Index)  	ADCSC3_ADCO = 1;\
												ADCSC1A = ADCSC1A_AIENA_MASK | sADCChannels[Index].u8Channel
												
#define ADC_COCO_EVENT			EVENT(sADC.gu8Status,0)
#define ADC_COCO				COMPARE(sADC.gu8Status,0)
#define ADC_COCO_CLEAR			CLEAR(sADC.gu8Status,0)

#define _8B_MASK		0
#define _9B_MASK		0
#define _12B_MASK		ADCCFG1_MODE0_MASK
#define _13B_MASK		ADCCFG1_MODE0_MASK
#define _10B_MASK		ADCCFG1_MODE1_MASK
#define _11B_MASK		ADCCFG1_MODE1_MASK
#define _16B_MASK		ADCCFG1_MODE1_MASK | ADCCFG1_MODE0_MASK

#define ADC_HWTRG_PDB		0
#define ADC_HWTRG_TOD		1

/** Hardware Compare */
#define ADC_COMPARE			ADCSC2_ACFE_MASK
#define ADC_GREATER_THAN	ADCSC2_ACFGT_MASK		
#define ADC_LESS_THAN		0
#define ADC_INSIDE_RANGE	ADCSC2_ACREN_MASK
#define ADC_OUTSIDE_RANGE	0

/** Hardware average */
#define ADC_HW_AVERAGE		ADCSC3_AVGE_MASK
#define ADC_4SAMPLES		0
#define ADC_8SAMPLES		ADCSC3_AVGS0_MASK
#define ADC_16SAMPLES		ADCSC3_AVGS1_MASK
#define ADC_32SAMPLES		ADCSC3_AVGS1_MASK | ADCSC3_AVGS0_MASK

/** Single ended channels */
#define ADC_DIFP0		0
#define ADC_DIFP1		ADCSC1A_ADCHA0_MASK
#define ADC_DIFP2		ADCSC1A_ADCHA1_MASK
#define ADC_DIFP3		ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_CH4			ADCSC1A_ADCHA2_MASK
#define ADC_CH5			ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_CH6			ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK
#define ADC_CH7			ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_CH8			ADCSC1A_ADCHA3_MASK
#define	ADC_CH9			ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA0_MASK
#define	ADC_CH10		ADCSC1A_ADCHA3_MASK	| ADCSC1A_ADCHA1_MASK
#define ADC_CH11		ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_ACMP_CH		ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK
#define ADC_OPAMP0_CH	ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_OPAMP1_CH	ADCSC1A_ADCHA4_MASK
#define ADC_DACO_CH		ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_TEMPSEN_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_BANDGAP_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_VREFO_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA3_MASK
#define ADC_VREFH2_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK 
#define ADC_VREFH_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_VREFL_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK

/** Differential channels */
#define ADC_DAD0		0
#define ADC_DAD1		ADCSC1A_ADCHA0_MASK
#define ADC_DAD2		ADCSC1A_ADCHA1_MASK
#define ADC_DAD3		ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_TEMPDIF_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_BANDGAP_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA1_MASK | ADCSC1A_ADCHA0_MASK
#define ADC_VREFH2_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK 
#define ADC_VREFH_CH	ADCSC1A_ADCHA4_MASK | ADCSC1A_ADCHA3_MASK | ADCSC1A_ADCHA2_MASK | ADCSC1A_ADCHA0_MASK



#define INIT_ADCHWTRG_COUNTER(WakeupTime)  \
	vfnTOD_Init(_TOD_32_768KHZ_XTAL_, (TODSC_MTCHIE_MASK | TODSC_MTCHEN_MASK), WakeupTime)


/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
void vfnADConfigChannel (UINT8 lu8ChannelIndex);
void vfnADCHWTrigger (UINT8 lu8Trigger);
void vfnADC_Init (void);
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

#endif /* __APP_ADC_H */
