#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "MCG.h"
#include "Display.h"
#include "VREF.h"
#include "DAC.h"
#include "OPAMP.h"
#include "ADC.h"

void main(void) 
{
  EnableInterrupts;
  vfnMCG_Init();
   vfnSCIInit();
   
   /**Step1: Enabled VREF to source internal peripherals */
   vfnVREF_Init (_IntUseOnly);
   
   /**Step2: Sine wave to exit from DAC output*/
   TPM1SC = 0x49;
   vfnDACFillBuffer();
   vfnDACInit(gu8DACConfig1, gu8DACConfig2);
   vfnDACSetPointer (0,15);
   
   /**Step3: Amplify DAC output with the OPAMP */
   vfnOPAMPInit ();
   vfnOPAMPConfig (OPAMP0);
   
   /**Step5: Measure sine wave*/
   vfnADC_Init ();
   vfnADConfigChannel(2);
   ADC_CONVERT_CONTINUOUS_CHANNEL(2);
   
   for(;;) 
   {
 	if (ADC_COCO)
 	{
 		ADC_COCO_CLEAR;
 		vfnGraphicWords(&sADC.gu16LatestResult[0]);
 	}
 	
   __RESET_WATCHDOG();	
   } 
 
}
