/****************************************************************************************************/
/**
\file       OPAMP.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "OPAMP.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
struct tOPAMP sOPAMP[2]; 
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief Loads on the OPAMP structure with the configuration values	
* \param  void    
* \return void  
* \todo     
*/

/****************************************************************************************************/
void vfnOPAMPInit (void)
{
	/** Disable OPAMPs & setting high speed */
	GPAMP1C0 = 0;
	GPAMP2C0 = 0;
	
	sOPAMP[0].gu8Mode = OPAMP_NINV_MODE;
	sOPAMP[0].gu8Gain = OPAMP_NINV_13;
	sOPAMP[0].gu8NegativeInput = OPAMP_NI_VSS;
	sOPAMP[0].gu8PositiveInput = OPAMP_PI_DAC12;
	
	
		
}

void vfnOPAMPConfig(UINT8 u8OPAMPNumber)
{
    if (u8OPAMPNumber)
    {
    	GPAMP2C0 |= sOPAMP[u8OPAMPNumber].gu8Mode;
    	GPAMP2C1 = sOPAMP[u8OPAMPNumber].gu8Gain;
    	GPAMP2C2 = sOPAMP[u8OPAMPNumber].gu8NegativeInput | sOPAMP[u8OPAMPNumber].gu8PositiveInput;
    	GPAMP2C0_GPAMPEN = 1;    	
    }	
    else
    {
    	GPAMP1C0 |= sOPAMP[u8OPAMPNumber].gu8Mode;
    	GPAMP1C1 = sOPAMP[u8OPAMPNumber].gu8Gain;
    	GPAMP1C2 = sOPAMP[u8OPAMPNumber].gu8NegativeInput | sOPAMP[0].gu8PositiveInput;
    	GPAMP1C0_GPAMPEN = 1;
    }
}




