/****************************************************************************************************/
/**
\file       MCG.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "MCG.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

void vfnMCG_Init (void)
{
	 /* Assume 16MHz external clock source connected. */
	  
	  /* In order to use the USB we need to enter PEE mode and MCGOUT set to 48 MHz. 
	     Out of reset MCG is in FEI mode. */
	     
	  /**** Moving from FEI (FLL engaged internal) to PEE (PLL engaged external) mode. */ 
	  /* switch from FEI to FBE (FLL bypassed external) */ 
	    /* enable external clock source */
	  MCGC2 = MCGC2_HGO_MASK       /* oscillator in high gain mode */
	          | MCGC2_EREFS_MASK   /* because crystal is being used */
	          | MCGC2_RANGE_MASK   /* 16 MHz is in high freq range */
	          | MCGC2_ERCLKEN_MASK;     /* activate external reference clock */
	  while (MCGSC_OSCINIT == 0)
	    ;
	    /* select clock mode */
	  MCGC1 = (2<<6)         /* CLKS = 10 -> external reference clock. */
	          | (3<<3);      /* RDIV = 3 -> 16MHz/8=2 MHz */
	  
	    /* wait for mode change to be done */
	  while (MCGSC_IREFST != 0){}
	  while (MCGSC_CLKST != 2){}
	    
	  /* switch from FBE to PBE (PLL bypassed internal) mode */
	  MCGC3=MCGC3_PLLS_MASK
	        | (6<<0);     /* VDIV=6 -> multiply by 24 -> 2MHz * 24 = 48MHz */
	
	  while(MCGSC_PLLST != 1){}
	  while(MCGSC_LOCK != 1){}
	  /* finally switch from PBE to PEE (PLL enabled external mode) */
	  MCGC1 = (0<<6)         /* CLKS = 0 -> PLL or FLL output clock. */
	          | (3<<3);      /* RDIV = 3 -> 16MHz/8=2 MHz */
	  while(MCGSC_CLKST!=3){}
	

}
