/****************************************************************************************************/
/**
\file       SCI.c
\author     Freescale Semiconductor
\author     Technical Information Center (TIC)
\version    1.0
\date		June 2010	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connection with product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "SCI.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/

UINT8 	gu8SCIStatus = 0;

UINT8 	gu8SCIRxData;

UINT16	gu16SCIMsgSize;

UINT8* 	gu8pSCITxMsg;

/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief Initialization of the SCI	
* \param      
* \return 
* \warning The Baudrate of the initialization depends directly of the BusClock; it is important to
      update the BusClock Define  in order to update the BaudRate  
* \todo     
*/

/****************************************************************************************************/
void vfnSCIInit(void)
{
  volatile unsigned char DummyByte = 0;
  
  SCI1BD = SCIBaudRate;
  
  DummyByte = SCI1S1;  
  SCI1D = DummyByte;
  
  SCI1C1 = 0x00;
  
  SCI1C2 = 0xA4;
  /*       0b10100100
             ||||||||____ SendBrakeBit
             |||||||_____ Receiver Wakeup bit
             ||||||______ Receiver Enable bit = 1
             |||||_______ Transmiter Enable Bit = 1
             ||||________ Idle Line Interrupt Enable Bit = 0
             |||_________ Receiver full interrupt enable bit = 1
             ||__________ Transmission complete interrupt enable bit = 0
             |___________ Transmitter Interrupt Enable Bit
  */
  
  /** PTD6 && PTD7 works like Tx1 and Rx1*/
  SOPT3_SCI1PS = 1;
  
  SCI_TxInProgress_CLEAR_EVENT();
  SCI_TxMsg_CLEAR_EVENT();
  SCI_Rx_CLEAR_EVENT();
  
}
/****************************************************************************************************/
/**
* \brief This function transmits a byte using the SCI, if the SCI is busy the function returns an
* 		 ERROR; the error must be handle by the function which called u8fnSCITxData	
* \param lu8SCIData --> Data to transmit     
* \return ERROR || OK  
* \todo     
*/
/****************************************************************************************************/
UINT8 u8fnSCITxData(UINT8 lu8SCIData)
{

	if (~SCI_TxInProgress)
	{
		SCI1C2_TE = 1;		/** Enabled Transmitter  */
		SCI1D = lu8SCIData;
		SCI_TxInProgress_EVENT();
		return (SCI_OK);	
	}
	else
	{
		return (SCI_ERROR);	
	}
}

void vfnSCITxMsg(UINT8* lu8pSCIData, UINT16 lu16SCIDataSize)
{
	
	do
	{
	 if ((UINT8)(u8fnSCITxData(*lu8pSCIData)))
	 {
		lu8pSCIData++;
		SCI_TxMsg_EVENT();
		-- lu16SCIDataSize;
	 } 
	}while (lu16SCIDataSize);
	
	SCI_TxMsg_CLEAR_EVENT();
}

__interrupt VectorNumber_Vsci1tx void vfnSCITxISR (void)
{
	  /* Acknowledge Interrupt */
    volatile UINT8 u8DummyRead = SCI1S1;
	SCI1C2_TE = 0;		/** Disable Transmitter */
	SCI1D = 0xFF;
	SCI_TxInProgress_CLEAR_EVENT();  
  }



