#include "SPI.h"

/************************************************/
void SPI_Init(void)
{
  SPI_SS = 1;
  _SPI_SS= 1;
  
  //SPI1BR = 0x24; // 375 Khz  
  SPI2BR = 0x00; // 3 Mhz? with 24 MHz busclock     		
  SPI2C2 = 0x00;     
  SPI2C1 = SPI2C1_SPE_MASK | SPI2C1_MSTR_MASK;
}

/************************************************/
void SPI_Send_byte(UINT8 u8Data)
{
	(void)SPI2S;
	SPI2D=u8Data;
	while(!SPI2S_SPTEF){};
}

/************************************************/
UINT8 SPI_Receive_byte(void)
{
	(void)SPI2D;
	SPI2D=0xFF;
	while(!SPI2S_SPRF){};	
	return(SPI2D);
}

/************************************************/
void SPI_High_rate(void)
{
  SPI2C1 = 0x00;
  //SPI2BR = 0x11; // 375 Khz
  SPI2BR = 0x00; // 3Mhz? for 24 Mhz clock      		
  SPI2C1 = SPI2C1_SPE_MASK | SPI2C1_MSTR_MASK;
}
