#ifndef _Pedometer_H_
#define _Pedometer_H_

/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

#include "FslTypes.h"
#include "MMA7660.h"
#include "IICV1Driver.h"
#include "ButtonsHandler.h"
#include "Numbers.h"
#include "Fat.h"
  
/*****************************************************************************/
/*                               Definitions
/*****************************************************************************/
  
#define X_TRESHOLD          -10   /**/
#define Y_TRESHOLD          15    //---> Comparation Tresholds
#define Z_TRESHOLD          5     /**/
  
#define X_COMPARATION_EN    True  /**/
#define Y_COMPARATION_EN    True  //---> Comparation Enable
#define Z_COMPARATION_EN    True  /**/
  
#define STEPS_FILE          (UINT8*)"STEPDATA.AMD"
  
/*****************************************************************************/
/*                          Typedefs and Structs
/*****************************************************************************/

enum{
  SAVE_STEPS,
  LOAD_STEPS
};

/*****************************************************************************/
/*                                 Globals
/*****************************************************************************/
 
extern UINT32 u32Steps_Counter;

/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/

extern void vfnPedometer_Handler (void);
 
void vfnPedometer_Get_Steps (void);
 
void vfnPedometer_Init (void);
 
extern UINT32 u32StepsCountSDHandler (UINT8 u8Task);

extern UINT8 first;

#endif