/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2010                
*  ALL RIGHTS RESERVED                                       
*                                                            
*  File Name:   TOD_for_CFV1.c                               
*                                                               
*  Description: Time Of Day C source for ColdFire V1 (R) (Designed for MCF51MM256)            
*                                                                           
*  Assembler:   Codewarrior for HC(S)08 V6.1                 
*                                                            
*  Version:     1.0                                           
*                                                                                                                                                         
*  Author:      Santiago Lopez [SL](SSE Americas)
*              
*                                                                                     
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR   DESCRIPTION OF CHANGE
* ---   ----------  ------   --------------------- 
* 1.0   2010.12.06    SL        Initial version
* 
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

 #include "TOD_for_CFV1.h" 
  
/*****************************************************************************/
/*                               Definitions
/*****************************************************************************/
 
  
/*****************************************************************************/
/*                          Typedefs and Structs
/*****************************************************************************/


/*****************************************************************************/
/*                                 Globals
/*****************************************************************************/

 UINT8 gu8TOD_ISR_Flag = False;

/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/

 void vfnTOD_Init (void)
 {

  /***************************************************************************/
  /*                             TOD Match Register                          */
  
    TODM =  0b00001000;
  /*          ||||||||                         
  /*          ||||||| ----------------- \   MQSEC
  /*          |||||| ------------------ / 
  /*          ||||| ------------------- |
  /*          |||| --------------------  |
  /*          ||| ---------------------   | TOD Match Value
  /*          || ----------------------  |
  /*          | ----------------------- |
  /*           ------------------------  
  /*
  /*

  
  /***************************************************************************/
  /*                     TOD Status and Control Register                     */
  
    TODSC = 0b00001000;
  /*          ||||||||                         
  /*          ||||||| ----------------- MTCHWC   /* Match Write Complete (Read) 
  /*          |||||| ------------------ MTCHEN   /* Match function enable 0-Disabled 1-Enabled
  /*          ||||| ------------------- MTCHIE   /* Match interrupt enable 0-Disabled 1-Enabled
  /*          |||| -------------------- SECIE    /* Second interrupt enable 0-Disabled 1-Enabled
  /*          ||| --------------------- QSECIE   /* 1/4 second interrupt enable 0-Disabled 1-Enabled
  /*          || ---------------------- MTCHF    /* Match interrupt flag (write 1 to clear)
  /*          | ----------------------- SECF     /* Second interrupt flag (write 1 to clear)
  /*           ------------------------ QSECF    /* 1/4 second interrupt flag (write 1 to clear)
  /*
  /*                                                                         */
  

  
  /***************************************************************************/
  /*                         TOD Control Register                            */
  
    TODC = 0b00001000;
  /*         ||||||||                         
  /*         ||||||| ----------------- TODPS0   /*                     000-1kHz LPO
  /*         |||||| ------------------ TODPS1   /* TOD Prescaler Bits  101-32kHz with 4MHz clock
  /*         ||||| ------------------- TODPS2   /*                     111-32kHz with 16MHz clock
  /*         |||| -------------------- TODCLKEN /* 0-Disabled 1-Enabled
  /*         ||| --------------------- TODR     /* 0-No operation  1-TOD counter reg reset to $00
  /*         || ---------------------- TODCLKS0 /* Clock Source for TOD 00-OSCOUT  10-Internal ref clk
  /*         | ----------------------- TODCLKS1 /*                      01-1kHz LPO 11-Reserved
  /*          ------------------------ TODEN    /* 0-TOD disabled 1-TOD Enabled
  /*
  /* TODEN Enable TOD CLK this should be the last bit to be set              */
  
 }
 
/****************************************************************************************************/ 
 
 void vfnTOD_ShutDown (void)
 {
 
  /*********************** Execute when TOD is not needed *********************/
  
  TODC  = 0b00010000; //Turn off TOD and reset counter register
  TODSC = 0b11100000; //Clear all flags and disable interrupts
 
 }
 
/****************************************************************************************************/ 

 interrupt VectorNumber_Vtod void TOD_ISR (void)
 {
  gu8TOD_ISR_Flag = True;  //Interrupt has ocurred
  
  /*Place your ISR code here*/
  
  
  
  
  /**************************/
  
  TODSC |= 0b11100000;     //Clear Flags
 }