/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2010
*  ALL RIGHTS RESERVED
*
*  File Name:   TPM.c
*                                                                          
*  Description: Timer 2 configuration functions 
*                                                                                     
*  Assembler:   Codewarrior for HC(S)08 V6.3
*                                            
*  Version:     1.0                                                         
*                                                                                                                                                         
*  Author:      Carlos Jose Maria Casillas Mora
*                                                                                       
*  Location:    Guadalajara,Mexico                                              
*                                                                                                                  
*                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR            DESCRIPTION OF CHANGE
* ---   ----------  ------            --------------------- 
* 1.0   2010.10.04  Carlos Casillas   Initial version
* 
******************************************************************************/ 
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/


/* Includes */
#include "TPM.h"
#include "FIR.h"
#include "HeartRate.h"
#include "derivative.h"
#include "buttonshandler.h"

/* Globals */
UINT8 gu8TPM1_CH0_IRQ=False;
UINT8 cnt2 = 150;

UINT16 u16ExitCounter;
extern UINT8 gu8ButtonStatus;
extern UINT8 u8Exit;

/*****************************************************************************************/

void TIMER2_Init(void)
{

/********       Timer Configuration        ********/

     TPM2SC = TIMER_BUS_DIV;                 /* Select busclk as clock source */
                                             /* Set prescaler = 32 */    //128
                                             /* Timer Frequency = busclk/prescaler = 24MHz/128   //32 */

/********       Timer Channel Configuration        ********/

     TPM2C0SC = 0x50;            /* Channel Interrupt Enabled */
                                             /* Config channel as Output Compare */
                                             /* The timer pin is not modified on Compare */

     TPM2C0V = SAMPLE_PERIOD;  /* Set Time Period for Channel 0 */
     
     TPM2C1V = (10*SAMPLE_PERIOD);
     TPM2C1SC = 0x50;
     
     TPM2C3SC=0x50;           /* Set Channel 3 Configuration*/
     TPM2C0V = 400;
     
}

/*****************************************************************************************/

interrupt VectorNumber_Vtpm2ch0 void TPM2CH0_ISR(void)
{
     TPM2C0SC;
     TPM2C0SC_CH0F = 0;                                      //Clear Interrupt Flag
     
     TPM2C0V += SAMPLE_PERIOD;
     
      if(ECG_ENABLE)
      gu8FilterTimeElapsed=1;
     
  
    
    
     
     if(u8Exit)u16ExitCounter++;
     if(u16ExitCounter>500)gu8ButtonStatus=BUTTON_EXIT;
      
}
     
/*****************************************************************************************/

interrupt VectorNumber_Vtpm2ch1 void TPM2CH1_ISR(void)
{
  TPM2C1SC;
  TPM2C1SC_CH1F = 0;   //Clear Interrupt Flag     
  TPM2C1V += (10*SAMPLE_PERIOD);
  
    
  if(ECG_ENABLE==ON){     
    HR_watchdog++;     
    FirstSample = SecondSample;
    SecondSample = ThirdSample;
    ThirdSample = (UINT16)(FilterOutput);
  }
  
  if(TIME_TRACK_ENABLE==ON){
    gu8TPM1_CH0_IRQ=True;
  } 
}
interrupt VectorNumber_Vtpm2ch3 void TPM3CH3_ISR(void){
  TPM2C3SC;
  TPM2C3SC_CH3F = 0;   //Clear Interrupt Flag     
  TPM2C3V += 400;
  
  if(HEART_BEAT==ON && cnt2>=150){
    cnt2=0;
  }
       
  if(cnt2<150){
    PTDD_PTDD3=~PTDD_PTDD3;
    cnt2++;
    if(cnt2==150){
      HEART_BEAT=OFF;
    }
  }


}
/*****************************************************************************************/
