/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   ATL_Sensor.c
*
* @brief  Contains functions to Perform the sensing ot the electrodes and set the status for each electrode
*
* @version 1.0.35.0
* 
* @date Jun-11-2010
* 
*
***********************************************************************************************************************/

#include "ATL_Sensor.h"

#if TSS_USE_ATL_LOW_LEVEL

  UINT8 atl_u8SampleIntFlag;
  UINT8 atl_u8HWTimerFlag = 0u;
  
  volatile UINT8 *atl_pu8ElectrodePortAdr;
  volatile UINT8 atl_u8ElectrodePortMask;

  #if TSS_USE_NOISE_WINDOWING
    UINT16 atl_au16WindowBase[TSS_N_ELECTRODES];
    extern const INT8 tss_cai8WindowDeltaLimit[TSS_N_ELECTRODES];
  #endif
  
  /* 
  *  Array that contains pointers to the ATL sensing functions.  
  *  The array is defined depending on the number of electrodes stablished by the user
  */
  UINT16 (* const ATL_faElectrodeSample[TSS_N_ELECTRODES])(void) = 
  {
  ATL_SampleE0,                   
  #if TSS_N_ELECTRODES > 1
      ATL_SampleE1,               
  #endif 
  #if TSS_N_ELECTRODES > 2
      ATL_SampleE2,               
  #endif
  #if TSS_N_ELECTRODES > 3
      ATL_SampleE3,               
  #endif
  #if TSS_N_ELECTRODES > 4
      ATL_SampleE4,
  #endif
  #if TSS_N_ELECTRODES > 5
      ATL_SampleE5,
  #endif
  #if TSS_N_ELECTRODES > 6
      ATL_SampleE6,
  #endif
  #if TSS_N_ELECTRODES > 7
      ATL_SampleE7,
  #endif
  #if TSS_N_ELECTRODES > 8
      ATL_SampleE8,
  #endif
  #if TSS_N_ELECTRODES > 9
      ATL_SampleE9,
  #endif
  #if TSS_N_ELECTRODES > 10
      ATL_SampleE10,
  #endif
  #if TSS_N_ELECTRODES > 11
      ATL_SampleE11,
  #endif
  #if TSS_N_ELECTRODES > 12
      ATL_SampleE12,
  #endif
  #if TSS_N_ELECTRODES > 13
      ATL_SampleE13,
  #endif
  #if TSS_N_ELECTRODES > 14
      ATL_SampleE14,
  #endif
  #if TSS_N_ELECTRODES > 15
      ATL_SampleE15,
  #endif
  #if TSS_N_ELECTRODES > 16
      ATL_SampleE16,
  #endif
  #if TSS_N_ELECTRODES > 17
      ATL_SampleE17,
  #endif
  #if TSS_N_ELECTRODES > 18
      ATL_SampleE18,
  #endif
  #if TSS_N_ELECTRODES > 19
      ATL_SampleE19,
  #endif
  #if TSS_N_ELECTRODES > 20
      ATL_SampleE20,
  #endif
  #if TSS_N_ELECTRODES > 21
      ATL_SampleE21,
  #endif
  #if TSS_N_ELECTRODES > 22
      ATL_SampleE22,
  #endif
  #if TSS_N_ELECTRODES > 23
      ATL_SampleE23,
  #endif
  #if TSS_N_ELECTRODES > 24
      ATL_SampleE24,
  #endif
  #if TSS_N_ELECTRODES > 25
      ATL_SampleE25,
  #endif
  #if TSS_N_ELECTRODES > 26
      ATL_SampleE26,
  #endif
  #if TSS_N_ELECTRODES > 27
      ATL_SampleE27,
  #endif
  #if TSS_N_ELECTRODES > 28
      ATL_SampleE28,
  #endif
  #if TSS_N_ELECTRODES > 29
      ATL_SampleE29,
  #endif
  #if TSS_N_ELECTRODES > 30
      ATL_SampleE30,
  #endif
  #if TSS_N_ELECTRODES > 31
      ATL_SampleE31,
  #endif
  #if TSS_N_ELECTRODES > 32
      ATL_SampleE32,
  #endif
  #if TSS_N_ELECTRODES > 33
      ATL_SampleE33,
  #endif
  #if TSS_N_ELECTRODES > 34
      ATL_SampleE34,
  #endif
  #if TSS_N_ELECTRODES > 35
      ATL_SampleE35,
  #endif
  #if TSS_N_ELECTRODES > 36
      ATL_SampleE36,
  #endif
  #if TSS_N_ELECTRODES > 37
      ATL_SampleE37,
  #endif
  #if TSS_N_ELECTRODES > 38
      ATL_SampleE38,
  #endif
  #if TSS_N_ELECTRODES > 39
      ATL_SampleE39,
  #endif
  #if TSS_N_ELECTRODES > 40
      ATL_SampleE40,
  #endif
  #if TSS_N_ELECTRODES > 41
      ATL_SampleE41,
  #endif
  #if TSS_N_ELECTRODES > 42
      ATL_SampleE42,
  #endif
  #if TSS_N_ELECTRODES > 43
      ATL_SampleE43,
  #endif
  #if TSS_N_ELECTRODES > 44
      ATL_SampleE44,
  #endif
  #if TSS_N_ELECTRODES > 45
      ATL_SampleE45,
  #endif
  #if TSS_N_ELECTRODES > 46
      ATL_SampleE46,
  #endif
  #if TSS_N_ELECTRODES > 47
      ATL_SampleE47,
  #endif
  #if TSS_N_ELECTRODES > 48
      ATL_SampleE48,
  #endif
  #if TSS_N_ELECTRODES > 49
      ATL_SampleE49,
  #endif
  #if TSS_N_ELECTRODES > 50
      ATL_SampleE50,
  #endif
  #if TSS_N_ELECTRODES > 51
      ATL_SampleE51,
  #endif
  #if TSS_N_ELECTRODES > 52
      ATL_SampleE52,
  #endif
  #if TSS_N_ELECTRODES > 53
      ATL_SampleE53,
  #endif
  #if TSS_N_ELECTRODES > 54
      ATL_SampleE54,
  #endif
  #if TSS_N_ELECTRODES > 55
      ATL_SampleE55,
  #endif
  #if TSS_N_ELECTRODES > 56
      ATL_SampleE56,
  #endif
  #if TSS_N_ELECTRODES > 57
      ATL_SampleE57,
  #endif
  #if TSS_N_ELECTRODES > 58
      ATL_SampleE58,
  #endif
  #if TSS_N_ELECTRODES > 59
      ATL_SampleE59,
  #endif
  #if TSS_N_ELECTRODES > 60
      ATL_SampleE60,
  #endif
  #if TSS_N_ELECTRODES > 61
      ATL_SampleE61,
  #endif
  #if TSS_N_ELECTRODES > 62
      ATL_SampleE62,
  #endif
  #if TSS_N_ELECTRODES > 63
      ATL_SampleE63,
  #endif   
  };


  /***************************************************************************//*!
  *
  * @brief  Sets the electrode state as output high
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/
  void ATL_ElectrodesSetStateHigh(void)
  {
      ATL_ELECTRODE_HIGH(E0);
      #if TSS_N_ELECTRODES > 1
          ATL_ELECTRODE_HIGH(E1);
      #endif
      #if TSS_N_ELECTRODES > 2
          ATL_ELECTRODE_HIGH(E2);
      #endif
      #if TSS_N_ELECTRODES > 3
          ATL_ELECTRODE_HIGH(E3);
      #endif
      #if TSS_N_ELECTRODES > 4
          ATL_ELECTRODE_HIGH(E4);
      #endif
      #if TSS_N_ELECTRODES > 5
          ATL_ELECTRODE_HIGH(E5);
      #endif
      #if TSS_N_ELECTRODES > 6
          ATL_ELECTRODE_HIGH(E6);      
      #endif
      #if TSS_N_ELECTRODES > 7
          ATL_ELECTRODE_HIGH(E7);
      #endif
      #if TSS_N_ELECTRODES > 8
          ATL_ELECTRODE_HIGH(E8);
      #endif
      #if TSS_N_ELECTRODES > 9
          ATL_ELECTRODE_HIGH(E9);
      #endif
      #if TSS_N_ELECTRODES > 10
          ATL_ELECTRODE_HIGH(E10);
      #endif
      #if TSS_N_ELECTRODES > 11
          ATL_ELECTRODE_HIGH(E11);
      #endif
      #if TSS_N_ELECTRODES > 12
          ATL_ELECTRODE_HIGH(E12);
      #endif
      #if TSS_N_ELECTRODES > 13
          ATL_ELECTRODE_HIGH(E13);
      #endif
      #if TSS_N_ELECTRODES > 14
          ATL_ELECTRODE_HIGH(E14);
      #endif
      #if TSS_N_ELECTRODES > 15
          ATL_ELECTRODE_HIGH(E15);
      #endif
      #if TSS_N_ELECTRODES > 16
          ATL_ELECTRODE_HIGH(E16);
      #endif
      #if TSS_N_ELECTRODES > 17
          ATL_ELECTRODE_HIGH(E17);
      #endif
      #if TSS_N_ELECTRODES > 18
          ATL_ELECTRODE_HIGH(E18);
      #endif
      #if TSS_N_ELECTRODES > 19
          ATL_ELECTRODE_HIGH(E19);
      #endif
      #if TSS_N_ELECTRODES > 20
          ATL_ELECTRODE_HIGH(E20);
      #endif
      #if TSS_N_ELECTRODES > 21
          ATL_ELECTRODE_HIGH(E21);
      #endif
      #if TSS_N_ELECTRODES > 22
          ATL_ELECTRODE_HIGH(E22);
      #endif
      #if TSS_N_ELECTRODES > 23
          ATL_ELECTRODE_HIGH(E23);
      #endif
      #if TSS_N_ELECTRODES > 24
          ATL_ELECTRODE_HIGH(E24);
      #endif
      #if TSS_N_ELECTRODES > 25
          ATL_ELECTRODE_HIGH(E25);
      #endif
      #if TSS_N_ELECTRODES > 26
          ATL_ELECTRODE_HIGH(E26);
      #endif
      #if TSS_N_ELECTRODES > 27
          ATL_ELECTRODE_HIGH(E27);
      #endif
      #if TSS_N_ELECTRODES > 28
          ATL_ELECTRODE_HIGH(E28);
      #endif
      #if TSS_N_ELECTRODES > 29
          ATL_ELECTRODE_HIGH(E29);
      #endif
      #if TSS_N_ELECTRODES > 30
          ATL_ELECTRODE_HIGH(E30);
      #endif
      #if TSS_N_ELECTRODES > 31
          ATL_ELECTRODE_HIGH(E31);
      #endif
      #if TSS_N_ELECTRODES > 32
          ATL_ELECTRODE_HIGH(E32);
      #endif
      #if TSS_N_ELECTRODES > 33
          ATL_ELECTRODE_HIGH(E33);
      #endif
      #if TSS_N_ELECTRODES > 34
          ATL_ELECTRODE_HIGH(E34);      
      #endif
      #if TSS_N_ELECTRODES > 35
          ATL_ELECTRODE_HIGH(E35);
      #endif
      #if TSS_N_ELECTRODES > 36
          ATL_ELECTRODE_HIGH(E36);
      #endif
      #if TSS_N_ELECTRODES > 37
          ATL_ELECTRODE_HIGH(E37);
      #endif
      #if TSS_N_ELECTRODES > 38
          ATL_ELECTRODE_HIGH(E38);
      #endif
      #if TSS_N_ELECTRODES > 39
          ATL_ELECTRODE_HIGH(E39);
      #endif
      #if TSS_N_ELECTRODES > 40
          ATL_ELECTRODE_HIGH(E40);
      #endif
      #if TSS_N_ELECTRODES > 41
          ATL_ELECTRODE_HIGH(E41);
      #endif
      #if TSS_N_ELECTRODES > 42
          ATL_ELECTRODE_HIGH(E42);
      #endif
      #if TSS_N_ELECTRODES > 43
          ATL_ELECTRODE_HIGH(E43);
      #endif
      #if TSS_N_ELECTRODES > 44
          ATL_ELECTRODE_HIGH(E44);
      #endif
      #if TSS_N_ELECTRODES > 45
          ATL_ELECTRODE_HIGH(E45);
      #endif
      #if TSS_N_ELECTRODES > 46
          ATL_ELECTRODE_HIGH(E46);
      #endif
      #if TSS_N_ELECTRODES > 47
          ATL_ELECTRODE_HIGH(E47);
      #endif
      #if TSS_N_ELECTRODES > 48
          ATL_ELECTRODE_HIGH(E48);
      #endif
      #if TSS_N_ELECTRODES > 49
          ATL_ELECTRODE_HIGH(E49);
      #endif
      #if TSS_N_ELECTRODES > 50
          ATL_ELECTRODE_HIGH(E50);
      #endif
      #if TSS_N_ELECTRODES > 51
          ATL_ELECTRODE_HIGH(E51);
      #endif
      #if TSS_N_ELECTRODES > 52
          ATL_ELECTRODE_HIGH(E52);
      #endif
      #if TSS_N_ELECTRODES > 53
          ATL_ELECTRODE_HIGH(E53);
      #endif
      #if TSS_N_ELECTRODES > 54
          ATL_ELECTRODE_HIGH(E54);
      #endif
      #if TSS_N_ELECTRODES > 55
          ATL_ELECTRODE_HIGH(E55);
      #endif
      #if TSS_N_ELECTRODES > 56
          ATL_ELECTRODE_HIGH(E56);
      #endif
      #if TSS_N_ELECTRODES > 57
          ATL_ELECTRODE_HIGH(E57);
      #endif
      #if TSS_N_ELECTRODES > 58
          ATL_ELECTRODE_HIGH(E58);
      #endif
      #if TSS_N_ELECTRODES > 59
          ATL_ELECTRODE_HIGH(E59);
      #endif
      #if TSS_N_ELECTRODES > 60
          ATL_ELECTRODE_HIGH(E60);
      #endif
      #if TSS_N_ELECTRODES > 61
          ATL_ELECTRODE_HIGH(E61);
      #endif
      #if TSS_N_ELECTRODES > 62
          ATL_ELECTRODE_HIGH(E62);
      #endif
      #if TSS_N_ELECTRODES > 63
          ATL_ELECTRODE_HIGH(E63);
      #endif   
  }

  /***************************************************************************//*!
  *
  * @brief  Sets KBI pin to rising edge 
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/
  void ATL_KBISetRisingEdge(void)
  {
      #if TSS_N_ELECTRODES > 0
        #if (ATL_DETECT_METHOD(E0,KBIM))
          ATL_SET_KBI_EDG(E0) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 1
        #if (ATL_DETECT_METHOD(E1,KBIM))
          ATL_SET_KBI_EDG(E1) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 2
        #if (ATL_DETECT_METHOD(E2,KBIM))
          ATL_SET_KBI_EDG(E2) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 3
        #if (ATL_DETECT_METHOD(E3,KBIM))
          ATL_SET_KBI_EDG(E3) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 4
        #if (ATL_DETECT_METHOD(E4,KBIM))
          ATL_SET_KBI_EDG(E4) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 5
        #if (ATL_DETECT_METHOD(E5,KBIM))
          ATL_SET_KBI_EDG(E5) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 6
        #if (ATL_DETECT_METHOD(E6,KBIM))
          ATL_SET_KBI_EDG(E6) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 7
        #if (ATL_DETECT_METHOD(E7,KBIM))
          ATL_SET_KBI_EDG(E7) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 8
        #if (ATL_DETECT_METHOD(E8,KBIM))
          ATL_SET_KBI_EDG(E8) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 9
        #if (ATL_DETECT_METHOD(E9,KBIM))
          ATL_SET_KBI_EDG(E9) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      
      #if TSS_N_ELECTRODES > 10
        #if (ATL_DETECT_METHOD(E10,KBIM))
          ATL_SET_KBI_EDG(E10) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 11
        #if (ATL_DETECT_METHOD(E11,KBIM))
          ATL_SET_KBI_EDG(E11) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 12
        #if (ATL_DETECT_METHOD(E12,KBIM))
          ATL_SET_KBI_EDG(E12) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 13
        #if (ATL_DETECT_METHOD(E13,KBIM))
          ATL_SET_KBI_EDG(E13) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 14
        #if (ATL_DETECT_METHOD(E14,KBIM))
          ATL_SET_KBI_EDG(E14) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 15
        #if (ATL_DETECT_METHOD(E15,KBIM))
          ATL_SET_KBI_EDG(E15) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 16
        #if (ATL_DETECT_METHOD(E16,KBIM))
          ATL_SET_KBI_EDG(E16) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 17
        #if (ATL_DETECT_METHOD(E17,KBIM))
          ATL_SET_KBI_EDG(E17) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 18
        #if (ATL_DETECT_METHOD(E18,KBIM))
          ATL_SET_KBI_EDG(E18) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 19
        #if (ATL_DETECT_METHOD(E19,KBIM))
          ATL_SET_KBI_EDG(E19) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      
      #if TSS_N_ELECTRODES > 20
        #if (ATL_DETECT_METHOD(E20,KBIM))
          ATL_SET_KBI_EDG(E20) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 21
        #if (ATL_DETECT_METHOD(E21,KBIM))
          ATL_SET_KBI_EDG(E21) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 22
        #if (ATL_DETECT_METHOD(E22,KBIM))
          ATL_SET_KBI_EDG(E22) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 23
        #if (ATL_DETECT_METHOD(E23,KBIM))
          ATL_SET_KBI_EDG(E23) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 24
        #if (ATL_DETECT_METHOD(E24,KBIM))
          ATL_SET_KBI_EDG(E24) = ATL_KBI_RISING_EDGE;
        #endif   
      #endif
      #if TSS_N_ELECTRODES > 25
        #if (ATL_DETECT_METHOD(E25,KBIM))
          ATL_SET_KBI_EDG(E25) = ATL_KBI_RISING_EDGE;
        #endif  
      #endif
      #if TSS_N_ELECTRODES > 26
        #if (ATL_DETECT_METHOD(E26,KBIM))
          ATL_SET_KBI_EDG(E26) = ATL_KBI_RISING_EDGE;
        #endif   
      #endif
      #if TSS_N_ELECTRODES > 27
        #if (ATL_DETECT_METHOD(E27,KBIM))
          ATL_SET_KBI_EDG(E27) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 28
        #if (ATL_DETECT_METHOD(E28,KBIM))
          ATL_SET_KBI_EDG(E28) = ATL_KBI_RISING_EDGE;
        #endif       
      #endif
      #if TSS_N_ELECTRODES > 29
        #if (ATL_DETECT_METHOD(E29,KBIM))
          ATL_SET_KBI_EDG(E29) = ATL_KBI_RISING_EDGE;
        #endif      
      #endif
      
      #if TSS_N_ELECTRODES > 30
        #if (ATL_DETECT_METHOD(E30,KBIM))
          ATL_SET_KBI_EDG(E30) = ATL_KBI_RISING_EDGE;
        #endif       
      #endif
      #if TSS_N_ELECTRODES > 31
        #if (ATL_DETECT_METHOD(E31,KBIM))
          ATL_SET_KBI_EDG(E31) = ATL_KBI_RISING_EDGE;
        #endif        
      #endif
      #if TSS_N_ELECTRODES > 32
        #if (ATL_DETECT_METHOD(E32,KBIM))
          ATL_SET_KBI_EDG(E32) = ATL_KBI_RISING_EDGE;
        #endif       
      #endif
      #if TSS_N_ELECTRODES > 33      
        #if (ATL_DETECT_METHOD(E33,KBIM))
          ATL_SET_KBI_EDG(E33) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 34
        #if (ATL_DETECT_METHOD(E34,KBIM))
          ATL_SET_KBI_EDG(E34) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 35
        #if (ATL_DETECT_METHOD(E35,KBIM))
          ATL_SET_KBI_EDG(E35) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 36
        #if (ATL_DETECT_METHOD(E36,KBIM))
          ATL_SET_KBI_EDG(E36) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 37
        #if (ATL_DETECT_METHOD(E37,KBIM))
          ATL_SET_KBI_EDG(E37) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 38
        #if (ATL_DETECT_METHOD(E38,KBIM))
          ATL_SET_KBI_EDG(E38) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 39
        #if (ATL_DETECT_METHOD(E39,KBIM))
          ATL_SET_KBI_EDG(E39) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      
      #if TSS_N_ELECTRODES > 40
        #if (ATL_DETECT_METHOD(E40,KBIM))
          ATL_SET_KBI_EDG(E40) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 41
        #if (ATL_DETECT_METHOD(E41,KBIM))
          ATL_SET_KBI_EDG(E41) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 42
        #if (ATL_DETECT_METHOD(E42,KBIM))
          ATL_SET_KBI_EDG(E42) = ATL_KBI_RISING_EDGE;
        #endif   
      #endif
      #if TSS_N_ELECTRODES > 43
        #if (ATL_DETECT_METHOD(E43,KBIM))
          ATL_SET_KBI_EDG(E43) = ATL_KBI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 44
        #if (ATL_DETECT_METHOD(E44,KBIM))
          ATL_SET_KBI_EDG(E44) = ATL_KBI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 45
        #if (ATL_DETECT_METHOD(E45,KBIM))
          ATL_SET_KBI_EDG(E45) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 46
        #if (ATL_DETECT_METHOD(E46,KBIM))
          ATL_SET_KBI_EDG(E46) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 47
        #if (ATL_DETECT_METHOD(E47,KBIM))
          ATL_SET_KBI_EDG(E47) = ATL_KBI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 48
        #if (ATL_DETECT_METHOD(E48,KBIM))
          ATL_SET_KBI_EDG(E48) = ATL_KBI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 49
        #if (ATL_DETECT_METHOD(E49,KBIM))
          ATL_SET_KBI_EDG(E49) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      
      #if TSS_N_ELECTRODES > 50
        #if (ATL_DETECT_METHOD(E50,KBIM))
          ATL_SET_KBI_EDG(E50) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 51
        #if (ATL_DETECT_METHOD(E51,KBIM))
          ATL_SET_KBI_EDG(E51) = ATL_KBI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 52
        #if (ATL_DETECT_METHOD(E52,KBIM))
          ATL_SET_KBI_EDG(E52) = ATL_KBI_RISING_EDGE;
        #endif      
      #endif
      #if TSS_N_ELECTRODES > 53
        #if (ATL_DETECT_METHOD(E53,KBIM))
          ATL_SET_KBI_EDG(E53) = ATL_KBI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 54
        #if (ATL_DETECT_METHOD(E54,KBIM))
          ATL_SET_KBI_EDG(E54) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 55
        #if (ATL_DETECT_METHOD(E55,KBIM))
          ATL_SET_KBI_EDG(E55) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 56
        #if (ATL_DETECT_METHOD(E56,KBIM))
          ATL_SET_KBI_EDG(E56) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 57
        #if (ATL_DETECT_METHOD(E57,KBIM))
          ATL_SET_KBI_EDG(E57) = ATL_KBI_RISING_EDGE;
        #endif      
      #endif
      #if TSS_N_ELECTRODES > 58
        #if (ATL_DETECT_METHOD(E58,KBIM))
          ATL_SET_KBI_EDG(E58) = ATL_KBI_RISING_EDGE;
        #endif      
      #endif
      #if TSS_N_ELECTRODES > 59
        #if (ATL_DETECT_METHOD(E59,KBIM))
          ATL_SET_KBI_EDG(E59) = ATL_KBI_RISING_EDGE;
        #endif  
      #endif
      
      #if TSS_N_ELECTRODES > 60
        #if (ATL_DETECT_METHOD(E60,KBIM))
          ATL_SET_KBI_EDG(E60) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 61
        #if (ATL_DETECT_METHOD(E61,KBIM))
          ATL_SET_KBI_EDG(E61) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 62
        #if (ATL_DETECT_METHOD(E62,KBIM))
          ATL_SET_KBI_EDG(E62) = ATL_KBI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 63
        #if (ATL_DETECT_METHOD(E63,KBIM))
          ATL_SET_KBI_EDG(E63) = ATL_KBI_RISING_EDGE;
        #endif    
      #endif
  }

  /***************************************************************************//*!
  *
  * @brief  Sets PTI pin to rising edge
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/
  void ATL_PTISetRisingEdge(void)
  {
      #if TSS_N_ELECTRODES > 0
        #if (ATL_DETECT_METHOD(E0,PTIM))
          ATL_SET_PTI_EDG(E0) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 1
        #if (ATL_DETECT_METHOD(E1,PTIM))
          ATL_SET_PTI_EDG(E1) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 2
        #if (ATL_DETECT_METHOD(E2,PTIM))
          ATL_SET_PTI_EDG(E2) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 3
        #if (ATL_DETECT_METHOD(E3,PTIM))
          ATL_SET_PTI_EDG(E3) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 4
        #if (ATL_DETECT_METHOD(E4,PTIM))
          ATL_SET_PTI_EDG(E4) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 5
        #if (ATL_DETECT_METHOD(E5,PTIM))
          ATL_SET_PTI_EDG(E5) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 6
        #if (ATL_DETECT_METHOD(E6,PTIM))
          ATL_SET_PTI_EDG(E6) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 7
        #if (ATL_DETECT_METHOD(E7,PTIM))
          ATL_SET_PTI_EDG(E7) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 8
        #if (ATL_DETECT_METHOD(E8,PTIM))
          ATL_SET_PTI_EDG(E8) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 9
        #if (ATL_DETECT_METHOD(E9,PTIM))
          ATL_SET_PTI_EDG(E9) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      
      #if TSS_N_ELECTRODES > 10
        #if (ATL_DETECT_METHOD(E10,PTIM))
          ATL_SET_PTI_EDG(E10) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 11
        #if (ATL_DETECT_METHOD(E11,PTIM))
          ATL_SET_PTI_EDG(E11) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 12
        #if (ATL_DETECT_METHOD(E12,PTIM))
          ATL_SET_PTI_EDG(E12) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 13
        #if (ATL_DETECT_METHOD(E13,PTIM))
          ATL_SET_PTI_EDG(E13) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 14
        #if (ATL_DETECT_METHOD(E14,PTIM))
          ATL_SET_PTI_EDG(E14) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 15
        #if (ATL_DETECT_METHOD(E15,PTIM))
          ATL_SET_PTI_EDG(E15) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 16
        #if (ATL_DETECT_METHOD(E16,PTIM))
          ATL_SET_PTI_EDG(E16) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 17
        #if (ATL_DETECT_METHOD(E17,PTIM))
          ATL_SET_PTI_EDG(E17) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 18
        #if (ATL_DETECT_METHOD(E18,PTIM))
          ATL_SET_PTI_EDG(E18) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 19
        #if (ATL_DETECT_METHOD(E19,PTIM))
          ATL_SET_PTI_EDG(E19) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      
      #if TSS_N_ELECTRODES > 20
        #if (ATL_DETECT_METHOD(E20,PTIM))
          ATL_SET_PTI_EDG(E20) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 21
        #if (ATL_DETECT_METHOD(E21,PTIM))
          ATL_SET_PTI_EDG(E21) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 22
        #if (ATL_DETECT_METHOD(E22,PTIM))
          ATL_SET_PTI_EDG(E22) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 23
        #if (ATL_DETECT_METHOD(E23,PTIM))
          ATL_SET_PTI_EDG(E23) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 24
        #if (ATL_DETECT_METHOD(E24,PTIM))
          ATL_SET_PTI_EDG(E24) = ATL_PTI_RISING_EDGE;
        #endif   
      #endif
      #if TSS_N_ELECTRODES > 25
        #if (ATL_DETECT_METHOD(E25,PTIM))
          ATL_SET_PTI_EDG(E25) = ATL_PTI_RISING_EDGE;
        #endif  
      #endif
      #if TSS_N_ELECTRODES > 26
        #if (ATL_DETECT_METHOD(E26,PTIM))
          ATL_SET_PTI_EDG(E26) = ATL_PTI_RISING_EDGE;
        #endif   
      #endif
      #if TSS_N_ELECTRODES > 27
        #if (ATL_DETECT_METHOD(E27,PTIM))
          ATL_SET_PTI_EDG(E27) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 28
        #if (ATL_DETECT_METHOD(E28,PTIM))
          ATL_SET_PTI_EDG(E28) = ATL_PTI_RISING_EDGE;
        #endif       
      #endif
      #if TSS_N_ELECTRODES > 29
        #if (ATL_DETECT_METHOD(E29,PTIM))
          ATL_SET_PTI_EDG(E29) = ATL_PTI_RISING_EDGE;
        #endif      
      #endif
      
      #if TSS_N_ELECTRODES > 30
        #if (ATL_DETECT_METHOD(E30,PTIM))
          ATL_SET_PTI_EDG(E30) = ATL_PTI_RISING_EDGE;
        #endif       
      #endif
      #if TSS_N_ELECTRODES > 31
        #if (ATL_DETECT_METHOD(E31,PTIM))
          ATL_SET_PTI_EDG(E31) = ATL_PTI_RISING_EDGE;
        #endif        
      #endif
      #if TSS_N_ELECTRODES > 32
        #if (ATL_DETECT_METHOD(E32,PTIM))
          ATL_SET_PTI_EDG(E32) = ATL_PTI_RISING_EDGE;
        #endif       
      #endif
      #if TSS_N_ELECTRODES > 33      
        #if (ATL_DETECT_METHOD(E33,PTIM))
          ATL_SET_PTI_EDG(E33) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 34
        #if (ATL_DETECT_METHOD(E34,PTIM))
          ATL_SET_PTI_EDG(E34) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 35
        #if (ATL_DETECT_METHOD(E35,PTIM))
          ATL_SET_PTI_EDG(E35) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 36
        #if (ATL_DETECT_METHOD(E36,PTIM))
          ATL_SET_PTI_EDG(E36) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 37
        #if (ATL_DETECT_METHOD(E37,PTIM))
          ATL_SET_PTI_EDG(E37) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 38
        #if (ATL_DETECT_METHOD(E38,PTIM))
          ATL_SET_PTI_EDG(E38) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 39
        #if (ATL_DETECT_METHOD(E39,PTIM))
          ATL_SET_PTI_EDG(E39) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      
      #if TSS_N_ELECTRODES > 40
        #if (ATL_DETECT_METHOD(E40,PTIM))
          ATL_SET_PTI_EDG(E40) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 41
        #if (ATL_DETECT_METHOD(E41,PTIM))
          ATL_SET_PTI_EDG(E41) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 42
        #if (ATL_DETECT_METHOD(E42,PTIM))
          ATL_SET_PTI_EDG(E42) = ATL_PTI_RISING_EDGE;
        #endif   
      #endif
      #if TSS_N_ELECTRODES > 43
        #if (ATL_DETECT_METHOD(E43,PTIM))
          ATL_SET_PTI_EDG(E43) = ATL_PTI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 44
        #if (ATL_DETECT_METHOD(E44,PTIM))
          ATL_SET_PTI_EDG(E44) = ATL_PTI_RISING_EDGE;
        #endif 
      #endif
      #if TSS_N_ELECTRODES > 45
        #if (ATL_DETECT_METHOD(E45,PTIM))
          ATL_SET_PTI_EDG(E45) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 46
        #if (ATL_DETECT_METHOD(E46,PTIM))
          ATL_SET_PTI_EDG(E46) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 47
        #if (ATL_DETECT_METHOD(E47,PTIM))
          ATL_SET_PTI_EDG(E47) = ATL_PTI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 48
        #if (ATL_DETECT_METHOD(E48,PTIM))
          ATL_SET_PTI_EDG(E48) = ATL_PTI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 49
        #if (ATL_DETECT_METHOD(E49,PTIM))
          ATL_SET_PTI_EDG(E49) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      
      #if TSS_N_ELECTRODES > 50
        #if (ATL_DETECT_METHOD(E50,PTIM))
          ATL_SET_PTI_EDG(E50) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 51
        #if (ATL_DETECT_METHOD(E51,PTIM))
          ATL_SET_PTI_EDG(E51) = ATL_PTI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 52
        #if (ATL_DETECT_METHOD(E52,PTIM))
          ATL_SET_PTI_EDG(E52) = ATL_PTI_RISING_EDGE;
        #endif      
      #endif
      #if TSS_N_ELECTRODES > 53
        #if (ATL_DETECT_METHOD(E53,PTIM))
          ATL_SET_PTI_EDG(E53) = ATL_PTI_RISING_EDGE;
        #endif    
      #endif
      #if TSS_N_ELECTRODES > 54
        #if (ATL_DETECT_METHOD(E54,PTIM))
          ATL_SET_PTI_EDG(E54) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 55
        #if (ATL_DETECT_METHOD(E55,PTIM))
          ATL_SET_PTI_EDG(E55) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 56
        #if (ATL_DETECT_METHOD(E56,PTIM))
          ATL_SET_PTI_EDG(E56) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 57
        #if (ATL_DETECT_METHOD(E57,PTIM))
          ATL_SET_PTI_EDG(E57) = ATL_PTI_RISING_EDGE;
        #endif      
      #endif
      #if TSS_N_ELECTRODES > 58
        #if (ATL_DETECT_METHOD(E58,PTIM))
          ATL_SET_PTI_EDG(E58) = ATL_PTI_RISING_EDGE;
        #endif      
      #endif
      #if TSS_N_ELECTRODES > 59
        #if (ATL_DETECT_METHOD(E59,PTIM))
          ATL_SET_PTI_EDG(E59) = ATL_PTI_RISING_EDGE;
        #endif  
      #endif
      
      #if TSS_N_ELECTRODES > 60
        #if (ATL_DETECT_METHOD(E60,PTIM))
          ATL_SET_PTI_EDG(E60) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 61
        #if (ATL_DETECT_METHOD(E61,PTIM))
          ATL_SET_PTI_EDG(E61) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 62
        #if (ATL_DETECT_METHOD(E62,PTIM))
          ATL_SET_PTI_EDG(E62) = ATL_PTI_RISING_EDGE;
        #endif     
      #endif
      #if TSS_N_ELECTRODES > 63
        #if (ATL_DETECT_METHOD(E63,PTIM))
          ATL_SET_PTI_EDG(E63) = ATL_PTI_RISING_EDGE;
        #endif    
      #endif
  }

  /***************************************************************************//*!
  *
  * @brief  Initializes the Noise Window variables 
  *
  * @param  Nothing
  *
  * @return Status Code
  *
  * @remarks
  *
  ****************************************************************************/
  #if TSS_USE_NOISE_WINDOWING
  void ATL_NoiseWindowInit(void) 
  {
      UINT8 u8counter; 

      for (u8counter = 0; u8counter < TSS_N_ELECTRODES; u8counter++) 
      {
        atl_au16WindowBase[u8counter] = 0u;  /* Set default value */
      }
  }
  #endif

  /***************************************************************************//*!
  *
  * @brief  Initializes the timer for the sensing of the electrodes
  *
  * @param  Nothing
  *
  * @return Status Code
  *
  * @remarks
  *
  ****************************************************************************/
  UINT8 ATL_SensorInit(void)
  {
      UINT8 u8result = TSS_STATUS_OK;

      /* Global Timer Initialization */
      #ifdef ATL_HW_TIMER_USED
        ATL_HW_TIMER_STOP();                                   /* Stops the timer */
        ATL_HW_TIMER_RESET();                                  /* Resets the timer */
        ATL_HW_TIMER_SET_PRESCALE(ATL_SENSOR_PRESCALER);       /* Sets a preescaler value */
        ATL_HW_TIMER_ENABLE_INT();                             /* Enable Timer interrupt */
        ATL_HW_TIMER_SET_MOD(ATL_SENSOR_TIMEOUT);              /* Sets the timeout value */
      #endif
      
      /* GPIO Initialization */
      ATL_ElectrodesSetStateHigh();
      
      /* KBI Initialization */
      #if ATL_KBI_USED
        ATL_KBI_ENABLE_INT(KBI);
      #endif
      #if ATL_KBI1_USED
        ATL_KBI_ENABLE_INT(KBI1);
      #endif
      #if ATL_KBI2_USED
        ATL_KBI_ENABLE_INT(KBI2);
      #endif
      #if ATL_KBI3_USED
        ATL_KBI_ENABLE_INT(KBI3);
      #endif

      #if (ATL_KBI_USED || ATL_KBI1_USED || ATL_KBI2_USED || ATL_KBI3_USED)
        ATL_KBISetRisingEdge();
      #endif
      
      /* PTI Initialization */      
      #if ATL_PIA_USED
        ATL_PTI_ENABLE_INT(PTA);
      #endif
      #if ATL_PIB_USED
        ATL_PTI_ENABLE_INT(PTB);
      #endif
      #if ATL_PIC_USED
        ATL_PTI_ENABLE_INT(PTC);
      #endif
      #if ATL_PID_USED
        ATL_PTI_ENABLE_INT(PTD);
      #endif
      #if ATL_PIJ_USED
        ATL_PTI_ENABLE_INT(PTJ);
      #endif
      
      #if (ATL_PIA_USED || ATL_PIB_USED || ATL_PIC_USED || ATL_PID_USED || ATL_PIJ_USED)
        ATL_PTISetRisingEdge();
      #endif

      /* TPM Initialization */
      #if ATL_TPMICM_USED
        ATL_IC_TIMER_STOP(TPM);                                   /* Stops the timer */
        ATL_IC_TIMER_RESET(TPM);                                  /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(TPM, ATL_SENSOR_PRESCALER);     /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(TPM);                             /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(TPM, ATL_SENSOR_TIMEOUT);            /* Sets the timeout value */      
      #endif
      #if ATL_TPM1ICM_USED
        ATL_IC_TIMER_STOP(TPM1);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(TPM1);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(TPM1, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(TPM1);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(TPM1, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      #if ATL_TPM2ICM_USED
        ATL_IC_TIMER_STOP(TPM2);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(TPM2);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(TPM2, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(TPM2);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(TPM2, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      #if ATL_TPM3ICM_USED
        ATL_IC_TIMER_STOP(TPM3);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(TPM3);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(TPM3, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(TPM3);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(TPM3, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      #if ATL_TPM4ICM_USED
        ATL_IC_TIMER_STOP(TPM4);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(TPM4);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(TPM4, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(TPM4);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(TPM4, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      /* FTM Initialization */
      #if ATL_FTMICM_USED
        ATL_IC_TIMER_STOP(FTM);                                   /* Stops the timer */
        ATL_IC_TIMER_RESET(FTM);                                  /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(FTM, ATL_SENSOR_PRESCALER);     /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(FTM);                             /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(FTM, ATL_SENSOR_TIMEOUT);            /* Sets the timeout value */      
      #endif
      #if ATL_FTM1ICM_USED
        ATL_IC_TIMER_STOP(FTM1);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(FTM1);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(FTM1, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(FTM1);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(FTM1, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      #if ATL_FTM2ICM_USED
        ATL_IC_TIMER_STOP(FTM2);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(FTM2);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(FTM2, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(FTM2);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(FTM2, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      #if ATL_FTM3ICM_USED
        ATL_IC_TIMER_STOP(FTM3);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(FTM3);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(FTM3, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(FTM3);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(FTM3, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif
      #if ATL_FTM4ICM_USED
        ATL_IC_TIMER_STOP(FTM4);                                  /* Stops the timer */
        ATL_IC_TIMER_RESET(FTM4);                                 /* Resets the timer */
        ATL_IC_TIMER_SET_PRESCALE(FTM4, ATL_SENSOR_PRESCALER);    /* Sets a preescaler value */
        ATL_IC_TIMER_ENABLE_INT(FTM4);                            /* Enable Timer interrupt */
        ATL_IC_TIMER_SET_MOD(FTM4, ATL_SENSOR_TIMEOUT);           /* Sets the timeout value */      
      #endif

      /* Noise Windowing Initialization */
      #if TSS_USE_NOISE_WINDOWING
        ATL_NoiseWindowInit(); 
      #endif
 
      return u8result;
  }



  UINT16 u16temp[TSS_N_ELECTRODES];    //trick
  /***************************************************************************//*!
  *
  * @brief  Performs a valid reading of one electrode stores the timer values 
  *         and returns a status code
  *
  * @param  u8ElecNum Electrode number to be scanned
  *
  * @return Status Code
  *
  * @remarks
  *
  ****************************************************************************/
  UINT8 ATL_SampleElectrode(UINT8 u8ElecNum)
  {
      UINT8 u8NSamp;
      UINT8 u8ElectrodeStatus;  
      UINT16 u16CapSubSample;
      UINT8 u8FaultCnt;

      #if TSS_USE_NOISE_WINDOWING
        INT16 i16WindowDeltaTemp;
        UINT16 u16WindowBaseTemp;
        INT8 i8WindowDeltaLimitTemp;
      #endif
      
      /* Initialization of variables */
      atl_u8HWTimerFlag = 0u;
      tss_u16CapSample = 0u;
      u8ElectrodeStatus = TSS_STATUS_OK;                  /* Sets status */
      u8FaultCnt = 0u;

      u8NSamp = tss_CSSys.NSamples;

      #if TSS_USE_NOISE_WINDOWING
        u16WindowBaseTemp = atl_au16WindowBase[u8ElecNum];
        
        if (u16WindowBaseTemp == 0u) {
          i8WindowDeltaLimitTemp = 127;
        } else {
          i8WindowDeltaLimitTemp = tss_cai8WindowDeltaLimit[u8ElecNum];
        }
      #endif

      /* Main oversampling measurement loop */
      while(u8NSamp)
      {
          #ifdef ATL_HW_TIMER_USED
            ATL_HW_TIMER_STOP();                          /* Stops the HW Timer  */
            ATL_HW_TIMER_RESET();                         /* Resets the HW Timer */
          #endif  
          ATL_CLEAR_SAMPLE_INTERRUPTED_FLAG();            /* Clears the interrupt sample flag */
          
          u16CapSubSample = ATL_faElectrodeSample[u8ElecNum]();             /* Samples one electrode */
          
          if(!ATL_FAULT_DETECTED)                         /* Verifies that no fault has occurr*/
          {            
              if(!ATL_SAMPLE_INTERRUPTED)             /* Verifies that the sample has not been inturrupted*/
              {
                #if TSS_USE_NOISE_WINDOWING
                  i16WindowDeltaTemp = (INT16) (u16CapSubSample - u16WindowBaseTemp);
                  if(i16WindowDeltaTemp > 127)
                    i16WindowDeltaTemp = 127;
                  else if(i16WindowDeltaTemp < -127){
                    i16WindowDeltaTemp = -127;
                  }            
                  
                  if(i16WindowDeltaTemp > i8WindowDeltaLimitTemp) {
                    u16WindowBaseTemp++;
                    u8FaultCnt++;
                  } else if (i16WindowDeltaTemp < -i8WindowDeltaLimitTemp) {
                    u16WindowBaseTemp--;
                    u8FaultCnt++;                    
                  } else { 
                    tss_u16CapSample += u16CapSubSample;
                    u8NSamp--;
                    u8FaultCnt = 0u;                 /* Restart Fault counter due long cyclic interrupts */
                  }
                #else
                  tss_u16CapSample += u16CapSubSample;
                  u8NSamp--;
                  u8FaultCnt = 0u;                   /* Restart Fault counter due long cyclic interrupts */
                #endif  
              }
              else
              {    
                /* Do nothing if interrupt occured and do sample again in next loop*/
                u8FaultCnt++; 
              }
          }
          else
          {
              ATL_SET_ELECTRODE_OUTPUT_LOW();               /* Sets the electrode to OUTPUT LOW default value bacause short was detected there */
              u8ElectrodeStatus = TSS_ERROR_CHARGE_TIMEOUT; /* If a fault has occurred sets the return status code error */
              u8NSamp = 0u;                                  
          }
          
          if(u8FaultCnt >= ATL_FAULT_TIMEOUT) {
              u8ElectrodeStatus = TSS_ERROR_CHARGE_TIMEOUT; /* If a fault has occurred sets the return status code error */
              u8NSamp = 0u; 
          }        
      }

      if ((tss_u16CapSample < ATL_KEYDETECT_CAP_LOWER_LIMIT) && (u8ElectrodeStatus != TSS_ERROR_CHARGE_TIMEOUT)) u8ElectrodeStatus = TSS_ERROR_KEYDETECT_SMALL_CAP;

      #if TSS_USE_NOISE_WINDOWING
        if (u8ElectrodeStatus == TSS_STATUS_OK) {
          if (atl_au16WindowBase[u8ElecNum] == 0u) {
            atl_au16WindowBase[u8ElecNum] = (UINT16) (tss_u16CapSample / tss_CSSys.NSamples);
          } else {
            atl_au16WindowBase[u8ElecNum] = u16WindowBaseTemp;
          }
        } else {
          atl_au16WindowBase[u8ElecNum] = 0u; /* Initiate Window Base refresh */
        }
      #endif
      
      u16temp[u8ElecNum] = tss_u16CapSample;  //Trick
      
      return u8ElectrodeStatus;   /* Return status code */ 
  }

  /***************************************************************************//*!
  *
  * @brief  HW Timer Overflow Interrupt handlers. Occurrs when there has been 
  *         a timeout in the ATL_SampleElectrode Function
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/

  #ifdef ATL_HW_TIMER_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      ATL_HW_TIMER_VECTOR
    #endif
    void ATL_HWTimerIsr(void)
    {
      ATL_HW_TIMER_CLEARFLAG();              /* ATL TPM/FTM/MTIM Clear Flag */
      atl_u8HWTimerFlag = 1u;                /* Set measurement Overflow Flag variable */
      ATL_SET_ELECTRODE_OUTPUT_HIGH();       /* For escape from measurement loop */
    }
  #endif

  /***************************************************************************//*!
  *
  * @brief  KBI Interrupt handler
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/
  #if ATL_KBI_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vkeyboard
    #endif
    void ATL_KBIIsr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_KBI_ACK(KBI);
    }
  #endif

  #if ATL_KBI1_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vkeyboard1
    #endif
    void ATL_KBI1Isr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_KBI_ACK(KBI1);
    }
  #endif

  #if ATL_KBI2_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vkeyboard2
    #endif
    void ATL_KBI2Isr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_KBI_ACK(KBI2);
    }
  #endif

  #if ATL_KBI3_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vkeyboard3
    #endif
    void ATL_KBI3Isr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_KBI_ACK(KBI3);
    }
  #endif
  
  /***************************************************************************//*!
  *
  * @brief  PTI Interrupt handler
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/
  #if ATL_PIA_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vporta
    #endif
    void ATL_PIAIsr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_PTI_ACK(PTA);
    }
  #endif

  #if ATL_PIB_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vportb
    #endif
    void ATL_PIBIsr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_PTI_ACK(PTB);
    }
  #endif

  #if ATL_PIC_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vportc
    #endif
    void ATL_PICIsr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_PTI_ACK(PTC);
    }
  #endif

  #if ATL_PID_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vportd
    #endif
    void ATL_PIDIsr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_PTI_ACK(PTD);
    }
  #endif
  
  #if ATL_PIJ_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vportj
    #endif
    void ATL_PIJIsr(void)
    {
      ATL_HW_TIMER_STOP();
      ATL_PTI_ACK(PTJ);
    }
  #endif
  
  /***************************************************************************//*!
  *
  * @brief  TPMx/FTMx Overflow Interrupt handlers
  *
  * @param  void
  *
  * @return void
  *
  * @remarks
  *
  ****************************************************************************/

  #if ATL_TPMICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vtpmovf
    #endif
    void ATL_TPMIsr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_TPM1ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vtpm1ovf
    #endif
    void ATL_TPM1Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif
  
  #if ATL_TPM2ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vtpm2ovf
    #endif
    void ATL_TPM2Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_TPM3ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vtpm3ovf
    #endif
    void ATL_TPM3Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_TPM4ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vtpm4ovf
    #endif
    void ATL_TPM4Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_FTMICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vftmovf
    #endif
    void ATL_FTMIsr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_FTM1ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vftm1ovf
    #endif
    void ATL_FTM1Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif
  
  #if ATL_FTM2ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vftm2ovf
    #endif
    void ATL_FTM2Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_FTM3ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vftm3ovf
    #endif
    void ATL_FTM3Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  #if ATL_FTM4ICM_USED
    interrupt 
    #if !TSS_USE_PE_COMPONENT
      VectorNumber_Vftm4ovf
    #endif
    void ATL_FTM4Isr(void)
    {
      atl_u8HWTimerFlag = 1u;                   /* Set measurement Overflow Flag variable */
    }
  #endif

  /* 
  * Handler Bodies of the each measurement method 
  */

  #define ATL_GPIO_METHOD_CONTROL(el)   ATL_SAVE_ELECTRODE_PORT(el);           /* Save the electrode port */\
                                        ATL_ELECTRODE_DISCHARGE(el);          /* Discharges the electrode */\
                                        ATL_HW_TIMER_START();                 /* Timer Starts counting */\
                                        ATL_ELECTRODE_CHARGE(el);             /* Charges the required electrode  */\
                                        while(ATL_ELECTRODE_DISCHARGED(el))   /* Waits until the electrode has been charged */\
                                        {\
                                          /* MISRA Rule 14.8 */\
                                        }\
                                        ATL_HW_TIMER_STOP();\
                                        ATL_ELECTRODE_DISCHARGE(el);\
                                        return ATL_HW_TIMER_GET_CNT()\

  #define ATL_KBI_METHOD_CONTROL(el)    ATL_SAVE_ELECTRODE_PORT(el);           /* Save the electrode port */\
                                        ATL_ELECTRODE_DISCHARGE(el);\
                                        ATL_HW_TIMER_START();\
                                        ATL_KBI_PIN_ENABLE(el);\
                                        ATL_GOTO_WAIT();\
                                        ATL_ELECTRODE_CHARGE(el);             /* Charges the required electrode for high state */\
                                        ATL_KBI_PIN_DISABLE(el);\
                                        ATL_HW_TIMER_STOP();                  /* For sure if KBI doesn't appear */\
                                        return ATL_HW_TIMER_GET_CNT()\

  #define ATL_PTI_METHOD_CONTROL(el)    ATL_SAVE_ELECTRODE_PORT(el);           /* Save the electrode port */\
                                        ATL_ELECTRODE_DISCHARGE(el);\
                                        ATL_HW_TIMER_START();\
                                        ATL_PTI_PIN_ENABLE(el);\
                                        ATL_GOTO_WAIT();\
                                        ATL_ELECTRODE_CHARGE(el);             /* Charges the required electrode for high state */\
                                        ATL_PTI_PIN_DISABLE(el);\
                                        ATL_HW_TIMER_STOP();                  /* For sure if KBI doesn't appear */\
                                        return ATL_HW_TIMER_GET_CNT()\

  #define ATL_TPMIC_METHOD_CONTROL(el)  ATL_ELECTRODE_DISCHARGE(el);\
                                        ATL_IC_TIMER_EL_START(el);\
                                        ATL_IC_TIMER_EL_CHANNEL_ENABLE(el);   /* Enable Input Capture + Clear channel flag + Charge*/\
                                        ATL_IC_TIMER_EL_RESET(el);            /* Reset TPM/FTM Counter */\
                                        while(!ATL_IC_TIMER_EL_CHANNEL_FLAG(el) && !ATL_IC_TIMER_EL_OVF_FLAG(el))\
                                        {\
                                          /* MISRA Rule 14.8 */\
                                        }\
                                        ATL_ELECTRODE_CHARGE(el);             /* Charges the required electrode for high state */\
                                        ATL_IC_TIMER_EL_CHANNEL_DISABLE(el);  /* Disable Input Capture + Clear channel flag + Discharge*/\
                                        ATL_IC_TIMER_EL_CLEARFLAG(el);        /* Clear Timer Flag */\
                                        ATL_IC_TIMER_EL_STOP(el);             /* Stop the Timer */\
                                        return ATL_IC_TIMER_EL_CHANNEL_V(el);\

  /* 
  * Functions are defined according to the number of declared electrodes,
  * this way only the functions needed are compiled
  */

  /* Samples EX electrode */
  UINT16 ATL_SampleE0(void)                     
  {
    #if (ATL_DETECT_METHOD(E0,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E0);
    #endif 
    #if (ATL_DETECT_METHOD(E0,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E0);
    #endif
    #if (ATL_DETECT_METHOD(E0,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E0);
    #endif
    #if (ATL_DETECT_METHOD(E0,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E0);
    #endif
  }

  #if TSS_N_ELECTRODES > 1
  UINT16 ATL_SampleE1(void)
  {
    #if (ATL_DETECT_METHOD(E1,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E1);
    #endif 
    #if (ATL_DETECT_METHOD(E1,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E1);
    #endif
    #if (ATL_DETECT_METHOD(E1,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E1);
    #endif
    #if (ATL_DETECT_METHOD(E1,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E1);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 2
  UINT16 ATL_SampleE2(void)
  {
    #if (ATL_DETECT_METHOD(E2,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E2);
    #endif 
    #if (ATL_DETECT_METHOD(E2,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E2);
    #endif
    #if (ATL_DETECT_METHOD(E2,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E2);
    #endif
    #if (ATL_DETECT_METHOD(E2,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E2);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 3
  UINT16 ATL_SampleE3(void)
  {
    #if (ATL_DETECT_METHOD(E3,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E3);
    #endif 
    #if (ATL_DETECT_METHOD(E3,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E3);
    #endif
    #if (ATL_DETECT_METHOD(E3,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E3);
    #endif
    #if (ATL_DETECT_METHOD(E3,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E3);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 4
  UINT16 ATL_SampleE4(void)
  {
    #if (ATL_DETECT_METHOD(E4,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E4);
    #endif 
    #if (ATL_DETECT_METHOD(E4,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E4);
    #endif
    #if (ATL_DETECT_METHOD(E4,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E4);
    #endif
    #if (ATL_DETECT_METHOD(E4,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E4);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 5
  UINT16 ATL_SampleE5(void)
  {
    #if (ATL_DETECT_METHOD(E5,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E5);
    #endif 
    #if (ATL_DETECT_METHOD(E5,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E5);
    #endif
    #if (ATL_DETECT_METHOD(E5,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E5);
    #endif
    #if (ATL_DETECT_METHOD(E5,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E5);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 6
  UINT16 ATL_SampleE6(void)
  {
    #if (ATL_DETECT_METHOD(E6,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E6);
    #endif 
    #if (ATL_DETECT_METHOD(E6,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E6);
    #endif
    #if (ATL_DETECT_METHOD(E6,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E6);
    #endif
    #if (ATL_DETECT_METHOD(E6,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E6);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 7
  UINT16 ATL_SampleE7(void)
  {
    #if (ATL_DETECT_METHOD(E7,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E7);
    #endif 
    #if (ATL_DETECT_METHOD(E7,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E7);
    #endif
    #if (ATL_DETECT_METHOD(E7,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E7);
    #endif
    #if (ATL_DETECT_METHOD(E7,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E7);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 8
  UINT16 ATL_SampleE8(void)
  {
    #if (ATL_DETECT_METHOD(E8,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E8);
    #endif 
    #if (ATL_DETECT_METHOD(E8,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E8);
    #endif
    #if (ATL_DETECT_METHOD(E8,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E8);
    #endif
    #if (ATL_DETECT_METHOD(E8,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E8);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 9
  UINT16 ATL_SampleE9(void)
  {
    #if (ATL_DETECT_METHOD(E9,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E9);
    #endif 
    #if (ATL_DETECT_METHOD(E9,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E9);
    #endif
    #if (ATL_DETECT_METHOD(E9,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E9);
    #endif
    #if (ATL_DETECT_METHOD(E9,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E9);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 10
  UINT16 ATL_SampleE10(void)
  {
    #if (ATL_DETECT_METHOD(E10,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E10);
    #endif 
    #if (ATL_DETECT_METHOD(E10,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E10);
    #endif
    #if (ATL_DETECT_METHOD(E10,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E10);
    #endif
    #if (ATL_DETECT_METHOD(E10,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E10);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 11
  UINT16 ATL_SampleE11(void)
  {
    #if (ATL_DETECT_METHOD(E11,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E11);
    #endif 
    #if (ATL_DETECT_METHOD(E11,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E11);
    #endif
    #if (ATL_DETECT_METHOD(E11,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E11);
    #endif
    #if (ATL_DETECT_METHOD(E11,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E11);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 12
  UINT16 ATL_SampleE12(void)
  {
    #if (ATL_DETECT_METHOD(E12,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E12);
    #endif 
    #if (ATL_DETECT_METHOD(E12,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E12);
    #endif
    #if (ATL_DETECT_METHOD(E12,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E12);
    #endif
    #if (ATL_DETECT_METHOD(E12,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E12);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 13
  UINT16 ATL_SampleE13(void)
  {
    #if (ATL_DETECT_METHOD(E13,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E13);
    #endif 
    #if (ATL_DETECT_METHOD(E13,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E13);
    #endif
    #if (ATL_DETECT_METHOD(E13,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E13);
    #endif
    #if (ATL_DETECT_METHOD(E13,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E13);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 14
  UINT16 ATL_SampleE14(void)
  {
    #if (ATL_DETECT_METHOD(E14,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E14);
    #endif 
    #if (ATL_DETECT_METHOD(E14,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E14);
    #endif
    #if (ATL_DETECT_METHOD(E14,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E14);
    #endif
    #if (ATL_DETECT_METHOD(E14,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E14);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 15
  UINT16 ATL_SampleE15(void)
  {
    #if (ATL_DETECT_METHOD(E15,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E15);
    #endif 
    #if (ATL_DETECT_METHOD(E15,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E15);
    #endif
    #if (ATL_DETECT_METHOD(E15,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E15);
    #endif
    #if (ATL_DETECT_METHOD(E15,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E15);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 16
  UINT16 ATL_SampleE16(void)
  {
    #if (ATL_DETECT_METHOD(E16,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E16);
    #endif 
    #if (ATL_DETECT_METHOD(E16,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E16);
    #endif
    #if (ATL_DETECT_METHOD(E16,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E16);
    #endif
    #if (ATL_DETECT_METHOD(E16,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E16);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 17
  UINT16 ATL_SampleE17(void)
  {
    #if (ATL_DETECT_METHOD(E17,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E17);
    #endif 
    #if (ATL_DETECT_METHOD(E17,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E17);
    #endif
    #if (ATL_DETECT_METHOD(E17,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E17);
    #endif
    #if (ATL_DETECT_METHOD(E17,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E17);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 18
  UINT16 ATL_SampleE18(void)
  {
    #if (ATL_DETECT_METHOD(E18,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E18);
    #endif 
    #if (ATL_DETECT_METHOD(E18,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E18);
    #endif
    #if (ATL_DETECT_METHOD(E18,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E18);
    #endif
    #if (ATL_DETECT_METHOD(E18,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E18);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 19
  UINT16 ATL_SampleE19(void)
  {
    #if (ATL_DETECT_METHOD(E19,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E19);
    #endif 
    #if (ATL_DETECT_METHOD(E19,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E19);
    #endif
    #if (ATL_DETECT_METHOD(E19,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E19);
    #endif
    #if (ATL_DETECT_METHOD(E19,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E19);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 20
  UINT16 ATL_SampleE20(void)
  {
    #if (ATL_DETECT_METHOD(E20,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E20);
    #endif 
    #if (ATL_DETECT_METHOD(E20,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E20);
    #endif
    #if (ATL_DETECT_METHOD(E20,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E20);
    #endif
    #if (ATL_DETECT_METHOD(E20,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E20);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 21
  UINT16 ATL_SampleE21(void)
  {
    #if (ATL_DETECT_METHOD(E21,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E21);
    #endif 
    #if (ATL_DETECT_METHOD(E21,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E21);
    #endif
    #if (ATL_DETECT_METHOD(E21,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E21);
    #endif
    #if (ATL_DETECT_METHOD(E21,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E21);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 22
  UINT16 ATL_SampleE22(void)
  {
    #if (ATL_DETECT_METHOD(E22,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E22);
    #endif 
    #if (ATL_DETECT_METHOD(E22,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E22);
    #endif
    #if (ATL_DETECT_METHOD(E22,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E22);
    #endif
    #if (ATL_DETECT_METHOD(E22,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E22);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 23
  UINT16 ATL_SampleE23(void)
  {
    #if (ATL_DETECT_METHOD(E23,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E23);
    #endif 
    #if (ATL_DETECT_METHOD(E23,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E23);
    #endif
    #if (ATL_DETECT_METHOD(E23,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E23);
    #endif
    #if (ATL_DETECT_METHOD(E23,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E23);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 24
  UINT16 ATL_SampleE24(void)
  {
    #if (ATL_DETECT_METHOD(E24,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E24);
    #endif 
    #if (ATL_DETECT_METHOD(E24,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E24);
    #endif
    #if (ATL_DETECT_METHOD(E24,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E24);
    #endif
    #if (ATL_DETECT_METHOD(E24,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E24);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 25
  UINT16 ATL_SampleE25(void)
  {
    #if (ATL_DETECT_METHOD(E25,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E25);
    #endif 
    #if (ATL_DETECT_METHOD(E25,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E25);
    #endif
    #if (ATL_DETECT_METHOD(E25,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E25);
    #endif
    #if (ATL_DETECT_METHOD(E25,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E25);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 26
  UINT16 ATL_SampleE26(void)
  {
    #if (ATL_DETECT_METHOD(E26,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E26);
    #endif 
    #if (ATL_DETECT_METHOD(E26,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E26);
    #endif
    #if (ATL_DETECT_METHOD(E26,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E26);
    #endif
    #if (ATL_DETECT_METHOD(E26,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E26);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 27
  UINT16 ATL_SampleE27(void)
  {
    #if (ATL_DETECT_METHOD(E27,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E27);
    #endif 
    #if (ATL_DETECT_METHOD(E27,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E27);
    #endif
    #if (ATL_DETECT_METHOD(E27,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E27);
    #endif
    #if (ATL_DETECT_METHOD(E27,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E27);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 28
  UINT16 ATL_SampleE28(void)
  {
    #if (ATL_DETECT_METHOD(E28,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E28);
    #endif 
    #if (ATL_DETECT_METHOD(E28,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E28);
    #endif
    #if (ATL_DETECT_METHOD(E28,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E28);
    #endif
    #if (ATL_DETECT_METHOD(E28,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E28);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 29
  UINT16 ATL_SampleE29(void)
  {
    #if (ATL_DETECT_METHOD(E29,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E29);
    #endif 
    #if (ATL_DETECT_METHOD(E29,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E29);
    #endif
    #if (ATL_DETECT_METHOD(E29,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E29);
    #endif
    #if (ATL_DETECT_METHOD(E29,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E29);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 30
  UINT16 ATL_SampleE30(void)
  {
    #if (ATL_DETECT_METHOD(E30,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E30);
    #endif 
    #if (ATL_DETECT_METHOD(E30,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E30);
    #endif
    #if (ATL_DETECT_METHOD(E30,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E30);
    #endif
    #if (ATL_DETECT_METHOD(E30,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E30);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 31
  UINT16 ATL_SampleE31(void)
  {
    #if (ATL_DETECT_METHOD(E31,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E31);
    #endif 
    #if (ATL_DETECT_METHOD(E31,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E31);
    #endif
    #if (ATL_DETECT_METHOD(E31,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E31);
    #endif
    #if (ATL_DETECT_METHOD(E31,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E31);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 32
  UINT16 ATL_SampleE32(void)
  {
    #if (ATL_DETECT_METHOD(E32,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E32);
    #endif 
    #if (ATL_DETECT_METHOD(E32,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E32);
    #endif
    #if (ATL_DETECT_METHOD(E32,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E32);
    #endif
    #if (ATL_DETECT_METHOD(E32,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E32);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 33
  UINT16 ATL_SampleE33(void)
  {
    #if (ATL_DETECT_METHOD(E33,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E33);
    #endif 
    #if (ATL_DETECT_METHOD(E33,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E33);
    #endif
    #if (ATL_DETECT_METHOD(E33,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E33);
    #endif
    #if (ATL_DETECT_METHOD(E33,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E33);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 34
  UINT16 ATL_SampleE34(void)
  {
    #if (ATL_DETECT_METHOD(E34,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E34);
    #endif 
    #if (ATL_DETECT_METHOD(E34,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E34);
    #endif
    #if (ATL_DETECT_METHOD(E34,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E34);
    #endif
    #if (ATL_DETECT_METHOD(E34,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E34);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 35
  UINT16 ATL_SampleE35(void)
  {
    #if (ATL_DETECT_METHOD(E35,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E35);
    #endif 
    #if (ATL_DETECT_METHOD(E35,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E35);
    #endif
    #if (ATL_DETECT_METHOD(E35,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E35);
    #endif
    #if (ATL_DETECT_METHOD(E35,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E35);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 36
  UINT16 ATL_SampleE36(void)
  {
    #if (ATL_DETECT_METHOD(E36,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E36);
    #endif 
    #if (ATL_DETECT_METHOD(E36,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E36);
    #endif
    #if (ATL_DETECT_METHOD(E36,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E36);
    #endif
    #if (ATL_DETECT_METHOD(E36,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E36);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 37
  UINT16 ATL_SampleE37(void)
  {
    #if (ATL_DETECT_METHOD(E37,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E37);
    #endif 
    #if (ATL_DETECT_METHOD(E37,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E37);
    #endif
    #if (ATL_DETECT_METHOD(E37,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E37);
    #endif
    #if (ATL_DETECT_METHOD(E37,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E37);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 38
  UINT16 ATL_SampleE38(void)
  {
    #if (ATL_DETECT_METHOD(E38,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E38);
    #endif 
    #if (ATL_DETECT_METHOD(E38,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E38);
    #endif
    #if (ATL_DETECT_METHOD(E38,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E38);
    #endif
    #if (ATL_DETECT_METHOD(E38,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E38);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 39
  UINT16 ATL_SampleE39(void)
  {
    #if (ATL_DETECT_METHOD(E39,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E39);
    #endif 
    #if (ATL_DETECT_METHOD(E39,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E39);
    #endif
    #if (ATL_DETECT_METHOD(E39,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E39);
    #endif
    #if (ATL_DETECT_METHOD(E39,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E39);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 40
  UINT16 ATL_SampleE40(void)
  {
    #if (ATL_DETECT_METHOD(E40,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E40);
    #endif 
    #if (ATL_DETECT_METHOD(E40,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E40);
    #endif
    #if (ATL_DETECT_METHOD(E40,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E40);
    #endif
    #if (ATL_DETECT_METHOD(E40,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E40);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 41
  UINT16 ATL_SampleE41(void)
  {
    #if (ATL_DETECT_METHOD(E41,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E41);
    #endif 
    #if (ATL_DETECT_METHOD(E41,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E41);
    #endif
    #if (ATL_DETECT_METHOD(E41,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E41);
    #endif
    #if (ATL_DETECT_METHOD(E41,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E41);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 42
  UINT16 ATL_SampleE42(void)
  {
    #if (ATL_DETECT_METHOD(E42,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E42);
    #endif 
    #if (ATL_DETECT_METHOD(E42,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E42);
    #endif
    #if (ATL_DETECT_METHOD(E42,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E42);
    #endif
    #if (ATL_DETECT_METHOD(E42,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E42);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 43
  UINT16 ATL_SampleE43(void)
  {
    #if (ATL_DETECT_METHOD(E43,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E43);
    #endif 
    #if (ATL_DETECT_METHOD(E43,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E43);
    #endif
    #if (ATL_DETECT_METHOD(E43,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E43);
    #endif
    #if (ATL_DETECT_METHOD(E43,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E43);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 44
  UINT16 ATL_SampleE44(void)
  {
    #if (ATL_DETECT_METHOD(E44,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E44);
    #endif 
    #if (ATL_DETECT_METHOD(E44,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E44);
    #endif
    #if (ATL_DETECT_METHOD(E44,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E44);
    #endif
    #if (ATL_DETECT_METHOD(E44,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E44);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 45
  UINT16 ATL_SampleE45(void)
  {
    #if (ATL_DETECT_METHOD(E45,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E45);
    #endif 
    #if (ATL_DETECT_METHOD(E45,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E45);
    #endif
    #if (ATL_DETECT_METHOD(E45,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E45);
    #endif
    #if (ATL_DETECT_METHOD(E45,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E45);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 46
  UINT16 ATL_SampleE46(void)
  {
    #if (ATL_DETECT_METHOD(E46,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E46);
    #endif 
    #if (ATL_DETECT_METHOD(E46,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E46);
    #endif
    #if (ATL_DETECT_METHOD(E46,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E46);
    #endif
    #if (ATL_DETECT_METHOD(E46,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E46);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 47
  UINT16 ATL_SampleE47(void)
  {
    #if (ATL_DETECT_METHOD(E47,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E47);
    #endif 
    #if (ATL_DETECT_METHOD(E47,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E47);
    #endif
    #if (ATL_DETECT_METHOD(E47,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E47);
    #endif
    #if (ATL_DETECT_METHOD(E47,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E47);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 48
  UINT16 ATL_SampleE48(void)
  {
    #if (ATL_DETECT_METHOD(E48,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E48);
    #endif 
    #if (ATL_DETECT_METHOD(E48,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E48);
    #endif
    #if (ATL_DETECT_METHOD(E48,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E48);
    #endif
    #if (ATL_DETECT_METHOD(E48,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E48);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 49
  UINT16 ATL_SampleE49(void)
  {
    #if (ATL_DETECT_METHOD(E49,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E49);
    #endif 
    #if (ATL_DETECT_METHOD(E49,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E49);
    #endif
    #if (ATL_DETECT_METHOD(E49,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E49);
    #endif
    #if (ATL_DETECT_METHOD(E49,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E49);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 50
  UINT16 ATL_SampleE50(void)
  {
    #if (ATL_DETECT_METHOD(E50,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E50);
    #endif 
    #if (ATL_DETECT_METHOD(E50,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E50);
    #endif
    #if (ATL_DETECT_METHOD(E50,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E50);
    #endif
    #if (ATL_DETECT_METHOD(E50,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E50);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 51
  UINT16 ATL_SampleE51(void)
  {
    #if (ATL_DETECT_METHOD(E51,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E51);
    #endif 
    #if (ATL_DETECT_METHOD(E51,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E51);
    #endif
    #if (ATL_DETECT_METHOD(E51,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E51);
    #endif
    #if (ATL_DETECT_METHOD(E51,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E51);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 52
  UINT16 ATL_SampleE52(void)
  {
    #if (ATL_DETECT_METHOD(E52,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E52);
    #endif 
    #if (ATL_DETECT_METHOD(E52,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E52);
    #endif
    #if (ATL_DETECT_METHOD(E52,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E52);
    #endif
    #if (ATL_DETECT_METHOD(E52,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E52);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 53
  UINT16 ATL_SampleE53(void)
  {
    #if (ATL_DETECT_METHOD(E53,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E53);
    #endif 
    #if (ATL_DETECT_METHOD(E53,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E53);
    #endif
    #if (ATL_DETECT_METHOD(E53,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E53);
    #endif
    #if (ATL_DETECT_METHOD(E53,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E53);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 54
  UINT16 ATL_SampleE54(void)
  {
    #if (ATL_DETECT_METHOD(E54,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E54);
    #endif 
    #if (ATL_DETECT_METHOD(E54,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E54);
    #endif
    #if (ATL_DETECT_METHOD(E54,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E54);
    #endif
    #if (ATL_DETECT_METHOD(E54,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E54);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 55
  UINT16 ATL_SampleE55(void)
  {
    #if (ATL_DETECT_METHOD(E55,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E55);
    #endif 
    #if (ATL_DETECT_METHOD(E55,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E55);
    #endif
    #if (ATL_DETECT_METHOD(E55,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E55);
    #endif
    #if (ATL_DETECT_METHOD(E55,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E55);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 56
  UINT16 ATL_SampleE56(void)
  {
    #if (ATL_DETECT_METHOD(E56,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E56);
    #endif 
    #if (ATL_DETECT_METHOD(E56,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E56);
    #endif
    #if (ATL_DETECT_METHOD(E56,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E56);
    #endif
    #if (ATL_DETECT_METHOD(E56,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E56);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 57
  UINT16 ATL_SampleE57(void)
  {
    #if (ATL_DETECT_METHOD(E57,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E57);
    #endif 
    #if (ATL_DETECT_METHOD(E57,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E57);
    #endif
    #if (ATL_DETECT_METHOD(E57,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E57);
    #endif
    #if (ATL_DETECT_METHOD(E57,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E57);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 58
  UINT16 ATL_SampleE58(void)
  {
    #if (ATL_DETECT_METHOD(E58,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E58);
    #endif 
    #if (ATL_DETECT_METHOD(E58,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E58);
    #endif
    #if (ATL_DETECT_METHOD(E58,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E58);
    #endif
    #if (ATL_DETECT_METHOD(E58,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E58);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 59
  UINT16 ATL_SampleE59(void)
  {
    #if (ATL_DETECT_METHOD(E59,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E59);
    #endif 
    #if (ATL_DETECT_METHOD(E59,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E59);
    #endif
    #if (ATL_DETECT_METHOD(E59,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E59);
    #endif
    #if (ATL_DETECT_METHOD(E59,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E59);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 60
  UINT16 ATL_SampleE60(void)
  {
    #if (ATL_DETECT_METHOD(E60,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E60);
    #endif 
    #if (ATL_DETECT_METHOD(E60,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E60);
    #endif
    #if (ATL_DETECT_METHOD(E60,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E60);
    #endif
    #if (ATL_DETECT_METHOD(E60,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E60);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 61
  UINT16 ATL_SampleE61(void)
  {
    #if (ATL_DETECT_METHOD(E61,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E61);
    #endif 
    #if (ATL_DETECT_METHOD(E61,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E61);
    #endif
    #if (ATL_DETECT_METHOD(E61,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E61);
    #endif
    #if (ATL_DETECT_METHOD(E61,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E61);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 62
  UINT16 ATL_SampleE62(void)
  {
    #if (ATL_DETECT_METHOD(E62,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E62);
    #endif 
    #if (ATL_DETECT_METHOD(E62,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E62);
    #endif
    #if (ATL_DETECT_METHOD(E62,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E62);
    #endif
    #if (ATL_DETECT_METHOD(E62,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E62);
    #endif
  }
  #endif
  
  #if TSS_N_ELECTRODES > 63
  UINT16 ATL_SampleE63(void)
  {
    #if (ATL_DETECT_METHOD(E63,GPIOM)) /* Standard GPIO Measurement */
      ATL_GPIO_METHOD_CONTROL(E63);
    #endif 
    #if (ATL_DETECT_METHOD(E63,KBIM)) /* KBIM Measurement */
      ATL_KBI_METHOD_CONTROL(E63);
    #endif
    #if (ATL_DETECT_METHOD(E63,PTIM)) /* PTIM Measurement */
      ATL_PTI_METHOD_CONTROL(E63);
    #endif
    #if (ATL_DETECT_METHOD(E63,TIMERICM)) /* TIMER ICM Measurement */
      ATL_TPMIC_METHOD_CONTROL(E63);
    #endif
  }
  #endif
  
#endif  /*TSS_USE_ATL_LOW_LEVEL*/ 
