/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   ATL_Sensor.h
*
* @brief  Functions Prototypes, constants, variables and macros for the sensing of electrodes
*
* @version 1.0.32.0
* 
* @date Jun-11-2010
* 
*
***********************************************************************************************************************/


#ifndef __ATL_SENSOR_H__
  #define __ATL_SENSOR_H__

  #include "derivative.h" 
  #include "TSS_API.h"
  #include "TSS_GPIO.h"

  extern UINT16 tss_u16CapSample;
  extern UINT8 atl_u8HWTimerFlag;
  
  extern volatile UINT8 *atl_pu8ElectrodePortAdr;
  extern volatile UINT8 atl_u8ElectrodePortMask;

  extern UINT8 atl_u8SampleIntFlag;                            /* Extern Variable Flag for sample interrupted*/
  
  /*******************************************************
   ************ ATL Sensor Interrupt Vectors *************
   *******************************************************/

  /* GPIO Method HW Timer Interrupt */
  extern void ATL_HWTimerIsr(void);
    
  /* KBI Method Interrupts */
  extern void ATL_KBIIsr(void);
  extern void ATL_KBI1Isr(void);
  extern void ATL_KBI2Isr(void);
  extern void ATL_KBI3Isr(void);  
  
  /* Pin Interrupt Method Interrupts */
  extern void ATL_PIAIsr(void);  
  extern void ATL_PIBIsr(void);
  extern void ATL_PICIsr(void);
  extern void ATL_PIDIsr(void);
  extern void ATL_PIJIsr(void);
  
  /* Timer Input Capture Method Interrupts */
  extern void ATL_TPMIsr(void);
  extern void ATL_TPM1Isr(void);
  extern void ATL_TPM2Isr(void);
  extern void ATL_TPM3Isr(void);
  extern void ATL_TPM4Isr(void);
  extern void ATL_FTMIsr(void);
  extern void ATL_FTM1Isr(void);
  extern void ATL_FTM2Isr(void);
  extern void ATL_FTM3Isr(void);
  extern void ATL_FTM4Isr(void);

  /*******************************************************
   *************** Constants Definitions *****************
   *******************************************************/

  #define ATL_ELEC_STATE_INPUT            0xFFU         /* Command for electrode as input */
  #define ATL_ELEC_STATE_HIGH             0x01U         /* Command for electrode as high  */
  #define ATL_ELEC_STATE_LOW              0x02U         /* Command for electrode as low   */

  /* Set Default values */
  #define ATL_FAULT_TIMEOUT               255u
  
  #ifndef ATL_SENSOR_PRESCALER
    #define ATL_SENSOR_PRESCALER          2u
  #endif
  #ifndef ATL_SENSOR_TIMEOUT
    #define ATL_SENSOR_TIMEOUT            0x1FFu
  #endif  

  #define ATL_KEYDETECT_CAP_LOWER_LIMIT   100U           /* Calculate bus cycles */
  
  #define ATL_DEFAULT_NOISE_WINDOW_SIZE   255u
  
  #ifdef __HCS08__
    #define ATL_GOTO_WAIT()               {asm ( wait; );}
  #endif

  #ifdef __COLDFIRE__
    #ifdef SOPT_WAITE
      #define ATL_GOTO_WAIT()             {SOPT_WAITE = 1;asm ( nop; stop #0x2000; );}
    #endif
    #ifdef SOPT1_WAITE      
      #define ATL_GOTO_WAIT()             {SOPT1_WAITE = 1;asm ( nop; stop #0x2000; );}
    #endif
  #endif

  /*******************************************************
   ***************** Setting validation ******************
   *******************************************************/
  
  #if TSS_USE_IIR_FILTER
    #if (ATL_SENSOR_TIMEOUT > 0x1FFu)
      #error "ATL_SENSOR_TIMEOUT exceeded maximum value 0x1FF with IIR Filter enabled"
    #endif
  #else 
    #if (ATL_SENSOR_TIMEOUT > 0x7FFu)
      #error "ATL_SENSOR_TIMEOUT exceeded maximum value 0x7FF with IIR Filter disabled"
    #endif
  #endif
  
  /*******************************************************
   ****************** Functions Declarations *************
   *******************************************************/

  UINT8 ATL_SampleElectrode(UINT8 u8ElecNum);
  /*
  function:   ATL_SampleElectrode
  brief:      Performs a valid reading of one electrode, stores the timer values and returns a status code
  param:      u8ElecNum   -  Number of electrode to be scanned
  return:     Status code                              
  */                           

  UINT8 ATL_SensorInit(void);
  /*
  function:   ATL_SensorInit
  brief:      Initializes the HW Timer, KBI, PTI and Timer Input Capture peripherals 
              for the sensing of the electrodes.
  param:      Void                           
  return:     Status code                              
  */

  UINT16 ATL_SampleE0(void);
  /*
  function:   ATL_SampleEX
  brief:      Samples one electrode
  param:      Void                            
  return:     UINT16 Measured capacitance value
  */

  /* Depending on the number of electrodes defined, the function declarations are compiled */ 
  #if TSS_N_ELECTRODES > 1          
      UINT16 ATL_SampleE1(void);
  #endif
  #if TSS_N_ELECTRODES > 2 
      UINT16 ATL_SampleE2(void);
  #endif
  #if TSS_N_ELECTRODES > 3 
      UINT16 ATL_SampleE3(void);
  #endif
  #if TSS_N_ELECTRODES > 4 
      UINT16 ATL_SampleE4(void);
  #endif
  #if TSS_N_ELECTRODES > 5 
      UINT16 ATL_SampleE5(void);
  #endif
  #if TSS_N_ELECTRODES > 6 
      UINT16 ATL_SampleE6(void);
  #endif
  #if TSS_N_ELECTRODES > 7 
      UINT16 ATL_SampleE7(void);
  #endif
  #if TSS_N_ELECTRODES > 8 
      UINT16 ATL_SampleE8(void);
  #endif
  #if TSS_N_ELECTRODES > 9 
      UINT16 ATL_SampleE9(void);
  #endif
  #if TSS_N_ELECTRODES > 10
      UINT16 ATL_SampleE10(void);
  #endif
  #if TSS_N_ELECTRODES > 11
      UINT16 ATL_SampleE11(void);
  #endif
  #if TSS_N_ELECTRODES > 12
      UINT16 ATL_SampleE12(void);
  #endif
  #if TSS_N_ELECTRODES > 13
      UINT16 ATL_SampleE13(void);
  #endif
  #if TSS_N_ELECTRODES > 14
      UINT16 ATL_SampleE14(void);
  #endif
  #if TSS_N_ELECTRODES > 15
      UINT16 ATL_SampleE15(void);
  #endif
  #if TSS_N_ELECTRODES > 16
      UINT16 ATL_SampleE16(void);
  #endif
  #if TSS_N_ELECTRODES > 17
      UINT16 ATL_SampleE17(void);
  #endif
  #if TSS_N_ELECTRODES > 18
      UINT16 ATL_SampleE18(void);
  #endif
  #if TSS_N_ELECTRODES > 19
      UINT16 ATL_SampleE19(void);
  #endif
  #if TSS_N_ELECTRODES > 20
      UINT16 ATL_SampleE20(void);
  #endif
  #if TSS_N_ELECTRODES > 21
      UINT16 ATL_SampleE21(void);
  #endif
  #if TSS_N_ELECTRODES > 22
      UINT16 ATL_SampleE22(void);
  #endif
  #if TSS_N_ELECTRODES > 23
      UINT16 ATL_SampleE23(void);
  #endif
  #if TSS_N_ELECTRODES > 24
      UINT16 ATL_SampleE24(void);
  #endif
  #if TSS_N_ELECTRODES > 25
      UINT16 ATL_SampleE25(void);
  #endif
  #if TSS_N_ELECTRODES > 26
      UINT16 ATL_SampleE26(void);
  #endif
  #if TSS_N_ELECTRODES > 27
      UINT16 ATL_SampleE27(void);
  #endif
  #if TSS_N_ELECTRODES > 28
      UINT16 ATL_SampleE28(void);
  #endif
  #if TSS_N_ELECTRODES > 29
      UINT16 ATL_SampleE29(void);
  #endif
  #if TSS_N_ELECTRODES > 30
      UINT16 ATL_SampleE30(void);
  #endif
  #if TSS_N_ELECTRODES > 31
      UINT16 ATL_SampleE31(void);
  #endif
  #if TSS_N_ELECTRODES > 32
      UINT16 ATL_SampleE32(void);
  #endif
  #if TSS_N_ELECTRODES > 33
      UINT16 ATL_SampleE33(void);
  #endif
  #if TSS_N_ELECTRODES > 34
      UINT16 ATL_SampleE34(void);
  #endif
  #if TSS_N_ELECTRODES > 35
      UINT16 ATL_SampleE35(void);
  #endif
  #if TSS_N_ELECTRODES > 36
      UINT16 ATL_SampleE36(void);
  #endif
  #if TSS_N_ELECTRODES > 37
      UINT16 ATL_SampleE37(void);
  #endif
  #if TSS_N_ELECTRODES > 38
      UINT16 ATL_SampleE38(void);
  #endif
  #if TSS_N_ELECTRODES > 39
      UINT16 ATL_SampleE39(void);
  #endif
  #if TSS_N_ELECTRODES > 40
      UINT16 ATL_SampleE40(void);
  #endif
  #if TSS_N_ELECTRODES > 41
      UINT16 ATL_SampleE41(void);
  #endif
  #if TSS_N_ELECTRODES > 42
      UINT16 ATL_SampleE42(void);
  #endif
  #if TSS_N_ELECTRODES > 43
      UINT16 ATL_SampleE43(void);
  #endif
  #if TSS_N_ELECTRODES > 44
      UINT16 ATL_SampleE44(void);
  #endif
  #if TSS_N_ELECTRODES > 45
      UINT16 ATL_SampleE45(void);
  #endif
  #if TSS_N_ELECTRODES > 46
      UINT16 ATL_SampleE46(void);
  #endif
  #if TSS_N_ELECTRODES > 47
      UINT16 ATL_SampleE47(void);
  #endif
  #if TSS_N_ELECTRODES > 48
      UINT16 ATL_SampleE48(void);
  #endif
  #if TSS_N_ELECTRODES > 49
      UINT16 ATL_SampleE49(void);
  #endif
  #if TSS_N_ELECTRODES > 50
      UINT16 ATL_SampleE50(void);
  #endif
  #if TSS_N_ELECTRODES > 51
      UINT16 ATL_SampleE51(void);
  #endif
  #if TSS_N_ELECTRODES > 52
      UINT16 ATL_SampleE52(void);
  #endif
  #if TSS_N_ELECTRODES > 53
      UINT16 ATL_SampleE53(void);
  #endif
  #if TSS_N_ELECTRODES > 54
      UINT16 ATL_SampleE54(void);
  #endif
  #if TSS_N_ELECTRODES > 55
      UINT16 ATL_SampleE55(void);
  #endif
  #if TSS_N_ELECTRODES > 56
      UINT16 ATL_SampleE56(void);
  #endif
  #if TSS_N_ELECTRODES > 57
      UINT16 ATL_SampleE57(void);
  #endif
  #if TSS_N_ELECTRODES > 58
      UINT16 ATL_SampleE58(void);
  #endif
  #if TSS_N_ELECTRODES > 59
      UINT16 ATL_SampleE59(void);
  #endif
  #if TSS_N_ELECTRODES > 60
      UINT16 ATL_SampleE60(void);
  #endif
  #if TSS_N_ELECTRODES > 61
      UINT16 ATL_SampleE61(void);
  #endif
  #if TSS_N_ELECTRODES > 62
      UINT16 ATL_SampleE62(void);
  #endif
  #if TSS_N_ELECTRODES > 63
      UINT16 ATL_SampleE63(void);
  #endif

  /* If not defined Electrode Type then set to default GPIO type, or if is not used electrode set UNUSED */
  #if TSS_N_ELECTRODES > 0
    #ifndef TSS_E0_TYPE
      #define TSS_E0_TYPE      GPIO
    #endif
  #else
    #undef TSS_E0_TYPE
    #define TSS_E0_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 1
    #ifndef TSS_E1_TYPE
      #define TSS_E1_TYPE      GPIO
    #endif
  #else
    #undef TSS_E1_TYPE
    #define TSS_E1_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 2
    #ifndef TSS_E2_TYPE
      #define TSS_E2_TYPE      GPIO
    #endif
  #else
    #undef TSS_E2_TYPE
    #define TSS_E2_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 3
    #ifndef TSS_E3_TYPE
      #define TSS_E3_TYPE      GPIO
    #endif
  #else
    #undef TSS_E3_TYPE
    #define TSS_E3_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 4
    #ifndef TSS_E4_TYPE
      #define TSS_E4_TYPE      GPIO
    #endif
  #else
    #undef TSS_E4_TYPE
    #define TSS_E4_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 5
    #ifndef TSS_E5_TYPE
      #define TSS_E5_TYPE      GPIO
    #endif
  #else
    #undef TSS_E5_TYPE
    #define TSS_E5_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 6
    #ifndef TSS_E6_TYPE
      #define TSS_E6_TYPE      GPIO
    #endif
  #else
    #undef TSS_E6_TYPE
    #define TSS_E6_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 7
    #ifndef TSS_E7_TYPE
      #define TSS_E7_TYPE      GPIO
    #endif
  #else
    #undef TSS_E7_TYPE
    #define TSS_E7_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 8
    #ifndef TSS_E8_TYPE
      #define TSS_E8_TYPE      GPIO
    #endif
  #else
    #undef TSS_E8_TYPE
    #define TSS_E8_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 9
    #ifndef TSS_E9_TYPE
      #define TSS_E9_TYPE      GPIO
    #endif
  #else
    #undef TSS_E9_TYPE
    #define TSS_E9_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 10
    #ifndef TSS_E10_TYPE
      #define TSS_E10_TYPE      GPIO
    #endif
  #else
    #undef TSS_E10_TYPE
    #define TSS_E10_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 11
    #ifndef TSS_E11_TYPE
      #define TSS_E11_TYPE      GPIO
    #endif
  #else
    #undef TSS_E11_TYPE
    #define TSS_E11_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 12
    #ifndef TSS_E12_TYPE
      #define TSS_E12_TYPE      GPIO
    #endif
  #else
    #undef TSS_E12_TYPE
    #define TSS_E12_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 13
    #ifndef TSS_E13_TYPE
      #define TSS_E13_TYPE      GPIO
    #endif
  #else
    #undef TSS_E13_TYPE
    #define TSS_E13_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 14
    #ifndef TSS_E14_TYPE
      #define TSS_E14_TYPE      GPIO
    #endif
  #else
    #undef TSS_E14_TYPE
    #define TSS_E14_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 15
    #ifndef TSS_E15_TYPE
      #define TSS_E15_TYPE      GPIO
    #endif
  #else
    #undef TSS_E15_TYPE
    #define TSS_E15_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 16
    #ifndef TSS_E16_TYPE
      #define TSS_E16_TYPE      GPIO
    #endif
  #else
    #undef TSS_E16_TYPE
    #define TSS_E16_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 17
    #ifndef TSS_E17_TYPE
      #define TSS_E17_TYPE      GPIO
    #endif
  #else
    #undef TSS_E17_TYPE
    #define TSS_E17_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 18
    #ifndef TSS_E18_TYPE
      #define TSS_E18_TYPE      GPIO
    #endif
  #else
    #undef TSS_E18_TYPE
    #define TSS_E18_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 19
    #ifndef TSS_E19_TYPE
      #define TSS_E19_TYPE      GPIO
    #endif
  #else
    #undef TSS_E19_TYPE
    #define TSS_E19_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 20
    #ifndef TSS_E20_TYPE
      #define TSS_E20_TYPE      GPIO
    #endif
  #else
    #undef TSS_E20_TYPE
    #define TSS_E20_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 21
    #ifndef TSS_E21_TYPE
      #define TSS_E21_TYPE      GPIO
    #endif
  #else
    #undef TSS_E21_TYPE
    #define TSS_E21_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 22
    #ifndef TSS_E22_TYPE
      #define TSS_E22_TYPE      GPIO
    #endif
  #else
    #undef TSS_E22_TYPE
    #define TSS_E22_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 23
    #ifndef TSS_E23_TYPE
      #define TSS_E23_TYPE      GPIO
    #endif
  #else
    #undef TSS_E23_TYPE
    #define TSS_E23_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 24
    #ifndef TSS_E24_TYPE
      #define TSS_E24_TYPE      GPIO
    #endif
  #else
    #undef TSS_E24_TYPE
    #define TSS_E24_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 25
    #ifndef TSS_E25_TYPE
      #define TSS_E25_TYPE      GPIO
    #endif
  #else
    #undef TSS_E25_TYPE
    #define TSS_E25_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 26
    #ifndef TSS_E26_TYPE
      #define TSS_E26_TYPE      GPIO
    #endif
  #else
    #undef TSS_E26_TYPE
    #define TSS_E26_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 27
    #ifndef TSS_E27_TYPE
      #define TSS_E27_TYPE      GPIO
    #endif
  #else
    #undef TSS_E27_TYPE
    #define TSS_E27_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 28
    #ifndef TSS_E28_TYPE
      #define TSS_E28_TYPE      GPIO
    #endif
  #else
    #undef TSS_E28_TYPE
    #define TSS_E28_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 29
    #ifndef TSS_E29_TYPE
      #define TSS_E29_TYPE      GPIO
    #endif
  #else
    #undef TSS_E29_TYPE
    #define TSS_E29_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 30
    #ifndef TSS_E30_TYPE
      #define TSS_E30_TYPE      GPIO
    #endif
  #else
    #undef TSS_E30_TYPE
    #define TSS_E30_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 31
    #ifndef TSS_E31_TYPE
      #define TSS_E31_TYPE      GPIO
    #endif
  #else
    #undef TSS_E31_TYPE
    #define TSS_E31_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 32
    #ifndef TSS_E32_TYPE
      #define TSS_E32_TYPE      GPIO
    #endif
  #else
    #undef TSS_E32_TYPE
    #define TSS_E32_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 33
    #ifndef TSS_E33_TYPE
      #define TSS_E33_TYPE      GPIO
    #endif
  #else
    #undef TSS_E33_TYPE
    #define TSS_E33_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 34
    #ifndef TSS_E34_TYPE
      #define TSS_E34_TYPE      GPIO
    #endif
  #else
    #undef TSS_E34_TYPE
    #define TSS_E34_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 35
    #ifndef TSS_E35_TYPE
      #define TSS_E35_TYPE      GPIO
    #endif
  #else
    #undef TSS_E35_TYPE
    #define TSS_E35_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 36
    #ifndef TSS_E36_TYPE
      #define TSS_E36_TYPE      GPIO
    #endif
  #else
    #undef TSS_E36_TYPE
    #define TSS_E36_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 37
    #ifndef TSS_E37_TYPE
      #define TSS_E37_TYPE      GPIO
    #endif
  #else
    #undef TSS_E37_TYPE
    #define TSS_E37_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 38
    #ifndef TSS_E38_TYPE
      #define TSS_E38_TYPE      GPIO
    #endif
  #else
    #undef TSS_E38_TYPE
    #define TSS_E38_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 39
    #ifndef TSS_E39_TYPE
      #define TSS_E39_TYPE      GPIO
    #endif
  #else
    #undef TSS_E39_TYPE
    #define TSS_E39_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 40
    #ifndef TSS_E40_TYPE
      #define TSS_E40_TYPE      GPIO
    #endif
  #else
    #undef TSS_E40_TYPE
    #define TSS_E40_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 41
    #ifndef TSS_E41_TYPE
      #define TSS_E41_TYPE      GPIO
    #endif
  #else
    #undef TSS_E41_TYPE
    #define TSS_E41_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 42
    #ifndef TSS_E42_TYPE
      #define TSS_E42_TYPE      GPIO
    #endif
  #else
    #undef TSS_E42_TYPE
    #define TSS_E42_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 43
    #ifndef TSS_E43_TYPE
      #define TSS_E43_TYPE      GPIO
    #endif
  #else
    #undef TSS_E43_TYPE
    #define TSS_E43_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 44
    #ifndef TSS_E44_TYPE
      #define TSS_E44_TYPE      GPIO
    #endif
  #else
    #undef TSS_E44_TYPE
    #define TSS_E44_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 45
    #ifndef TSS_E45_TYPE
      #define TSS_E45_TYPE      GPIO
    #endif
  #else
    #undef TSS_E45_TYPE
    #define TSS_E45_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 46
    #ifndef TSS_E46_TYPE
      #define TSS_E46_TYPE      GPIO
    #endif
  #else
    #undef TSS_E46_TYPE
    #define TSS_E46_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 47
    #ifndef TSS_E47_TYPE
      #define TSS_E47_TYPE      GPIO
    #endif
  #else
    #undef TSS_E47_TYPE
    #define TSS_E47_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 48
    #ifndef TSS_E48_TYPE
      #define TSS_E48_TYPE      GPIO
    #endif
  #else
    #undef TSS_E48_TYPE
    #define TSS_E48_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 49
    #ifndef TSS_E49_TYPE
      #define TSS_E49_TYPE      GPIO
    #endif
  #else
    #undef TSS_E49_TYPE
    #define TSS_E49_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 50
    #ifndef TSS_E50_TYPE
      #define TSS_E50_TYPE      GPIO
    #endif
  #else
    #undef TSS_E50_TYPE
    #define TSS_E50_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 51
    #ifndef TSS_E51_TYPE
      #define TSS_E51_TYPE      GPIO
    #endif
  #else
    #undef TSS_E51_TYPE
    #define TSS_E51_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 52
    #ifndef TSS_E52_TYPE
      #define TSS_E52_TYPE      GPIO
    #endif
  #else
    #undef TSS_E52_TYPE
    #define TSS_E52_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 53
    #ifndef TSS_E53_TYPE
      #define TSS_E53_TYPE      GPIO
    #endif
  #else
    #undef TSS_E53_TYPE
    #define TSS_E53_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 54
    #ifndef TSS_E54_TYPE
      #define TSS_E54_TYPE      GPIO
    #endif
  #else
    #undef TSS_E54_TYPE
    #define TSS_E54_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 55
    #ifndef TSS_E55_TYPE
      #define TSS_E55_TYPE      GPIO
    #endif
  #else
    #undef TSS_E55_TYPE
    #define TSS_E55_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 56
    #ifndef TSS_E56_TYPE
      #define TSS_E56_TYPE      GPIO
    #endif
  #else
    #undef TSS_E56_TYPE
    #define TSS_E56_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 57
    #ifndef TSS_E57_TYPE
      #define TSS_E57_TYPE      GPIO
    #endif
  #else
    #undef TSS_E57_TYPE
    #define TSS_E57_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 58
    #ifndef TSS_E58_TYPE
      #define TSS_E58_TYPE      GPIO
    #endif
  #else
    #undef TSS_E58_TYPE
    #define TSS_E58_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 59
    #ifndef TSS_E59_TYPE
      #define TSS_E59_TYPE      GPIO
    #endif
  #else
    #undef TSS_E59_TYPE
    #define TSS_E59_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 60
    #ifndef TSS_E60_TYPE
      #define TSS_E60_TYPE      GPIO
    #endif
  #else
    #undef TSS_E60_TYPE
    #define TSS_E60_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 61
    #ifndef TSS_E61_TYPE
      #define TSS_E61_TYPE      GPIO
    #endif
  #else
    #undef TSS_E61_TYPE
    #define TSS_E61_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 62
    #ifndef TSS_E62_TYPE
      #define TSS_E62_TYPE      GPIO
    #endif
  #else
    #undef TSS_E62_TYPE
    #define TSS_E62_TYPE        UNUSED
  #endif
  #if TSS_N_ELECTRODES > 63
    #ifndef TSS_E63_TYPE
      #define TSS_E63_TYPE      GPIO
    #endif
  #else
    #undef TSS_E63_TYPE
    #define TSS_E63_TYPE        UNUSED
  #endif

  /**************************************************************************************
  * The section below is related to GPIO, KBI/PTI and TPM/FTM INPUT CAPTURE Methods
  * 
  **************************************************************************************/

  /* UNUSED Identificator */
  #define ATL_UNUSEDM_CHK   0xFF >> 4         /* Identificatior of UNUSED electrode */
  
  #define ATL_UNUSED_CHK    0xFF

  /* GPIO Identificator */
  #define ATL_GPIOM_CHK     0x10 >> 4         /* Identificatior of All GPIO Method using electrodes */
  
  #define ATL_GPIO_CHK      0x10
  
  /* KBI Identificator */
  #define ATL_KBIM_CHK      0x20 >> 4         /* Identificatior of All KBI Method using electrodes */
  
  #define ATL_KBIX_CHK      0x20
  
  #define ATL_KBI0_CHK      0x20
  #define ATL_KBI1_CHK      0x20
  #define ATL_KBI2_CHK      0x20
  #define ATL_KBI3_CHK      0x20
  #define ATL_KBI4_CHK      0x20
  #define ATL_KBI5_CHK      0x20
  #define ATL_KBI6_CHK      0x20
  #define ATL_KBI7_CHK      0x20

  #define ATL_KBIP0_CHK     ATL_KBI0_CHK
  #define ATL_KBIP1_CHK     ATL_KBI1_CHK
  #define ATL_KBIP2_CHK     ATL_KBI2_CHK
  #define ATL_KBIP3_CHK     ATL_KBI3_CHK
  #define ATL_KBIP4_CHK     ATL_KBI4_CHK
  #define ATL_KBIP5_CHK     ATL_KBI5_CHK
  #define ATL_KBIP6_CHK     ATL_KBI6_CHK
  #define ATL_KBIP7_CHK     ATL_KBI7_CHK
  
  /* JR12 exception */
  #define ATL_KBIP8_CHK     ATL_KBI2P0_CHK
  #define ATL_KBIP9_CHK     ATL_KBI2P1_CHK
  #define ATL_KBIP10_CHK    ATL_KBI2P2_CHK
  #define ATL_KBIP11_CHK    ATL_KBI2P3_CHK
  #define ATL_KBIP12_CHK    ATL_KBI2P4_CHK
  #define ATL_KBIP13_CHK    ATL_KBI2P5_CHK
  #define ATL_KBIP14_CHK    ATL_KBI2P6_CHK
  #define ATL_KBIP15_CHK    ATL_KBI2P7_CHK
  
  #define ATL_KBI1X_CHK     0x21
  
  #define ATL_KBI1P0_CHK    0x21
  #define ATL_KBI1P1_CHK    0x21
  #define ATL_KBI1P2_CHK    0x21
  #define ATL_KBI1P3_CHK    0x21
  #define ATL_KBI1P4_CHK    0x21
  #define ATL_KBI1P5_CHK    0x21
  #define ATL_KBI1P6_CHK    0x21
  #define ATL_KBI1P7_CHK    0x21
  
  #define ATL_KBI2X_CHK     0x22
  
  #define ATL_KBI2P0_CHK    0x22
  #define ATL_KBI2P1_CHK    0x22
  #define ATL_KBI2P2_CHK    0x22
  #define ATL_KBI2P3_CHK    0x22
  #define ATL_KBI2P4_CHK    0x22
  #define ATL_KBI2P5_CHK    0x22
  #define ATL_KBI2P6_CHK    0x22
  #define ATL_KBI2P7_CHK    0x22
  
  #define ATL_KBI3X_CHK     0x23
  
  #define ATL_KBI3P0_CHK    0x23
  #define ATL_KBI3P1_CHK    0x23
  #define ATL_KBI3P2_CHK    0x23
  #define ATL_KBI3P3_CHK    0x23
  #define ATL_KBI3P4_CHK    0x23
  #define ATL_KBI3P5_CHK    0x23
  #define ATL_KBI3P6_CHK    0x23
  #define ATL_KBI3P7_CHK    0x23
  
  /* PTI Identificator */
  #define ATL_PTIM_CHK      0x30 >> 4         /* Identificatior of All PTI Method using electrodes */
  
  #define ATL_PTI_CHK       0x30
  
  #define ATL_PIA_CHK       0x31
  #define ATL_PIB_CHK       0x32
  #define ATL_PIC_CHK       0x33
  #define ATL_PID_CHK       0x34
  #define ATL_PIJ_CHK       0x35
  
  /* TPM/FTM Identificator */
  #define ATL_TIMERICM_CHK  0x40 >> 4         /* Identificatior of All TPM/FTM Input Capture Method using electrodes */
  
  #define ATL_TPMICM_CHK    0x40
  
  #define ATL_TPMCH0_CHK    0x40
  #define ATL_TPMCH1_CHK    0x40
  #define ATL_TPMCH2_CHK    0x40
  #define ATL_TPMCH3_CHK    0x40
  #define ATL_TPMCH4_CHK    0x40
  #define ATL_TPMCH5_CHK    0x40
  #define ATL_TPMCH6_CHK    0x40
  #define ATL_TPMCH7_CHK    0x40

  #define ATL_TPM1ICM_CHK   0x41
  
  #define ATL_TPM1CH0_CHK   0x41
  #define ATL_TPM1CH1_CHK   0x41
  #define ATL_TPM1CH2_CHK   0x41
  #define ATL_TPM1CH3_CHK   0x41
  #define ATL_TPM1CH4_CHK   0x41
  #define ATL_TPM1CH5_CHK   0x41
  #define ATL_TPM1CH6_CHK   0x41
  #define ATL_TPM1CH7_CHK   0x41
  
  #define ATL_TPM2ICM_CHK   0x42
  
  #define ATL_TPM2CH0_CHK   0x42
  #define ATL_TPM2CH1_CHK   0x42
  #define ATL_TPM2CH2_CHK   0x42
  #define ATL_TPM2CH3_CHK   0x42
  #define ATL_TPM2CH4_CHK   0x42
  #define ATL_TPM2CH5_CHK   0x42
  #define ATL_TPM2CH6_CHK   0x42
  #define ATL_TPM2CH7_CHK   0x42
  
  #define ATL_TPM3ICM_CHK   0x43
  
  #define ATL_TPM3CH0_CHK   0x43
  #define ATL_TPM3CH1_CHK   0x43
  #define ATL_TPM3CH2_CHK   0x43
  #define ATL_TPM3CH3_CHK   0x43
  #define ATL_TPM3CH4_CHK   0x43
  #define ATL_TPM3CH5_CHK   0x43
  #define ATL_TPM3CH6_CHK   0x43
  #define ATL_TPM3CH7_CHK   0x43
  
  #define ATL_TPM4ICM_CHK   0x44
  
  #define ATL_TPM4CH0_CHK   0x44
  #define ATL_TPM4CH1_CHK   0x44
  #define ATL_TPM4CH2_CHK   0x44
  #define ATL_TPM4CH3_CHK   0x44
  #define ATL_TPM4CH4_CHK   0x44
  #define ATL_TPM4CH5_CHK   0x44
  #define ATL_TPM4CH6_CHK   0x44
  #define ATL_TPM4CH7_CHK   0x44
  
  #define ATL_FTMICM_CHK    0x45
  
  #define ATL_FTMCH0_CHK    0x45
  #define ATL_FTMCH1_CHK    0x45
  #define ATL_FTMCH2_CHK    0x45
  #define ATL_FTMCH3_CHK    0x45
  #define ATL_FTMCH4_CHK    0x45
  #define ATL_FTMCH5_CHK    0x45
  #define ATL_FTMCH6_CHK    0x45
  #define ATL_FTMCH7_CHK    0x45

  #define ATL_FTM1ICM_CHK   0x46
  
  #define ATL_FTM1CH0_CHK   0x46
  #define ATL_FTM1CH1_CHK   0x46
  #define ATL_FTM1CH2_CHK   0x46
  #define ATL_FTM1CH3_CHK   0x46
  #define ATL_FTM1CH4_CHK   0x46
  #define ATL_FTM1CH5_CHK   0x46
  #define ATL_FTM1CH6_CHK   0x46
  #define ATL_FTM1CH7_CHK   0x46

  #define ATL_FTM2ICM_CHK   0x47
  
  #define ATL_FTM2CH0_CHK   0x47
  #define ATL_FTM2CH1_CHK   0x47
  #define ATL_FTM2CH2_CHK   0x47
  #define ATL_FTM2CH3_CHK   0x47
  #define ATL_FTM2CH4_CHK   0x47
  #define ATL_FTM2CH5_CHK   0x47
  #define ATL_FTM2CH6_CHK   0x47
  #define ATL_FTM2CH7_CHK   0x47
  
  #define ATL_FTM3ICM_CHK   0x48
  
  #define ATL_FTM3CH0_CHK   0x48
  #define ATL_FTM3CH1_CHK   0x48
  #define ATL_FTM3CH2_CHK   0x48
  #define ATL_FTM3CH3_CHK   0x48
  #define ATL_FTM3CH4_CHK   0x48
  #define ATL_FTM3CH5_CHK   0x48
  #define ATL_FTM3CH6_CHK   0x48
  #define ATL_FTM3CH7_CHK   0x48
  
  #define ATL_FTM4ICM_CHK   0x49
  
  #define ATL_FTM4CH0_CHK   0x49
  #define ATL_FTM4CH1_CHK   0x49
  #define ATL_FTM4CH2_CHK   0x49
  #define ATL_FTM4CH3_CHK   0x49
  #define ATL_FTM4CH4_CHK   0x49
  #define ATL_FTM4CH5_CHK   0x49
  #define ATL_FTM4CH6_CHK   0x49
  #define ATL_FTM4CH7_CHK   0x49

  #define ATL_ELEC_TYPE2NAME_RESULT(res)      ATL_##res##_CHK
  #define ATL_ELEC_TYPE2NAME_CONV(text)       ATL_ELEC_TYPE2NAME_RESULT(text)
  #define ATL_ELEC_TYPE_CHK(elec)             ATL_ELEC_TYPE2NAME_CONV(elec)
  
  #define ATL_DETECT_METHOD(el,method)        ATL_ELEC_TYPE_CHK(TSS_##el##_TYPE) >> 4 == ATL_##method##_CHK

  /**********************************************************************************
  * The section below is related just with GPIO Method of the electrodes
  * 
  ***********************************************************************************/
   
  #define ATL_GPIO_E0_USE         (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E1_USE         (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E2_USE         (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E3_USE         (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E4_USE         (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E5_USE         (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E6_USE         (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E7_USE         (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E8_USE         (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E9_USE         (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_GPIO_CHK)
  #define ATL_GPIO_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_GPIO_CHK)

  #define ATL_GPIO_USED           (ATL_GPIO_E0_USE || ATL_GPIO_E1_USE || ATL_GPIO_E2_USE || ATL_GPIO_E3_USE || ATL_GPIO_E4_USE || ATL_GPIO_E5_USE || ATL_GPIO_E6_USE || ATL_GPIO_E7_USE || ATL_GPIO_E8_USE || ATL_GPIO_E9_USE || ATL_GPIO_E10_USE || ATL_GPIO_E11_USE || ATL_GPIO_E12_USE || ATL_GPIO_E13_USE || ATL_GPIO_E14_USE || ATL_GPIO_E15_USE || ATL_GPIO_E16_USE || ATL_GPIO_E17_USE || ATL_GPIO_E18_USE || ATL_GPIO_E19_USE || ATL_GPIO_E20_USE || ATL_GPIO_E21_USE || ATL_GPIO_E22_USE || ATL_GPIO_E23_USE || ATL_GPIO_E24_USE || ATL_GPIO_E25_USE || ATL_GPIO_E26_USE || ATL_GPIO_E27_USE || ATL_GPIO_E28_USE || ATL_GPIO_E29_USE || ATL_GPIO_E30_USE || ATL_GPIO_E31_USE || ATL_GPIO_E32_USE || ATL_GPIO_E33_USE || ATL_GPIO_E34_USE || ATL_GPIO_E35_USE || ATL_GPIO_E36_USE || ATL_GPIO_E37_USE || ATL_GPIO_E38_USE || ATL_GPIO_E39_USE || ATL_GPIO_E40_USE || ATL_GPIO_E41_USE || ATL_GPIO_E42_USE || ATL_GPIO_E43_USE || ATL_GPIO_E44_USE || ATL_GPIO_E45_USE || ATL_GPIO_E46_USE || ATL_GPIO_E47_USE || ATL_GPIO_E48_USE || ATL_GPIO_E49_USE || ATL_GPIO_E50_USE || ATL_GPIO_E51_USE || ATL_GPIO_E52_USE || ATL_GPIO_E53_USE || ATL_GPIO_E54_USE || ATL_GPIO_E55_USE || ATL_GPIO_E56_USE || ATL_GPIO_E57_USE || ATL_GPIO_E58_USE || ATL_GPIO_E59_USE || ATL_GPIO_E60_USE || ATL_GPIO_E61_USE || ATL_GPIO_E62_USE || ATL_GPIO_E63_USE)

  /**********************************************************************************
  * The section below is related just with KBI Method of the electrodes
  * 
  ***********************************************************************************/
  
  #define ATL_KBI_FALLING_EDGE                0x00U         /* Falling Edge/Low Level */
  #define ATL_KBI_RISING_EDGE                 0x01U         /* Rising Edge/High Level */
  
  /* Special MCU exceptions solving */
  #ifndef KBISC_KBIE
    #ifdef KBI1SC_KBIE
      #define KBISC_KBIE          KBI1SC_KBIE
    #else /* JR12 exception */
      #define KBISC_KBIE          KBI1SC_KB1IE
    #endif  
  #endif
  #ifndef KBISC_KBACK  
    #ifdef KBI1SC_KBACK
      #define KBISC_KBACK         KBI1SC_KBACK  
    #else /* JR12 exception */
      #define KBISC_KBACK         KBI1SC_KB1ACK  
    #endif
  #endif  
  /* JR12 exception */
  #ifndef KBI2SC_KBIE
    #define KBI2SC_KBIE           KBI2SC_KB2IE
  #endif
  #ifndef KBI2SC_KBACK
    #define KBI2SC_KBACK          KBI2SC_KB2ACK
  #endif
  
  /* AC128 exception */
  #ifndef KBI1SC_KBIE
    #define KBI1SC_KBIE         KBISC_KBIE
  #endif
  #ifndef KBI1SC_KBACK  
    #define KBI1SC_KBACK        KBISC_KBACK  
  #endif  

  /* KBI PE macros */
  #ifdef KBIPE
    #define ATL_KBI0PE                          KBIPE_KBIPE0      
    #define ATL_KBI1PE                          KBIPE_KBIPE1      
    #define ATL_KBI2PE                          KBIPE_KBIPE2      
    #define ATL_KBI3PE                          KBIPE_KBIPE3      
    #define ATL_KBI4PE                          KBIPE_KBIPE4      
    #define ATL_KBI5PE                          KBIPE_KBIPE5      
    #define ATL_KBI6PE                          KBIPE_KBIPE6      
    #define ATL_KBI7PE                          KBIPE_KBIPE7   
  #else
    #ifdef KBI1PE_KBIPE0
      #define ATL_KBI0PE                        KBI1PE_KBIPE0
    #else
      #define ATL_KBI0PE                        KBI1PE_KBI1PE0
    #endif
    #ifdef KBI1PE_KBIPE1
      #define ATL_KBI1PE                        KBI1PE_KBIPE1
    #else
      #define ATL_KBI1PE                        KBI1PE_KBI1PE1
    #endif
    #ifdef KBI1PE_KBIPE2
      #define ATL_KBI2PE                        KBI1PE_KBIPE2
    #else
      #define ATL_KBI2PE                        KBI1PE_KBI1PE2
    #endif
    #ifdef KBI1PE_KBIPE3
      #define ATL_KBI3PE                        KBI1PE_KBIPE3
    #else
      #define ATL_KBI3PE                        KBI1PE_KBI1PE3
    #endif
    #ifdef KBI1PE_KBIPE4
      #define ATL_KBI4PE                        KBI1PE_KBIPE4
    #else
      #define ATL_KBI4PE                        KBI1PE_KBI1PE4
    #endif
    #ifdef KBI1PE_KBIPE5
      #define ATL_KBI5PE                        KBI1PE_KBIPE5
    #else
      #define ATL_KBI5PE                        KBI1PE_KBI1PE5
    #endif
    #ifdef KBI1PE_KBIPE6
      #define ATL_KBI6PE                        KBI1PE_KBIPE6
    #else
      #define ATL_KBI6PE                        KBI1PE_KBI1PE6
    #endif
    #ifdef KBI1PE_KBIPE7
      #define ATL_KBI7PE                        KBI1PE_KBIPE7
    #else
      #define ATL_KBI7PE                        KBI1PE_KBI1PE7
    #endif
  #endif

  #ifdef KBIPE  
    #define ATL_KBIP0PE                         KBIPE_KBIPE0      
    #define ATL_KBIP1PE                         KBIPE_KBIPE1      
    #define ATL_KBIP2PE                         KBIPE_KBIPE2      
    #define ATL_KBIP3PE                         KBIPE_KBIPE3      
    #define ATL_KBIP4PE                         KBIPE_KBIPE4      
    #define ATL_KBIP5PE                         KBIPE_KBIPE5      
    #define ATL_KBIP6PE                         KBIPE_KBIPE6      
    #define ATL_KBIP7PE                         KBIPE_KBIPE7   
  #else
    #ifdef KBI1PE_KBIPE0
      #define ATL_KBIP0PE                       KBI1PE_KBIPE0
    #else
      #define ATL_KBIP0PE                       KBI1PE_KBI1PE0
    #endif
    #ifdef KBI1PE_KBIPE1
      #define ATL_KBIP1PE                       KBI1PE_KBIPE1
    #else
      #define ATL_KBIP1PE                       KBI1PE_KBI1PE1
    #endif
    #ifdef KBI1PE_KBIPE2
      #define ATL_KBIP2PE                       KBI1PE_KBIPE2
    #else
      #define ATL_KBIP2PE                       KBI1PE_KBI1PE2
    #endif
    #ifdef KBI1PE_KBIPE3
      #define ATL_KBIP3PE                       KBI1PE_KBIPE3
    #else
      #define ATL_KBIP3PE                       KBI1PE_KBI1PE3
    #endif
    #ifdef KBI1PE_KBIPE4
      #define ATL_KBIP4PE                       KBI1PE_KBIPE4
    #else
      #define ATL_KBIP4PE                       KBI1PE_KBI1PE4
    #endif
    #ifdef KBI1PE_KBIPE5
      #define ATL_KBIP5PE                       KBI1PE_KBIPE5
    #else
      #define ATL_KBIP5PE                       KBI1PE_KBI1PE5
    #endif
    #ifdef KBI1PE_KBIPE6
      #define ATL_KBIP6PE                       KBI1PE_KBIPE6
    #else
      #define ATL_KBIP6PE                       KBI1PE_KBI1PE6
    #endif
    #ifdef KBI1PE_KBIPE7
      #define ATL_KBIP7PE                       KBI1PE_KBIPE7
    #else
      #define ATL_KBIP7PE                       KBI1PE_KBI1PE7
    #endif
  #endif

  #ifdef KBI1PE    
    #ifdef KBI1PE_KBIPE0
      #define ATL_KBI1P0PE                       KBI1PE_KBIPE0
    #else
      #define ATL_KBI1P0PE                       KBI1PE_KBI1PE0
    #endif
    #ifdef KBI1PE_KBIPE1
      #define ATL_KBI1P1PE                       KBI1PE_KBIPE1
    #else
      #define ATL_KBI1P1PE                       KBI1PE_KBI1PE1
    #endif
    #ifdef KBI1PE_KBIPE2
      #define ATL_KBI1P2PE                       KBI1PE_KBIPE2
    #else
      #define ATL_KBI1P2PE                       KBI1PE_KBI1PE2
    #endif
    #ifdef KBI1PE_KBIPE3
      #define ATL_KBI1P3PE                       KBI1PE_KBIPE3
    #else
      #define ATL_KBI1P3PE                       KBI1PE_KBI1PE3
    #endif
    #ifdef KBI1PE_KBIPE4
      #define ATL_KBI1P4PE                       KBI1PE_KBIPE4
    #else
      #define ATL_KBI1P4PE                       KBI1PE_KBI1PE4
    #endif
    #ifdef KBI1PE_KBIPE5
      #define ATL_KBI1P5PE                       KBI1PE_KBIPE5
    #else
      #define ATL_KBI1P5PE                       KBI1PE_KBI1PE5
    #endif
    #ifdef KBI1PE_KBIPE6
      #define ATL_KBI1P6PE                       KBI1PE_KBIPE6
    #else
      #define ATL_KBI1P6PE                       KBI1PE_KBI1PE6
    #endif
    #ifdef KBI1PE_KBIPE7
      #define ATL_KBI1P7PE                       KBI1PE_KBIPE7
    #else
      #define ATL_KBI1P7PE                       KBI1PE_KBI1PE7
    #endif
  #else 
    #define ATL_KBI1P0PE                        KBIPE_KBIPE0      
    #define ATL_KBI1P1PE                        KBIPE_KBIPE1      
    #define ATL_KBI1P2PE                        KBIPE_KBIPE2      
    #define ATL_KBI1P3PE                        KBIPE_KBIPE3      
    #define ATL_KBI1P4PE                        KBIPE_KBIPE4      
    #define ATL_KBI1P5PE                        KBIPE_KBIPE5      
    #define ATL_KBI1P6PE                        KBIPE_KBIPE6      
    #define ATL_KBI1P7PE                        KBIPE_KBIPE7   
  #endif
  
  #ifdef KBI2PE_KBIPE0
    #define ATL_KBI2P0PE                       KBI2PE_KBIPE0
  #else
    #define ATL_KBI2P0PE                       KBI2PE_KBI2PE0
  #endif
  #ifdef KBI2PE_KBIPE1
    #define ATL_KBI2P1PE                       KBI2PE_KBIPE1
  #else
    #define ATL_KBI2P1PE                       KBI2PE_KBI2PE1
  #endif
  #ifdef KBI2PE_KBIPE2
    #define ATL_KBI2P2PE                       KBI2PE_KBIPE2
  #else
    #define ATL_KBI2P2PE                       KBI2PE_KBI2PE2
  #endif
  #ifdef KBI2PE_KBIPE3
    #define ATL_KBI2P3PE                       KBI2PE_KBIPE3
  #else
    #define ATL_KBI2P3PE                       KBI2PE_KBI2PE3
  #endif
  #ifdef KBI2PE_KBIPE4
    #define ATL_KBI2P4PE                       KBI2PE_KBIPE4
  #else
    #define ATL_KBI2P4PE                       KBI2PE_KBI2PE4
  #endif
  #ifdef KBI2PE_KBIPE5
    #define ATL_KBI2P5PE                       KBI2PE_KBIPE5
  #else
    #define ATL_KBI2P5PE                       KBI2PE_KBI2PE5
  #endif
  #ifdef KBI2PE_KBIPE6
    #define ATL_KBI2P6PE                       KBI2PE_KBIPE6
  #else
    #define ATL_KBI2P6PE                       KBI2PE_KBI2PE6
  #endif
  #ifdef KBI2PE_KBIPE7
    #define ATL_KBI2P7PE                       KBI2PE_KBIPE7
  #else
    #define ATL_KBI2P7PE                       KBI2PE_KBI2PE7
  #endif

  #ifdef KBI3PE_KBIPE0
    #define ATL_KBI3P0PE                       KBI3PE_KBIPE0
  #else
    #define ATL_KBI3P0PE                       KBI3PE_KBI3PE0
  #endif
  #ifdef KBI3PE_KBIPE1
    #define ATL_KBI3P1PE                       KBI3PE_KBIPE1
  #else
    #define ATL_KBI3P1PE                       KBI3PE_KBI3PE1
  #endif
  #ifdef KBI3PE_KBIPE2
    #define ATL_KBI3P2PE                       KBI3PE_KBIPE2
  #else
    #define ATL_KBI3P2PE                       KBI3PE_KBI3PE2
  #endif
  #ifdef KBI3PE_KBIPE3
    #define ATL_KBI3P3PE                       KBI3PE_KBIPE3
  #else
    #define ATL_KBI3P3PE                       KBI3PE_KBI3PE3
  #endif
  #ifdef KBI3PE_KBIPE4
    #define ATL_KBI3P4PE                       KBI3PE_KBIPE4
  #else
    #define ATL_KBI3P4PE                       KBI3PE_KBI3PE4
  #endif
  #ifdef KBI3PE_KBIPE5
    #define ATL_KBI3P5PE                       KBI3PE_KBIPE5
  #else
    #define ATL_KBI3P5PE                       KBI3PE_KBI3PE5
  #endif
  #ifdef KBI3PE_KBIPE6
    #define ATL_KBI3P6PE                       KBI3PE_KBIPE6
  #else
    #define ATL_KBI3P6PE                       KBI3PE_KBI3PE6
  #endif
  #ifdef KBI3PE_KBIPE7
    #define ATL_KBI3P7PE                       KBI3PE_KBIPE7
  #else
    #define ATL_KBI3P7PE                       KBI3PE_KBI3PE7
  #endif
     
  /* JR12 exception */
  #define ATL_KBIP8PE                        ATL_KBI2P0PE
  #define ATL_KBIP9PE                        ATL_KBI2P1PE  
  #define ATL_KBIP10PE                       ATL_KBI2P2PE
  #define ATL_KBIP11PE                       ATL_KBI2P3PE
  #define ATL_KBIP12PE                       ATL_KBI2P4PE
  #define ATL_KBIP13PE                       ATL_KBI2P5PE
  #define ATL_KBIP14PE                       ATL_KBI2P6PE
  #define ATL_KBIP15PE                       ATL_KBI2P7PE
  
  #define ATL_KBI_TO_PE(reg)                  ATL_##reg##PE
  #define ATL_GET_KBI_PE(name)                ATL_KBI_TO_PE(name)
  #define ATL_KBI_PIN_ENABLE(el)              (ATL_GET_KBI_PE(TSS_##el##_TYPE) = 1u)
  #define ATL_KBI_PIN_DISABLE(el)             (ATL_GET_KBI_PE(TSS_##el##_TYPE) = 0u)  

   /* KBI EDGE macros */
  #ifdef KBIES
    #define ATL_KBI0EDG                       KBIES_KBEDG0      
    #define ATL_KBI1EDG                       KBIES_KBEDG1      
    #define ATL_KBI2EDG                       KBIES_KBEDG2      
    #define ATL_KBI3EDG                       KBIES_KBEDG3      
    #define ATL_KBI4EDG                       KBIES_KBEDG4      
    #define ATL_KBI5EDG                       KBIES_KBEDG5      
    #define ATL_KBI6EDG                       KBIES_KBEDG6      
    #define ATL_KBI7EDG                       KBIES_KBEDG7      
  #else
    #ifdef KBISC    
      #define ATL_KBI0EDG                       KBISC_KBEDG0      
      #define ATL_KBI1EDG                       KBISC_KBEDG1      
      #define ATL_KBI2EDG                       KBISC_KBEDG2      
      #define ATL_KBI3EDG                       KBISC_KBEDG3      
      #define ATL_KBI4EDG                       KBISC_KBEDG4      
      #define ATL_KBI5EDG                       KBISC_KBEDG5      
      #define ATL_KBI6EDG                       KBISC_KBEDG6      
      #define ATL_KBI7EDG                       KBISC_KBEDG7      
    #else
      #ifdef KBI1SC_KBEDG0
        #define ATL_KBI0EDG                       KBI1SC_KBEDG0
      #else
        #define ATL_KBI0EDG                       KBI1SC_KB1EDG0
      #endif
      #ifdef KBI1SC_KBEDG1
        #define ATL_KBI1EDG                       KBI1SC_KBEDG1
      #else
        #define ATL_KBI1EDG                       KBI1SC_KB1EDG1
      #endif
      #ifdef KBI1SC_KBEDG2
        #define ATL_KBI2EDG                       KBI1SC_KBEDG2
      #else
        #define ATL_KBI2EDG                       KBI1SC_KB1EDG2
      #endif
      #ifdef KBI1SC_KBEDG3
        #define ATL_KBI3EDG                       KBI1SC_KBEDG3
      #else
        #define ATL_KBI3EDG                       KBI1SC_KB1EDG3
      #endif
      #ifdef KBI1SC_KBEDG4
        #define ATL_KBI4EDG                       KBI1SC_KBEDG4
      #else
        #define ATL_KBI4EDG                       KBI1SC_KB1EDG4
      #endif
      #ifdef KBI1SC_KBEDG5
        #define ATL_KBI5EDG                       KBI1SC_KBEDG5
      #else
        #define ATL_KBI5EDG                       KBI1SC_KB1EDG5
      #endif
      #ifdef KBI1SC_KBEDG6
        #define ATL_KBI6EDG                       KBI1SC_KBEDG6
      #else
        #define ATL_KBI6EDG                       KBI1SC_KB1EDG6
      #endif
      #ifdef KBI1SC_KBEDG7
        #define ATL_KBI7EDG                       KBI1SC_KBEDG7
      #else
        #define ATL_KBI7EDG                       KBI1SC_KB1EDG7
      #endif
    #endif
  #endif  
  #ifdef KBIES
    #define ATL_KBIP0EDG                      KBIES_KBEDG0      
    #define ATL_KBIP1EDG                      KBIES_KBEDG1      
    #define ATL_KBIP2EDG                      KBIES_KBEDG2      
    #define ATL_KBIP3EDG                      KBIES_KBEDG3      
    #define ATL_KBIP4EDG                      KBIES_KBEDG4      
    #define ATL_KBIP5EDG                      KBIES_KBEDG5      
    #define ATL_KBIP6EDG                      KBIES_KBEDG6      
    #define ATL_KBIP7EDG                      KBIES_KBEDG7
    /* QD4 Exception */
    #ifndef KBI1ES     
      #ifdef KBIES_KBEDG0
        #define ATL_KBI1P0EDG                     KBIES_KBEDG0      
      #endif
      #ifdef KBIES_KBEDG1
        #define ATL_KBI1P1EDG                     KBIES_KBEDG1      
      #endif
      #ifdef KBIES_KBEDG2
        #define ATL_KBI1P2EDG                     KBIES_KBEDG2      
      #endif
      #ifdef KBIES_KBEDG3
        #define ATL_KBI1P3EDG                     KBIES_KBEDG3      
      #endif
      #ifdef KBIES_KBEDG4
        #define ATL_KBI1P4EDG                     KBIES_KBEDG4      
      #endif
      #ifdef KBIES_KBEDG5
        #define ATL_KBI1P5EDG                     KBIES_KBEDG5      
      #endif
      #ifdef KBIES_KBEDG6
        #define ATL_KBI1P6EDG                     KBIES_KBEDG6      
      #endif
      #ifdef KBIES_KBEDG7
        #define ATL_KBI1P7EDG                     KBIES_KBEDG7
      #endif
    #endif
  #else
    #ifdef KBISC    
      #ifdef KBISC_KBEDG0
        #define ATL_KBIP0EDG                      KBISC_KBEDG0      
      #endif
      #ifdef KBISC_KBEDG1      
        #define ATL_KBIP1EDG                      KBISC_KBEDG1      
      #endif
      #ifdef KBISC_KBEDG2      
        #define ATL_KBIP2EDG                      KBISC_KBEDG2      
      #endif
      #ifdef KBISC_KBEDG3      
        #define ATL_KBIP3EDG                      KBISC_KBEDG3      
      #endif
      #ifdef KBISC_KBEDG4      
        #define ATL_KBIP4EDG                      KBISC_KBEDG4      
      #endif
      #ifdef KBISC_KBEDG5      
        #define ATL_KBIP5EDG                      KBISC_KBEDG5      
      #endif
      #ifdef KBISC_KBEDG6      
        #define ATL_KBIP6EDG                      KBISC_KBEDG6      
      #endif
      #ifdef KBISC_KBEDG7      
        #define ATL_KBIP7EDG                      KBISC_KBEDG7      
      #endif
    #else
      #ifdef KBI1SC_KBEDG0
        #define ATL_KBIP0EDG                       KBI1SC_KBEDG0
      #else
        #define ATL_KBIP0EDG                       KBI1SC_KB1EDG0
      #endif
      #ifdef KBI1SC_KBEDG1
        #define ATL_KBIP1EDG                       KBI1SC_KBEDG1
      #else
        #define ATL_KBIP1EDG                       KBI1SC_KB1EDG1
      #endif
      #ifdef KBI1SC_KBEDG2
        #define ATL_KBIP2EDG                       KBI1SC_KBEDG2
      #else
        #define ATL_KBIP2EDG                       KBI1SC_KB1EDG2
      #endif
      #ifdef KBI1SC_KBEDG3
        #define ATL_KBIP3EDG                       KBI1SC_KBEDG3
      #else
        #define ATL_KBIP3EDG                       KBI1SC_KB1EDG3
      #endif
      #ifdef KBI1SC_KBEDG4
        #define ATL_KBIP4EDG                       KBI1SC_KBEDG4
      #else
        #define ATL_KBIP4EDG                       KBI1SC_KB1EDG4
      #endif
      #ifdef KBI1SC_KBEDG5
        #define ATL_KBIP5EDG                       KBI1SC_KBEDG5
      #else
        #define ATL_KBIP5EDG                       KBI1SC_KB1EDG5
      #endif
      #ifdef KBI1SC_KBEDG6
        #define ATL_KBIP6EDG                       KBI1SC_KBEDG6
      #else
        #define ATL_KBIP6EDG                       KBI1SC_KB1EDG6
      #endif
      #ifdef KBI1SC_KBEDG7
        #define ATL_KBIP7EDG                       KBI1SC_KBEDG7
      #else
        #define ATL_KBIP7EDG                       KBI1SC_KB1EDG7
      #endif
    #endif 
  #endif   
  #ifdef KBI1ES  
    #ifdef KBI1ES_KBEDG0
      #define ATL_KBI1P0EDG                     KBI1ES_KBEDG0      
    #endif
    #ifdef KBI1ES_KBEDG1
      #define ATL_KBI1P1EDG                     KBI1ES_KBEDG1      
    #endif
    #ifdef KBI1ES_KBEDG2
      #define ATL_KBI1P2EDG                     KBI1ES_KBEDG2      
    #endif
    #ifdef KBI1ES_KBEDG3
      #define ATL_KBI1P3EDG                     KBI1ES_KBEDG3      
    #endif
    #ifdef KBI1ES_KBEDG4
      #define ATL_KBI1P4EDG                     KBI1ES_KBEDG4      
    #endif
    #ifdef KBI1ES_KBEDG5
      #define ATL_KBI1P5EDG                     KBI1ES_KBEDG5      
    #endif
    #ifdef KBI1ES_KBEDG6
      #define ATL_KBI1P6EDG                     KBI1ES_KBEDG6      
    #endif
    #ifdef KBI1ES_KBEDG7
      #define ATL_KBI1P7EDG                     KBI1ES_KBEDG7
    #endif
  #else
    #ifdef KBI1SC    
      #ifdef KBI1SC_KBEDG0
        #define ATL_KBI1P0EDG                       KBI1SC_KBEDG0
      #else
        #define ATL_KBI1P0EDG                       KBI1SC_KB1EDG0
      #endif
      #ifdef KBI1SC_KBEDG1
        #define ATL_KBI1P1EDG                       KBI1SC_KBEDG1
      #else
        #define ATL_KBI1P1EDG                       KBI1SC_KB1EDG1
      #endif
      #ifdef KBI1SC_KBEDG2
        #define ATL_KBI1P2EDG                       KBI1SC_KBEDG2
      #else
        #define ATL_KBI1P2EDG                       KBI1SC_KB1EDG2
      #endif
      #ifdef KBI1SC_KBEDG3
        #define ATL_KBI1P3EDG                       KBI1SC_KBEDG3
      #else
        #define ATL_KBI1P3EDG                       KBI1SC_KB1EDG3
      #endif
      #ifdef KBI1SC_KBEDG4
        #define ATL_KBI1P4EDG                       KBI1SC_KBEDG4
      #else
        #define ATL_KBI1P4EDG                       KBI1SC_KB1EDG4
      #endif
      #ifdef KBI1SC_KBEDG5
        #define ATL_KBI1P5EDG                       KBI1SC_KBEDG5
      #else
        #define ATL_KBI1P5EDG                       KBI1SC_KB1EDG5
      #endif
      #ifdef KBI1SC_KBEDG6
        #define ATL_KBI1P6EDG                       KBI1SC_KBEDG6
      #else
        #define ATL_KBI1P6EDG                       KBI1SC_KB1EDG6
      #endif
      #ifdef KBI1SC_KBEDG7
        #define ATL_KBI1P7EDG                       KBI1SC_KBEDG7
      #else
        #define ATL_KBI1P7EDG                       KBI1SC_KB1EDG7
      #endif      
    #else
      #ifdef KBISC_KBEDG0
        #define ATL_KBI1P0EDG                     KBISC_KBEDG0      
      #endif
      #ifdef KBISC_KBEDG1      
        #define ATL_KBI1P1EDG                     KBISC_KBEDG1      
      #endif
      #ifdef KBISC_KBEDG2      
        #define ATL_KBI1P2EDG                     KBISC_KBEDG2      
      #endif
      #ifdef KBISC_KBEDG3      
        #define ATL_KBI1P3EDG                     KBISC_KBEDG3      
      #endif
      #ifdef KBISC_KBEDG4      
        #define ATL_KBI1P4EDG                     KBISC_KBEDG4      
      #endif
      #ifdef KBISC_KBEDG5      
        #define ATL_KBI1P5EDG                     KBISC_KBEDG5      
      #endif
      #ifdef KBISC_KBEDG6      
        #define ATL_KBI1P6EDG                     KBISC_KBEDG6      
      #endif
      #ifdef KBISC_KBEDG7      
        #define ATL_KBI1P7EDG                     KBISC_KBEDG7    
      #endif
    #endif
  #endif
  #ifdef KBI2ES
    #define ATL_KBI2P0EDG                     KBI2ES_KBEDG0      
    #define ATL_KBI2P1EDG                     KBI2ES_KBEDG1      
    #define ATL_KBI2P2EDG                     KBI2ES_KBEDG2      
    #define ATL_KBI2P3EDG                     KBI2ES_KBEDG3      
    #define ATL_KBI2P4EDG                     KBI2ES_KBEDG4      
    #define ATL_KBI2P5EDG                     KBI2ES_KBEDG5      
    #define ATL_KBI2P6EDG                     KBI2ES_KBEDG6      
    #define ATL_KBI2P7EDG                     KBI2ES_KBEDG7      
  #else
    #ifdef KBI2SC_KBEDG0
      #define ATL_KBI2P0EDG                       KBI2SC_KBEDG0
    #else
      #define ATL_KBI2P0EDG                       KBI2SC_KB2EDG0
    #endif
    #ifdef KBI2SC_KBEDG1
      #define ATL_KBI2P1EDG                       KBI2SC_KBEDG1
    #else
      #define ATL_KBI2P1EDG                       KBI2SC_KB2EDG1
    #endif
    #ifdef KBI2SC_KBEDG2
      #define ATL_KBI2P2EDG                       KBI2SC_KBEDG2
    #else
      #define ATL_KBI2P2EDG                       KBI2SC_KB2EDG2
    #endif
    #ifdef KBI2SC_KBEDG3
      #define ATL_KBI2P3EDG                       KBI2SC_KBEDG3
    #else
      #define ATL_KBI2P3EDG                       KBI2SC_KB2EDG3
    #endif
    #ifdef KBI2SC_KBEDG4
      #define ATL_KBI2P4EDG                       KBI2SC_KBEDG4
    #else
      #define ATL_KBI2P4EDG                       KBI2SC_KB2EDG4
    #endif
    #ifdef KBI2SC_KBEDG5
      #define ATL_KBI2P5EDG                       KBI2SC_KBEDG5
    #else
      #define ATL_KBI2P5EDG                       KBI2SC_KB2EDG5
    #endif
    #ifdef KBI2SC_KBEDG6
      #define ATL_KBI2P6EDG                       KBI2SC_KBEDG6
    #else
      #define ATL_KBI2P6EDG                       KBI2SC_KB2EDG6
    #endif
    #ifdef KBI2SC_KBEDG7
      #define ATL_KBI2P7EDG                       KBI2SC_KBEDG7
    #else
      #define ATL_KBI2P7EDG                       KBI2SC_KB2EDG7
    #endif  
  #endif
  #ifdef KBI3ES
    #define ATL_KBI3P0EDG                     KBI3ES_KBEDG0      
    #define ATL_KBI3P1EDG                     KBI3ES_KBEDG1      
    #define ATL_KBI3P2EDG                     KBI3ES_KBEDG2      
    #define ATL_KBI3P3EDG                     KBI3ES_KBEDG3      
    #define ATL_KBI3P4EDG                     KBI3ES_KBEDG4      
    #define ATL_KBI3P5EDG                     KBI3ES_KBEDG5      
    #define ATL_KBI3P6EDG                     KBI3ES_KBEDG6      
    #define ATL_KBI3P7EDG                     KBI3ES_KBEDG7      
  #else
    #ifdef KBI3SC_KBEDG0
      #define ATL_KBI3P0EDG                       KBI3SC_KBEDG0
    #else
      #define ATL_KBI3P0EDG                       KBI3SC_KB3EDG0
    #endif
    #ifdef KBI3SC_KBEDG1
      #define ATL_KBI3P1EDG                       KBI3SC_KBEDG1
    #else
      #define ATL_KBI3P1EDG                       KBI3SC_KB3EDG1
    #endif
    #ifdef KBI3SC_KBEDG2
      #define ATL_KBI3P2EDG                       KBI3SC_KBEDG2
    #else
      #define ATL_KBI3P2EDG                       KBI3SC_KB3EDG2
    #endif
    #ifdef KBI3SC_KBEDG3
      #define ATL_KBI3P3EDG                       KBI3SC_KBEDG3
    #else
      #define ATL_KBI3P3EDG                       KBI3SC_KB3EDG3
    #endif
    #ifdef KBI3SC_KBEDG4
      #define ATL_KBI3P4EDG                       KBI3SC_KBEDG4
    #else
      #define ATL_KBI3P4EDG                       KBI3SC_KB3EDG4
    #endif
    #ifdef KBI3SC_KBEDG5
      #define ATL_KBI3P5EDG                       KBI3SC_KBEDG5
    #else
      #define ATL_KBI3P5EDG                       KBI3SC_KB3EDG5
    #endif
    #ifdef KBI3SC_KBEDG6
      #define ATL_KBI3P6EDG                       KBI3SC_KBEDG6
    #else
      #define ATL_KBI3P6EDG                       KBI3SC_KB3EDG6
    #endif
    #ifdef KBI3SC_KBEDG7
      #define ATL_KBI3P7EDG                       KBI3SC_KBEDG7
    #else
      #define ATL_KBI3P7EDG                       KBI3SC_KB3EDG7
    #endif
  #endif

  /* JR12 exception */
  #define ATL_KBIP8EDG                        ATL_KBI2P0EDG
  #define ATL_KBIP9EDG                        ATL_KBI2P1EDG  
  #define ATL_KBIP10EDG                       ATL_KBI2P2EDG
  #define ATL_KBIP11EDG                       ATL_KBI2P3EDG
  #define ATL_KBIP12EDG                       ATL_KBI2P4EDG
  #define ATL_KBIP13EDG                       ATL_KBI2P5EDG
  #define ATL_KBIP14EDG                       ATL_KBI2P6EDG
  #define ATL_KBIP15EDG                       ATL_KBI2P7EDG

  #define ATL_KBI_TO_EDG(reg)                 ATL_##reg##EDG
  #define _ATL_SET_KBI_EDG(name)              ATL_KBI_TO_EDG(name)
  #define ATL_SET_KBI_EDG(el)                 _ATL_SET_KBI_EDG(TSS_##el##_TYPE)

  #define ATL_KBI_TO_IE(reg)                  reg##SC_KBIE
  #define ATL_KBI_ENABLE_INT(num)             (ATL_KBI_TO_IE(num) = 1u)
  
  #define ATL_KBI_TO_ACK(reg)                 reg##SC_KBACK
  #define ATL_KBI_ACK(num)                    (ATL_KBI_TO_ACK(num) = 1u)
  
  /* Determination what KBI module is used for later conditional KBI module initialization */
  #define ATL_KBI_E0_USE         (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E1_USE         (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E2_USE         (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E3_USE         (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E4_USE         (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E5_USE         (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E6_USE         (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E7_USE         (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E8_USE         (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E9_USE         (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E10_USE       (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E10_USE       (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E10_USE       (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E11_USE       (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E11_USE       (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E11_USE       (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E12_USE       (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E12_USE       (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E12_USE       (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E13_USE       (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E13_USE       (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E13_USE       (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E14_USE       (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E14_USE       (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E14_USE       (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E15_USE       (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E15_USE       (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E15_USE       (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E16_USE       (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E16_USE       (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E16_USE       (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E17_USE       (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E17_USE       (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E17_USE       (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E18_USE       (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E18_USE       (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E18_USE       (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E19_USE       (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E19_USE       (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E19_USE       (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E20_USE       (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E20_USE       (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E20_USE       (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E21_USE       (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E21_USE       (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E21_USE       (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E22_USE       (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E22_USE       (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E22_USE       (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E23_USE       (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E23_USE       (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E23_USE       (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E24_USE       (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E24_USE       (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E24_USE       (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E25_USE       (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E25_USE       (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E25_USE       (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E26_USE       (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E26_USE       (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E26_USE       (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E27_USE       (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E27_USE       (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E27_USE       (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E28_USE       (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E28_USE       (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E28_USE       (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E29_USE       (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E29_USE       (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E29_USE       (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E30_USE       (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E30_USE       (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E30_USE       (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E31_USE       (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E31_USE       (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E31_USE       (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E32_USE       (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E32_USE       (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E32_USE       (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E33_USE       (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E33_USE       (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E33_USE       (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E34_USE       (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E34_USE       (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E34_USE       (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E35_USE       (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E35_USE       (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E35_USE       (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E36_USE       (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E36_USE       (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E36_USE       (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E37_USE       (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E37_USE       (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E37_USE       (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E38_USE       (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E38_USE       (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E38_USE       (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E39_USE       (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E39_USE       (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E39_USE       (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E40_USE       (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E40_USE       (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E40_USE       (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E41_USE       (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E41_USE       (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E41_USE       (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E42_USE       (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E42_USE       (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E42_USE       (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E43_USE       (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E43_USE       (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E43_USE       (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E44_USE       (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E44_USE       (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E44_USE       (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E45_USE       (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E45_USE       (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E45_USE       (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E46_USE       (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E46_USE       (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E46_USE       (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E47_USE       (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E47_USE       (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E47_USE       (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E48_USE       (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E48_USE       (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E48_USE       (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E49_USE       (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E49_USE       (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E49_USE       (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E50_USE       (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E50_USE       (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E50_USE       (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E51_USE       (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E51_USE       (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E51_USE       (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E52_USE       (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E52_USE       (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E52_USE       (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E53_USE       (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E53_USE       (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E53_USE       (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E54_USE       (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E54_USE       (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E54_USE       (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E55_USE       (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E55_USE       (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E55_USE       (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E56_USE       (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E56_USE       (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E56_USE       (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E57_USE       (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E57_USE       (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E57_USE       (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E58_USE       (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E58_USE       (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E58_USE       (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E59_USE       (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E59_USE       (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E59_USE       (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E60_USE       (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E60_USE       (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E60_USE       (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E61_USE       (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E61_USE       (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E61_USE       (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E62_USE       (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E62_USE       (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E62_USE       (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_KBIX_CHK)
  #define ATL_KBI1_E63_USE       (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_KBI1X_CHK)
  #define ATL_KBI2_E63_USE       (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_KBI2X_CHK)
  #define ATL_KBI3_E63_USE       (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_KBI3X_CHK)

  #define ATL_KBI_USED         (ATL_KBI_E0_USE || ATL_KBI_E1_USE || ATL_KBI_E2_USE || ATL_KBI_E3_USE || ATL_KBI_E4_USE || ATL_KBI_E5_USE || ATL_KBI_E6_USE || ATL_KBI_E7_USE || ATL_KBI_E8_USE || ATL_KBI_E9_USE || ATL_KBI_E10_USE || ATL_KBI_E11_USE || ATL_KBI_E12_USE || ATL_KBI_E13_USE || ATL_KBI_E14_USE || ATL_KBI_E15_USE || ATL_KBI_E16_USE || ATL_KBI_E17_USE || ATL_KBI_E18_USE || ATL_KBI_E19_USE || ATL_KBI_E20_USE || ATL_KBI_E21_USE || ATL_KBI_E22_USE || ATL_KBI_E23_USE || ATL_KBI_E24_USE || ATL_KBI_E25_USE || ATL_KBI_E26_USE || ATL_KBI_E27_USE || ATL_KBI_E28_USE || ATL_KBI_E29_USE || ATL_KBI_E30_USE || ATL_KBI_E31_USE || ATL_KBI_E32_USE || ATL_KBI_E33_USE || ATL_KBI_E34_USE || ATL_KBI_E35_USE || ATL_KBI_E36_USE || ATL_KBI_E37_USE || ATL_KBI_E38_USE || ATL_KBI_E39_USE || ATL_KBI_E40_USE || ATL_KBI_E41_USE || ATL_KBI_E42_USE || ATL_KBI_E43_USE || ATL_KBI_E44_USE || ATL_KBI_E45_USE || ATL_KBI_E46_USE || ATL_KBI_E47_USE || ATL_KBI_E48_USE || ATL_KBI_E49_USE || ATL_KBI_E50_USE || ATL_KBI_E51_USE || ATL_KBI_E52_USE || ATL_KBI_E53_USE || ATL_KBI_E54_USE || ATL_KBI_E55_USE || ATL_KBI_E56_USE || ATL_KBI_E57_USE || ATL_KBI_E58_USE || ATL_KBI_E59_USE || ATL_KBI_E60_USE || ATL_KBI_E61_USE || ATL_KBI_E62_USE || ATL_KBI_E63_USE)
  #define ATL_KBI1_USED        (ATL_KBI1_E0_USE || ATL_KBI1_E1_USE || ATL_KBI1_E2_USE || ATL_KBI1_E3_USE || ATL_KBI1_E4_USE || ATL_KBI1_E5_USE || ATL_KBI1_E6_USE || ATL_KBI1_E7_USE || ATL_KBI1_E8_USE || ATL_KBI1_E9_USE || ATL_KBI1_E10_USE || ATL_KBI1_E11_USE || ATL_KBI1_E12_USE || ATL_KBI1_E13_USE || ATL_KBI1_E14_USE || ATL_KBI1_E15_USE || ATL_KBI1_E16_USE || ATL_KBI1_E17_USE || ATL_KBI1_E18_USE || ATL_KBI1_E19_USE || ATL_KBI1_E20_USE || ATL_KBI1_E21_USE || ATL_KBI1_E22_USE || ATL_KBI1_E23_USE || ATL_KBI1_E24_USE || ATL_KBI1_E25_USE || ATL_KBI1_E26_USE || ATL_KBI1_E27_USE || ATL_KBI1_E28_USE || ATL_KBI1_E29_USE || ATL_KBI1_E30_USE || ATL_KBI1_E31_USE || ATL_KBI1_E32_USE || ATL_KBI1_E33_USE || ATL_KBI1_E34_USE || ATL_KBI1_E35_USE || ATL_KBI1_E36_USE || ATL_KBI1_E37_USE || ATL_KBI1_E38_USE || ATL_KBI1_E39_USE || ATL_KBI1_E40_USE || ATL_KBI1_E41_USE || ATL_KBI1_E42_USE || ATL_KBI1_E43_USE || ATL_KBI1_E44_USE || ATL_KBI1_E45_USE || ATL_KBI1_E46_USE || ATL_KBI1_E47_USE || ATL_KBI1_E48_USE || ATL_KBI1_E49_USE || ATL_KBI1_E50_USE || ATL_KBI1_E51_USE || ATL_KBI1_E52_USE || ATL_KBI1_E53_USE || ATL_KBI1_E54_USE || ATL_KBI1_E55_USE || ATL_KBI1_E56_USE || ATL_KBI1_E57_USE || ATL_KBI1_E58_USE || ATL_KBI1_E59_USE || ATL_KBI1_E60_USE || ATL_KBI1_E61_USE || ATL_KBI1_E62_USE || ATL_KBI1_E63_USE)
  #define ATL_KBI2_USED        (ATL_KBI2_E0_USE || ATL_KBI2_E1_USE || ATL_KBI2_E2_USE || ATL_KBI2_E3_USE || ATL_KBI2_E4_USE || ATL_KBI2_E5_USE || ATL_KBI2_E6_USE || ATL_KBI2_E7_USE || ATL_KBI2_E8_USE || ATL_KBI2_E9_USE || ATL_KBI2_E10_USE || ATL_KBI2_E11_USE || ATL_KBI2_E12_USE || ATL_KBI2_E13_USE || ATL_KBI2_E14_USE || ATL_KBI2_E15_USE || ATL_KBI2_E16_USE || ATL_KBI2_E17_USE || ATL_KBI2_E18_USE || ATL_KBI2_E19_USE || ATL_KBI2_E20_USE || ATL_KBI2_E21_USE || ATL_KBI2_E22_USE || ATL_KBI2_E23_USE || ATL_KBI2_E24_USE || ATL_KBI2_E25_USE || ATL_KBI2_E26_USE || ATL_KBI2_E27_USE || ATL_KBI2_E28_USE || ATL_KBI2_E29_USE || ATL_KBI2_E30_USE || ATL_KBI2_E31_USE || ATL_KBI2_E32_USE || ATL_KBI2_E33_USE || ATL_KBI2_E34_USE || ATL_KBI2_E35_USE || ATL_KBI2_E36_USE || ATL_KBI2_E37_USE || ATL_KBI2_E38_USE || ATL_KBI2_E39_USE || ATL_KBI2_E40_USE || ATL_KBI2_E41_USE || ATL_KBI2_E42_USE || ATL_KBI2_E43_USE || ATL_KBI2_E44_USE || ATL_KBI2_E45_USE || ATL_KBI2_E46_USE || ATL_KBI2_E47_USE || ATL_KBI2_E48_USE || ATL_KBI2_E49_USE || ATL_KBI2_E50_USE || ATL_KBI2_E51_USE || ATL_KBI2_E52_USE || ATL_KBI2_E53_USE || ATL_KBI2_E54_USE || ATL_KBI2_E55_USE || ATL_KBI2_E56_USE || ATL_KBI2_E57_USE || ATL_KBI2_E58_USE || ATL_KBI2_E59_USE || ATL_KBI2_E60_USE || ATL_KBI2_E61_USE || ATL_KBI2_E62_USE || ATL_KBI2_E63_USE)
  #define ATL_KBI3_USED        (ATL_KBI3_E0_USE || ATL_KBI3_E1_USE || ATL_KBI3_E2_USE || ATL_KBI3_E3_USE || ATL_KBI3_E4_USE || ATL_KBI3_E5_USE || ATL_KBI3_E6_USE || ATL_KBI3_E7_USE || ATL_KBI3_E8_USE || ATL_KBI3_E9_USE || ATL_KBI3_E10_USE || ATL_KBI3_E11_USE || ATL_KBI3_E12_USE || ATL_KBI3_E13_USE || ATL_KBI3_E14_USE || ATL_KBI3_E15_USE || ATL_KBI3_E16_USE || ATL_KBI3_E17_USE || ATL_KBI3_E18_USE || ATL_KBI3_E19_USE || ATL_KBI3_E20_USE || ATL_KBI3_E21_USE || ATL_KBI3_E22_USE || ATL_KBI3_E23_USE || ATL_KBI3_E24_USE || ATL_KBI3_E25_USE || ATL_KBI3_E26_USE || ATL_KBI3_E27_USE || ATL_KBI3_E28_USE || ATL_KBI3_E29_USE || ATL_KBI3_E30_USE || ATL_KBI3_E31_USE || ATL_KBI3_E32_USE || ATL_KBI3_E33_USE || ATL_KBI3_E34_USE || ATL_KBI3_E35_USE || ATL_KBI3_E36_USE || ATL_KBI3_E37_USE || ATL_KBI3_E38_USE || ATL_KBI3_E39_USE || ATL_KBI3_E40_USE || ATL_KBI3_E41_USE || ATL_KBI3_E42_USE || ATL_KBI3_E43_USE || ATL_KBI3_E44_USE || ATL_KBI3_E45_USE || ATL_KBI3_E46_USE || ATL_KBI3_E47_USE || ATL_KBI3_E48_USE || ATL_KBI3_E49_USE || ATL_KBI3_E50_USE || ATL_KBI3_E51_USE || ATL_KBI3_E52_USE || ATL_KBI3_E53_USE || ATL_KBI3_E54_USE || ATL_KBI3_E55_USE || ATL_KBI3_E56_USE || ATL_KBI3_E57_USE || ATL_KBI3_E58_USE || ATL_KBI3_E59_USE || ATL_KBI3_E60_USE || ATL_KBI3_E61_USE || ATL_KBI3_E62_USE || ATL_KBI3_E63_USE)

  /* Special MCU exceptions solving */
  
  /* DE60 exception */
  #if ATL_KBI_USED
    #ifndef VectorNumber_Vkeyboard 
      #define VectorNumber_Vkeyboard         VectorNumber_Vkeyboard1
    #endif
  #endif
  
  /* QE128 exception */
  #if ATL_KBI2_USED
    #ifndef VectorNumber_Vkeyboard2 
      #ifndef VectorNumber_Vkeyboard1 
        #define VectorNumber_Vkeyboard2         VectorNumber_Vkeyboard
      #endif
    #endif
  #endif
  
  /* QE32 exception */
  #if ATL_KBI1_USED
    #ifndef VectorNumber_Vkeyboard1 
      #define VectorNumber_Vkeyboard1         VectorNumber_Vkeyboard
    #endif
  #endif
  
  /* 51AC256 vector number exception */
  #if ATL_KBI1_USED
    #if !ATL_KBI_USED
      #define ATL_KBIIsr                      ATL_KBI1Isr
    #endif
  #endif
  
  /* Predicted Solving */
  #if ATL_KBI_USED
    #if !ATL_KBI1_USED
      #define ATL_KBI1Isr                     ATL_KBIIsr
    #endif
  #endif
  
  /**********************************************************************************
  * The section below is related just with PTI Method of the electrodes
  * 
  ***********************************************************************************/
  
  #define ATL_PTI_FALLING_EDGE                0x00U         /* Falling Edge/Low Level  */
  #define ATL_PTI_RISING_EDGE                 0x01U         /* Rising Edge/High Level  */
  
  #define ATL_PTI_TO_PE(port, pin)            PT##port##PS_PT##port##PS##pin
  #define ATL_GET_PTI_PE(port, pin)           ATL_PTI_TO_PE(port, pin)
  #define ATL_PTI_PIN_CONV(port, pin)         ATL_GET_PTI_PE(port, pin)
  #define ATL_PTI_PIN_ENABLE(X)               (ATL_PTI_PIN_CONV(TSS_##X##_P, TSS_##X##_B) = 1u)
  #define ATL_PTI_PIN_DISABLE(X)              (ATL_PTI_PIN_CONV(TSS_##X##_P, TSS_##X##_B) = 0u)  
  
  #define ATL_PTI_TO_EDG(port, pin)           PT##port##ES_PT##port##ES##pin
  #define ATL_PTI_EDG_CONV(port, pin)         ATL_PTI_TO_EDG(port, pin)
  #define ATL_SET_PTI_EDG(X)                  ATL_PTI_EDG_CONV(TSS_##X##_P, TSS_##X##_B)

  #define ATL_PTI_TO_IE(reg)                  reg##SC_##reg##IE
  #define ATL_PTI_ENABLE_INT(num)             (ATL_PTI_TO_IE(num) = 1u)
  
  #define ATL_PTI_TO_ACK(reg)                 reg##SC_##reg##ACK
  #define ATL_PTI_ACK(num)                    (ATL_PTI_TO_ACK(num) = 1u)
  
  #define ATL_PTI_TYPE2NAME_RESULT(res)       ATL_PI##res##_CHK
  #define ATL_PTI_TYPE2NAME_CONV(text)        ATL_PTI_TYPE2NAME_RESULT(text)
  #define ATL_PTI_TYPE_CHK(elec)              ATL_PTI_TYPE2NAME_CONV(TSS_##elec##_P)

  /* Determination what PTI is used for later conditional PTI initialization */
  #if (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E0_USE        (ATL_PTI_TYPE_CHK(E0) == ATL_PIA_CHK)
    #define ATL_PIB_E0_USE        (ATL_PTI_TYPE_CHK(E0) == ATL_PIB_CHK)
    #define ATL_PIC_E0_USE        (ATL_PTI_TYPE_CHK(E0) == ATL_PIC_CHK)
    #define ATL_PID_E0_USE        (ATL_PTI_TYPE_CHK(E0) == ATL_PID_CHK)
    #define ATL_PIJ_E0_USE        (ATL_PTI_TYPE_CHK(E0) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E0_USE        0
    #define ATL_PIB_E0_USE        0
    #define ATL_PIC_E0_USE        0
    #define ATL_PID_E0_USE        0
    #define ATL_PIJ_E0_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E1_USE        (ATL_PTI_TYPE_CHK(E1) == ATL_PIA_CHK)
    #define ATL_PIB_E1_USE        (ATL_PTI_TYPE_CHK(E1) == ATL_PIB_CHK)
    #define ATL_PIC_E1_USE        (ATL_PTI_TYPE_CHK(E1) == ATL_PIC_CHK)
    #define ATL_PID_E1_USE        (ATL_PTI_TYPE_CHK(E1) == ATL_PID_CHK)
    #define ATL_PIJ_E1_USE        (ATL_PTI_TYPE_CHK(E1) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E1_USE        0
    #define ATL_PIB_E1_USE        0
    #define ATL_PIC_E1_USE        0
    #define ATL_PID_E1_USE        0
    #define ATL_PIJ_E1_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E2_USE        (ATL_PTI_TYPE_CHK(E2) == ATL_PIA_CHK)
    #define ATL_PIB_E2_USE        (ATL_PTI_TYPE_CHK(E2) == ATL_PIB_CHK)
    #define ATL_PIC_E2_USE        (ATL_PTI_TYPE_CHK(E2) == ATL_PIC_CHK)
    #define ATL_PID_E2_USE        (ATL_PTI_TYPE_CHK(E2) == ATL_PID_CHK)
    #define ATL_PIJ_E2_USE        (ATL_PTI_TYPE_CHK(E2) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E2_USE        0
    #define ATL_PIB_E2_USE        0
    #define ATL_PIC_E2_USE        0
    #define ATL_PID_E2_USE        0
    #define ATL_PIJ_E2_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E3_USE        (ATL_PTI_TYPE_CHK(E3) == ATL_PIA_CHK)
    #define ATL_PIB_E3_USE        (ATL_PTI_TYPE_CHK(E3) == ATL_PIB_CHK)
    #define ATL_PIC_E3_USE        (ATL_PTI_TYPE_CHK(E3) == ATL_PIC_CHK)
    #define ATL_PID_E3_USE        (ATL_PTI_TYPE_CHK(E3) == ATL_PID_CHK)
    #define ATL_PIJ_E3_USE        (ATL_PTI_TYPE_CHK(E3) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E3_USE        0
    #define ATL_PIB_E3_USE        0
    #define ATL_PIC_E3_USE        0
    #define ATL_PID_E3_USE        0
    #define ATL_PIJ_E3_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E4_USE        (ATL_PTI_TYPE_CHK(E4) == ATL_PIA_CHK)
    #define ATL_PIB_E4_USE        (ATL_PTI_TYPE_CHK(E4) == ATL_PIB_CHK)
    #define ATL_PIC_E4_USE        (ATL_PTI_TYPE_CHK(E4) == ATL_PIC_CHK)
    #define ATL_PID_E4_USE        (ATL_PTI_TYPE_CHK(E4) == ATL_PID_CHK)
    #define ATL_PIJ_E4_USE        (ATL_PTI_TYPE_CHK(E4) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E4_USE        0
    #define ATL_PIB_E4_USE        0
    #define ATL_PIC_E4_USE        0
    #define ATL_PID_E4_USE        0
    #define ATL_PIJ_E4_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E5_USE        (ATL_PTI_TYPE_CHK(E5) == ATL_PIA_CHK)
    #define ATL_PIB_E5_USE        (ATL_PTI_TYPE_CHK(E5) == ATL_PIB_CHK)
    #define ATL_PIC_E5_USE        (ATL_PTI_TYPE_CHK(E5) == ATL_PIC_CHK)
    #define ATL_PID_E5_USE        (ATL_PTI_TYPE_CHK(E5) == ATL_PID_CHK)
    #define ATL_PIJ_E5_USE        (ATL_PTI_TYPE_CHK(E5) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E5_USE        0
    #define ATL_PIB_E5_USE        0
    #define ATL_PIC_E5_USE        0
    #define ATL_PID_E5_USE        0
    #define ATL_PIJ_E5_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E6_USE        (ATL_PTI_TYPE_CHK(E6) == ATL_PIA_CHK)
    #define ATL_PIB_E6_USE        (ATL_PTI_TYPE_CHK(E6) == ATL_PIB_CHK)
    #define ATL_PIC_E6_USE        (ATL_PTI_TYPE_CHK(E6) == ATL_PIC_CHK)
    #define ATL_PID_E6_USE        (ATL_PTI_TYPE_CHK(E6) == ATL_PID_CHK)
    #define ATL_PIJ_E6_USE        (ATL_PTI_TYPE_CHK(E6) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E6_USE        0
    #define ATL_PIB_E6_USE        0
    #define ATL_PIC_E6_USE        0
    #define ATL_PID_E6_USE        0
    #define ATL_PIJ_E6_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E7_USE        (ATL_PTI_TYPE_CHK(E7) == ATL_PIA_CHK)
    #define ATL_PIB_E7_USE        (ATL_PTI_TYPE_CHK(E7) == ATL_PIB_CHK)
    #define ATL_PIC_E7_USE        (ATL_PTI_TYPE_CHK(E7) == ATL_PIC_CHK)
    #define ATL_PID_E7_USE        (ATL_PTI_TYPE_CHK(E7) == ATL_PID_CHK)
    #define ATL_PIJ_E7_USE        (ATL_PTI_TYPE_CHK(E7) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E7_USE        0
    #define ATL_PIB_E7_USE        0
    #define ATL_PIC_E7_USE        0
    #define ATL_PID_E7_USE        0
    #define ATL_PIJ_E7_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E8_USE        (ATL_PTI_TYPE_CHK(E8) == ATL_PIA_CHK)
    #define ATL_PIB_E8_USE        (ATL_PTI_TYPE_CHK(E8) == ATL_PIB_CHK)
    #define ATL_PIC_E8_USE        (ATL_PTI_TYPE_CHK(E8) == ATL_PIC_CHK)
    #define ATL_PID_E8_USE        (ATL_PTI_TYPE_CHK(E8) == ATL_PID_CHK)
    #define ATL_PIJ_E8_USE        (ATL_PTI_TYPE_CHK(E8) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E8_USE        0
    #define ATL_PIB_E8_USE        0
    #define ATL_PIC_E8_USE        0
    #define ATL_PID_E8_USE        0
    #define ATL_PIJ_E8_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E9_USE        (ATL_PTI_TYPE_CHK(E9) == ATL_PIA_CHK)
    #define ATL_PIB_E9_USE        (ATL_PTI_TYPE_CHK(E9) == ATL_PIB_CHK)
    #define ATL_PIC_E9_USE        (ATL_PTI_TYPE_CHK(E9) == ATL_PIC_CHK)
    #define ATL_PID_E9_USE        (ATL_PTI_TYPE_CHK(E9) == ATL_PID_CHK)
    #define ATL_PIJ_E9_USE        (ATL_PTI_TYPE_CHK(E9) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E9_USE        0
    #define ATL_PIB_E9_USE        0
    #define ATL_PIC_E9_USE        0
    #define ATL_PID_E9_USE        0
    #define ATL_PIJ_E9_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E10_USE        (ATL_PTI_TYPE_CHK(E10) == ATL_PIA_CHK)
    #define ATL_PIB_E10_USE        (ATL_PTI_TYPE_CHK(E10) == ATL_PIB_CHK)
    #define ATL_PIC_E10_USE        (ATL_PTI_TYPE_CHK(E10) == ATL_PIC_CHK)
    #define ATL_PID_E10_USE        (ATL_PTI_TYPE_CHK(E10) == ATL_PID_CHK)
    #define ATL_PIJ_E10_USE        (ATL_PTI_TYPE_CHK(E10) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E10_USE        0
    #define ATL_PIB_E10_USE        0
    #define ATL_PIC_E10_USE        0
    #define ATL_PID_E10_USE        0
    #define ATL_PIJ_E10_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E11_USE        (ATL_PTI_TYPE_CHK(E11) == ATL_PIA_CHK)
    #define ATL_PIB_E11_USE        (ATL_PTI_TYPE_CHK(E11) == ATL_PIB_CHK)
    #define ATL_PIC_E11_USE        (ATL_PTI_TYPE_CHK(E11) == ATL_PIC_CHK)
    #define ATL_PID_E11_USE        (ATL_PTI_TYPE_CHK(E11) == ATL_PID_CHK)
    #define ATL_PIJ_E11_USE        (ATL_PTI_TYPE_CHK(E11) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E11_USE        0
    #define ATL_PIB_E11_USE        0
    #define ATL_PIC_E11_USE        0
    #define ATL_PID_E11_USE        0
    #define ATL_PIJ_E11_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E12_USE        (ATL_PTI_TYPE_CHK(E12) == ATL_PIA_CHK)
    #define ATL_PIB_E12_USE        (ATL_PTI_TYPE_CHK(E12) == ATL_PIB_CHK)
    #define ATL_PIC_E12_USE        (ATL_PTI_TYPE_CHK(E12) == ATL_PIC_CHK)
    #define ATL_PID_E12_USE        (ATL_PTI_TYPE_CHK(E12) == ATL_PID_CHK)
    #define ATL_PIJ_E12_USE        (ATL_PTI_TYPE_CHK(E12) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E12_USE        0
    #define ATL_PIB_E12_USE        0
    #define ATL_PIC_E12_USE        0
    #define ATL_PID_E12_USE        0
    #define ATL_PIJ_E12_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E13_USE        (ATL_PTI_TYPE_CHK(E13) == ATL_PIA_CHK)
    #define ATL_PIB_E13_USE        (ATL_PTI_TYPE_CHK(E13) == ATL_PIB_CHK)
    #define ATL_PIC_E13_USE        (ATL_PTI_TYPE_CHK(E13) == ATL_PIC_CHK)
    #define ATL_PID_E13_USE        (ATL_PTI_TYPE_CHK(E13) == ATL_PID_CHK)
    #define ATL_PIJ_E13_USE        (ATL_PTI_TYPE_CHK(E13) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E13_USE        0
    #define ATL_PIB_E13_USE        0
    #define ATL_PIC_E13_USE        0
    #define ATL_PID_E13_USE        0
    #define ATL_PIJ_E13_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E14_USE        (ATL_PTI_TYPE_CHK(E14) == ATL_PIA_CHK)
    #define ATL_PIB_E14_USE        (ATL_PTI_TYPE_CHK(E14) == ATL_PIB_CHK)
    #define ATL_PIC_E14_USE        (ATL_PTI_TYPE_CHK(E14) == ATL_PIC_CHK)
    #define ATL_PID_E14_USE        (ATL_PTI_TYPE_CHK(E14) == ATL_PID_CHK)
    #define ATL_PIJ_E14_USE        (ATL_PTI_TYPE_CHK(E14) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E14_USE        0
    #define ATL_PIB_E14_USE        0
    #define ATL_PIC_E14_USE        0
    #define ATL_PID_E14_USE        0
    #define ATL_PIJ_E14_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E15_USE        (ATL_PTI_TYPE_CHK(E15) == ATL_PIA_CHK)
    #define ATL_PIB_E15_USE        (ATL_PTI_TYPE_CHK(E15) == ATL_PIB_CHK)
    #define ATL_PIC_E15_USE        (ATL_PTI_TYPE_CHK(E15) == ATL_PIC_CHK)
    #define ATL_PID_E15_USE        (ATL_PTI_TYPE_CHK(E15) == ATL_PID_CHK)
    #define ATL_PIJ_E15_USE        (ATL_PTI_TYPE_CHK(E15) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E15_USE        0
    #define ATL_PIB_E15_USE        0
    #define ATL_PIC_E15_USE        0
    #define ATL_PID_E15_USE        0
    #define ATL_PIJ_E15_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E16_USE        (ATL_PTI_TYPE_CHK(E16) == ATL_PIA_CHK)
    #define ATL_PIB_E16_USE        (ATL_PTI_TYPE_CHK(E16) == ATL_PIB_CHK)
    #define ATL_PIC_E16_USE        (ATL_PTI_TYPE_CHK(E16) == ATL_PIC_CHK)
    #define ATL_PID_E16_USE        (ATL_PTI_TYPE_CHK(E16) == ATL_PID_CHK)
    #define ATL_PIJ_E16_USE        (ATL_PTI_TYPE_CHK(E16) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E16_USE        0
    #define ATL_PIB_E16_USE        0
    #define ATL_PIC_E16_USE        0
    #define ATL_PID_E16_USE        0
    #define ATL_PIJ_E16_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E17_USE        (ATL_PTI_TYPE_CHK(E17) == ATL_PIA_CHK)
    #define ATL_PIB_E17_USE        (ATL_PTI_TYPE_CHK(E17) == ATL_PIB_CHK)
    #define ATL_PIC_E17_USE        (ATL_PTI_TYPE_CHK(E17) == ATL_PIC_CHK)
    #define ATL_PID_E17_USE        (ATL_PTI_TYPE_CHK(E17) == ATL_PID_CHK)
    #define ATL_PIJ_E17_USE        (ATL_PTI_TYPE_CHK(E17) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E17_USE        0
    #define ATL_PIB_E17_USE        0
    #define ATL_PIC_E17_USE        0
    #define ATL_PID_E17_USE        0
    #define ATL_PIJ_E17_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E18_USE        (ATL_PTI_TYPE_CHK(E18) == ATL_PIA_CHK)
    #define ATL_PIB_E18_USE        (ATL_PTI_TYPE_CHK(E18) == ATL_PIB_CHK)
    #define ATL_PIC_E18_USE        (ATL_PTI_TYPE_CHK(E18) == ATL_PIC_CHK)
    #define ATL_PID_E18_USE        (ATL_PTI_TYPE_CHK(E18) == ATL_PID_CHK)
    #define ATL_PIJ_E18_USE        (ATL_PTI_TYPE_CHK(E18) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E18_USE        0
    #define ATL_PIB_E18_USE        0
    #define ATL_PIC_E18_USE        0
    #define ATL_PID_E18_USE        0
    #define ATL_PIJ_E18_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E19_USE        (ATL_PTI_TYPE_CHK(E19) == ATL_PIA_CHK)
    #define ATL_PIB_E19_USE        (ATL_PTI_TYPE_CHK(E19) == ATL_PIB_CHK)
    #define ATL_PIC_E19_USE        (ATL_PTI_TYPE_CHK(E19) == ATL_PIC_CHK)
    #define ATL_PID_E19_USE        (ATL_PTI_TYPE_CHK(E19) == ATL_PID_CHK)
    #define ATL_PIJ_E19_USE        (ATL_PTI_TYPE_CHK(E19) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E19_USE        0
    #define ATL_PIB_E19_USE        0
    #define ATL_PIC_E19_USE        0
    #define ATL_PID_E19_USE        0
    #define ATL_PIJ_E19_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E20_USE        (ATL_PTI_TYPE_CHK(E20) == ATL_PIA_CHK)
    #define ATL_PIB_E20_USE        (ATL_PTI_TYPE_CHK(E20) == ATL_PIB_CHK)
    #define ATL_PIC_E20_USE        (ATL_PTI_TYPE_CHK(E20) == ATL_PIC_CHK)
    #define ATL_PID_E20_USE        (ATL_PTI_TYPE_CHK(E20) == ATL_PID_CHK)
    #define ATL_PIJ_E20_USE        (ATL_PTI_TYPE_CHK(E20) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E20_USE        0
    #define ATL_PIB_E20_USE        0
    #define ATL_PIC_E20_USE        0
    #define ATL_PID_E20_USE        0
    #define ATL_PIJ_E20_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E21_USE        (ATL_PTI_TYPE_CHK(E21) == ATL_PIA_CHK)
    #define ATL_PIB_E21_USE        (ATL_PTI_TYPE_CHK(E21) == ATL_PIB_CHK)
    #define ATL_PIC_E21_USE        (ATL_PTI_TYPE_CHK(E21) == ATL_PIC_CHK)
    #define ATL_PID_E21_USE        (ATL_PTI_TYPE_CHK(E21) == ATL_PID_CHK)
    #define ATL_PIJ_E21_USE        (ATL_PTI_TYPE_CHK(E21) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E21_USE        0
    #define ATL_PIB_E21_USE        0
    #define ATL_PIC_E21_USE        0
    #define ATL_PID_E21_USE        0
    #define ATL_PIJ_E21_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E22_USE        (ATL_PTI_TYPE_CHK(E22) == ATL_PIA_CHK)
    #define ATL_PIB_E22_USE        (ATL_PTI_TYPE_CHK(E22) == ATL_PIB_CHK)
    #define ATL_PIC_E22_USE        (ATL_PTI_TYPE_CHK(E22) == ATL_PIC_CHK)
    #define ATL_PID_E22_USE        (ATL_PTI_TYPE_CHK(E22) == ATL_PID_CHK)
    #define ATL_PIJ_E22_USE        (ATL_PTI_TYPE_CHK(E22) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E22_USE        0
    #define ATL_PIB_E22_USE        0
    #define ATL_PIC_E22_USE        0
    #define ATL_PID_E22_USE        0
    #define ATL_PIJ_E22_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E23_USE        (ATL_PTI_TYPE_CHK(E23) == ATL_PIA_CHK)
    #define ATL_PIB_E23_USE        (ATL_PTI_TYPE_CHK(E23) == ATL_PIB_CHK)
    #define ATL_PIC_E23_USE        (ATL_PTI_TYPE_CHK(E23) == ATL_PIC_CHK)
    #define ATL_PID_E23_USE        (ATL_PTI_TYPE_CHK(E23) == ATL_PID_CHK)
    #define ATL_PIJ_E23_USE        (ATL_PTI_TYPE_CHK(E23) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E23_USE        0
    #define ATL_PIB_E23_USE        0
    #define ATL_PIC_E23_USE        0
    #define ATL_PID_E23_USE        0
    #define ATL_PIJ_E23_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E24_USE        (ATL_PTI_TYPE_CHK(E24) == ATL_PIA_CHK)
    #define ATL_PIB_E24_USE        (ATL_PTI_TYPE_CHK(E24) == ATL_PIB_CHK)
    #define ATL_PIC_E24_USE        (ATL_PTI_TYPE_CHK(E24) == ATL_PIC_CHK)
    #define ATL_PID_E24_USE        (ATL_PTI_TYPE_CHK(E24) == ATL_PID_CHK)
    #define ATL_PIJ_E24_USE        (ATL_PTI_TYPE_CHK(E24) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E24_USE        0
    #define ATL_PIB_E24_USE        0
    #define ATL_PIC_E24_USE        0
    #define ATL_PID_E24_USE        0
    #define ATL_PIJ_E24_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E25_USE        (ATL_PTI_TYPE_CHK(E25) == ATL_PIA_CHK)
    #define ATL_PIB_E25_USE        (ATL_PTI_TYPE_CHK(E25) == ATL_PIB_CHK)
    #define ATL_PIC_E25_USE        (ATL_PTI_TYPE_CHK(E25) == ATL_PIC_CHK)
    #define ATL_PID_E25_USE        (ATL_PTI_TYPE_CHK(E25) == ATL_PID_CHK)
    #define ATL_PIJ_E25_USE        (ATL_PTI_TYPE_CHK(E25) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E25_USE        0
    #define ATL_PIB_E25_USE        0
    #define ATL_PIC_E25_USE        0
    #define ATL_PID_E25_USE        0
    #define ATL_PIJ_E25_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E26_USE        (ATL_PTI_TYPE_CHK(E26) == ATL_PIA_CHK)
    #define ATL_PIB_E26_USE        (ATL_PTI_TYPE_CHK(E26) == ATL_PIB_CHK)
    #define ATL_PIC_E26_USE        (ATL_PTI_TYPE_CHK(E26) == ATL_PIC_CHK)
    #define ATL_PID_E26_USE        (ATL_PTI_TYPE_CHK(E26) == ATL_PID_CHK)
    #define ATL_PIJ_E26_USE        (ATL_PTI_TYPE_CHK(E26) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E26_USE        0
    #define ATL_PIB_E26_USE        0
    #define ATL_PIC_E26_USE        0
    #define ATL_PID_E26_USE        0
    #define ATL_PIJ_E26_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E27_USE        (ATL_PTI_TYPE_CHK(E27) == ATL_PIA_CHK)
    #define ATL_PIB_E27_USE        (ATL_PTI_TYPE_CHK(E27) == ATL_PIB_CHK)
    #define ATL_PIC_E27_USE        (ATL_PTI_TYPE_CHK(E27) == ATL_PIC_CHK)
    #define ATL_PID_E27_USE        (ATL_PTI_TYPE_CHK(E27) == ATL_PID_CHK)
    #define ATL_PIJ_E27_USE        (ATL_PTI_TYPE_CHK(E27) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E27_USE        0
    #define ATL_PIB_E27_USE        0
    #define ATL_PIC_E27_USE        0
    #define ATL_PID_E27_USE        0
    #define ATL_PIJ_E27_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E28_USE        (ATL_PTI_TYPE_CHK(E28) == ATL_PIA_CHK)
    #define ATL_PIB_E28_USE        (ATL_PTI_TYPE_CHK(E28) == ATL_PIB_CHK)
    #define ATL_PIC_E28_USE        (ATL_PTI_TYPE_CHK(E28) == ATL_PIC_CHK)
    #define ATL_PID_E28_USE        (ATL_PTI_TYPE_CHK(E28) == ATL_PID_CHK)
    #define ATL_PIJ_E28_USE        (ATL_PTI_TYPE_CHK(E28) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E28_USE        0
    #define ATL_PIB_E28_USE        0
    #define ATL_PIC_E28_USE        0
    #define ATL_PID_E28_USE        0
    #define ATL_PIJ_E28_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E29_USE        (ATL_PTI_TYPE_CHK(E29) == ATL_PIA_CHK)
    #define ATL_PIB_E29_USE        (ATL_PTI_TYPE_CHK(E29) == ATL_PIB_CHK)
    #define ATL_PIC_E29_USE        (ATL_PTI_TYPE_CHK(E29) == ATL_PIC_CHK)
    #define ATL_PID_E29_USE        (ATL_PTI_TYPE_CHK(E29) == ATL_PID_CHK)
    #define ATL_PIJ_E29_USE        (ATL_PTI_TYPE_CHK(E29) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E29_USE        0
    #define ATL_PIB_E29_USE        0
    #define ATL_PIC_E29_USE        0
    #define ATL_PID_E29_USE        0
    #define ATL_PIJ_E29_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E30_USE        (ATL_PTI_TYPE_CHK(E30) == ATL_PIA_CHK)
    #define ATL_PIB_E30_USE        (ATL_PTI_TYPE_CHK(E30) == ATL_PIB_CHK)
    #define ATL_PIC_E30_USE        (ATL_PTI_TYPE_CHK(E30) == ATL_PIC_CHK)
    #define ATL_PID_E30_USE        (ATL_PTI_TYPE_CHK(E30) == ATL_PID_CHK)
    #define ATL_PIJ_E30_USE        (ATL_PTI_TYPE_CHK(E30) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E30_USE        0
    #define ATL_PIB_E30_USE        0
    #define ATL_PIC_E30_USE        0
    #define ATL_PID_E30_USE        0
    #define ATL_PIJ_E30_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E31_USE        (ATL_PTI_TYPE_CHK(E31) == ATL_PIA_CHK)
    #define ATL_PIB_E31_USE        (ATL_PTI_TYPE_CHK(E31) == ATL_PIB_CHK)
    #define ATL_PIC_E31_USE        (ATL_PTI_TYPE_CHK(E31) == ATL_PIC_CHK)
    #define ATL_PID_E31_USE        (ATL_PTI_TYPE_CHK(E31) == ATL_PID_CHK)
    #define ATL_PIJ_E31_USE        (ATL_PTI_TYPE_CHK(E31) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E31_USE        0
    #define ATL_PIB_E31_USE        0
    #define ATL_PIC_E31_USE        0
    #define ATL_PID_E31_USE        0
    #define ATL_PIJ_E31_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E32_USE        (ATL_PTI_TYPE_CHK(E32) == ATL_PIA_CHK)
    #define ATL_PIB_E32_USE        (ATL_PTI_TYPE_CHK(E32) == ATL_PIB_CHK)
    #define ATL_PIC_E32_USE        (ATL_PTI_TYPE_CHK(E32) == ATL_PIC_CHK)
    #define ATL_PID_E32_USE        (ATL_PTI_TYPE_CHK(E32) == ATL_PID_CHK)
    #define ATL_PIJ_E32_USE        (ATL_PTI_TYPE_CHK(E32) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E32_USE        0
    #define ATL_PIB_E32_USE        0
    #define ATL_PIC_E32_USE        0
    #define ATL_PID_E32_USE        0
    #define ATL_PIJ_E32_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E33_USE        (ATL_PTI_TYPE_CHK(E33) == ATL_PIA_CHK)
    #define ATL_PIB_E33_USE        (ATL_PTI_TYPE_CHK(E33) == ATL_PIB_CHK)
    #define ATL_PIC_E33_USE        (ATL_PTI_TYPE_CHK(E33) == ATL_PIC_CHK)
    #define ATL_PID_E33_USE        (ATL_PTI_TYPE_CHK(E33) == ATL_PID_CHK)
    #define ATL_PIJ_E33_USE        (ATL_PTI_TYPE_CHK(E33) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E33_USE        0
    #define ATL_PIB_E33_USE        0
    #define ATL_PIC_E33_USE        0
    #define ATL_PID_E33_USE        0
    #define ATL_PIJ_E33_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E34_USE        (ATL_PTI_TYPE_CHK(E34) == ATL_PIA_CHK)
    #define ATL_PIB_E34_USE        (ATL_PTI_TYPE_CHK(E34) == ATL_PIB_CHK)
    #define ATL_PIC_E34_USE        (ATL_PTI_TYPE_CHK(E34) == ATL_PIC_CHK)
    #define ATL_PID_E34_USE        (ATL_PTI_TYPE_CHK(E34) == ATL_PID_CHK)
    #define ATL_PIJ_E34_USE        (ATL_PTI_TYPE_CHK(E34) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E34_USE        0
    #define ATL_PIB_E34_USE        0
    #define ATL_PIC_E34_USE        0
    #define ATL_PID_E34_USE        0
    #define ATL_PIJ_E34_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E35_USE        (ATL_PTI_TYPE_CHK(E35) == ATL_PIA_CHK)
    #define ATL_PIB_E35_USE        (ATL_PTI_TYPE_CHK(E35) == ATL_PIB_CHK)
    #define ATL_PIC_E35_USE        (ATL_PTI_TYPE_CHK(E35) == ATL_PIC_CHK)
    #define ATL_PID_E35_USE        (ATL_PTI_TYPE_CHK(E35) == ATL_PID_CHK)
    #define ATL_PIJ_E35_USE        (ATL_PTI_TYPE_CHK(E35) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E35_USE        0
    #define ATL_PIB_E35_USE        0
    #define ATL_PIC_E35_USE        0
    #define ATL_PID_E35_USE        0
    #define ATL_PIJ_E35_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E36_USE        (ATL_PTI_TYPE_CHK(E36) == ATL_PIA_CHK)
    #define ATL_PIB_E36_USE        (ATL_PTI_TYPE_CHK(E36) == ATL_PIB_CHK)
    #define ATL_PIC_E36_USE        (ATL_PTI_TYPE_CHK(E36) == ATL_PIC_CHK)
    #define ATL_PID_E36_USE        (ATL_PTI_TYPE_CHK(E36) == ATL_PID_CHK)
    #define ATL_PIJ_E36_USE        (ATL_PTI_TYPE_CHK(E36) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E36_USE        0
    #define ATL_PIB_E36_USE        0
    #define ATL_PIC_E36_USE        0
    #define ATL_PID_E36_USE        0
    #define ATL_PIJ_E36_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E37_USE        (ATL_PTI_TYPE_CHK(E37) == ATL_PIA_CHK)
    #define ATL_PIB_E37_USE        (ATL_PTI_TYPE_CHK(E37) == ATL_PIB_CHK)
    #define ATL_PIC_E37_USE        (ATL_PTI_TYPE_CHK(E37) == ATL_PIC_CHK)
    #define ATL_PID_E37_USE        (ATL_PTI_TYPE_CHK(E37) == ATL_PID_CHK)
    #define ATL_PIJ_E37_USE        (ATL_PTI_TYPE_CHK(E37) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E37_USE        0
    #define ATL_PIB_E37_USE        0
    #define ATL_PIC_E37_USE        0
    #define ATL_PID_E37_USE        0
    #define ATL_PIJ_E37_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E38_USE        (ATL_PTI_TYPE_CHK(E38) == ATL_PIA_CHK)
    #define ATL_PIB_E38_USE        (ATL_PTI_TYPE_CHK(E38) == ATL_PIB_CHK)
    #define ATL_PIC_E38_USE        (ATL_PTI_TYPE_CHK(E38) == ATL_PIC_CHK)
    #define ATL_PID_E38_USE        (ATL_PTI_TYPE_CHK(E38) == ATL_PID_CHK)
    #define ATL_PIJ_E38_USE        (ATL_PTI_TYPE_CHK(E38) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E38_USE        0
    #define ATL_PIB_E38_USE        0
    #define ATL_PIC_E38_USE        0
    #define ATL_PID_E38_USE        0
    #define ATL_PIJ_E38_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E39_USE        (ATL_PTI_TYPE_CHK(E39) == ATL_PIA_CHK)
    #define ATL_PIB_E39_USE        (ATL_PTI_TYPE_CHK(E39) == ATL_PIB_CHK)
    #define ATL_PIC_E39_USE        (ATL_PTI_TYPE_CHK(E39) == ATL_PIC_CHK)
    #define ATL_PID_E39_USE        (ATL_PTI_TYPE_CHK(E39) == ATL_PID_CHK)
    #define ATL_PIJ_E39_USE        (ATL_PTI_TYPE_CHK(E39) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E39_USE        0
    #define ATL_PIB_E39_USE        0
    #define ATL_PIC_E39_USE        0
    #define ATL_PID_E39_USE        0
    #define ATL_PIJ_E39_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E40_USE        (ATL_PTI_TYPE_CHK(E40) == ATL_PIA_CHK)
    #define ATL_PIB_E40_USE        (ATL_PTI_TYPE_CHK(E40) == ATL_PIB_CHK)
    #define ATL_PIC_E40_USE        (ATL_PTI_TYPE_CHK(E40) == ATL_PIC_CHK)
    #define ATL_PID_E40_USE        (ATL_PTI_TYPE_CHK(E40) == ATL_PID_CHK)
    #define ATL_PIJ_E40_USE        (ATL_PTI_TYPE_CHK(E40) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E40_USE        0
    #define ATL_PIB_E40_USE        0
    #define ATL_PIC_E40_USE        0
    #define ATL_PID_E40_USE        0
    #define ATL_PIJ_E40_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E41_USE        (ATL_PTI_TYPE_CHK(E41) == ATL_PIA_CHK)
    #define ATL_PIB_E41_USE        (ATL_PTI_TYPE_CHK(E41) == ATL_PIB_CHK)
    #define ATL_PIC_E41_USE        (ATL_PTI_TYPE_CHK(E41) == ATL_PIC_CHK)
    #define ATL_PID_E41_USE        (ATL_PTI_TYPE_CHK(E41) == ATL_PID_CHK)
    #define ATL_PIJ_E41_USE        (ATL_PTI_TYPE_CHK(E41) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E41_USE        0
    #define ATL_PIB_E41_USE        0
    #define ATL_PIC_E41_USE        0
    #define ATL_PID_E41_USE        0
    #define ATL_PIJ_E41_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E42_USE        (ATL_PTI_TYPE_CHK(E42) == ATL_PIA_CHK)
    #define ATL_PIB_E42_USE        (ATL_PTI_TYPE_CHK(E42) == ATL_PIB_CHK)
    #define ATL_PIC_E42_USE        (ATL_PTI_TYPE_CHK(E42) == ATL_PIC_CHK)
    #define ATL_PID_E42_USE        (ATL_PTI_TYPE_CHK(E42) == ATL_PID_CHK)
    #define ATL_PIJ_E42_USE        (ATL_PTI_TYPE_CHK(E42) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E42_USE        0
    #define ATL_PIB_E42_USE        0
    #define ATL_PIC_E42_USE        0
    #define ATL_PID_E42_USE        0
    #define ATL_PIJ_E42_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E43_USE        (ATL_PTI_TYPE_CHK(E43) == ATL_PIA_CHK)
    #define ATL_PIB_E43_USE        (ATL_PTI_TYPE_CHK(E43) == ATL_PIB_CHK)
    #define ATL_PIC_E43_USE        (ATL_PTI_TYPE_CHK(E43) == ATL_PIC_CHK)
    #define ATL_PID_E43_USE        (ATL_PTI_TYPE_CHK(E43) == ATL_PID_CHK)
    #define ATL_PIJ_E43_USE        (ATL_PTI_TYPE_CHK(E43) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E43_USE        0
    #define ATL_PIB_E43_USE        0
    #define ATL_PIC_E43_USE        0
    #define ATL_PID_E43_USE        0
    #define ATL_PIJ_E43_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E44_USE        (ATL_PTI_TYPE_CHK(E44) == ATL_PIA_CHK)
    #define ATL_PIB_E44_USE        (ATL_PTI_TYPE_CHK(E44) == ATL_PIB_CHK)
    #define ATL_PIC_E44_USE        (ATL_PTI_TYPE_CHK(E44) == ATL_PIC_CHK)
    #define ATL_PID_E44_USE        (ATL_PTI_TYPE_CHK(E44) == ATL_PID_CHK)
    #define ATL_PIJ_E44_USE        (ATL_PTI_TYPE_CHK(E44) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E44_USE        0
    #define ATL_PIB_E44_USE        0
    #define ATL_PIC_E44_USE        0
    #define ATL_PID_E44_USE        0
    #define ATL_PIJ_E44_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E45_USE        (ATL_PTI_TYPE_CHK(E45) == ATL_PIA_CHK)
    #define ATL_PIB_E45_USE        (ATL_PTI_TYPE_CHK(E45) == ATL_PIB_CHK)
    #define ATL_PIC_E45_USE        (ATL_PTI_TYPE_CHK(E45) == ATL_PIC_CHK)
    #define ATL_PID_E45_USE        (ATL_PTI_TYPE_CHK(E45) == ATL_PID_CHK)
    #define ATL_PIJ_E45_USE        (ATL_PTI_TYPE_CHK(E45) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E45_USE        0
    #define ATL_PIB_E45_USE        0
    #define ATL_PIC_E45_USE        0
    #define ATL_PID_E45_USE        0
    #define ATL_PIJ_E45_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E46_USE        (ATL_PTI_TYPE_CHK(E46) == ATL_PIA_CHK)
    #define ATL_PIB_E46_USE        (ATL_PTI_TYPE_CHK(E46) == ATL_PIB_CHK)
    #define ATL_PIC_E46_USE        (ATL_PTI_TYPE_CHK(E46) == ATL_PIC_CHK)
    #define ATL_PID_E46_USE        (ATL_PTI_TYPE_CHK(E46) == ATL_PID_CHK)
    #define ATL_PIJ_E46_USE        (ATL_PTI_TYPE_CHK(E46) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E46_USE        0
    #define ATL_PIB_E46_USE        0
    #define ATL_PIC_E46_USE        0
    #define ATL_PID_E46_USE        0
    #define ATL_PIJ_E46_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E47_USE        (ATL_PTI_TYPE_CHK(E47) == ATL_PIA_CHK)
    #define ATL_PIB_E47_USE        (ATL_PTI_TYPE_CHK(E47) == ATL_PIB_CHK)
    #define ATL_PIC_E47_USE        (ATL_PTI_TYPE_CHK(E47) == ATL_PIC_CHK)
    #define ATL_PID_E47_USE        (ATL_PTI_TYPE_CHK(E47) == ATL_PID_CHK)
    #define ATL_PIJ_E47_USE        (ATL_PTI_TYPE_CHK(E47) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E47_USE        0
    #define ATL_PIB_E47_USE        0
    #define ATL_PIC_E47_USE        0
    #define ATL_PID_E47_USE        0
    #define ATL_PIJ_E47_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E48_USE        (ATL_PTI_TYPE_CHK(E48) == ATL_PIA_CHK)
    #define ATL_PIB_E48_USE        (ATL_PTI_TYPE_CHK(E48) == ATL_PIB_CHK)
    #define ATL_PIC_E48_USE        (ATL_PTI_TYPE_CHK(E48) == ATL_PIC_CHK)
    #define ATL_PID_E48_USE        (ATL_PTI_TYPE_CHK(E48) == ATL_PID_CHK)
    #define ATL_PIJ_E48_USE        (ATL_PTI_TYPE_CHK(E48) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E48_USE        0
    #define ATL_PIB_E48_USE        0
    #define ATL_PIC_E48_USE        0
    #define ATL_PID_E48_USE        0
    #define ATL_PIJ_E48_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E49_USE        (ATL_PTI_TYPE_CHK(E49) == ATL_PIA_CHK)
    #define ATL_PIB_E49_USE        (ATL_PTI_TYPE_CHK(E49) == ATL_PIB_CHK)
    #define ATL_PIC_E49_USE        (ATL_PTI_TYPE_CHK(E49) == ATL_PIC_CHK)
    #define ATL_PID_E49_USE        (ATL_PTI_TYPE_CHK(E49) == ATL_PID_CHK)
    #define ATL_PIJ_E49_USE        (ATL_PTI_TYPE_CHK(E49) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E49_USE        0
    #define ATL_PIB_E49_USE        0
    #define ATL_PIC_E49_USE        0
    #define ATL_PID_E49_USE        0
    #define ATL_PIJ_E49_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E50_USE        (ATL_PTI_TYPE_CHK(E50) == ATL_PIA_CHK)
    #define ATL_PIB_E50_USE        (ATL_PTI_TYPE_CHK(E50) == ATL_PIB_CHK)
    #define ATL_PIC_E50_USE        (ATL_PTI_TYPE_CHK(E50) == ATL_PIC_CHK)
    #define ATL_PID_E50_USE        (ATL_PTI_TYPE_CHK(E50) == ATL_PID_CHK)
    #define ATL_PIJ_E50_USE        (ATL_PTI_TYPE_CHK(E50) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E50_USE        0
    #define ATL_PIB_E50_USE        0
    #define ATL_PIC_E50_USE        0
    #define ATL_PID_E50_USE        0
    #define ATL_PIJ_E50_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E51_USE        (ATL_PTI_TYPE_CHK(E51) == ATL_PIA_CHK)
    #define ATL_PIB_E51_USE        (ATL_PTI_TYPE_CHK(E51) == ATL_PIB_CHK)
    #define ATL_PIC_E51_USE        (ATL_PTI_TYPE_CHK(E51) == ATL_PIC_CHK)
    #define ATL_PID_E51_USE        (ATL_PTI_TYPE_CHK(E51) == ATL_PID_CHK)
    #define ATL_PIJ_E51_USE        (ATL_PTI_TYPE_CHK(E51) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E51_USE        0
    #define ATL_PIB_E51_USE        0
    #define ATL_PIC_E51_USE        0
    #define ATL_PID_E51_USE        0
    #define ATL_PIJ_E51_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E52_USE        (ATL_PTI_TYPE_CHK(E52) == ATL_PIA_CHK)
    #define ATL_PIB_E52_USE        (ATL_PTI_TYPE_CHK(E52) == ATL_PIB_CHK)
    #define ATL_PIC_E52_USE        (ATL_PTI_TYPE_CHK(E52) == ATL_PIC_CHK)
    #define ATL_PID_E52_USE        (ATL_PTI_TYPE_CHK(E52) == ATL_PID_CHK)
    #define ATL_PIJ_E52_USE        (ATL_PTI_TYPE_CHK(E52) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E52_USE        0
    #define ATL_PIB_E52_USE        0
    #define ATL_PIC_E52_USE        0
    #define ATL_PID_E52_USE        0
    #define ATL_PIJ_E52_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E53_USE        (ATL_PTI_TYPE_CHK(E53) == ATL_PIA_CHK)
    #define ATL_PIB_E53_USE        (ATL_PTI_TYPE_CHK(E53) == ATL_PIB_CHK)
    #define ATL_PIC_E53_USE        (ATL_PTI_TYPE_CHK(E53) == ATL_PIC_CHK)
    #define ATL_PID_E53_USE        (ATL_PTI_TYPE_CHK(E53) == ATL_PID_CHK)
    #define ATL_PIJ_E53_USE        (ATL_PTI_TYPE_CHK(E53) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E53_USE        0
    #define ATL_PIB_E53_USE        0
    #define ATL_PIC_E53_USE        0
    #define ATL_PID_E53_USE        0
    #define ATL_PIJ_E53_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E54_USE        (ATL_PTI_TYPE_CHK(E54) == ATL_PIA_CHK)
    #define ATL_PIB_E54_USE        (ATL_PTI_TYPE_CHK(E54) == ATL_PIB_CHK)
    #define ATL_PIC_E54_USE        (ATL_PTI_TYPE_CHK(E54) == ATL_PIC_CHK)
    #define ATL_PID_E54_USE        (ATL_PTI_TYPE_CHK(E54) == ATL_PID_CHK)
    #define ATL_PIJ_E54_USE        (ATL_PTI_TYPE_CHK(E54) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E54_USE        0
    #define ATL_PIB_E54_USE        0
    #define ATL_PIC_E54_USE        0
    #define ATL_PID_E54_USE        0
    #define ATL_PIJ_E54_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E55_USE        (ATL_PTI_TYPE_CHK(E55) == ATL_PIA_CHK)
    #define ATL_PIB_E55_USE        (ATL_PTI_TYPE_CHK(E55) == ATL_PIB_CHK)
    #define ATL_PIC_E55_USE        (ATL_PTI_TYPE_CHK(E55) == ATL_PIC_CHK)
    #define ATL_PID_E55_USE        (ATL_PTI_TYPE_CHK(E55) == ATL_PID_CHK)
    #define ATL_PIJ_E55_USE        (ATL_PTI_TYPE_CHK(E55) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E55_USE        0
    #define ATL_PIB_E55_USE        0
    #define ATL_PIC_E55_USE        0
    #define ATL_PID_E55_USE        0
    #define ATL_PIJ_E55_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E56_USE        (ATL_PTI_TYPE_CHK(E56) == ATL_PIA_CHK)
    #define ATL_PIB_E56_USE        (ATL_PTI_TYPE_CHK(E56) == ATL_PIB_CHK)
    #define ATL_PIC_E56_USE        (ATL_PTI_TYPE_CHK(E56) == ATL_PIC_CHK)
    #define ATL_PID_E56_USE        (ATL_PTI_TYPE_CHK(E56) == ATL_PID_CHK)
    #define ATL_PIJ_E56_USE        (ATL_PTI_TYPE_CHK(E56) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E56_USE        0
    #define ATL_PIB_E56_USE        0
    #define ATL_PIC_E56_USE        0
    #define ATL_PID_E56_USE        0
    #define ATL_PIJ_E56_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E57_USE        (ATL_PTI_TYPE_CHK(E57) == ATL_PIA_CHK)
    #define ATL_PIB_E57_USE        (ATL_PTI_TYPE_CHK(E57) == ATL_PIB_CHK)
    #define ATL_PIC_E57_USE        (ATL_PTI_TYPE_CHK(E57) == ATL_PIC_CHK)
    #define ATL_PID_E57_USE        (ATL_PTI_TYPE_CHK(E57) == ATL_PID_CHK)
    #define ATL_PIJ_E57_USE        (ATL_PTI_TYPE_CHK(E57) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E57_USE        0
    #define ATL_PIB_E57_USE        0
    #define ATL_PIC_E57_USE        0
    #define ATL_PID_E57_USE        0
    #define ATL_PIJ_E57_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E58_USE        (ATL_PTI_TYPE_CHK(E58) == ATL_PIA_CHK)
    #define ATL_PIB_E58_USE        (ATL_PTI_TYPE_CHK(E58) == ATL_PIB_CHK)
    #define ATL_PIC_E58_USE        (ATL_PTI_TYPE_CHK(E58) == ATL_PIC_CHK)
    #define ATL_PID_E58_USE        (ATL_PTI_TYPE_CHK(E58) == ATL_PID_CHK)
    #define ATL_PIJ_E58_USE        (ATL_PTI_TYPE_CHK(E58) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E58_USE        0
    #define ATL_PIB_E58_USE        0
    #define ATL_PIC_E58_USE        0
    #define ATL_PID_E58_USE        0
    #define ATL_PIJ_E58_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E59_USE        (ATL_PTI_TYPE_CHK(E59) == ATL_PIA_CHK)
    #define ATL_PIB_E59_USE        (ATL_PTI_TYPE_CHK(E59) == ATL_PIB_CHK)
    #define ATL_PIC_E59_USE        (ATL_PTI_TYPE_CHK(E59) == ATL_PIC_CHK)
    #define ATL_PID_E59_USE        (ATL_PTI_TYPE_CHK(E59) == ATL_PID_CHK)
    #define ATL_PIJ_E59_USE        (ATL_PTI_TYPE_CHK(E59) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E59_USE        0
    #define ATL_PIB_E59_USE        0
    #define ATL_PIC_E59_USE        0
    #define ATL_PID_E59_USE        0
    #define ATL_PIJ_E59_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E60_USE        (ATL_PTI_TYPE_CHK(E60) == ATL_PIA_CHK)
    #define ATL_PIB_E60_USE        (ATL_PTI_TYPE_CHK(E60) == ATL_PIB_CHK)
    #define ATL_PIC_E60_USE        (ATL_PTI_TYPE_CHK(E60) == ATL_PIC_CHK)
    #define ATL_PID_E60_USE        (ATL_PTI_TYPE_CHK(E60) == ATL_PID_CHK)
    #define ATL_PIJ_E60_USE        (ATL_PTI_TYPE_CHK(E60) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E60_USE        0
    #define ATL_PIB_E60_USE        0
    #define ATL_PIC_E60_USE        0
    #define ATL_PID_E60_USE        0
    #define ATL_PIJ_E60_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E61_USE        (ATL_PTI_TYPE_CHK(E61) == ATL_PIA_CHK)
    #define ATL_PIB_E61_USE        (ATL_PTI_TYPE_CHK(E61) == ATL_PIB_CHK)
    #define ATL_PIC_E61_USE        (ATL_PTI_TYPE_CHK(E61) == ATL_PIC_CHK)
    #define ATL_PID_E61_USE        (ATL_PTI_TYPE_CHK(E61) == ATL_PID_CHK)
    #define ATL_PIJ_E61_USE        (ATL_PTI_TYPE_CHK(E61) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E61_USE        0
    #define ATL_PIB_E61_USE        0
    #define ATL_PIC_E61_USE        0
    #define ATL_PID_E61_USE        0
    #define ATL_PIJ_E61_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E62_USE        (ATL_PTI_TYPE_CHK(E62) == ATL_PIA_CHK)
    #define ATL_PIB_E62_USE        (ATL_PTI_TYPE_CHK(E62) == ATL_PIB_CHK)
    #define ATL_PIC_E62_USE        (ATL_PTI_TYPE_CHK(E62) == ATL_PIC_CHK)
    #define ATL_PID_E62_USE        (ATL_PTI_TYPE_CHK(E62) == ATL_PID_CHK)
    #define ATL_PIJ_E62_USE        (ATL_PTI_TYPE_CHK(E62) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E62_USE        0
    #define ATL_PIB_E62_USE        0
    #define ATL_PIC_E62_USE        0
    #define ATL_PID_E62_USE        0
    #define ATL_PIJ_E62_USE        0
  #endif
  #if (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_PTI_CHK)
    #define ATL_PIA_E63_USE        (ATL_PTI_TYPE_CHK(E63) == ATL_PIA_CHK)
    #define ATL_PIB_E63_USE        (ATL_PTI_TYPE_CHK(E63) == ATL_PIB_CHK)
    #define ATL_PIC_E63_USE        (ATL_PTI_TYPE_CHK(E63) == ATL_PIC_CHK)
    #define ATL_PID_E63_USE        (ATL_PTI_TYPE_CHK(E63) == ATL_PID_CHK)
    #define ATL_PIJ_E63_USE        (ATL_PTI_TYPE_CHK(E63) == ATL_PIJ_CHK)
  #else
    #define ATL_PIA_E63_USE        0
    #define ATL_PIB_E63_USE        0
    #define ATL_PIC_E63_USE        0
    #define ATL_PID_E63_USE        0
    #define ATL_PIJ_E63_USE        0
  #endif

  #define ATL_PIA_USED        (ATL_PIA_E0_USE || ATL_PIA_E1_USE || ATL_PIA_E2_USE || ATL_PIA_E3_USE || ATL_PIA_E4_USE || ATL_PIA_E5_USE || ATL_PIA_E6_USE || ATL_PIA_E7_USE || ATL_PIA_E8_USE || ATL_PIA_E9_USE || ATL_PIA_E10_USE || ATL_PIA_E11_USE || ATL_PIA_E12_USE || ATL_PIA_E13_USE || ATL_PIA_E14_USE || ATL_PIA_E15_USE || ATL_PIA_E16_USE || ATL_PIA_E17_USE || ATL_PIA_E18_USE || ATL_PIA_E19_USE || ATL_PIA_E20_USE || ATL_PIA_E21_USE || ATL_PIA_E22_USE || ATL_PIA_E23_USE || ATL_PIA_E24_USE || ATL_PIA_E25_USE || ATL_PIA_E26_USE || ATL_PIA_E27_USE || ATL_PIA_E28_USE || ATL_PIA_E29_USE || ATL_PIA_E30_USE || ATL_PIA_E31_USE || ATL_PIA_E32_USE || ATL_PIA_E33_USE || ATL_PIA_E34_USE || ATL_PIA_E35_USE || ATL_PIA_E36_USE || ATL_PIA_E37_USE || ATL_PIA_E38_USE || ATL_PIA_E39_USE || ATL_PIA_E40_USE || ATL_PIA_E41_USE || ATL_PIA_E42_USE || ATL_PIA_E43_USE || ATL_PIA_E44_USE || ATL_PIA_E45_USE || ATL_PIA_E46_USE || ATL_PIA_E47_USE || ATL_PIA_E48_USE || ATL_PIA_E49_USE || ATL_PIA_E50_USE || ATL_PIA_E51_USE || ATL_PIA_E52_USE || ATL_PIA_E53_USE || ATL_PIA_E54_USE || ATL_PIA_E55_USE || ATL_PIA_E56_USE || ATL_PIA_E57_USE || ATL_PIA_E58_USE || ATL_PIA_E59_USE || ATL_PIA_E60_USE || ATL_PIA_E61_USE || ATL_PIA_E62_USE || ATL_PIA_E63_USE)
  #define ATL_PIB_USED        (ATL_PIB_E0_USE || ATL_PIB_E1_USE || ATL_PIB_E2_USE || ATL_PIB_E3_USE || ATL_PIB_E4_USE || ATL_PIB_E5_USE || ATL_PIB_E6_USE || ATL_PIB_E7_USE || ATL_PIB_E8_USE || ATL_PIB_E9_USE || ATL_PIB_E10_USE || ATL_PIB_E11_USE || ATL_PIB_E12_USE || ATL_PIB_E13_USE || ATL_PIB_E14_USE || ATL_PIB_E15_USE || ATL_PIB_E16_USE || ATL_PIB_E17_USE || ATL_PIB_E18_USE || ATL_PIB_E19_USE || ATL_PIB_E20_USE || ATL_PIB_E21_USE || ATL_PIB_E22_USE || ATL_PIB_E23_USE || ATL_PIB_E24_USE || ATL_PIB_E25_USE || ATL_PIB_E26_USE || ATL_PIB_E27_USE || ATL_PIB_E28_USE || ATL_PIB_E29_USE || ATL_PIB_E30_USE || ATL_PIB_E31_USE || ATL_PIB_E32_USE || ATL_PIB_E33_USE || ATL_PIB_E34_USE || ATL_PIB_E35_USE || ATL_PIB_E36_USE || ATL_PIB_E37_USE || ATL_PIB_E38_USE || ATL_PIB_E39_USE || ATL_PIB_E40_USE || ATL_PIB_E41_USE || ATL_PIB_E42_USE || ATL_PIB_E43_USE || ATL_PIB_E44_USE || ATL_PIB_E45_USE || ATL_PIB_E46_USE || ATL_PIB_E47_USE || ATL_PIB_E48_USE || ATL_PIB_E49_USE || ATL_PIB_E50_USE || ATL_PIB_E51_USE || ATL_PIB_E52_USE || ATL_PIB_E53_USE || ATL_PIB_E54_USE || ATL_PIB_E55_USE || ATL_PIB_E56_USE || ATL_PIB_E57_USE || ATL_PIB_E58_USE || ATL_PIB_E59_USE || ATL_PIB_E60_USE || ATL_PIB_E61_USE || ATL_PIB_E62_USE || ATL_PIB_E63_USE)
  #define ATL_PIC_USED        (ATL_PIC_E0_USE || ATL_PIC_E1_USE || ATL_PIC_E2_USE || ATL_PIC_E3_USE || ATL_PIC_E4_USE || ATL_PIC_E5_USE || ATL_PIC_E6_USE || ATL_PIC_E7_USE || ATL_PIC_E8_USE || ATL_PIC_E9_USE || ATL_PIC_E10_USE || ATL_PIC_E11_USE || ATL_PIC_E12_USE || ATL_PIC_E13_USE || ATL_PIC_E14_USE || ATL_PIC_E15_USE || ATL_PIC_E16_USE || ATL_PIC_E17_USE || ATL_PIC_E18_USE || ATL_PIC_E19_USE || ATL_PIC_E20_USE || ATL_PIC_E21_USE || ATL_PIC_E22_USE || ATL_PIC_E23_USE || ATL_PIC_E24_USE || ATL_PIC_E25_USE || ATL_PIC_E26_USE || ATL_PIC_E27_USE || ATL_PIC_E28_USE || ATL_PIC_E29_USE || ATL_PIC_E30_USE || ATL_PIC_E31_USE || ATL_PIC_E32_USE || ATL_PIC_E33_USE || ATL_PIC_E34_USE || ATL_PIC_E35_USE || ATL_PIC_E36_USE || ATL_PIC_E37_USE || ATL_PIC_E38_USE || ATL_PIC_E39_USE || ATL_PIC_E40_USE || ATL_PIC_E41_USE || ATL_PIC_E42_USE || ATL_PIC_E43_USE || ATL_PIC_E44_USE || ATL_PIC_E45_USE || ATL_PIC_E46_USE || ATL_PIC_E47_USE || ATL_PIC_E48_USE || ATL_PIC_E49_USE || ATL_PIC_E50_USE || ATL_PIC_E51_USE || ATL_PIC_E52_USE || ATL_PIC_E53_USE || ATL_PIC_E54_USE || ATL_PIC_E55_USE || ATL_PIC_E56_USE || ATL_PIC_E57_USE || ATL_PIC_E58_USE || ATL_PIC_E59_USE || ATL_PIC_E60_USE || ATL_PIC_E61_USE || ATL_PIC_E62_USE || ATL_PIC_E63_USE)
  #define ATL_PID_USED        (ATL_PID_E0_USE || ATL_PID_E1_USE || ATL_PID_E2_USE || ATL_PID_E3_USE || ATL_PID_E4_USE || ATL_PID_E5_USE || ATL_PID_E6_USE || ATL_PID_E7_USE || ATL_PID_E8_USE || ATL_PID_E9_USE || ATL_PID_E10_USE || ATL_PID_E11_USE || ATL_PID_E12_USE || ATL_PID_E13_USE || ATL_PID_E14_USE || ATL_PID_E15_USE || ATL_PID_E16_USE || ATL_PID_E17_USE || ATL_PID_E18_USE || ATL_PID_E19_USE || ATL_PID_E20_USE || ATL_PID_E21_USE || ATL_PID_E22_USE || ATL_PID_E23_USE || ATL_PID_E24_USE || ATL_PID_E25_USE || ATL_PID_E26_USE || ATL_PID_E27_USE || ATL_PID_E28_USE || ATL_PID_E29_USE || ATL_PID_E30_USE || ATL_PID_E31_USE || ATL_PID_E32_USE || ATL_PID_E33_USE || ATL_PID_E34_USE || ATL_PID_E35_USE || ATL_PID_E36_USE || ATL_PID_E37_USE || ATL_PID_E38_USE || ATL_PID_E39_USE || ATL_PID_E40_USE || ATL_PID_E41_USE || ATL_PID_E42_USE || ATL_PID_E43_USE || ATL_PID_E44_USE || ATL_PID_E45_USE || ATL_PID_E46_USE || ATL_PID_E47_USE || ATL_PID_E48_USE || ATL_PID_E49_USE || ATL_PID_E50_USE || ATL_PID_E51_USE || ATL_PID_E52_USE || ATL_PID_E53_USE || ATL_PID_E54_USE || ATL_PID_E55_USE || ATL_PID_E56_USE || ATL_PID_E57_USE || ATL_PID_E58_USE || ATL_PID_E59_USE || ATL_PID_E60_USE || ATL_PID_E61_USE || ATL_PID_E62_USE || ATL_PID_E63_USE)
  #define ATL_PIJ_USED        (ATL_PIJ_E0_USE || ATL_PIJ_E1_USE || ATL_PIJ_E2_USE || ATL_PIJ_E3_USE || ATL_PIJ_E4_USE || ATL_PIJ_E5_USE || ATL_PIJ_E6_USE || ATL_PIJ_E7_USE || ATL_PIJ_E8_USE || ATL_PIJ_E9_USE || ATL_PIJ_E10_USE || ATL_PIJ_E11_USE || ATL_PIJ_E12_USE || ATL_PIJ_E13_USE || ATL_PIJ_E14_USE || ATL_PIJ_E15_USE || ATL_PIJ_E16_USE || ATL_PIJ_E17_USE || ATL_PIJ_E18_USE || ATL_PIJ_E19_USE || ATL_PIJ_E20_USE || ATL_PIJ_E21_USE || ATL_PIJ_E22_USE || ATL_PIJ_E23_USE || ATL_PIJ_E24_USE || ATL_PIJ_E25_USE || ATL_PIJ_E26_USE || ATL_PIJ_E27_USE || ATL_PIJ_E28_USE || ATL_PIJ_E29_USE || ATL_PIJ_E30_USE || ATL_PIJ_E31_USE || ATL_PIJ_E32_USE || ATL_PIJ_E33_USE || ATL_PIJ_E34_USE || ATL_PIJ_E35_USE || ATL_PIJ_E36_USE || ATL_PIJ_E37_USE || ATL_PIJ_E38_USE || ATL_PIJ_E39_USE || ATL_PIJ_E40_USE || ATL_PIJ_E41_USE || ATL_PIJ_E42_USE || ATL_PIJ_E43_USE || ATL_PIJ_E44_USE || ATL_PIJ_E45_USE || ATL_PIJ_E46_USE || ATL_PIJ_E47_USE || ATL_PIJ_E48_USE || ATL_PIJ_E49_USE || ATL_PIJ_E50_USE || ATL_PIJ_E51_USE || ATL_PIJ_E52_USE || ATL_PIJ_E53_USE || ATL_PIJ_E54_USE || ATL_PIJ_E55_USE || ATL_PIJ_E56_USE || ATL_PIJ_E57_USE || ATL_PIJ_E58_USE || ATL_PIJ_E59_USE || ATL_PIJ_E60_USE || ATL_PIJ_E61_USE || ATL_PIJ_E62_USE || ATL_PIJ_E63_USE) 

  /* Special MCU exceptions solving */
  #if ATL_PIA_USED
    #ifndef VectorNumber_Vporta  
      #define VectorNumber_Vporta           VectorNumber_Vport
    #endif
  #endif

  #if ATL_PIB_USED
    #ifndef VectorNumber_Vportb  
      #define VectorNumber_Vportb           VectorNumber_Vport
    #endif
  #endif

  #if ATL_PIC_USED
    #ifndef VectorNumber_Vportc  
      #define VectorNumber_Vportc           VectorNumber_Vport
    #endif
  #endif
  /* DZ60 exception */
  #if ATL_PID_USED
    #ifndef VectorNumber_Vportd  
      #define VectorNumber_Vportd           VectorNumber_Vport
    #endif
  #endif

  #if ATL_PIJ_USED
    #ifndef VectorNumber_Vportj  
      #define VectorNumber_Vportj           VectorNumber_Vport
    #endif
  #endif

  /***************************************************************************
  * The section below is related with TPM/FTM Input Capture Method 
  * 
  ***************************************************************************/

  /* Timer name convert macros */
  #define ATL_IC_TIMER_TO_SC(reg)           reg##SC
  #define ATL_GET_IC_TIMER_SC(name)         ATL_IC_TIMER_TO_SC(name)

  /* Addresses of all the configuration timer registers */
  #define ATL_IC_TIMER_ADDRESS(x)           &ATL_GET_IC_TIMER_SC(x)  /* The address of the timer is assigned by the compiler */

  /* TPM/FTM configuration values */
  #define ATL_IC_TIMER_PRESCALE_MASK        0x07U
  #define ATL_IC_TIMER_IE                   0x40U
  #define ATL_IC_TIMER_FLAG                 0x80U
  #define ATL_IC_TIMER_ON                   0x08U
  #define ATL_IC_TIMER_OFF                  0xE7U
  #define ATL_IC_TIMER_FLAG_ACK             0x7FU

  #define ATL_IC_TIMER_SC(x)                *(volatile UINT8  *)(ATL_IC_TIMER_ADDRESS(x)+0) 
  #define ATL_IC_TIMER_CNT(x)               *(volatile UINT16 *)(ATL_IC_TIMER_ADDRESS(x)+1)
  #define ATL_IC_TIMER_CNTH(x)              *(volatile UINT8  *)(ATL_IC_TIMER_ADDRESS(x)+1)
  #define ATL_IC_TIMER_CNTL(x)              *(volatile UINT8  *)(ATL_IC_TIMER_ADDRESS(x)+2)
  #define ATL_IC_TIMER_MOD(x)               *(volatile UINT16 *)(ATL_IC_TIMER_ADDRESS(x)+3)
  #define ATL_IC_TIMER_MODH(x)              *(volatile UINT8  *)(ATL_IC_TIMER_ADDRESS(x)+3)
  #define ATL_IC_TIMER_MODL(x)              *(volatile UINT16 *)(ATL_IC_TIMER_ADDRESS(x)+4)

  /*******************************************************
   *********** TPM/FTM Channel related Macros ************
   *******************************************************/
  
  #define ATL_IC_TIMER_SET_PRESCALE(x,y)    (ATL_IC_TIMER_SC(x) = (UINT8)((ATL_IC_TIMER_SC(x) & (~ATL_IC_TIMER_PRESCALE_MASK)) | (y)))   /*Changed due to MISRA*/
  #define ATL_IC_TIMER_ENABLE_INT(x)        (ATL_IC_TIMER_SC(x) |= ATL_IC_TIMER_IE)
  #define ATL_IC_TIMER_DISABLE_INT(x)       ATL_IC_TIMER_SC(x) &= !ATL_IC_TIMER_IE
  #define ATL_IC_TIMER_SET_MOD(x,y)         (ATL_IC_TIMER_MOD(x) = y)
  #define ATL_IC_TIMER_GET_MOD(x)           ATL_IC_TIMER_MOD(x)
  #define ATL_IC_TIMER_START(x)             (ATL_IC_TIMER_SC(x) |= ATL_IC_TIMER_ON)
  #define ATL_IC_TIMER_STOP(x)              (ATL_IC_TIMER_SC(x) &= ATL_IC_TIMER_OFF)
  #define ATL_IC_TIMER_RESET(x)             (ATL_IC_TIMER_CNT(x) = 0x0000U)
  #define ATL_IC_TIMER_GET_LOWCNT(x)        ATL_IC_TIMER_CNTL(x)             
  #define ATL_IC_TIMER_GET_HICNT(x)         ATL_IC_TIMER_CNTH(x)             
  #define ATL_IC_TIMER_GET_CNT(x)           ATL_IC_TIMER_CNT(x)

  #define ATL_IC_TIMER_CLEARFLAG(x)         ATL_IC_TIMER_SC(x) &= ATL_IC_TIMER_FLAG_ACK;
  #define ATL_IC_TIMER_OVF_FLAG(x)          (ATL_IC_TIMER_SC(x) & ATL_IC_TIMER_FLAG)
  #define ATL_IC_TIMER_RUNS(x)              (ATL_IC_TIMER_SC(x) & ATL_IC_TIMER_ON)
  
  /* TPM/FTM Timer Name Recognition */

  #define ATL_TPMCH0_IC_TIMER_NAME          TPM
  #define ATL_TPMCH1_IC_TIMER_NAME          TPM   
  #define ATL_TPMCH2_IC_TIMER_NAME          TPM
  #define ATL_TPMCH3_IC_TIMER_NAME          TPM
  #define ATL_TPMCH4_IC_TIMER_NAME          TPM
  #define ATL_TPMCH5_IC_TIMER_NAME          TPM
  #define ATL_TPMCH6_IC_TIMER_NAME          TPM
  #define ATL_TPMCH7_IC_TIMER_NAME          TPM
 
  #define ATL_TPM1CH0_IC_TIMER_NAME         TPM1
  #define ATL_TPM1CH1_IC_TIMER_NAME         TPM1   
  #define ATL_TPM1CH2_IC_TIMER_NAME         TPM1
  #define ATL_TPM1CH3_IC_TIMER_NAME         TPM1
  #define ATL_TPM1CH4_IC_TIMER_NAME         TPM1
  #define ATL_TPM1CH5_IC_TIMER_NAME         TPM1
  #define ATL_TPM1CH6_IC_TIMER_NAME         TPM1
  #define ATL_TPM1CH7_IC_TIMER_NAME         TPM1
  
  #define ATL_TPM2CH0_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH1_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH2_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH3_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH4_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH5_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH6_IC_TIMER_NAME         TPM2
  #define ATL_TPM2CH7_IC_TIMER_NAME         TPM2
  
  #define ATL_TPM3CH0_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH1_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH2_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH3_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH4_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH5_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH6_IC_TIMER_NAME         TPM3
  #define ATL_TPM3CH7_IC_TIMER_NAME         TPM3
  
  #define ATL_TPM4CH0_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH1_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH2_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH3_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH4_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH5_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH6_IC_TIMER_NAME         TPM4
  #define ATL_TPM4CH7_IC_TIMER_NAME         TPM4
  
  #define ATL_FTMCH0_IC_TIMER_NAME          FTM
  #define ATL_FTMCH1_IC_TIMER_NAME          FTM   
  #define ATL_FTMCH2_IC_TIMER_NAME          FTM
  #define ATL_FTMCH3_IC_TIMER_NAME          FTM
  #define ATL_FTMCH4_IC_TIMER_NAME          FTM
  #define ATL_FTMCH5_IC_TIMER_NAME          FTM
  #define ATL_FTMCH6_IC_TIMER_NAME          FTM
  #define ATL_FTMCH7_IC_TIMER_NAME          FTM
 
  #define ATL_FTM1CH0_IC_TIMER_NAME         FTM1
  #define ATL_FTM1CH1_IC_TIMER_NAME         FTM1   
  #define ATL_FTM1CH2_IC_TIMER_NAME         FTM1
  #define ATL_FTM1CH3_IC_TIMER_NAME         FTM1
  #define ATL_FTM1CH4_IC_TIMER_NAME         FTM1
  #define ATL_FTM1CH5_IC_TIMER_NAME         FTM1
  #define ATL_FTM1CH6_IC_TIMER_NAME         FTM1
  #define ATL_FTM1CH7_IC_TIMER_NAME         FTM1
  
  #define ATL_FTM2CH0_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH1_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH2_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH3_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH4_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH5_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH6_IC_TIMER_NAME         FTM2
  #define ATL_FTM2CH7_IC_TIMER_NAME         FTM2
  
  #define ATL_FTM3CH0_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH1_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH2_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH3_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH4_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH5_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH6_IC_TIMER_NAME         FTM3
  #define ATL_FTM3CH7_IC_TIMER_NAME         FTM3
  
  #define ATL_FTM4CH0_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH1_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH2_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH3_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH4_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH5_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH6_IC_TIMER_NAME         FTM4
  #define ATL_FTM4CH7_IC_TIMER_NAME         FTM4
  

  #define ATL_IC_TIMER_NUM_RESULT(res)      ATL_##res##_IC_TIMER_NAME
  #define ATL_IC_TIMER_NUM_CONV(text)       ATL_IC_TIMER_NUM_RESULT(text)
  #define ATL_IC_TIMER_NUM(elec)            ATL_IC_TIMER_NUM_CONV(elec)


  /* TPM/FTM Channel Control Macros */
  #define ATL_TPMCH0SC                      TPMC0SC      
  #define ATL_TPMCH1SC                      TPMC1SC      
  #define ATL_TPMCH2SC                      TPMC2SC      
  #define ATL_TPMCH3SC                      TPMC3SC      
  #define ATL_TPMCH4SC                      TPMC4SC      
  #define ATL_TPMCH5SC                      TPMC5SC      
  #define ATL_TPMCH6SC                      TPMC6SC      
  #define ATL_TPMCH7SC                      TPMC7SC      

  #define ATL_TPM1CH0SC                     TPM1C0SC      
  #define ATL_TPM1CH1SC                     TPM1C1SC      
  #define ATL_TPM1CH2SC                     TPM1C2SC      
  #define ATL_TPM1CH3SC                     TPM1C3SC      
  #define ATL_TPM1CH4SC                     TPM1C4SC      
  #define ATL_TPM1CH5SC                     TPM1C5SC      
  #define ATL_TPM1CH6SC                     TPM1C6SC      
  #define ATL_TPM1CH7SC                     TPM1C7SC      
  
  #define ATL_TPM2CH0SC                     TPM2C0SC      
  #define ATL_TPM2CH1SC                     TPM2C1SC      
  #define ATL_TPM2CH2SC                     TPM2C2SC      
  #define ATL_TPM2CH3SC                     TPM2C3SC      
  #define ATL_TPM2CH4SC                     TPM2C4SC      
  #define ATL_TPM2CH5SC                     TPM2C5SC      
  #define ATL_TPM2CH6SC                     TPM2C6SC      
  #define ATL_TPM2CH7SC                     TPM2C7SC    
  
  #define ATL_TPM3CH0SC                     TPM3C0SC      
  #define ATL_TPM3CH1SC                     TPM3C1SC      
  #define ATL_TPM3CH2SC                     TPM3C2SC      
  #define ATL_TPM3CH3SC                     TPM3C3SC      
  #define ATL_TPM3CH4SC                     TPM3C4SC      
  #define ATL_TPM3CH5SC                     TPM3C5SC      
  #define ATL_TPM3CH6SC                     TPM3C6SC      
  #define ATL_TPM3CH7SC                     TPM3C7SC  
  
  #define ATL_TPM4CH0SC                     TPM4C0SC      
  #define ATL_TPM4CH1SC                     TPM4C1SC      
  #define ATL_TPM4CH2SC                     TPM4C2SC      
  #define ATL_TPM4CH3SC                     TPM4C3SC      
  #define ATL_TPM4CH4SC                     TPM4C4SC      
  #define ATL_TPM4CH5SC                     TPM4C5SC      
  #define ATL_TPM4CH6SC                     TPM4C6SC      
  #define ATL_TPM4CH7SC                     TPM4C7SC
  
  #define ATL_FTMCH0SC                      FTMC0SC      
  #define ATL_FTMCH1SC                      FTMC1SC      
  #define ATL_FTMCH2SC                      FTMC2SC      
  #define ATL_FTMCH3SC                      FTMC3SC      
  #define ATL_FTMCH4SC                      FTMC4SC      
  #define ATL_FTMCH5SC                      FTMC5SC      
  #define ATL_FTMCH6SC                      FTMC6SC      
  #define ATL_FTMCH7SC                      FTMC7SC      

  #define ATL_FTM1CH0SC                     FTM1C0SC      
  #define ATL_FTM1CH1SC                     FTM1C1SC      
  #define ATL_FTM1CH2SC                     FTM1C2SC      
  #define ATL_FTM1CH3SC                     FTM1C3SC      
  #define ATL_FTM1CH4SC                     FTM1C4SC      
  #define ATL_FTM1CH5SC                     FTM1C5SC      
  #define ATL_FTM1CH6SC                     FTM1C6SC      
  #define ATL_FTM1CH7SC                     FTM1C7SC      
  
  #define ATL_FTM2CH0SC                     FTM2C0SC      
  #define ATL_FTM2CH1SC                     FTM2C1SC      
  #define ATL_FTM2CH2SC                     FTM2C2SC      
  #define ATL_FTM2CH3SC                     FTM2C3SC      
  #define ATL_FTM2CH4SC                     FTM2C4SC      
  #define ATL_FTM2CH5SC                     FTM2C5SC      
  #define ATL_FTM2CH6SC                     FTM2C6SC      
  #define ATL_FTM2CH7SC                     FTM2C7SC    
  
  #define ATL_FTM3CH0SC                     FTM3C0SC      
  #define ATL_FTM3CH1SC                     FTM3C1SC      
  #define ATL_FTM3CH2SC                     FTM3C2SC      
  #define ATL_FTM3CH3SC                     FTM3C3SC      
  #define ATL_FTM3CH4SC                     FTM3C4SC      
  #define ATL_FTM3CH5SC                     FTM3C5SC      
  #define ATL_FTM3CH6SC                     FTM3C6SC      
  #define ATL_FTM3CH7SC                     FTM3C7SC  
  
  #define ATL_FTM4CH0SC                     FTM4C0SC      
  #define ATL_FTM4CH1SC                     FTM4C1SC      
  #define ATL_FTM4CH2SC                     FTM4C2SC      
  #define ATL_FTM4CH3SC                     FTM4C3SC      
  #define ATL_FTM4CH4SC                     FTM4C4SC      
  #define ATL_FTM4CH5SC                     FTM4C5SC      
  #define ATL_FTM4CH6SC                     FTM4C6SC      
  #define ATL_FTM4CH7SC                     FTM4C7SC

     
  #define ATL_IC_TIMER_TO_CH_SC(reg)        ATL_##reg##SC
  #define ATL_GET_IC_TIMER_CH_SC(name)      ATL_IC_TIMER_TO_CH_SC(name)

  #define ATL_IC_TIMER_CH_ICM_EN            0x04
  #define ATL_IC_TIMER_CH_FLAG              0x80
  
  /* TPM Channel Value Read Macros */

  #define ATL_TPMCH0V                       TPMC0V      
  #define ATL_TPMCH1V                       TPMC1V      
  #define ATL_TPMCH2V                       TPMC2V      
  #define ATL_TPMCH3V                       TPMC3V      
  #define ATL_TPMCH4V                       TPMC4V      
  #define ATL_TPMCH5V                       TPMC5V      
  #define ATL_TPMCH6V                       TPMC6V      
  #define ATL_TPMCH7V                       TPMC7V      

  #define ATL_TPM1CH0V                      TPM1C0V      
  #define ATL_TPM1CH1V                      TPM1C1V      
  #define ATL_TPM1CH2V                      TPM1C2V      
  #define ATL_TPM1CH3V                      TPM1C3V      
  #define ATL_TPM1CH4V                      TPM1C4V      
  #define ATL_TPM1CH5V                      TPM1C5V      
  #define ATL_TPM1CH6V                      TPM1C6V      
  #define ATL_TPM1CH7V                      TPM1C7V      
  
  #define ATL_TPM2CH0V                      TPM2C0V      
  #define ATL_TPM2CH1V                      TPM2C1V      
  #define ATL_TPM2CH2V                      TPM2C2V      
  #define ATL_TPM2CH3V                      TPM2C3V      
  #define ATL_TPM2CH4V                      TPM2C4V      
  #define ATL_TPM2CH5V                      TPM2C5V      
  #define ATL_TPM2CH6V                      TPM2C6V      
  #define ATL_TPM2CH7V                      TPM2C7V    
  
  #define ATL_TPM3CH0V                      TPM3C0V      
  #define ATL_TPM3CH1V                      TPM3C1V      
  #define ATL_TPM3CH2V                      TPM3C2V      
  #define ATL_TPM3CH3V                      TPM3C3V      
  #define ATL_TPM3CH4V                      TPM3C4V      
  #define ATL_TPM3CH5V                      TPM3C5V      
  #define ATL_TPM3CH6V                      TPM3C6V      
  #define ATL_TPM3CH7V                      TPM3C7V    
  
  #define ATL_TPM4CH0V                      TPM4C0V      
  #define ATL_TPM4CH1V                      TPM4C1V      
  #define ATL_TPM4CH2V                      TPM4C2V      
  #define ATL_TPM4CH3V                      TPM4C3V      
  #define ATL_TPM4CH4V                      TPM4C4V      
  #define ATL_TPM4CH5V                      TPM4C5V      
  #define ATL_TPM4CH6V                      TPM4C6V      
  #define ATL_TPM4CH7V                      TPM4C7V  
  
  #define ATL_FTMCH0V                       FTMC0V     
  #define ATL_FTMCH1V                       FTMC1V     
  #define ATL_FTMCH2V                       FTMC2V     
  #define ATL_FTMCH3V                       FTMC3V     
  #define ATL_FTMCH4V                       FTMC4V     
  #define ATL_FTMCH5V                       FTMC5V     
  #define ATL_FTMCH6V                       FTMC6V     
  #define ATL_FTMCH7V                       FTMC7V     

  #define ATL_FTM1CH0V                      FTM1C0V      
  #define ATL_FTM1CH1V                      FTM1C1V      
  #define ATL_FTM1CH2V                      FTM1C2V      
  #define ATL_FTM1CH3V                      FTM1C3V      
  #define ATL_FTM1CH4V                      FTM1C4V      
  #define ATL_FTM1CH5V                      FTM1C5V      
  #define ATL_FTM1CH6V                      FTM1C6V      
  #define ATL_FTM1CH7V                      FTM1C7V      
  
  #define ATL_FTM2CH0V                      FTM2C0V      
  #define ATL_FTM2CH1V                      FTM2C1V      
  #define ATL_FTM2CH2V                      FTM2C2V      
  #define ATL_FTM2CH3V                      FTM2C3V      
  #define ATL_FTM2CH4V                      FTM2C4V      
  #define ATL_FTM2CH5V                      FTM2C5V      
  #define ATL_FTM2CH6V                      FTM2C6V      
  #define ATL_FTM2CH7V                      FTM2C7V    
  
  #define ATL_FTM3CH0V                      FTM3C0V      
  #define ATL_FTM3CH1V                      FTM3C1V      
  #define ATL_FTM3CH2V                      FTM3C2V      
  #define ATL_FTM3CH3V                      FTM3C3V      
  #define ATL_FTM3CH4V                      FTM3C4V      
  #define ATL_FTM3CH5V                      FTM3C5V      
  #define ATL_FTM3CH6V                      FTM3C6V      
  #define ATL_FTM3CH7V                      FTM3C7V    
  
  #define ATL_FTM4CH0V                      FTM4C0V      
  #define ATL_FTM4CH1V                      FTM4C1V      
  #define ATL_FTM4CH2V                      FTM4C2V      
  #define ATL_FTM4CH3V                      FTM4C3V      
  #define ATL_FTM4CH4V                      FTM4C4V      
  #define ATL_FTM4CH5V                      FTM4C5V      
  #define ATL_FTM4CH6V                      FTM4C6V      
  #define ATL_FTM4CH7V                      FTM4C7V        
      
    
  #define ATL_IC_TIMER_TO_CH_V(reg)         ATL_##reg##V
  #define ATL_GET_IC_TIMER_CH_V(name)       ATL_IC_TIMER_TO_CH_V(name)

  /* TPM/FTM Timer Control Macros */
  
  #define ATL_IC_TIMER_EL_RESET(el)            ATL_IC_TIMER_RESET(ATL_IC_TIMER_NUM(TSS_##el##_TYPE))
  #define ATL_IC_TIMER_EL_START(el)            ATL_IC_TIMER_START(ATL_IC_TIMER_NUM(TSS_##el##_TYPE))
  #define ATL_IC_TIMER_EL_STOP(el)             ATL_IC_TIMER_STOP(ATL_IC_TIMER_NUM(TSS_##el##_TYPE))
  #define ATL_IC_TIMER_EL_OVF_FLAG(el)         ATL_IC_TIMER_OVF_FLAG(ATL_IC_TIMER_NUM(TSS_##el##_TYPE))
  #define ATL_IC_TIMER_EL_CLEARFLAG(el)        ATL_IC_TIMER_CLEARFLAG(ATL_IC_TIMER_NUM(TSS_##el##_TYPE))
  
  #define ATL_IC_TIMER_EL_CHANNEL_ENABLE(el)   ATL_GET_IC_TIMER_CH_SC(TSS_##el##_TYPE) = ATL_IC_TIMER_CH_ICM_EN
  #define ATL_IC_TIMER_EL_CHANNEL_FLAG(el)     (ATL_GET_IC_TIMER_CH_SC(TSS_##el##_TYPE) & ATL_IC_TIMER_CH_FLAG)
  #define ATL_IC_TIMER_EL_CHANNEL_DISABLE(el)  ATL_GET_IC_TIMER_CH_SC(TSS_##el##_TYPE) = 0x00
  #define ATL_IC_TIMER_EL_CHANNEL_V(el)        ATL_GET_IC_TIMER_CH_V(TSS_##el##_TYPE)

  /* Input Capture Electrode type detection */
  #define ATL_TPMIC_E0_USE         (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E0_USE         (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E0_USE        (ATL_ELEC_TYPE_CHK(TSS_E0_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E1_USE         (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E1_USE         (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E1_USE        (ATL_ELEC_TYPE_CHK(TSS_E1_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E2_USE         (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E2_USE         (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E2_USE        (ATL_ELEC_TYPE_CHK(TSS_E2_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E3_USE         (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E3_USE         (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E3_USE        (ATL_ELEC_TYPE_CHK(TSS_E3_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E4_USE         (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E4_USE         (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E4_USE        (ATL_ELEC_TYPE_CHK(TSS_E4_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E5_USE         (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E5_USE         (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E5_USE        (ATL_ELEC_TYPE_CHK(TSS_E5_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E6_USE         (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E6_USE         (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E6_USE        (ATL_ELEC_TYPE_CHK(TSS_E6_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E7_USE         (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E7_USE         (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E7_USE        (ATL_ELEC_TYPE_CHK(TSS_E7_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E8_USE         (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E8_USE         (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E8_USE        (ATL_ELEC_TYPE_CHK(TSS_E8_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E9_USE         (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E9_USE         (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E9_USE        (ATL_ELEC_TYPE_CHK(TSS_E9_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E10_USE         (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E10_USE         (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E10_USE        (ATL_ELEC_TYPE_CHK(TSS_E10_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E11_USE         (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E11_USE         (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E11_USE        (ATL_ELEC_TYPE_CHK(TSS_E11_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E12_USE         (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E12_USE         (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E12_USE        (ATL_ELEC_TYPE_CHK(TSS_E12_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E13_USE         (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E13_USE         (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E13_USE        (ATL_ELEC_TYPE_CHK(TSS_E13_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E14_USE         (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E14_USE         (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E14_USE        (ATL_ELEC_TYPE_CHK(TSS_E14_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E15_USE         (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E15_USE         (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E15_USE        (ATL_ELEC_TYPE_CHK(TSS_E15_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E16_USE         (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E16_USE         (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E16_USE        (ATL_ELEC_TYPE_CHK(TSS_E16_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E17_USE         (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E17_USE         (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E17_USE        (ATL_ELEC_TYPE_CHK(TSS_E17_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E18_USE         (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E18_USE         (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E18_USE        (ATL_ELEC_TYPE_CHK(TSS_E18_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E19_USE         (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E19_USE         (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E19_USE        (ATL_ELEC_TYPE_CHK(TSS_E19_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E20_USE         (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E20_USE         (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E20_USE        (ATL_ELEC_TYPE_CHK(TSS_E20_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E21_USE         (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E21_USE         (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E21_USE        (ATL_ELEC_TYPE_CHK(TSS_E21_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E22_USE         (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E22_USE         (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E22_USE        (ATL_ELEC_TYPE_CHK(TSS_E22_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E23_USE         (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E23_USE         (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E23_USE        (ATL_ELEC_TYPE_CHK(TSS_E23_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E24_USE         (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E24_USE         (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E24_USE        (ATL_ELEC_TYPE_CHK(TSS_E24_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E25_USE         (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E25_USE         (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E25_USE        (ATL_ELEC_TYPE_CHK(TSS_E25_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E26_USE         (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E26_USE         (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E26_USE        (ATL_ELEC_TYPE_CHK(TSS_E26_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E27_USE         (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E27_USE         (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E27_USE        (ATL_ELEC_TYPE_CHK(TSS_E27_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E28_USE         (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E28_USE         (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E28_USE        (ATL_ELEC_TYPE_CHK(TSS_E28_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E29_USE         (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E29_USE         (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E29_USE        (ATL_ELEC_TYPE_CHK(TSS_E29_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E30_USE         (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E30_USE         (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E30_USE        (ATL_ELEC_TYPE_CHK(TSS_E30_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E31_USE         (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E31_USE         (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E31_USE        (ATL_ELEC_TYPE_CHK(TSS_E31_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E32_USE         (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E32_USE         (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E32_USE        (ATL_ELEC_TYPE_CHK(TSS_E32_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E33_USE         (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E33_USE         (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E33_USE        (ATL_ELEC_TYPE_CHK(TSS_E33_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E34_USE         (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E34_USE         (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E34_USE        (ATL_ELEC_TYPE_CHK(TSS_E34_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E35_USE         (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E35_USE         (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E35_USE        (ATL_ELEC_TYPE_CHK(TSS_E35_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E36_USE         (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E36_USE         (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E36_USE        (ATL_ELEC_TYPE_CHK(TSS_E36_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E37_USE         (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E37_USE         (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E37_USE        (ATL_ELEC_TYPE_CHK(TSS_E37_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E38_USE         (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E38_USE         (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E38_USE        (ATL_ELEC_TYPE_CHK(TSS_E38_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E39_USE         (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E39_USE         (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E39_USE        (ATL_ELEC_TYPE_CHK(TSS_E39_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E40_USE         (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E40_USE         (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E40_USE        (ATL_ELEC_TYPE_CHK(TSS_E40_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E41_USE         (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E41_USE         (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E41_USE        (ATL_ELEC_TYPE_CHK(TSS_E41_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E42_USE         (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E42_USE         (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E42_USE        (ATL_ELEC_TYPE_CHK(TSS_E42_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E43_USE         (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E43_USE         (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E43_USE        (ATL_ELEC_TYPE_CHK(TSS_E43_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E44_USE         (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E44_USE         (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E44_USE        (ATL_ELEC_TYPE_CHK(TSS_E44_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E45_USE         (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E45_USE         (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E45_USE        (ATL_ELEC_TYPE_CHK(TSS_E45_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E46_USE         (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E46_USE         (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E46_USE        (ATL_ELEC_TYPE_CHK(TSS_E46_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E47_USE         (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E47_USE         (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E47_USE        (ATL_ELEC_TYPE_CHK(TSS_E47_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E48_USE         (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E48_USE         (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E48_USE        (ATL_ELEC_TYPE_CHK(TSS_E48_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E49_USE         (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E49_USE         (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E49_USE        (ATL_ELEC_TYPE_CHK(TSS_E49_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E50_USE         (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E50_USE         (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E50_USE        (ATL_ELEC_TYPE_CHK(TSS_E50_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E51_USE         (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E51_USE         (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E51_USE        (ATL_ELEC_TYPE_CHK(TSS_E51_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E52_USE         (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E52_USE         (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E52_USE        (ATL_ELEC_TYPE_CHK(TSS_E52_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E53_USE         (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E53_USE         (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E53_USE        (ATL_ELEC_TYPE_CHK(TSS_E53_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E54_USE         (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E54_USE         (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E54_USE        (ATL_ELEC_TYPE_CHK(TSS_E54_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E55_USE         (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E55_USE         (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E55_USE        (ATL_ELEC_TYPE_CHK(TSS_E55_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E56_USE         (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E56_USE         (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E56_USE        (ATL_ELEC_TYPE_CHK(TSS_E56_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E57_USE         (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E57_USE         (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E57_USE        (ATL_ELEC_TYPE_CHK(TSS_E57_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E58_USE         (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E58_USE         (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E58_USE        (ATL_ELEC_TYPE_CHK(TSS_E58_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E59_USE         (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E59_USE         (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E59_USE        (ATL_ELEC_TYPE_CHK(TSS_E59_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E60_USE         (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E60_USE         (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E60_USE        (ATL_ELEC_TYPE_CHK(TSS_E60_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E61_USE         (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E61_USE         (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E61_USE        (ATL_ELEC_TYPE_CHK(TSS_E61_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E62_USE         (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E62_USE         (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E62_USE        (ATL_ELEC_TYPE_CHK(TSS_E62_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMIC_E63_USE         (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_TPMICM_CHK)
  #define ATL_TPM1IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_TPM1ICM_CHK)
  #define ATL_TPM2IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_TPM2ICM_CHK)
  #define ATL_TPM3IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_TPM3ICM_CHK)
  #define ATL_TPM4IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_TPM4ICM_CHK)
  #define ATL_FTMIC_E63_USE         (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_FTMICM_CHK)
  #define ATL_FTM1IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_FTM1ICM_CHK)
  #define ATL_FTM2IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_FTM2ICM_CHK)
  #define ATL_FTM3IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_FTM3ICM_CHK)
  #define ATL_FTM4IC_E63_USE        (ATL_ELEC_TYPE_CHK(TSS_E63_TYPE) == ATL_FTM4ICM_CHK)

  #define ATL_TPMICM_USED         (ATL_TPMIC_E0_USE || ATL_TPMIC_E1_USE || ATL_TPMIC_E2_USE || ATL_TPMIC_E3_USE || ATL_TPMIC_E4_USE || ATL_TPMIC_E5_USE || ATL_TPMIC_E6_USE || ATL_TPMIC_E7_USE || ATL_TPMIC_E8_USE || ATL_TPMIC_E9_USE || ATL_TPMIC_E10_USE || ATL_TPMIC_E11_USE || ATL_TPMIC_E12_USE || ATL_TPMIC_E13_USE || ATL_TPMIC_E14_USE || ATL_TPMIC_E15_USE || ATL_TPMIC_E16_USE || ATL_TPMIC_E17_USE || ATL_TPMIC_E18_USE || ATL_TPMIC_E19_USE || ATL_TPMIC_E20_USE || ATL_TPMIC_E21_USE || ATL_TPMIC_E22_USE || ATL_TPMIC_E23_USE || ATL_TPMIC_E24_USE || ATL_TPMIC_E25_USE || ATL_TPMIC_E26_USE || ATL_TPMIC_E27_USE || ATL_TPMIC_E28_USE || ATL_TPMIC_E29_USE || ATL_TPMIC_E30_USE || ATL_TPMIC_E31_USE || ATL_TPMIC_E32_USE || ATL_TPMIC_E33_USE || ATL_TPMIC_E34_USE || ATL_TPMIC_E35_USE || ATL_TPMIC_E36_USE || ATL_TPMIC_E37_USE || ATL_TPMIC_E38_USE || ATL_TPMIC_E39_USE || ATL_TPMIC_E40_USE || ATL_TPMIC_E41_USE || ATL_TPMIC_E42_USE || ATL_TPMIC_E43_USE || ATL_TPMIC_E44_USE || ATL_TPMIC_E45_USE || ATL_TPMIC_E46_USE || ATL_TPMIC_E47_USE || ATL_TPMIC_E48_USE || ATL_TPMIC_E49_USE || ATL_TPMIC_E50_USE || ATL_TPMIC_E51_USE || ATL_TPMIC_E52_USE || ATL_TPMIC_E53_USE || ATL_TPMIC_E54_USE || ATL_TPMIC_E55_USE || ATL_TPMIC_E56_USE || ATL_TPMIC_E57_USE || ATL_TPMIC_E58_USE || ATL_TPMIC_E59_USE || ATL_TPMIC_E60_USE || ATL_TPMIC_E61_USE || ATL_TPMIC_E62_USE || ATL_TPMIC_E63_USE)
  #define ATL_TPM1ICM_USED        (ATL_TPM1IC_E0_USE || ATL_TPM1IC_E1_USE || ATL_TPM1IC_E2_USE || ATL_TPM1IC_E3_USE || ATL_TPM1IC_E4_USE || ATL_TPM1IC_E5_USE || ATL_TPM1IC_E6_USE || ATL_TPM1IC_E7_USE || ATL_TPM1IC_E8_USE || ATL_TPM1IC_E9_USE || ATL_TPM1IC_E10_USE || ATL_TPM1IC_E11_USE || ATL_TPM1IC_E12_USE || ATL_TPM1IC_E13_USE || ATL_TPM1IC_E14_USE || ATL_TPM1IC_E15_USE || ATL_TPM1IC_E16_USE || ATL_TPM1IC_E17_USE || ATL_TPM1IC_E18_USE || ATL_TPM1IC_E19_USE || ATL_TPM1IC_E20_USE || ATL_TPM1IC_E21_USE || ATL_TPM1IC_E22_USE || ATL_TPM1IC_E23_USE || ATL_TPM1IC_E24_USE || ATL_TPM1IC_E25_USE || ATL_TPM1IC_E26_USE || ATL_TPM1IC_E27_USE || ATL_TPM1IC_E28_USE || ATL_TPM1IC_E29_USE || ATL_TPM1IC_E30_USE || ATL_TPM1IC_E31_USE || ATL_TPM1IC_E32_USE || ATL_TPM1IC_E33_USE || ATL_TPM1IC_E34_USE || ATL_TPM1IC_E35_USE || ATL_TPM1IC_E36_USE || ATL_TPM1IC_E37_USE || ATL_TPM1IC_E38_USE || ATL_TPM1IC_E39_USE || ATL_TPM1IC_E40_USE || ATL_TPM1IC_E41_USE || ATL_TPM1IC_E42_USE || ATL_TPM1IC_E43_USE || ATL_TPM1IC_E44_USE || ATL_TPM1IC_E45_USE || ATL_TPM1IC_E46_USE || ATL_TPM1IC_E47_USE || ATL_TPM1IC_E48_USE || ATL_TPM1IC_E49_USE || ATL_TPM1IC_E50_USE || ATL_TPM1IC_E51_USE || ATL_TPM1IC_E52_USE || ATL_TPM1IC_E53_USE || ATL_TPM1IC_E54_USE || ATL_TPM1IC_E55_USE || ATL_TPM1IC_E56_USE || ATL_TPM1IC_E57_USE || ATL_TPM1IC_E58_USE || ATL_TPM1IC_E59_USE || ATL_TPM1IC_E60_USE || ATL_TPM1IC_E61_USE || ATL_TPM1IC_E62_USE || ATL_TPM1IC_E63_USE)
  #define ATL_TPM2ICM_USED        (ATL_TPM2IC_E0_USE || ATL_TPM2IC_E1_USE || ATL_TPM2IC_E2_USE || ATL_TPM2IC_E3_USE || ATL_TPM2IC_E4_USE || ATL_TPM2IC_E5_USE || ATL_TPM2IC_E6_USE || ATL_TPM2IC_E7_USE || ATL_TPM2IC_E8_USE || ATL_TPM2IC_E9_USE || ATL_TPM2IC_E10_USE || ATL_TPM2IC_E11_USE || ATL_TPM2IC_E12_USE || ATL_TPM2IC_E13_USE || ATL_TPM2IC_E14_USE || ATL_TPM2IC_E15_USE || ATL_TPM2IC_E16_USE || ATL_TPM2IC_E17_USE || ATL_TPM2IC_E18_USE || ATL_TPM2IC_E19_USE || ATL_TPM2IC_E20_USE || ATL_TPM2IC_E21_USE || ATL_TPM2IC_E22_USE || ATL_TPM2IC_E23_USE || ATL_TPM2IC_E24_USE || ATL_TPM2IC_E25_USE || ATL_TPM2IC_E26_USE || ATL_TPM2IC_E27_USE || ATL_TPM2IC_E28_USE || ATL_TPM2IC_E29_USE || ATL_TPM2IC_E30_USE || ATL_TPM2IC_E31_USE || ATL_TPM2IC_E32_USE || ATL_TPM2IC_E33_USE || ATL_TPM2IC_E34_USE || ATL_TPM2IC_E35_USE || ATL_TPM2IC_E36_USE || ATL_TPM2IC_E37_USE || ATL_TPM2IC_E38_USE || ATL_TPM2IC_E39_USE || ATL_TPM2IC_E40_USE || ATL_TPM2IC_E41_USE || ATL_TPM2IC_E42_USE || ATL_TPM2IC_E43_USE || ATL_TPM2IC_E44_USE || ATL_TPM2IC_E45_USE || ATL_TPM2IC_E46_USE || ATL_TPM2IC_E47_USE || ATL_TPM2IC_E48_USE || ATL_TPM2IC_E49_USE || ATL_TPM2IC_E50_USE || ATL_TPM2IC_E51_USE || ATL_TPM2IC_E52_USE || ATL_TPM2IC_E53_USE || ATL_TPM2IC_E54_USE || ATL_TPM2IC_E55_USE || ATL_TPM2IC_E56_USE || ATL_TPM2IC_E57_USE || ATL_TPM2IC_E58_USE || ATL_TPM2IC_E59_USE || ATL_TPM2IC_E60_USE || ATL_TPM2IC_E61_USE || ATL_TPM2IC_E62_USE || ATL_TPM2IC_E63_USE)
  #define ATL_TPM3ICM_USED        (ATL_TPM3IC_E0_USE || ATL_TPM3IC_E1_USE || ATL_TPM3IC_E2_USE || ATL_TPM3IC_E3_USE || ATL_TPM3IC_E4_USE || ATL_TPM3IC_E5_USE || ATL_TPM3IC_E6_USE || ATL_TPM3IC_E7_USE || ATL_TPM3IC_E8_USE || ATL_TPM3IC_E9_USE || ATL_TPM3IC_E10_USE || ATL_TPM3IC_E11_USE || ATL_TPM3IC_E12_USE || ATL_TPM3IC_E13_USE || ATL_TPM3IC_E14_USE || ATL_TPM3IC_E15_USE || ATL_TPM3IC_E16_USE || ATL_TPM3IC_E17_USE || ATL_TPM3IC_E18_USE || ATL_TPM3IC_E19_USE || ATL_TPM3IC_E20_USE || ATL_TPM3IC_E21_USE || ATL_TPM3IC_E22_USE || ATL_TPM3IC_E23_USE || ATL_TPM3IC_E24_USE || ATL_TPM3IC_E25_USE || ATL_TPM3IC_E26_USE || ATL_TPM3IC_E27_USE || ATL_TPM3IC_E28_USE || ATL_TPM3IC_E29_USE || ATL_TPM3IC_E30_USE || ATL_TPM3IC_E31_USE || ATL_TPM3IC_E32_USE || ATL_TPM3IC_E33_USE || ATL_TPM3IC_E34_USE || ATL_TPM3IC_E35_USE || ATL_TPM3IC_E36_USE || ATL_TPM3IC_E37_USE || ATL_TPM3IC_E38_USE || ATL_TPM3IC_E39_USE || ATL_TPM3IC_E40_USE || ATL_TPM3IC_E41_USE || ATL_TPM3IC_E42_USE || ATL_TPM3IC_E43_USE || ATL_TPM3IC_E44_USE || ATL_TPM3IC_E45_USE || ATL_TPM3IC_E46_USE || ATL_TPM3IC_E47_USE || ATL_TPM3IC_E48_USE || ATL_TPM3IC_E49_USE || ATL_TPM3IC_E50_USE || ATL_TPM3IC_E51_USE || ATL_TPM3IC_E52_USE || ATL_TPM3IC_E53_USE || ATL_TPM3IC_E54_USE || ATL_TPM3IC_E55_USE || ATL_TPM3IC_E56_USE || ATL_TPM3IC_E57_USE || ATL_TPM3IC_E58_USE || ATL_TPM3IC_E59_USE || ATL_TPM3IC_E60_USE || ATL_TPM3IC_E61_USE || ATL_TPM3IC_E62_USE || ATL_TPM3IC_E63_USE)
  #define ATL_TPM4ICM_USED        (ATL_TPM4IC_E0_USE || ATL_TPM4IC_E1_USE || ATL_TPM4IC_E2_USE || ATL_TPM4IC_E3_USE || ATL_TPM4IC_E4_USE || ATL_TPM4IC_E5_USE || ATL_TPM4IC_E6_USE || ATL_TPM4IC_E7_USE || ATL_TPM4IC_E8_USE || ATL_TPM4IC_E9_USE || ATL_TPM4IC_E10_USE || ATL_TPM4IC_E11_USE || ATL_TPM4IC_E12_USE || ATL_TPM4IC_E13_USE || ATL_TPM4IC_E14_USE || ATL_TPM4IC_E15_USE || ATL_TPM4IC_E16_USE || ATL_TPM4IC_E17_USE || ATL_TPM4IC_E18_USE || ATL_TPM4IC_E19_USE || ATL_TPM4IC_E20_USE || ATL_TPM4IC_E21_USE || ATL_TPM4IC_E22_USE || ATL_TPM4IC_E23_USE || ATL_TPM4IC_E24_USE || ATL_TPM4IC_E25_USE || ATL_TPM4IC_E26_USE || ATL_TPM4IC_E27_USE || ATL_TPM4IC_E28_USE || ATL_TPM4IC_E29_USE || ATL_TPM4IC_E30_USE || ATL_TPM4IC_E31_USE || ATL_TPM4IC_E32_USE || ATL_TPM4IC_E33_USE || ATL_TPM4IC_E34_USE || ATL_TPM4IC_E35_USE || ATL_TPM4IC_E36_USE || ATL_TPM4IC_E37_USE || ATL_TPM4IC_E38_USE || ATL_TPM4IC_E39_USE || ATL_TPM4IC_E40_USE || ATL_TPM4IC_E41_USE || ATL_TPM4IC_E42_USE || ATL_TPM4IC_E43_USE || ATL_TPM4IC_E44_USE || ATL_TPM4IC_E45_USE || ATL_TPM4IC_E46_USE || ATL_TPM4IC_E47_USE || ATL_TPM4IC_E48_USE || ATL_TPM4IC_E49_USE || ATL_TPM4IC_E50_USE || ATL_TPM4IC_E51_USE || ATL_TPM4IC_E52_USE || ATL_TPM4IC_E53_USE || ATL_TPM4IC_E54_USE || ATL_TPM4IC_E55_USE || ATL_TPM4IC_E56_USE || ATL_TPM4IC_E57_USE || ATL_TPM4IC_E58_USE || ATL_TPM4IC_E59_USE || ATL_TPM4IC_E60_USE || ATL_TPM4IC_E61_USE || ATL_TPM4IC_E62_USE || ATL_TPM4IC_E63_USE)
  #define ATL_FTMICM_USED         (ATL_FTMIC_E0_USE || ATL_FTMIC_E1_USE || ATL_FTMIC_E2_USE || ATL_FTMIC_E3_USE || ATL_FTMIC_E4_USE || ATL_FTMIC_E5_USE || ATL_FTMIC_E6_USE || ATL_FTMIC_E7_USE || ATL_FTMIC_E8_USE || ATL_FTMIC_E9_USE || ATL_FTMIC_E10_USE || ATL_FTMIC_E11_USE || ATL_FTMIC_E12_USE || ATL_FTMIC_E13_USE || ATL_FTMIC_E14_USE || ATL_FTMIC_E15_USE || ATL_FTMIC_E16_USE || ATL_FTMIC_E17_USE || ATL_FTMIC_E18_USE || ATL_FTMIC_E19_USE || ATL_FTMIC_E20_USE || ATL_FTMIC_E21_USE || ATL_FTMIC_E22_USE || ATL_FTMIC_E23_USE || ATL_FTMIC_E24_USE || ATL_FTMIC_E25_USE || ATL_FTMIC_E26_USE || ATL_FTMIC_E27_USE || ATL_FTMIC_E28_USE || ATL_FTMIC_E29_USE || ATL_FTMIC_E30_USE || ATL_FTMIC_E31_USE || ATL_FTMIC_E32_USE || ATL_FTMIC_E33_USE || ATL_FTMIC_E34_USE || ATL_FTMIC_E35_USE || ATL_FTMIC_E36_USE || ATL_FTMIC_E37_USE || ATL_FTMIC_E38_USE || ATL_FTMIC_E39_USE || ATL_FTMIC_E40_USE || ATL_FTMIC_E41_USE || ATL_FTMIC_E42_USE || ATL_FTMIC_E43_USE || ATL_FTMIC_E44_USE || ATL_FTMIC_E45_USE || ATL_FTMIC_E46_USE || ATL_FTMIC_E47_USE || ATL_FTMIC_E48_USE || ATL_FTMIC_E49_USE || ATL_FTMIC_E50_USE || ATL_FTMIC_E51_USE || ATL_FTMIC_E52_USE || ATL_FTMIC_E53_USE || ATL_FTMIC_E54_USE || ATL_FTMIC_E55_USE || ATL_FTMIC_E56_USE || ATL_FTMIC_E57_USE || ATL_FTMIC_E58_USE || ATL_FTMIC_E59_USE || ATL_FTMIC_E60_USE || ATL_FTMIC_E61_USE || ATL_FTMIC_E62_USE || ATL_FTMIC_E63_USE)
  #define ATL_FTM1ICM_USED        (ATL_FTM1IC_E0_USE || ATL_FTM1IC_E1_USE || ATL_FTM1IC_E2_USE || ATL_FTM1IC_E3_USE || ATL_FTM1IC_E4_USE || ATL_FTM1IC_E5_USE || ATL_FTM1IC_E6_USE || ATL_FTM1IC_E7_USE || ATL_FTM1IC_E8_USE || ATL_FTM1IC_E9_USE || ATL_FTM1IC_E10_USE || ATL_FTM1IC_E11_USE || ATL_FTM1IC_E12_USE || ATL_FTM1IC_E13_USE || ATL_FTM1IC_E14_USE || ATL_FTM1IC_E15_USE || ATL_FTM1IC_E16_USE || ATL_FTM1IC_E17_USE || ATL_FTM1IC_E18_USE || ATL_FTM1IC_E19_USE || ATL_FTM1IC_E20_USE || ATL_FTM1IC_E21_USE || ATL_FTM1IC_E22_USE || ATL_FTM1IC_E23_USE || ATL_FTM1IC_E24_USE || ATL_FTM1IC_E25_USE || ATL_FTM1IC_E26_USE || ATL_FTM1IC_E27_USE || ATL_FTM1IC_E28_USE || ATL_FTM1IC_E29_USE || ATL_FTM1IC_E30_USE || ATL_FTM1IC_E31_USE || ATL_FTM1IC_E32_USE || ATL_FTM1IC_E33_USE || ATL_FTM1IC_E34_USE || ATL_FTM1IC_E35_USE || ATL_FTM1IC_E36_USE || ATL_FTM1IC_E37_USE || ATL_FTM1IC_E38_USE || ATL_FTM1IC_E39_USE || ATL_FTM1IC_E40_USE || ATL_FTM1IC_E41_USE || ATL_FTM1IC_E42_USE || ATL_FTM1IC_E43_USE || ATL_FTM1IC_E44_USE || ATL_FTM1IC_E45_USE || ATL_FTM1IC_E46_USE || ATL_FTM1IC_E47_USE || ATL_FTM1IC_E48_USE || ATL_FTM1IC_E49_USE || ATL_FTM1IC_E50_USE || ATL_FTM1IC_E51_USE || ATL_FTM1IC_E52_USE || ATL_FTM1IC_E53_USE || ATL_FTM1IC_E54_USE || ATL_FTM1IC_E55_USE || ATL_FTM1IC_E56_USE || ATL_FTM1IC_E57_USE || ATL_FTM1IC_E58_USE || ATL_FTM1IC_E59_USE || ATL_FTM1IC_E60_USE || ATL_FTM1IC_E61_USE || ATL_FTM1IC_E62_USE || ATL_FTM1IC_E63_USE)
  #define ATL_FTM2ICM_USED        (ATL_FTM2IC_E0_USE || ATL_FTM2IC_E1_USE || ATL_FTM2IC_E2_USE || ATL_FTM2IC_E3_USE || ATL_FTM2IC_E4_USE || ATL_FTM2IC_E5_USE || ATL_FTM2IC_E6_USE || ATL_FTM2IC_E7_USE || ATL_FTM2IC_E8_USE || ATL_FTM2IC_E9_USE || ATL_FTM2IC_E10_USE || ATL_FTM2IC_E11_USE || ATL_FTM2IC_E12_USE || ATL_FTM2IC_E13_USE || ATL_FTM2IC_E14_USE || ATL_FTM2IC_E15_USE || ATL_FTM2IC_E16_USE || ATL_FTM2IC_E17_USE || ATL_FTM2IC_E18_USE || ATL_FTM2IC_E19_USE || ATL_FTM2IC_E20_USE || ATL_FTM2IC_E21_USE || ATL_FTM2IC_E22_USE || ATL_FTM2IC_E23_USE || ATL_FTM2IC_E24_USE || ATL_FTM2IC_E25_USE || ATL_FTM2IC_E26_USE || ATL_FTM2IC_E27_USE || ATL_FTM2IC_E28_USE || ATL_FTM2IC_E29_USE || ATL_FTM2IC_E30_USE || ATL_FTM2IC_E31_USE || ATL_FTM2IC_E32_USE || ATL_FTM2IC_E33_USE || ATL_FTM2IC_E34_USE || ATL_FTM2IC_E35_USE || ATL_FTM2IC_E36_USE || ATL_FTM2IC_E37_USE || ATL_FTM2IC_E38_USE || ATL_FTM2IC_E39_USE || ATL_FTM2IC_E40_USE || ATL_FTM2IC_E41_USE || ATL_FTM2IC_E42_USE || ATL_FTM2IC_E43_USE || ATL_FTM2IC_E44_USE || ATL_FTM2IC_E45_USE || ATL_FTM2IC_E46_USE || ATL_FTM2IC_E47_USE || ATL_FTM2IC_E48_USE || ATL_FTM2IC_E49_USE || ATL_FTM2IC_E50_USE || ATL_FTM2IC_E51_USE || ATL_FTM2IC_E52_USE || ATL_FTM2IC_E53_USE || ATL_FTM2IC_E54_USE || ATL_FTM2IC_E55_USE || ATL_FTM2IC_E56_USE || ATL_FTM2IC_E57_USE || ATL_FTM2IC_E58_USE || ATL_FTM2IC_E59_USE || ATL_FTM2IC_E60_USE || ATL_FTM2IC_E61_USE || ATL_FTM2IC_E62_USE || ATL_FTM2IC_E63_USE)
  #define ATL_FTM3ICM_USED        (ATL_FTM3IC_E0_USE || ATL_FTM3IC_E1_USE || ATL_FTM3IC_E2_USE || ATL_FTM3IC_E3_USE || ATL_FTM3IC_E4_USE || ATL_FTM3IC_E5_USE || ATL_FTM3IC_E6_USE || ATL_FTM3IC_E7_USE || ATL_FTM3IC_E8_USE || ATL_FTM3IC_E9_USE || ATL_FTM3IC_E10_USE || ATL_FTM3IC_E11_USE || ATL_FTM3IC_E12_USE || ATL_FTM3IC_E13_USE || ATL_FTM3IC_E14_USE || ATL_FTM3IC_E15_USE || ATL_FTM3IC_E16_USE || ATL_FTM3IC_E17_USE || ATL_FTM3IC_E18_USE || ATL_FTM3IC_E19_USE || ATL_FTM3IC_E20_USE || ATL_FTM3IC_E21_USE || ATL_FTM3IC_E22_USE || ATL_FTM3IC_E23_USE || ATL_FTM3IC_E24_USE || ATL_FTM3IC_E25_USE || ATL_FTM3IC_E26_USE || ATL_FTM3IC_E27_USE || ATL_FTM3IC_E28_USE || ATL_FTM3IC_E29_USE || ATL_FTM3IC_E30_USE || ATL_FTM3IC_E31_USE || ATL_FTM3IC_E32_USE || ATL_FTM3IC_E33_USE || ATL_FTM3IC_E34_USE || ATL_FTM3IC_E35_USE || ATL_FTM3IC_E36_USE || ATL_FTM3IC_E37_USE || ATL_FTM3IC_E38_USE || ATL_FTM3IC_E39_USE || ATL_FTM3IC_E40_USE || ATL_FTM3IC_E41_USE || ATL_FTM3IC_E42_USE || ATL_FTM3IC_E43_USE || ATL_FTM3IC_E44_USE || ATL_FTM3IC_E45_USE || ATL_FTM3IC_E46_USE || ATL_FTM3IC_E47_USE || ATL_FTM3IC_E48_USE || ATL_FTM3IC_E49_USE || ATL_FTM3IC_E50_USE || ATL_FTM3IC_E51_USE || ATL_FTM3IC_E52_USE || ATL_FTM3IC_E53_USE || ATL_FTM3IC_E54_USE || ATL_FTM3IC_E55_USE || ATL_FTM3IC_E56_USE || ATL_FTM3IC_E57_USE || ATL_FTM3IC_E58_USE || ATL_FTM3IC_E59_USE || ATL_FTM3IC_E60_USE || ATL_FTM3IC_E61_USE || ATL_FTM3IC_E62_USE || ATL_FTM3IC_E63_USE)
  #define ATL_FTM4ICM_USED        (ATL_FTM4IC_E0_USE || ATL_FTM4IC_E1_USE || ATL_FTM4IC_E2_USE || ATL_FTM4IC_E3_USE || ATL_FTM4IC_E4_USE || ATL_FTM4IC_E5_USE || ATL_FTM4IC_E6_USE || ATL_FTM4IC_E7_USE || ATL_FTM4IC_E8_USE || ATL_FTM4IC_E9_USE || ATL_FTM4IC_E10_USE || ATL_FTM4IC_E11_USE || ATL_FTM4IC_E12_USE || ATL_FTM4IC_E13_USE || ATL_FTM4IC_E14_USE || ATL_FTM4IC_E15_USE || ATL_FTM4IC_E16_USE || ATL_FTM4IC_E17_USE || ATL_FTM4IC_E18_USE || ATL_FTM4IC_E19_USE || ATL_FTM4IC_E20_USE || ATL_FTM4IC_E21_USE || ATL_FTM4IC_E22_USE || ATL_FTM4IC_E23_USE || ATL_FTM4IC_E24_USE || ATL_FTM4IC_E25_USE || ATL_FTM4IC_E26_USE || ATL_FTM4IC_E27_USE || ATL_FTM4IC_E28_USE || ATL_FTM4IC_E29_USE || ATL_FTM4IC_E30_USE || ATL_FTM4IC_E31_USE || ATL_FTM4IC_E32_USE || ATL_FTM4IC_E33_USE || ATL_FTM4IC_E34_USE || ATL_FTM4IC_E35_USE || ATL_FTM4IC_E36_USE || ATL_FTM4IC_E37_USE || ATL_FTM4IC_E38_USE || ATL_FTM4IC_E39_USE || ATL_FTM4IC_E40_USE || ATL_FTM4IC_E41_USE || ATL_FTM4IC_E42_USE || ATL_FTM4IC_E43_USE || ATL_FTM4IC_E44_USE || ATL_FTM4IC_E45_USE || ATL_FTM4IC_E46_USE || ATL_FTM4IC_E47_USE || ATL_FTM4IC_E48_USE || ATL_FTM4IC_E49_USE || ATL_FTM4IC_E50_USE || ATL_FTM4IC_E51_USE || ATL_FTM4IC_E52_USE || ATL_FTM4IC_E53_USE || ATL_FTM4IC_E54_USE || ATL_FTM4IC_E55_USE || ATL_FTM4IC_E56_USE || ATL_FTM4IC_E57_USE || ATL_FTM4IC_E58_USE || ATL_FTM4IC_E59_USE || ATL_FTM4IC_E60_USE || ATL_FTM4IC_E61_USE || ATL_FTM4IC_E62_USE || ATL_FTM4IC_E63_USE)

  /*******************************************************
   ****** Solving of condflicts between used Timers ******
   *******************************************************/

  /* Determine if HW Timer is needed */
  
  /* GPIO Method */
  #if ATL_GPIO_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif

  /* KBI Method */
  #if ATL_KBI_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_KBI1_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_KBI2_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_KBI3_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  
  /* PTI Method */
  #if ATL_PIA_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_PIB_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_PIC_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_PID_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  #if ATL_PIJ_USED
    #ifndef ATL_HW_TIMER_USED
      #define ATL_HW_TIMER_USED      1
    #endif
  #endif
  
  /* Include "ATL_Timer.h" if ATL HW Timer is used */
  #ifdef ATL_HW_TIMER_USED
    #include "ATL_Timer.h"
  #endif
  
  /* If HW Timer already using the same TPM/FTM Input Capture Timer then undef TPM/FTM Input Capture Timer */ 
  #if TSS_USE_ATL_LOW_LEVEL
    #ifdef ATL_HW_TIMER_USED
      
      #define TPMID          0x01
      #define TPM1ID         0x10
      #define TPM2ID         0x20
      #define TPM3ID         0x30
      #define TPM4ID         0x40
      #define FTMID          0x50
      #define FTM1ID         0x60
      #define FTM2ID         0x70
      #define FTM3ID         0x80
      #define FTM4ID         0x90
      
      #define ATL_TPMID2NAME_RESULT(res)      res##ID
      #define ATL_TPMID2NAME_CONV(text)       ATL_TPMID2NAME_RESULT(text)
      #define ATL_TPM_ID(name)                ATL_TPMID2NAME_CONV(name)

      #if (ATL_TPM_ID(ATL_HW_TIMER) == TPMID) 
         #undef ATL_TPMICM_USED
         #define ATL_TPMICM_USED      0
      #endif     
      #if (ATL_TPM_ID(ATL_HW_TIMER) == TPM1ID) 
         #undef ATL_TPM1ICM_USED
         #define ATL_TPM1ICM_USED     0
      #endif     
      #if (ATL_TPM_ID(ATL_HW_TIMER) == TPM2ID) 
         #undef ATL_TPM2ICM_USED
         #define ATL_TPM2ICM_USED     0
      #endif     
      #if (ATL_TPM_ID(ATL_HW_TIMER) == TPM3ID) 
         #undef ATL_TPM3ICM_USED
         #define ATL_TPM3ICM_USED     0
      #endif     
      #if (ATL_TPM_ID(ATL_HW_TIMER) == TPM4ID) 
         #undef ATL_TPM4ICM_USED
         #define ATL_TPM4ICM_USED     0
      #endif  
      #if (ATL_TPM_ID(ATL_HW_TIMER) == FTMID) 
         #undef ATL_FTMICM_USED
         #define ATL_FTMICM_USED     0
      #endif  
      #if (ATL_TPM_ID(ATL_HW_TIMER) == FTM1ID) 
         #undef ATL_FTM1ICM_USED
         #define ATL_FTM1ICM_USED     0
      #endif  
      #if (ATL_TPM_ID(ATL_HW_TIMER) == FTM2ID) 
         #undef ATL_FTM2ICM_USED
         #define ATL_FTM2ICM_USED     0
      #endif  
      #if (ATL_TPM_ID(ATL_HW_TIMER) == FTM3ID) 
         #undef ATL_FTM3ICM_USED
         #define ATL_FTM3ICM_USED     0
      #endif  
      #if (ATL_TPM_ID(ATL_HW_TIMER) == FTM4ID) 
         #undef ATL_FTM4ICM_USED
         #define ATL_FTM4ICM_USED     0
      #endif
      
    #endif    
  #endif
  
  /*******************************************************
   ************ Electrode Macros Definitions *************
   *******************************************************/
   
  #define ATL_FAULT_DETECTED              (atl_u8HWTimerFlag != 0u)       /* Sets the fault flag */

  #define ATL_ELECTRODE_DISCHARGE(X)      TSS_GPIO_CLEAR(TSS_##X##_P,TSS_##X##_B); TSS_GPIO_OUT(TSS_##X##_P,TSS_##X##_B) 
  #define ATL_ELECTRODE_CHARGE(X)         TSS_GPIO_IN(TSS_##X##_P,TSS_##X##_B)                                
  #define ATL_ELECTRODE_DISCHARGED(X)     ((TSS_GPIO_READ(TSS_##X##_P,TSS_##X##_B)) == 0)
  #define ATL_ELECTRODE_INPUT(elec)       TSS_GPIO_IN(TSS_##elec##_P,TSS_##elec##_B)
  #define ATL_ELECTRODE_HIGH(elec)        TSS_GPIO_SET(TSS_##elec##_P,TSS_##elec##_B); TSS_GPIO_OUT(TSS_##elec##_P,TSS_##elec##_B)
  #define ATL_ELECTRODE_LOW(elec)         TSS_GPIO_CLEAR(TSS_##elec##_P,TSS_##elec##_B); TSS_GPIO_OUT(TSS_##elec##_P,TSS_##elec##_B)
  #define ATL_ELECTRODE_LOW_OUT(elec)     TSS_GPIO_OUT(TSS_##elec##_P,TSS_##elec##_B)
  
  #define ATL_SAVE_EL_PORT_ADR(elec)      (atl_pu8ElectrodePortAdr = TSS_GPIO_PORT_ADR(TSS_##elec##_P))
  #define ATL_SAVE_EL_PORT_MASK(elec)     (atl_u8ElectrodePortMask = 1 << TSS_##elec##_B)
  #define ATL_SAVE_ELECTRODE_PORT(elec)   ATL_SAVE_EL_PORT_ADR(elec);ATL_SAVE_EL_PORT_MASK(elec);
  
  #define ATL_SET_ELECTRODE_HIGH()        *atl_pu8ElectrodePortAdr |= atl_u8ElectrodePortMask;
  #define ATL_SET_ELECTRODE_LOW()         *atl_pu8ElectrodePortAdr &= ~atl_u8ElectrodePortMask;
  #define ATL_SET_ELECTRODE_OUTPUT()      *(atl_pu8ElectrodePortAdr+1) |= atl_u8ElectrodePortMask;
  #define ATL_SET_ELECTRODE_OUTPUT_HIGH() ATL_SET_ELECTRODE_HIGH();ATL_SET_ELECTRODE_OUTPUT();
  #define ATL_SET_ELECTRODE_OUTPUT_LOW()  ATL_SET_ELECTRODE_LOW();ATL_SET_ELECTRODE_OUTPUT();

  #define ATL_CLEAR_SAMPLE_INTERRUPTED_FLAG()   (atl_u8SampleIntFlag = 0U)
  #define ATL_SAMPLE_INTERRUPTED                (atl_u8SampleIntFlag != 0U)
 
#endif /*__ATL_SENSOR_H__*/