/***********************************************************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2006-2009 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
*********************************************************************************************************************//*!
*
* @file   CTS_Sensor.h
*
* @brief  Functions Prototypes, constants, variables and macros for the sensing of electrodes 
*
* @version 1.0.11.0
* 
* @date Jun-4-2010
* 
*
***********************************************************************************************************************/


#ifndef __CTS_SENSOR_H__
  #define __CTS_SENSOR_H__

  #include "derivative.h"      
  #include "TSS_API.h"

  extern UINT16 tss_u16CapSample;

  /*******************************************************
   *************** Constants Definitions *****************
   *******************************************************/

  #define CTS_FAULT_TIMEOUT               128U         
  #define CTS_SIGNAL_OFFSET               20U
  #define CTS_RECALIB_LIMIT               5U
  
  #define CTS_DEFAULT_NOISE_WINDOW_SIZE   255u

  /*******************************************************
   ****************** Functions Declarations *************
   *******************************************************/

  UINT8 CTS_SampleElectrode(UINT8 u8ElecNum);
  /*
  function:   CTS_SampleElectrode
  brief:      Performs a valid reading of one electrode, stores the timer values and returns a status code
  param:      u8ElecNum   -  Number of electrode to be scanned
  return:     Status code                              
  */                           

  UINT8 CTS_SensorInit(void);
  /*
  function:   CTS_SensorInit
  brief:      Initializing of CTS Routines
  param:      Void                           
  return:     Void                              
  */
  
  UINT8 CTS_GetTurbo(UINT8 u8ElecNum); 
  /*
  function:   CTS_GetTurbo
  brief:      Performs a determination of Turbo values for certain electrode
  param:      UINT8 u8ElecNum - -  Number of electrode to be scanned                           
  return:     Void                              
  */

#endif /*__CTS_SENSOR_H__*/