/*******************************************************************************
* FILE NAME: etpu_CEA709.h           COPYRIGHT (c) Freescale Semiconductor 2006
*                                              All Rights Reserved
* DESCRIPTION:
* This file contains the prototypes and definitions for the CEA709 eTPU 
* function API.
*===============================================================================
* REV      AUTHOR      DATE        DESCRIPTION OF CHANGE
* ---   -----------  ----------    ---------------------
* 1.0    M. Princ     08/Jun/07    Initial version of file.
*******************************************************************************/
#ifndef _ETPU_CEA709_H_
#define _ETPU_CEA709_H_

#include "etpu_CEA709_auto.h"		/* Auto generated header file for eTPU CEA709. */

/*******************************************************************************
*                            Definitions
*******************************************************************************/
#define FS_ETPU_CEA709_CHAN_NOT_USED      0xFE

/* cd_tail options. */
#define FS_ETPU_CEA709_CDTAIL_NO          0x00
#define FS_ETPU_CEA709_CDTAIL_YES         0x01

/* cd_preamble options. */
#define FS_ETPU_CEA709_CDPREAMBLE_NO      0x00
#define FS_ETPU_CEA709_CDPREAMBLE_YES     0x02

/* dma_trigger_mode options. */
#define FS_ETPU_CEA709_DMA_TRIGGER_RISING_EDGE      0x00
#define FS_ETPU_CEA709_DMA_TRIGGER_FALLING_EDGE     0x01
#define FS_ETPU_CEA709_DMA_TRIGGER_INTERNAL         0x02

/* status mask */
#define FS_ETPU_CEA709_STATUS_RX_FRAME_END               0x000001 /* End of frame = line code violation */
#define FS_ETPU_CEA709_STATUS_RX_ERROR                   0x000002 /* Error occurred when receiving */
#define FS_ETPU_CEA709_STATUS_TX_PRI_BUFFER_FULL         0x000004 /* TX priority buffer contains new data to be transmitted */
#define FS_ETPU_CEA709_STATUS_TX_NONPRI_BUFFER_FULL      0x000008 /* TX non-priority buffer contains new data to be transmitted */
#define FS_ETPU_CEA709_STATUS_TX_TRANSMISSION_BEGINNING  0x000010 /* Transmission begins */
#define FS_ETPU_CEA709_STATUS_TX_TRANSMISSION_SUCCESSFUL 0x000020 /* Data transmitted successfully */
#define FS_ETPU_CEA709_STATUS_TX_ERROR                   0x000040 /* Error occurred when transmitting */
#define FS_ETPU_CEA709_STATUS_BACKLOG_OVERFLOW           0x000080 /* Backlog overflow */
#define FS_ETPU_CEA709_STATUS_COLLISION_DETECTED         0x000100 /* Collision detected either during the preamble or at the end of packet */

/* eTPU buffers size */
#define FS_ETPU_CEA709_BUFFER_SIZE  16

/*******************************************************************************
*                       Function Prototypes
*******************************************************************************/

/* Initialization of one CEA709 MAC unit. */
int32_t fs_etpu_CEA709_init_1unit( uint8_t   rx_channel,
                                   uint8_t   tx_channel,
                                   uint8_t   preamble_length,
                                   uint24_t  packet_cycle,
                                   uint24_t  beta2_control,
                                   uint24_t  xmit_interpacket,
                                   uint24_t  receive_interpacket,
                                   uint8_t   channel_priorities,
                                   uint8_t   node_priority,
                                   uint8_t   bit_sync_threshold,
                                   uint8_t   dma_control_channel,
                                   uint8_t   dma_trigger_mode,
                                   uint8_t   tx_en_channel,
                                   uint8_t   cd_channel,
                                   uint8_t   cd_preamble,
                                   uint8_t   cd_tail,
                                   uint24_t  cd_to_end_packet);

/* Initialization of two CEA709 MAC unist. */
int32_t fs_etpu_CEA709_init_2units( uint8_t   rx_channel_1,
                                    uint8_t   tx_channel_1,
                                    uint8_t   preamble_length_1,
                                    uint24_t  packet_cycle_1,
                                    uint24_t  beta2_control_1,
                                    uint24_t  xmit_interpacket_1,
                                    uint24_t  receive_interpacket_1,
                                    uint8_t   channel_priorities_1,
                                    uint8_t   node_priority_1,
                                    uint8_t   bit_sync_threshold_1,
                                    uint8_t   dma_control_channel_1,
                                    uint8_t   dma_trigger_mode_1,
                                    uint8_t   tx_en_channel_1,
                                    uint8_t   cd_channel_1,
                                    uint8_t   cd_preamble_1,
                                    uint8_t   cd_tail_1,
                                    uint24_t  cd_to_end_packet_1,
                                    uint8_t   rx_channel_2,
                                    uint8_t   tx_channel_2,
                                    uint8_t   preamble_length_2,
                                    uint24_t  packet_cycle_2,
                                    uint24_t  beta2_control_2,
                                    uint24_t  xmit_interpacket_2,
                                    uint24_t  receive_interpacket_2,
                                    uint8_t   channel_priorities_2,
                                    uint8_t   node_priority_2,
                                    uint8_t   bit_sync_threshold_2,
                                    uint8_t   dma_control_channel_2,
                                    uint8_t   dma_trigger_mode_2,
                                    uint8_t   tx_en_channel_2,
                                    uint8_t   cd_channel_2,
                                    uint8_t   cd_preamble_2,
                                    uint8_t   cd_tail_2,
                                    uint24_t  cd_to_end_packet_2);

/* Get pointer to the beginning of the transmit priority buffer. */
uint32_t fs_etpu_CEA709_get_tx_pri_buffer_start(uint8_t rx_channel);

/* Get pointer to the beginning of the transmit non-priority buffer. */
uint32_t fs_etpu_CEA709_get_tx_nonpri_buffer_start(uint8_t rx_channel);

/* Get pointer to the beginning of the receive buffer. */
uint32_t fs_etpu_CEA709_get_rx_buffer_start(uint8_t rx_channel);

/* Enables eTPU channels of the given transciever. */
uint32_t fs_etpu_CEA709_enable(uint8_t   rx_channel,
                               uint8_t   tx_channel,
                               uint8_t   dma_control_channel,
                               uint8_t   tx_en_channel,
                               uint8_t   cd_channel);

/* Disables eTPU channels of the given transciever. */
uint32_t fs_etpu_CEA709_disable(uint8_t   rx_channel,
                                uint8_t   tx_channel,
                                uint8_t   dma_control_channel,
                                uint8_t   tx_en_channel,
                                uint8_t   cd_channel);

/* Request for transmitting the next packet. */
int32_t  fs_etpu_CEA709_transmit_packet(uint8_t rx_channel);

/* Get actual MAC/Link layer status flags for callback function. */
uint24_t  fs_etpu_CEA709_get_status_flags(uint8_t rx_channel);

/* Set appropriate status flag. */
uint32_t fs_etpu_CEA709_set_status_flag(uint8_t rx_channel, uint32_t mask);

/* Clear appropriate status flag. */
uint32_t fs_etpu_CEA709_clear_status_flag(uint8_t rx_channel, uint32_t mask);

/* Get the length of the last received packet. */
uint24_t  fs_etpu_CEA709_get_last_rx_packet_length(uint8_t rx_channel);

/* Get high 24 bits of the last received packet timestamp. */
uint24_t  fs_etpu_CEA709_get_last_rx_packet_time_stamp_high24(uint8_t rx_channel);

/* Get low 24 bits of the last received packet timestamp. */
uint24_t  fs_etpu_CEA709_get_last_rx_packet_time_stamp_low24(uint8_t rx_channel);

/* Get the additional datagram info of the last received packet. */
uint8_t fs_etpu_CEA709_get_last_rx_packet_datagram_info(uint8_t rx_channel);

/* Get high 24 bits of the timestamp counter value. */
uint24_t fs_etpu_CEA709_get_timestamp_counter_value_high24(uint8_t rx_channel);

/* Get low 24 bits of the timestamp counter value. */
uint24_t fs_etpu_CEA709_get_timestamp_counter_value_low24(uint8_t rx_channel);

/*******************************************************************************
*        Information for eTPU Graphical Configuration Tool
*******************************************************************************/
/* full function name: CEA709 communication protocol */ 

#endif

/*********************************************************************
 *
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 ********************************************************************/
