/* 
* Declare all custom 128-bit UUIDs here using the format:
*
*  UUID128(name, bytes)
*
* where: 
*	-name : an unique tag for the newly defined UUID;
		will be used to reference this UUID when defining
		services and characteristics in <<gattDb.h>>
*	-bytes: 16 bytes representing the 128-bit value
*
* One definition per line. No semicolon required after each definition.
*
* example:
*  UUID128(uuid_service_robot_characteristics, 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD, 0xEF, 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD, 0xEF)
*  UUID128(uuid_char_robot_direction, 0x12, 0x34, 0x50, 0x00, 0x90, 0xAB, 0xCD, 0xEF, 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD, 0xEF)
*	
*/
/* Services */

/* LED Control Service */
UUID128(uuid_service_led_control, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x00, 0x56, 0xFF, 0x02)
/* Input Report Service */
UUID128(uuid_service_input_report, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x01, 0x56, 0xFF, 0x02)
/* Buzzer Control Service */
UUID128(uuid_service_buzzer_control, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x02, 0x56, 0xFF, 0x02)
/* Chip Temperature Service */
UUID128(uuid_service_chip_temperature, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x03, 0x56, 0xFF, 0x02)
/* Potentiometer Service */
UUID128(uuid_service_potentiometer, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x04, 0x56, 0xFF, 0x02)
/* Accelerometer Service */
UUID128(uuid_service_accelerometer, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x05, 0x56, 0xFF, 0x02)
/* Compass Service */
UUID128(uuid_service_compass, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x06, 0x56, 0xFF, 0x02)
/* Remote Controller Service */
UUID128(uuid_service_remote_controller, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x07, 0x56, 0xFF, 0x02)

/* Characteristics */

/* LED Status Characteristic */
UUID128(uuid_characteristic_led_status, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x00, 0x57, 0xFF, 0x02)
/* LED Control Characteristic */
UUID128(uuid_characteristic_led_control, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x01, 0x57, 0xFF, 0x02)
/* Input Report Characteristic */
UUID128(uuid_characteristic_input_report, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x02, 0x57, 0xFF, 0x02)
/* Buzzer Control Characteristic */
UUID128(uuid_characteristic_buzzer, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x03, 0x57, 0xFF, 0x02)
/* Potentiometer Characteristic */
UUID128(uuid_characteristic_potentiometer_relative_value, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x04, 0x57, 0xFF, 0x02)
/* Accelerometer Scale Characteristic */
UUID128(uuid_characteristic_accelerometer_scale, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x05, 0x57, 0xFF, 0x02)
/* Accelerometer Readings Characteristic */
UUID128(uuid_characteristic_accelerometer_readings, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x06, 0x57, 0xFF, 0x02)
/* Compass Heading Characteristic */
UUID128(uuid_characteristic_compass_heading, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x07, 0x57, 0xFF, 0x02)
/* Controller Command Characteristic */
UUID128(uuid_characteristic_controller_command, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x08, 0x57, 0xFF, 0x02)
/* Controller Configuration Characteristic */
UUID128(uuid_characteristic_controller_configuration, 0xE0, 0x1C, 0x4B, 0x5E, 0x1E, 0xEB, 0xA1, 0x5C, 0xEE, 0xF4, 0x5E, 0xBA, 0x09, 0x57, 0xFF, 0x02)