/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _APP_H_
#define _APP_H_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*${macro:start}*/
#define DEMO_USART USART0
#define DEMO_USART_CLK_SRC 				kCLOCK_Fro32M
#define DEMO_USART_CLK_FREQ				CLOCK_GetFreq(DEMO_USART_CLK_SRC)


#define WRITE_REG32(A, B)           	(*(volatile uint32 *)(A)) = (B)
#define READ_REG32(A)     				(*(volatile uint32 *)(A))
#define JN518X_ZBMAC                	0x400B1000
#define JN518X_ZBMODEM                	0x400B0000
#define JN518X_RFPMODEM                	0x40013000
#define REG_BBC_LIFS_TURNAROUND   		0x80
#define REG_BBC_PRTT 					0x4C
#define REG_BBC_TAT						0x54
#define REG_BBC_SCFRC 					0x24
#define REG_BBC_RXTSTP					0x34
#define MF_RSSI_DBM_PACKET				0x1dc

#define vREG_BbcWrite(eOffset, u32Data) WRITE_REG32(eOffset + JN518X_ZBMAC, u32Data)
#define u32REG_RFPModemRead(eOffset)    READ_REG32(eOffset + JN518X_RFPMODEM)

/*${macro:end}*/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
/*${prototype:start}*/
void BOARD_InitHardware(void);
/*${prototype:end}*/


#endif /* _APP_H_ */
