/*
 * Copyright (c) 2019, NXP B.V.
 * Copyright 2016-2019 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*  Standard C Included Files */
#include <stdio.h>
#include <string.h>
#include <jendefs.h>
#include "board.h"
#include "fsl_debug_console.h"
#include "app.h"

#include "fsl_iocon.h"
#include "fsl_gpio.h"
#include "fsl_usart.h"
#include "pin_mux.h"
#include "command.h"
#include <MMAC.h>

#ifdef MODE_CMD
#include "app_serial_commands.h"
#endif

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
extern PUBLIC tsPhyFrame sFrame;

bool_t bHighPower = FALSE;

bool_t bUartRxDataAvailable(USART_Type *base)
{
	if (base->FIFOSTAT & USART_FIFOSTAT_RXNOTEMPTY_MASK) return TRUE;
	return FALSE;
}

#ifdef MODE_CMD

/******************************************************************************
 * NAME: APP_taskAtSerial
 *
 * DESCRIPTION:
 *
 *
 * PARAMETERS:      Name            Usage
 *
 * RETURNS:
 * None
 ****************************************************************************/
PUBLIC void APP_taskAtSerial( void)
{
	uint8 u8RxByte;

	while (bUartRxDataAvailable(USART0)){
		USART_ReadBlocking(USART0, &u8RxByte, 1);
		USART_WriteBlocking(USART0, &u8RxByte, 1);
		vProcessRxChar(u8RxByte);
	}
}
#else
PUBLIC void APP_taskAtSerial( void)
{
	uint8 u8RxByte;

	while (bUartRxDataAvailable(USART0)){
		USART_ReadBlocking(USART0, &u8RxByte, 1);
		USART_WriteBlocking(USART0, &u8RxByte, 1);

		vCommand_ResetCounters();

	}
}
#endif


void GPIO_set_level(uint8_t u8TestDIO, uint8_t level)
{
       // set DIO during 1us
    GPIO_PinWrite(GPIO, 0, u8TestDIO, level);
}
#ifdef ANTENNA_DIVERSITY
void GPIO_configure(uint8_t u8TestDIO)
{
    gpio_pin_config_t out_trigger_config = {
        kGPIO_DigitalOutput, 0,
    };
    IOCON_PinMuxSet(IOCON, 0, u8TestDIO, (IOCON_FUNC0 | IOCON_MODE_PULLUP | IOCON_DIGITAL_EN));
    GPIO_PinInit(GPIO, 0, u8TestDIO, &out_trigger_config);
    GPIO_PinWrite(GPIO, 0, u8TestDIO, 0);

}

static void Configure_AD_Debug(void)
{
      GPIO_configure(1);
      GPIO_configure(2);
      GPIO_configure(3);
      GPIO_configure(4);
      GPIO_configure(10);

    IOCON_PinMuxSet(IOCON, 0, 6,
                      IOCON_FUNC7 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* ADE for antenna diversity */
    IOCON_PinMuxSet(IOCON, 0, 7,
                      IOCON_FUNC7 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* ADO for antenna diversity */

    IOCON_PinMuxSet(IOCON, 0, 21,
                      IOCON_FUNC5 | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);  /* RFRX for antenna diversity */
}
#endif

int __main(void)
{

   BOARD_InitHardware();

   vMMAC_Enable();
   vMMAC_ConfigureRadio();
   vMMAC_SetChannelAndPower(DEFAULT_CHANNEL, DEFAULT_TX_POWER_dBm);
   vMMAC_SetTxParameters(1, 1, 1, 1);
   vMMAC_SetCcaMode(E_MMAC_CCAMODE_CARRIER);
   vMMAC_StartPhyReceive(&sFrame, E_MMAC_RX_START_NOW | E_MMAC_RX_ALLOW_MALFORMED | E_MMAC_RX_ALLOW_FCS_ERROR);

#ifdef ANTENNA_DIVERSITY
   Configure_AD_Debug();
   vRadio_AntennaDiversityTxRxEnable(TRUE, FALSE);
   // The value to program for the RSSI is a 10bit 2complement’s value in 1/4th of dBm.
   // So take the absolute value that you want to program, multiply it by 4, binary not the hex value obtained and add 1.
   //-91 db
   // Abs = 91
   // Abs x4 = 364 = 0x16C
   // Not (Abs x4) = 0x293
   // Not (Abs x4) +1 = 0x294
   // For the rx_timer, the value is a quarter of the timer required doe for 32us use a value of 8.

   //vRadio_Jn518x_AntennaDiversityConfigure(0x278, 0x8);
#endif

#ifdef MODE_CMD
   PRINTF("\n\rTIS/TRP CMD JN5189 V1.1\n>");
#else
   PRINTF("\n\rTIS/TRP DUT JN5189 V1.1\n");
#endif

   // Disable the interrupts. We will poll the MAC
   NVIC_DisableIRQ(ZIGBEE_MAC_IRQn);

   /* Sit in loop forever */
   while (1) {
		vCommand_Task(TRUE);
		APP_taskAtSerial();
   }
}


