/*
 * vectortable.c
 * This file holds the interrupt vector table
 
 * $Author: rgd04c $
 * $Date: 2006/09/06 05:41:51 $
 * $Name:  $
 */
#include "pub_def.h"
#include "app_config.h"

typedef void(*tIsrFunc)(void);


extern interrupt void IRQIsr(void);

//extern interrupt void KBD_ISR();

//*****************************
//Put your ISR routines here.
//extern interrupt void yourAppISR(void);
//extern interrupt void Vscirx();

//Put the Function Name of your interrupt handler into this constant array.
//at the ISR location that you want.

interrupt void UnimplementedISR(void)
{
  for(;;);
}

// Added redirected ISR vectors when BootLoader is enabled.
// The application cannot have a reset vector (resides in BootLoader).
#if (EMBEDDED_BOOTLOADER == TRUE)
    // Redirected ISR vectors
    const tIsrFunc _vect[] @0xEFD0 = {  /* Interrupt table */
#else
    const tIsrFunc _vect[] @0xFFD0 = {  /* Interrupt table */
#endif 
        UnimplementedISR,       /* vector 23: RT */
        UnimplementedISR,       /* reserved vector 22*/
        UnimplementedISR,       /* reserved vector 21*/
        UnimplementedISR,       /* reserved vector 20*/
        UnimplementedISR,       /* vector 19: ATD */
        UnimplementedISR,       /* vector 18: KBI */
        UnimplementedISR,       /* reserved vector 17*/
        UnimplementedISR,       /* reserved vector 16*/
        UnimplementedISR,       /* reserved vector 15*/
        UnimplementedISR,       /* reserved vector 14*/
        UnimplementedISR,       /* reserved vector 13*/
        UnimplementedISR,       /* reserved vector 12*/
        UnimplementedISR,       /* reserved vector 11*/
        UnimplementedISR,       /* vector 10: TPM2OF */
        UnimplementedISR,       /* reserved vector 09*/
        UnimplementedISR,       /* vector 08: TPM2C0 */
        UnimplementedISR,       /* vector 07: TPM1OF */
        UnimplementedISR,       /* vector 06: TPM1C1 */
        UnimplementedISR,       /* vector 05: TPM1C0 */
        UnimplementedISR,       /* reserved vector 04*/
        IRQIsr,                 /* vector 03: IRQ pin */
        UnimplementedISR,       /* vector 02: Low Voltage Detect */
        UnimplementedISR        /* vector 01: SWI */
        /*_Startup, by default in library*/ /* Reset vector */
   };