
/****************************************************************************
Main Application
****************************************************************************/

/************************************************************************************************/
/*                                      Includes Section                                        */
/************************************************************************************************/

#include <hidef.h> /* for EnableInterrupts macro */
#include "pub_def.h"
#include "APP_SMAC_API.h"
#include "freescale_radio_hardware.h"
#include "drivers.h"
#include "simple_phy.h"

/************************************************************************************************/
/*                                     Constants Section                                        */
/************************************************************************************************/

#define CHANNEL_NUMBER      7

#define OUTPUT_POWER        MAX_POWER
//#define OUTPUT_POWER        NOMINAL_POWER
//#define OUTPUT_POWER        MIN_POWER

#define ClearOutputs          (0xFF87)
#define GPIO7                 (1<<6)
#define GPIO6                 (1<<5)
#define GPIO5                 (1<<4)
#define GPIO4                 (1<<3)
#define GPIO3                 (1<<2)
const UINT16 u16CoilsArray[] = {GPIO4,GPIO5,GPIO6,GPIO7};

/************************************************************************************************/
/*                                Global Variables Section                                      */
/************************************************************************************************/

#pragma DATA_SEG _DATA_ZEROPAGE

UINT8 gu8RTxMode;                            /* needed for s-mac, application can read this variable */
                                             /* gu8RTxMode is the software state variable of the radio */
                                             /* This variable reflects the current state of MC13192 */
INT8 gi8AppStatus = 0;                       /*State machine variable for the application    */
UINT8 gu8LedStatus = 0;                      /*led status reflects which power setting should be set.  */
UINT8 link_quality;                          /*Holds the link quality of the last received ZigBee Packet.*/
UINT8 gau8TxDataBuffer[20];
UINT8 gau8RxDataBuffer[20];
tTxPacket gsTxPacket;
tRxPacket gsRxPacket;

/********************************************/

/* Put your variables declaration here!! */


#pragma DATA_SEG DEFAULT

/************************************************************************************************/
/*                                      Functions Section                                       */
/************************************************************************************************/

void main(void) 
{

    /*Initialize the packet.*/
    gsTxPacket.u8DataLength = 0;                  /*Set TX default length to 0*/
    gsTxPacket.pu8Data = &gau8TxDataBuffer[0];    /*Load the address of our txbuffer into the tx structure*/
    gsRxPacket.u8DataLength = 0;                  /*Set RX default length to 0*/
    gsRxPacket.pu8Data = &gau8RxDataBuffer[0];    /*Load the address of our rxbuffer into the rx structure*/
    gsRxPacket.u8MaxDataLength = 20;              /*Define the max buffer we are interested in.*/
    gsRxPacket.u8Status = 0;                      /*initial status variable for rx to 0.*/
    

    MCUInit();                                    /*Initialize the mcu, setup GPIOs, SPI, clock scheme, etc.*/
    RadioInit();

    (void)MLMESetMC13192ClockRate(2);                            /* Set initial Clk speed */
    UseExternalClock();                                          /* switch clock sources */

     EnableInterrupts;                                           /* Turn on system interrupts */
     (void)MLMESetChannelRequest(CHANNEL_NUMBER);            /*Set channel to 0 (2.405GHz)  */
     
     /******************************************************************
     To adjust output power call the MLME_MC13192_PA_output_adjust() with:
     MAX_POWER     (+3 to +5dBm)
     NOMINAL_POWER (0 dBm)
     MIN_POWER     ~(-16dBm)
     or somewhere custom ? (0-15, 11 (NOMINAL_POWER) being Default power)
     ******************************************************************/
     (void)MLMEMC13192PAOutputAdjust(OUTPUT_POWER);              /*Set MAX power setting*/
     
     
/************************************************************************************************/
/************************************************************************************************/
/************************************************************************************************/
     
    /* include your start up code here */    
    
    
/******************************************/

/*   This is only a transmit example, you can erase it if you wish */

     gau8TxDataBuffer[0] = '\n';
     gau8TxDataBuffer[1] = '\r';
     gau8TxDataBuffer[2] = 'M';
     gau8TxDataBuffer[3] = 'C';
     gau8TxDataBuffer[4] = '9';
     gau8TxDataBuffer[5] = 'S';
     gau8TxDataBuffer[6] = '0';
     gau8TxDataBuffer[7] = '8';
     gau8TxDataBuffer[8] = 'Q';
     gau8TxDataBuffer[9] = 'D';
     gau8TxDataBuffer[10] = '4';
     gau8TxDataBuffer[11] = '\0';
     gsTxPacket.u8DataLength = 12;

     MCPSDataRequest(&gsTxPacket);                /* Transmit String */
     
/******************************************/

     (void)MLMERXEnableRequest(&gsRxPacket, 0);   /* Enable Reception */
     
/******************************************/
    
     for(;;)
     {
          /* This is only an example, you can erase it */
          UINT16 u16Delay = 30000;
          while(--u16Delay);
          u16GPIO ^= GPIO5;                            /* Toggle GPIO5 */
          SPIDrvWrite(0x0C,u16GPIO);
          /* end of example */
     }
}

void MCPSDataIndication(tRxPacket *gsRxPacket) 
{
    if (gsRxPacket->u8Status == SUCCESS) 
    {
          /* Packet received successfully */
          /* Packet can be read from gsRxPacket->pu8Data */
    }    
}

void MLMEMC13192ResetIndication(void) 
{
     /* Don't erase this function */
}
