/*==================================================================================================
*   (c) Copyright 2015-2016 Freescale Semiconductor, Inc.
*   Copyright 2017-2019 NXP
*   NXP Confidential. This software is owned or controlled by NXP and may only be used strictly
*   in accordance with the applicable license terms. By expressly accepting
*   such terms or by downloading, installing, activating and/or otherwise using
*   the software, you are agreeing that you have read, and that you agree to
*   comply with and are bound by, such license terms. If you do not agree to
*   be bound by the applicable license terms, then you may not retain,
*   install, activate or otherwise use the software.
==================================================================================================*/
/*==================================================================================================
*                                        INCLUDE FILES
==================================================================================================*/
#include "edma_init.h"
#include "rdc_checker.h"
#include "etpu_set/etpu_gct.h"
#include "etpu_set/etpu/resolver/etpu_resolver.h"
//#include "etpu_set/include/mpc5777c_vars.h"

/*==================================================================================================
*                                      GLOBAL VARIABLES
==================================================================================================*/
const uint32_t link_cnst[] = {0,FS_ETPU_RESOLVER_HSR_UPDATE_1ST,0, FS_ETPU_RESOLVER_HSR_UPDATE_2ND};
/*==================================================================================================
*                                       GLOBAL FUNCTIONS
==================================================================================================*/

void edma_init(void)
{
	uint8_t hsr_ch = 48;

	// DMA B ch 36 - SDADC0 result ready
	// DMA B ch 39 - SDADC3 result ready
	// DMA_A ch 28 - eTPU_A 1 DMA request


	// DMA settings for SDADC_0 request
	DMA_B.TCD[36].SADDR.R = (uint32_t)&SDADC_1.CDR.R;

	DMA_B.TCD[36].ATTR.B.SMOD = 0;			/* source address modulo*/
	DMA_B.TCD[36].ATTR.B.SSIZE = 2;		 	/* source data size: 32bit */
	DMA_B.TCD[36].ATTR.B.DMOD = 0;			/* destination address modulo: 32 datawords each 4 bytes */
	DMA_B.TCD[36].ATTR.B.DSIZE = 2;			/* destination data size: 32bit */
	DMA_B.TCD[36].SOFF.R = 0;					/* source address signed offset */

	DMA_B.TCD[36].NBYTES.MLNO.R = 32;			/* inner "minor" byte count */

	DMA_B.TCD[36].SLAST.R = 0;				/* TCD Last Source Address Adjustment */

	DMA_B.TCD[36].DADDR.R = (vuint32_t)resolver_instance.signals_pba;	/* destination address */

	DMA_B.TCD[36].CITER.ELINKYES.B.ELINK = 1;			/* Enable channel-to-channel linking on minor-loop complete */
	DMA_B.TCD[36].CITER.ELINKYES.B.LINKCH = hsr_ch;	/* Minor Loop Link Channel Number */
	DMA_B.TCD[36].CITER.ELINKYES.B.CITER = 4;			/* current major iteration count */

	DMA_B.TCD[36].DOFF.R = 4;							/* signed destination address offset */

	DMA_B.TCD[36].DLASTSGA.R = -128; 					/* last destination address adjustment /scatter gather  address */

	DMA_B.TCD[36].BITER.ELINKYES.B.ELINK = 1;			/* enable channel-to-channel linking on minor loop complete */
	DMA_B.TCD[36].BITER.ELINKYES.B.LINKCH = hsr_ch;	/* Minor Loop Link Channel Number */
	DMA_B.TCD[36].BITER.ELINKYES.B.BITER = 4;			/* beginning major iteration count */
	DMA_B.TCD[36].CSR.B.MAJORELINK = 1;				/* enable channel-to-channel linking on major loop complete */
	DMA_B.TCD[36].CSR.B.MAJORLINKCH = hsr_ch;			/* Major Loop Link Channel Number */


	// DMA settings for SDADC_3 request
	DMA_B.TCD[39].SADDR.R = (uint32_t)&SDADC_4.CDR.R;

	DMA_B.TCD[39].ATTR.B.SMOD = 0;			/* source address modulo*/
	DMA_B.TCD[39].ATTR.B.SSIZE = 2;		 	/* source data size: 32bit */
	DMA_B.TCD[39].ATTR.B.DMOD = 0;			/* destination address modulo: 32 datawords each 4 bytes */
	DMA_B.TCD[39].ATTR.B.DSIZE = 2;			/* destination data size: 32bit */
	DMA_B.TCD[39].SOFF.R = 0;					/* source address signed offset */

	DMA_B.TCD[39].NBYTES.MLNO.R = 32;			/* inner "minor" byte count */

	DMA_B.TCD[39].SLAST.R = 0;				/* TCD Last Source Address Adjustment */

	DMA_B.TCD[39].DADDR.R = (vuint32_t)resolver_instance.signals_pba + 0x80;	/* destination address */

	DMA_B.TCD[39].CITER.ELINKNO.B.ELINK = 0;			/* Disable channel-to-channel linking on minor-loop complete */
	DMA_B.TCD[39].CITER.ELINKNO.B.CITER = 4;			/* current major iteration count */

	DMA_B.TCD[39].DOFF.R = 4;							/* signed destination address offset */

	DMA_B.TCD[39].DLASTSGA.R = -128; 					/* last destination address adjustment /scatter gather  address */

	DMA_B.TCD[39].BITER.ELINKNO.B.ELINK = 0;			/* Disable channel-to-channel linking on minor loop complete */
	DMA_B.TCD[39].BITER.ELINKNO.B.BITER = 4;			/* Beginning major iteration count */
	DMA_B.TCD[39].CSR.B.MAJORELINK = 0;				/* Disable channel-to-channel linking on major loop complete */

	// DMA settings for hsr link
	DMA_B.TCD[hsr_ch].SADDR.R = (uint32_t)&link_cnst[0];

	DMA_B.TCD[hsr_ch].ATTR.B.SMOD = 0;			/* source address modulo*/
	DMA_B.TCD[hsr_ch].ATTR.B.SSIZE = 2;		 	/* source data size: 32bit */
	DMA_B.TCD[hsr_ch].ATTR.B.DMOD = 0;			/* destination address modulo: 32 datawords each 4 bytes */
	DMA_B.TCD[hsr_ch].ATTR.B.DSIZE = 2;			/* destination data size: 32bit */
	DMA_B.TCD[hsr_ch].SOFF.R = 4;					/* source address signed offset */

	DMA_B.TCD[hsr_ch].NBYTES.MLNO.R = 4;			/* inner "minor" byte count */

	DMA_B.TCD[hsr_ch].SLAST.R = -16;				/* TCD Last Source Address Adjustment */

	DMA_B.TCD[hsr_ch].DADDR.R = (uint32_t)&eTPU->CHAN[resolver_instance.chan_num_ato].HSRR.R;	/* destination address */

	DMA_B.TCD[hsr_ch].CITER.ELINKNO.B.ELINK = 0;			/* Disable channel-to-channel linking on minor-loop complete */
	DMA_B.TCD[hsr_ch].CITER.ELINKNO.B.CITER = 4;			/* current major iteration count */

	DMA_B.TCD[hsr_ch].DOFF.R = 0;							/* signed destination address offset */

	DMA_B.TCD[hsr_ch].DLASTSGA.R = 0; 					/* last destination address adjustment /scatter gather  address */

	DMA_B.TCD[hsr_ch].BITER.ELINKNO.B.ELINK = 0;			/* Disable channel-to-channel linking on minor loop complete */
	DMA_B.TCD[hsr_ch].BITER.ELINKNO.B.BITER = 4;			/* Beginning major iteration count */
	DMA_B.TCD[hsr_ch].CSR.B.MAJORELINK = 0;				/* Disable channel-to-channel linking on major loop complete */


	// DMA settings for eTPU Resolver DMA Request
	DMA_A.TCD[28].SADDR.R = (vuint32_t)resolver_instance.checker_signals_pba+ 0x4000;	/* Source address - eTPU checker data structure on signed extended memory area */
	DMA_A.TCD[28].ATTR.B.SMOD = 0;			/* Source address modulo*/
	DMA_A.TCD[28].ATTR.B.SSIZE = 2;		 	/* Source data size: 32bit */
	DMA_A.TCD[28].ATTR.B.DMOD = 0;			/* Destination address modulo: 32 datawords each 4 bytes */
	DMA_A.TCD[28].ATTR.B.DSIZE = 2;			/* Destination data size: 32bit */
	DMA_A.TCD[28].SOFF.R = 4;					/* source address signed offset */

	DMA_A.TCD[28].NBYTES.MLNO.R = 44;			/* Inner "minor" byte count */

	DMA_A.TCD[28].SLAST.R = -44;				/* TCD Last Source Address Adjustment */

	DMA_A.TCD[28].DADDR.R = (vuint32_t)&rdc_data.sin08;	/* Destination address */

	DMA_A.TCD[28].CITER.ELINKNO.B.ELINK = 0;			/* Disable channel-to-channel linking on minor-loop complete */
	DMA_A.TCD[28].CITER.ELINKNO.B.CITER = 1;			/* Current major iteration count */

	DMA_A.TCD[28].DOFF.R = 4;							/* Signed destination address offset */

	DMA_A.TCD[28].DLASTSGA.R = -44; 					/* Last destination address adjustment /scatter gather  address */

	DMA_A.TCD[28].BITER.ELINKNO.B.ELINK = 0;			/* Disable channel-to-channel linking on minor loop complete */
	DMA_A.TCD[28].BITER.ELINKNO.B.BITER = 1;			/* Beginning major iteration count */
	DMA_A.TCD[28].CSR.B.MAJORELINK = 0;				/* Enable channel-to-channel linking on major loop complete */
	DMA_A.TCD[28].CSR.B.INTMAJOR = 1;				/* Enable an interrupt when major iteration count completes. */

}


void edma_start(void)
{
	/* Enable eDMA channels*/
//	DMA_B.SERQ.R = 36;		/* SDADC0 result ready */
//	DMA_B.SERQ.R = 39;		/* SDADC3 result ready */
//	DMA_B.SERQ.R = 48;	/* linked by DMA_B ch 36 */
	DMA_A.SERQ.R = 28;	/* Resolver DMA Request */

}

