/******************************************************************************
*  Serial.C                                   *
*
*   Low Level Serial Routines for Serial Port 1                                                                         
*    
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.       
*                                                                            
******************************************************************************/

#include "LPC230x.H"             /* LPC21xx definitions               */
#include "command.h"
#define CR     0x0D				 /* ASCII Carraige return */ 

unsigned char temp_char;

unsigned char int_id;
unsigned char int_source;

unsigned char rcv_buf;
extern unsigned char proc_cmd;


#define UART1                                  

/* If UART 0 is used for printf                                               */
#ifdef UART0
  #define UxFDR  U0FDR
  #define UxLCR  U0LCR
  #define UxDLL  U0DLL
  #define UxDLM  U0DLM
  #define UxLSR  U0LSR
  #define UxTHR  U0THR
  #define UxRBR  U0RBR
/* If UART 1 is used for printf                                               */
#elif defined(UART1)
  #define UxFDR  U1FDR
  #define UxLCR  U1LCR
  #define UxDLL  U1DLL
  #define UxDLM  U1DLM
  #define UxLSR  U1LSR
  #define UxTHR  U1THR
  #define UxRBR  U1RBR
#endif


void init_serial (void)  {               // Initialize Serial Interface       
  #ifdef UART0
    PINSEL0 |= 0x00000050;               // Enable TxD0 and RxD0             
  #elif defined (UART1)
    PINSEL0 |= 0x40000000;               // Enable TxD1                       
    PINSEL1 |= 0x00000001;               // Enable RxD1                       
  #endif
  UxFDR    = 0xA1;                          // Fractional divider 9600@12mhz      */
//  UxFDR    = 0x00;                          // Fractional divider not used       */
  UxLCR    = 0x83;                       // 8 bits, no Parity, 1 Stop bit     
//  UxDLL    = xx;                         // 9600 Baud Rate @ 14.4 MHZ PCLK   
  UxDLL    = 71;                         // 9600 Baud Rate @ 12 MHZ PCLK    
  UxDLM    = 0;                          // High divisor latch = 0            
  UxLCR    = 0x03;                       // DLAB = 0                         
  U1IER = 0x05;			  // Enable U1RBR Interrupt
}

void serial_1 (void) __irq;    


char putchar (char ch)  	   // Write character to Serial Port    
{                  
  if (ch == '\n')  
  {
    while (!(UxLSR & 0x20));
    UxTHR = CR;                     // output CR 
  }
  while (!(UxLSR & 0x20));
  return(UxTHR = ch);
}


char getchar (void)  {                    // Read character from Serial Port   

  while (!(UxLSR & 0x01));
  return (UxRBR);
}

 void puthex (char hex) {                    // Write Hex Digit to Serial Port  
  if (hex > 9) putchar('A' + (hex - 10));
  else         putchar('0' +  hex);
}

void putstr (char *p) {                    // Write string 
  while (*p) {
    putchar (*p++);
  }
}

void put_long_hex (long value) 
{
  putstr ("0x");
  puthex((value >> 28) & 0x0F);		 // Write Hex Digits
  puthex((value >> 24) & 0x0F);
  puthex((value >> 20) & 0x0F);
  puthex((value >>16) & 0x0F);           
  puthex((value >>12) & 0x0F);
  puthex((value >> 8) & 0x0F);              
  puthex((value >> 4) & 0x0F);               
  puthex (value & 0x0F);
 }
                     
void serial_1 (void) __irq
{
  VICIntEnClr = 0x00000010;    // disable Timer0 Interrupt
								// prevents nested timer interrupt
  int_id = U1IIR;			// read int ID
  int_source = UxLSR;

  temp_char=getchar ();
  Menu(temp_char);			 //get menu and set flags (see commands.c)

  VICVectAddr = 0;            // Acknowledge Interrupt
  VICIntEnable |= 0x00000010;  // Enable Timer0
}

