/*****************************************************************************
*  Time.c   Timer 0 init, isr, and functions               
*                                  
*
*   IEC Medical Alert Tone Generator Application                                                                        
*   
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.                  
*                                                                            
******************************************************************************/

#include "LPC230X.H"                            // LPC21XX Peripheral Registers
#include "multi_tone_gen.h"
#include "command.h"
#include "seqencer.h"

 #define LED_A       0x01		  //   For MCB2300 Test 
 #define LED_B       0x02		  //   For MCB2300 Test
 #define LED_C       0x04		  //   For MCB2300 Test
 #define LED_D       0x08		  //   For MCB2300 Test

long timeval;
long sequence;
unsigned char alarm;
unsigned char note_on;		// flag to turn on tone
unsigned char note_level;
unsigned short mscount;
enum {GENERAL,OXYGEN,VENTILATION,CARDIOVASCULAR,TEMPERATURE,DRUG_DELIVERY,
		PERRFUSION,POWER_FAIL,LOW_ALARM};
		     
void tc0 (void) __irq ;
void EnvelopeControl(void);

void init_timer (void)
{
  T0MR0 = 479;                          // 40 uSec = 480-1 counts (25ksps @ 12 mhz) 
  T0MCR = 3;                            // Interrupt and Reset on MR0
  T0TCR = 1;                            // Timer0 Enable
  timeval=0;							// variable initializations
  mscount=0;
  sequence = 0;		
}

void tc0 (void) __irq 
{
	FIO2SET = LED_A;
	if (envelope_on )
	{
		OutputTones(active_note,note_level); // parameters are set in sequencer
	}
	FIO2CLR = LED_A;		  // used to test time to generate tones
	T0IR = 1;                              // Clear interrupt flag
   	VICVectAddr = 0;                           // Acknowledge Interrupt
	timeval++;
	if (timeval == 25)			// millisecond interval (@ 25 khz sample rate)
	{
	    if (sequence)
		{
			switch (priority)
	   		{
		 		case 1:
		 			HighPriSequence(alarm);
					break;
		 		case 2:
		 			MedPriSequence(alarm);
					break;
		 		case 3:
		 			LowPriSequence(alarm);
					break;
				case 4:
		 			TestSequence(alarm);
					break;
	   		}
		}
		mscount++;				// increment ms counter
		timeval = 0;			// clear interval counter
		EnvelopeControl();		
	}

}

