/**************************************************************
*  commands.c
*
*
* This Module contains the command handler and menus for the 
* Medical alert tone demo
*
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved. 	
*
**************************************************************/

#include <LPC23xx.H> 
#include "serial.h"	
#include "Timer.h"	
#include "VIC.h"
#include "seqencer.h"
#include "multi_tone_gen.h"

#define CR     0x0D				 // ASCII Carraige return 

unsigned char proc_cmd;
unsigned char k;
unsigned char valid_cmd;
unsigned char priority;

void Menu(unsigned char rcv_byte);
void HPCommnds(void);
void MPCommnds(void);
void LPCommnds(void); 
void TestCommnds(void);

// Test for command flag to be set, and process command if set. 

void cmd_test(void)
 {
  	if (proc_cmd)
	{
	   switch (priority)
	   {
		 case 1:
		 	HPCommnds();
			break;
		 case 2:
		 	MPCommnds();
			break;
		 case 3:
		 	LPCommnds();
			break;
		 case 4:
		 	TestCommnds();
			break;
	   }
	}
 }
void HPCommnds(void)
{
	switch (rcv_buf)
	{
	   case '1':		  
		 putstr ("High Priority General Alarm\n\n");
		 alarm = GENERAL;
		 sequence = 1;
		 break;
	   case '2':		  
		 putstr ("High Priority Cardiac Alarm\n\n");
		 alarm = CARDIOVASCULAR;
		 sequence = 1;
		 break;
	   case '3':		   
		 putstr ("High Priority Artificial Perfusion Alarm\n\n");
		 alarm = PERFUSION;
		 sequence = 1;
		 break;
	   case '4':		  
		 putstr ("High Priority Ventilation Alarm\n\n");
		 alarm = VENTILATION;
		 sequence = 1;
		 break;
	   case '5':		  
		 putstr ("High Priority Temperature Alarm\n\n");
		 alarm = TEMPERATURE;
		 sequence = 1;
		 break;
	   case '6':		   
		 putstr ("High Priority Oxygen Alarm\n\n"); 
		 alarm = OXYGEN;
		 sequence = 1;
		 break;
	   case '7':		 
		 putstr ("High Priority Drug Delivery Alarm\n\n");
		 alarm = DRUG_DELIVERY;
		 sequence = 1;
		 break;
	   case '8':	
		 putstr ("High Priority Equipment/Supply Failure Alarm\n\n");
		 alarm = POWER_FAIL;
		 sequence = 1;		 
		 break;	  
	   default:
		 putstr ("Command not supported\n\n");
		 break;	 
	   }
		proc_cmd=0;      // reset command status
		mscount = 0;
}
void MPCommnds(void)
{
	switch (rcv_buf)
	{
	   case '1':		  
		 putstr ("Command 1\n");
		 putstr ("Medium Priority General Alarm\n\n");
		 alarm = GENERAL;
		 sequence = 1;
		 break;
	   case '2':		  
		 putstr ("Medium  Priority Cardiac Alarm\n\n");
		 alarm = CARDIOVASCULAR;
		 sequence = 1;
		 break;
	   case '3':		   
		 putstr ("Medium  Priority Artificial Perfusion Alarm\n\n");
		 alarm = PERFUSION;
		 sequence = 1;
		 break;
	   case '4':		  
		 putstr ("Medium  Priority Ventilation Alarm\n\n");
		 alarm = VENTILATION;
		 sequence = 1;		 
		 break;
	   case '5':		  
		 putstr ("Medium  Priority Temperature Alarm\n\n");
		 alarm = TEMPERATURE;
		 sequence = 1;
		 break;
	   case '6':		   
		 putstr ("Medium  Priority Oxygen Alarm\n\n"); 
		 alarm = OXYGEN;
		 sequence = 1;
		 break;
	   case '7':		   
		 putstr ("Medium  Priority Drug Delivery Alarm\n\n");
		 alarm = DRUG_DELIVERY;
		 sequence = 1;
		 break;
	   case '8':	
		 putstr ("Medium  Priority Equipment/Supply Failure Alarm\n\n");
		 alarm = POWER_FAIL;
		 sequence = 1;
		 break;	  
	   default:
		 putstr ("Command not supported\n\n");
		 break;	 
	   }
		proc_cmd=0;      // reset command status
		mscount = 0;
}
void LPCommnds(void)
{
	switch (rcv_buf)
	{
	   case '1':		  
		 putstr ("Low Priority Alarm\n\n");
		 alarm = LOW_ALARM;
		 sequence = 1;
		 break;
 
	   default:
		 putstr ("Command not supported\n\n");
		 break;	 
	   }
		proc_cmd=0;      // reset command status
		mscount = 0;
}

void TestCommnds(void)
{
	switch (rcv_buf)
	{
	   case '1':		  
		 putstr ("Sound Low Multi Tone\n\n");
		 active_note = C4;
		 sequence = 1;
		 mscount = 0;
		 break;
	   case '2':		  
		 putstr ("Sound High Multi Tone\n\n");
		 active_note = C5;
		 sequence = 1;
		 mscount = 0;
		 break;
	   case '3':		   
		 putstr ("Sound Low Single Tone\n\n");
		 active_note = C4;
		 ToneWeights[0]= 255;
		 ToneWeights[1]= 0;
		 ToneWeights[2]= 0;
		 ToneWeights[3]= 0;
		 ToneWeights[4]= 0;
		 sequence = 1;
		 mscount = 0;
		 putstr ("\n\n");
		 break;
	   case '4':		  
		 putstr ("Sound High Single Tone\n\n");
		 active_note = C5;
		 ToneWeights[0]= 0;
		 ToneWeights[1]= 0;
		 ToneWeights[2]= 0;
		 ToneWeights[3]= 0;
		 ToneWeights[4]= 255;
		 sequence = 1;
		 mscount = 0;
		 break;
	   case '5':		   
		 putstr ("Reset Test Settings\n\n");
		 ToneWeights[0]= 255;
		 ToneWeights[1]= 255;
		 ToneWeights[2]= 255;
		 ToneWeights[3]= 255;
		 ToneWeights[4]= 255;
		 break;
	   case '6':		  
		 putstr ("\n\n"); 
		 break;  
	   default:
		 putstr ("Command not supported\n\n");
		 break;	 
	   }
		proc_cmd=0;      // reset command status
}
void CommandInit(void)
{
 	  valid_cmd = 0;		  // initialize valid command status
	  proc_cmd = 0;			  // initialize process command status
	  k=0;
}
// Menus

void Menu(unsigned char rcv_byte)
{
  switch (rcv_byte)
  {
    case 'h':		  // 'c'
   		k=0;			  // reset index
		putstr ("\nCommands:\n\n");
	    putstr ("Command Number 1 - High Priority General Alarm\n");
		putstr ("Command Number 2 - High Priority Cardiac Alarm\n");		
		putstr ("Command Number 3 - High Priority Artificial Perfusion Alarm\n");
		putstr ("Command Number 4 - High Priority Ventilation Alarm\n");
		putstr ("Command Number 5 - High Priority Temperature Alarm\n");
		putstr ("Command Number 6 - High Priority Oxygen Alarm\n");
	    putstr ("Command Number 7 - High Priority Drug Delivery Alarm\n");
		putstr ("Command Number 8 - High Priority Equipment/Supply Failure Alarm\n");
		putstr ("\nEnter Command Number then <CR>\n\n");
		valid_cmd=1;
		priority = 1;
		break;
	case 'm':		  // 'c'
   		k=0;			  // reset index
		putstr ("\nCommands:\n\n");
	    putstr ("Command Number 1 - Medium Priority General Alarm\n");
		putstr ("Command Number 2 - Medium Priority Cardiac Alarm\n");		
		putstr ("Command Number 3 - Medium Priority Artificial Perfusion Alarm\n");
		putstr ("Command Number 4 - Medium Priority Ventilation Alarm\n");
		putstr ("Command Number 5 - Medium Priority Temperature Alarm\n");
		putstr ("Command Number 6 - Medium Priority Oxygen Alarm\n");
	    putstr ("Command Number 7 - Medium Priority Drug Delivery Alarm\n");
		putstr ("Command Number 8 - Medium Priority Equipment/Supply Failure Alarm\n");
		putstr ("\nEnter Command Number then <CR>\n\n");
		valid_cmd=1;
		priority = 2;
		break;
	case 'l':		  // 'c'
   		k=0;			  // reset index
		putstr ("\nCommands:\n\n");
	    putstr ("Command Number 1 - Low Priority General Alarm\n");
		putstr ("\nEnter Command Number then <CR>\n\n");
		valid_cmd=1;
		priority = 3;
		break;
	case 't':		  // 'c'
   		k=0;			  // reset index
		putstr ("\nCommands:\n\n");
	    putstr ("Command Number 1 - Sound Low Multi-Tone\n");
		putstr ("Command Number 2 - Sound High Multi-Tone\n");
		putstr ("Command Number 3 - Sound Low Single Tone\n");
		putstr ("Command Number 4 - Sound High Single Tone\n");
		putstr ("Command Number 5 - Reset Test Settings\n");
		putstr ("\nEnter Command Number then <CR>\n\n");
		valid_cmd=1;
		priority = 4;
		break;
	case CR:			   // process when CR is entered
		if (valid_cmd)
		{
		  putstr ("\nCommand Received\n");
		  proc_cmd=1;		// set command process status				
		  valid_cmd=0;	    // reset valid commanad status
		}
		break;
	default:
		if (valid_cmd)
		{
		  rcv_buf=rcv_byte;
		  k++;
		}
		break;
  }
}

void ResetMenu(void)
{
	putstr ("Press 'h' for High Priority Alarm Menu\n");
	putstr ("Press 'm' for Medium Priority Alarm Menu\n");
	putstr ("Press 'l' for Low Priority Alarm Menu\n");
	putstr ("Press 't' for Test Menu\n");
}




