/******************************************************************************
*      Tones_demo.C:                         
*
*      This module contains the "main" function for the IEC60601-1-8 alarm tone                                                                      
*      synthesizer. The main function initializes peripnerals and variables and                                                 		  
*      provides for a command test in the main loop to handle incoming commands.
*  
*   Copyright(C) 2007, NXP Semiconductor
*   All rights reserved.                                                                    
******************************************************************************/
                  
#include "LPC23xx.H"         
#include "Timer.h"		   
#include "serial.h"	  	// Call functions putchar, getchar, init_serial, etc 
#include "VIC.h"		// call function VIC_init()
#include "multi_tone_gen.h"
#include "command.h"
#include "seqencer.h"
#include "t1pwm_clk.h"
extern void LED_init (void);
extern void io_init (void);

extern void cmd_test(void);

 /* Main */

int main (void) 
{
  io_init ();
  init_timer();
  init_serial();                    // Initialize Serial Interface  
  VIC_init();
  CommandInit();
  init_seqencer();
  InitT1PWM();		  
  InitToneCoefArray();
  ResetMenu();
  DACR = 0x8000;					// init DAC to half on voltage

  while (1)  
  {                                 
	cmd_test();		// poll for command
  }
}
