/*****************************************************************************
** 
**	Timer16 Driver for the self wake up example
** 
*****************************************************************************/

#include "LPC11xx.h"
#include "timer16_tk.h"

void Init_Timer( uint32_t TimerNum, uint32_t SystemFreq, uint32_t matchOutputInterval){

	/* 	SystemFreq is the freq outputted by the system clock
		Output of the AHBCLKDIV	*/
	/*	Calc prescaler needed for 10ms * TimerInterval*/
	volatile uint32_t prescaler = (SystemFreq / 100) - 1;
	/*  matchOutputInterval is in terms of ms; but each increment is @ 10ms (thus div 10) */
	volatile uint32_t match     = (matchOutputInterval / 10) - 1;


	if(TimerNum == 0){
		/* Turn on 16-bit Timer 0 and IOCON, in case it hasn't already been turned on */
		LPC_SYSCON->SYSAHBCLKCTRL	|=	(1<<7) | (1<<16);
		
		/* Disable and Reset Timer */
		LPC_TMR16B0->TCR = (1<<1);

		/* Setup Timer prescaler */
		LPC_TMR16B0->PR	=	prescaler;

		/* Match Reg 0: Interrupt Disabled, Reset Enabled, Do not Stop */
		LPC_TMR16B0->MCR =	(1<<1);

		/* Match Reg 0 value */
		LPC_TMR16B0->MR0 =	match;

		/* External Match; Clear output and set on match */
		LPC_TMR16B0->EMR =	(0x2<<4);

		/* Enable MAT0 onto IOCON: CT16BO_MAT0: PIO0_8 */
		LPC_IOCON->PIO0_8 = (2<<0);

	}else{
		/* Turn on 16-bit Timer 1, in case it hasn't already been turned on */
		LPC_SYSCON->SYSAHBCLKCTRL	|=	(1<<8) | (1<<16);

		/* Disable and Reset Timer */
		LPC_TMR16B1->TCR = (1<<1);

		/* Setup Timer prescaler */
		LPC_TMR16B1->PR	=	prescaler;

		/* Match Reg 0: Interrupt Disabled, Reset Enabled, Do not Stop */
		LPC_TMR16B1->MCR =	(1<<1);

		/* Match Reg 0 value */
		LPC_TMR16B1->MR0 =	match;

		/* External Match; Clear output and set on match */
		LPC_TMR16B1->EMR =	(0x2<<4);

		/* Enable MAT0 onto IOCON: CT16B1_MAT0: PIO1_9 */
		LPC_IOCON->PIO1_9 =	(1<<0);
	}

	return;
}

void DeInit_Timer( uint32_t TimerNum ){
	
	if(TimerNum == 0) {
		/* Disable and Reset */
		LPC_TMR16B0->TCR = (1<<1);
		
		/* Turn of 16-bit Timer 0 */
		LPC_SYSCON->SYSAHBCLKCTRL	&=	~(1<<7);
	}else{
		/* Disable and Reset */
		LPC_TMR16B1->TCR = (1<<1);

		/* Turn of 16-bit Timer 0 */
		LPC_SYSCON->SYSAHBCLKCTRL	&=	~(1<<8);
	}


}

void Enable_Timer ( uint32_t TimerNum ){
	/* Remove Reset and Enable Timer */	

	if(TimerNum == 0){
		LPC_TMR16B0->TCR = (1<<0);

	}else{
		LPC_TMR16B1->TCR = (1<<0);

	}
	return;
}

void Disable_Timer ( uint32_t TimerNum ){
	/* Disable and Reset Timer */
	
	if(TimerNum == 0){
		LPC_TMR16B0->TCR = (1<<1);

	}else{
		LPC_TMR16B1->TCR = (1<<1);

	}
	return;
}

void Clear_MAT0( uint32_t TimerNum ){
	/* Clear the match output register value */

	if(TimerNum == 0){
		LPC_TMR16B0->EMR  &= ~(1<<0);
	}else{
		LPC_TMR16B1->EMR  &= ~(1<<0);
	}
	return;
}
