//  ---------------------------------------------------------------------------
//                    Copyright Message
//  ---------------------------------------------------------------------------
//
//  NXP Semiconductors confidential and proprietary.
//  COPYRIGHT   2009 by NXP Semiconductors N.V.
//
//  All rights are reserved. Reproduction in whole or in part is
//  prohibited without the written consent of the copyright owner.
//
//  ---------------------------------------------------------------------------
//                    Design Information
//  ---------------------------------------------------------------------------
//
//  File         : $RCSfile: ezh.h,v $
//
//  Author       : Phil Cupryk
//
//  Description  : Macro definitions for EZH (Easy Handler) instructions
//
//  ---------------------------------------------------------------------------
//  $Id: ezh.h 4196 2010-08-04 08:36:51Z abj1819 $
//  $Source: d:/CVS/software/ezh_driver/inc/ezh.h,v $
//  ---------------------------------------------------------------------------

#ifndef ezh_h_file
#define ezh_h_file

// 2 bit instructions

#define E_AHB_READ(x)			DCD 0x01 + x
#define E_AHB_WRITE(x)			DCD 0x02 + x
#define E_GOSUB(a)             		DCD 0x03 + a

// config instructions

#define E_CFG_SRC(x)			DCD 0x00 + (x<<8)
#define E_CFG_MUX(x)			DCD 0x04 + (x<<5)
#define E_CLR_FLOPS(x)			DCD 0x08 + (x<<8)
#define E_ENABLE_ORS(x)			DCD 0x0c + (x<<8)

// execution flow

#define ACC1_ZERO         0x0
#define ACC1_CROSS_ZERO   0x1
#define ALWAYS_1          0x2
#define ALWAYS_0          0x3
#define ACC2_ZERO         0x4
#define ACC2_CROSS_ZERO   0x5
#define ACC1_NON_ZERO     0x6
#define ACC2_NON_ZERO     0x7

#define E_HOLD 				DCD 0x10
#define E_CHECK 			DCD 0x20
#define E_RETURN 			DCD 0x30
#define E_VECTORED_HOLD 		DCD 0x18
#define E_CHECK_ACC(x)			DCD 0x120 + ((x) << 29)
#define E_CHECK_IMM(x)			DCD 0x220 + ((x) << 24)
#define E_CHECK_IMM_NE(x)		DCD 0x420 + ((x) << 24)
#define E_CHECK_SET_IMM(x)	        DCD 0x820 + ((x) << 24)
#define E_CHECK_SET_IMM_NE(x)		DCD 0xC20 + ((x) << 24)
											// the pre-processor/linker will calculate it this way (<< relative not allowed)
#define E_GOTO(a)			DCD 0x3c + a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a + a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a

// accumulator instructions

#define E_ACC_ADD(source)		DCD 0x40 + (source<<8)	
#define E_ACC_ADD_IMM(x)		DCD 0x140 + (x<<16)
#define E_ACC2_ADD(source)		DCD 0x4c + (source<<8)
#define E_ACC2_ADD_IMM(x)		DCD 0x14c + (x<<16)
#define E_SWAP_ACCS 			DCD 0x50
#define E_OR(source) 			DCD 0x70 + (source<<8)
#define E_AND(source)			DCD 0x74 + (source<<8)
#define E_XOR(source)			DCD 0x78 + (source<<8)
#define E_MODIFY_ACC_BYTE(and_mask,or_mask,xor_mask)	DCD 0x1c + (and_mask<<24) + (or_mask<<16) + (xor_mask<<8)

#define E_OR_IMM(x) 		DCD 0x170 + ((x) << 24)
#define E_AND_IMM(x)		DCD 0x174 + ((x) << 24)
#define E_XOR_IMM(x)		DCD 0x178 + ((x) << 24)

// shift amounts
#define LEFT_1  	0x000
#define LEFT_2  	0x100
#define LEFT_8  	0x200
#define LEFT_16 	0x300
#define RIGHT_1 	0x400
#define RIGHT_2 	0x500
#define RIGHT_8 	0x600
#define RIGHT_16	0x700

#define E_SHIFT(shift)			DCD 0x7C + shift
#define E_ROTATE(shift)			DCD 0x7C + shift + 0x800
#define E_FLIP   			DCD 0x7C + 0x1000

#define E_INDIRECT_WRITE(source)		DCD (0x10014) + (source<<8) 
#define E_INDIRECT_READ(source)			DCD (0x00014) + (source<<8) 




// sources
#define GPI		0x03
#define GPO		0x0C
#define GPIO_DIR	0x30
#define BIT_SLICE	0x02

// source/destination
#define ACC1 		0x80
#define ACC2 		0x40
#define GPR1 		0x20
#define GPR2 		0x10
#define RDPTR		0x08
#define WRPTR		0x04

#define E_MOV(source,dest)	DCD 0x54 + (source<<8) + (dest<<16)		
#define E_LOAD_BYTE(x,dest) 	DCD 0x154 + (dest<<16) + (x<<24)

// output event

#define E_INT_TRIGGER(x) 		DCD 0x80 + (x<<8)
#define E_GPIO_DIR(source) 		DCD 0x90 +(source<<8)
#define E_GPIO_CLR(source) 		DCD 0x94 +(source<<8)
#define E_GPIO_SET(source) 		DCD 0x98 +(source<<8)
#define E_GPIO_WRITE(source)		DCD 0x9c +(source<<8)
#define E_GPIO_DIR_IMM(x) 		DCD 0x190 +(x<<24)
#define E_GPIO_CLR_IMM(x) 		DCD 0x194 +(x<<24)
#define E_GPIO_SET_IMM(x) 		DCD 0x198 +(x<<24)
#define E_GPIO_WR_IMM(x)		DCD 0x19c +(x<<24)

// miscellaneous instructions

#define E_READ_INC 			DCD 0xf4
#define E_WRITE_INC 			DCD 0xf8
#define E_READ_INC_BYTE 		DCD 0x1f4
#define E_WRITE_INC_BYTE 		DCD 0x1f8
#define E_NOP 				DCD 0xfc

#endif
