#ifndef nxp_rom_h_file
#define nxp_rom_h_file

//function type define for API

typedef int (*FUN1)(unsigned int ui_Data1, unsigned int ui_Data2, char c_Data);
typedef int (*FUN2)(unsigned char * uc_Pointer, unsigned int ui_Data);
typedef int (*FUN3)(void);

typedef int (*FUN4)(unsigned int ui_Data1, unsigned int ui_Data2, unsigned int ui_Data3);
typedef void (*FUN5)(unsigned int ui_Data1, unsigned char * uc_Pointer, unsigned int ui_Data2);
typedef void (*FUN6)(unsigned char * uc_Pointer);



//for euart02 api
#define ezh_uart_init_v02(x,y,z)	    			((FUN1)0x1ffe0f99)(x,y,z)
#define ezh_uart_send_v02(x,y) 			    	    ((FUN2)0x1ffe113b)(x,y)
#define ezh_uart_receive_v02(x,y)            	    ((FUN2)0x1ffe1175)(x,y)
#define ezh_uart_status_v02()	        			((FUN3)0x1ffe11b1)()

////for I2C DMA API
#define EZ_I2C_DMA_Init(x, y, z) 				    ((FUN4)0x1ffe0b41)(x, y, z)
#define EZ_I2C_DMA_Master_Transmit(x, y, z) 	    ((FUN5)0x1ffe0c3d)(x, y, z)
#define EZ_I2C_DMA_Master_Receive(x, y, z) 			((FUN5)0x1ffe0c5f)(x, y, z)
#define EZ_I2C_DMA_Slave_Transaction(x) 			((FUN6)0x1ffe0c81)(x)
#define EZ_I2C_DMA_GetStatus() 				        ((FUN3)0x1ffe0c8f)()

#endif//nxp_rom_h_file
