/******************************************************************************/
/* SERIAL.C: Low Level Serial Routines                                        */
/******************************************************************************/
/* This file is part of the uVision/ARM development tools.                    */
/* Copyright (c) 2005-2006 Keil Software. All rights reserved.                */
/* This software may only be used under the terms of a valid, current,        */
/* end user licence from KEIL for a compatible version of KEIL software       */
/* development tools. Nothing else gives you the right to use this software.  */
/******************************************************************************/

#include <LPC122x.h>                     /* LPC21xx definitions               */
#include "uart.h"

#define CR     0x0D

//#define UART_PORT		0
#define UART_PORT	    1

void uart_port_init(void)
{

#if (UART_PORT == 0)
  UARTInit(0, 115200);
#elif (UART_PORT == 1)
  UARTInit(1, 115200);
#endif

}

/* implementation of putchar (also used by printf function to output data)    */
int sendchar (int ch)  {                 /* Write character to Serial Port    */

#if (UART_PORT == 0)
  if (ch == '\n')  {
    while (!(LPC_UART0->LSR & 0x20));
    LPC_UART0->THR = CR;                          /* output CR */
  }
  while (!(LPC_UART0->LSR & 0x20));
  return (LPC_UART0->THR = ch);
#elif (UART_PORT == 1)
  if (ch == '\n')  {
    while (!(LPC_UART1->LSR & 0x20));
    LPC_UART1->THR = CR;                          /* output CR */
  }
  while (!(LPC_UART1->LSR & 0x20));
  return (LPC_UART1->THR = ch);
#endif


}


int getkey (void)  {                     /* Read character from Serial Port   */

#if (UART_PORT == 0)
  while (!(LPC_UART0->LSR & 0x01));
  return (LPC_UART0->RBR);
#elif (UART_PORT == 1)
  while (!(LPC_UART1->LSR & 0x01));
  return (LPC_UART1->RBR);
#endif


}
