/*****************************************************************************
 *   rtc.h:  Header file for NXP LPC11xx Family Microprocessors
 *
 *   Copyright(C) 2006, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2006.09.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __RTC_H 
#define __RTC_H
#define RTC_MATCH 1
#include <stdint.h>
typedef enum{
	RTC_CLK_1HZ 		= 0x0,
	RTC_CLK_DELAY_1HZ 	= 0x1,
	RTC_CLK_PCLK 		= 0x4,
	RTC_CLK_1KHZ 		= 0xA
}RTC_CLK_SEL;

extern void RTC_IRQHandler(void);
extern uint32_t RTC_Init(RTC_CLK_SEL mode, uint32_t pclkDiv);
extern void RTC_Match(uint32_t matchValue);
extern void RTC_Load(uint32_t timerValue);
#endif /* end __RTC_H */
/*****************************************************************************
**                            End Of File
******************************************************************************/
