/****************************************************************************
*   $Id:: LPC_ROM_DIV.c 7309 2011-05-02 19:26:52Z nxp28548         $        *
*   Project: Division API Example					    *
*									    *
*   Description:							    *
*			This project demonstrates LPC122x ROM based Division*
*
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
/* LPC12xx Peripheral Registers */
#include "LPC122x.h"
#include "LPC_ROM_DIV.h"

/*****************************************************************************
These are the stock signatures from ARM for EABI division

int __aeabi_idiv(int numerator, int denominator); 
unsigned __aeabi_uidiv(unsigned numerator, unsigned denominator); 
typedef struct { int quot, int rem; } idiv_return; 

typedef struct { unsigned quot, unsigned rem; } uidiv_return; 
__value_in_regs idiv_return __aeabi_idivmod(int numerator, int denominator); 
__value_in_regs uidiv_return __aeabi_uidivmod(unsigned numerator, unsigned denominator);
******************************************************************************/
__no_init static LPC_ROM_DIV_STRUCT buffer;
static LPC_ROM_DIV_STRUCT const *const pROMDiv = &buffer;

void ROM_Divide_Init(void)
{
  //Entry to ROM API Table - fixed location
  const void**const pROMTable = (const void**) LPC_122x_DIVROM_LOC;
  
  //Entry to Division API - location may vary across ROM versions
  LPC_ROM_DIV_STRUCT*const pDivAPI = (LPC_ROM_DIV_STRUCT*) pROMTable[0];
  
  //Copy from pDivAPI into buffer
  buffer.sidiv = pDivAPI->sidiv;
  buffer.uidiv = pDivAPI->uidiv;
  buffer.sidivmod = pDivAPI->sidivmod;
  buffer.uidivmod = pDivAPI->uidivmod;
}

int __aeabi_idiv(int numerator, int denominator)
{	   
  return ( pROMDiv->sidiv(numerator,denominator) );
}

unsigned __aeabi_uidiv(unsigned numerator, unsigned denominator)
{
  return ( pROMDiv->uidiv(numerator,denominator) );
}

__value_in_regs idiv_return __aeabi_idivmod(int numerator, int denominator)
{
  return pROMDiv->sidivmod(numerator,denominator);	
}

__value_in_regs uidiv_return __aeabi_uidivmod(unsigned numerator, unsigned denominator)
{
  return pROMDiv->uidivmod(numerator,denominator);
}
