/*****************************************************************************
 *   $Id:: LPC_ROM_DIV.h 6530 2011-02-22 21:06:29Z nxp28548              $		 *
 *   Project: Division API Example											 *
 *																			 *
 *   Description:															 *
 *			LPC122x ROM Division API			 							 *
 *																			 *
 *****************************************************************************/
#ifndef LPC122x_DIVROM_H
#define LPC122x_DIVROM_H

typedef struct { int quot; int rem; } idiv_return; 
typedef struct { unsigned quot; unsigned rem; } uidiv_return; 

typedef struct{
	/* Signed integer division */
	int			(*sidiv)	(int numerator, int denominator);
	/* Unsigned integer division */
	unsigned	(*uidiv) 	(unsigned numerator, unsigned denominator);
	/* Signed integer division with remainder */
	idiv_return	(*sidivmod)	(int numerator, int denominator);
	/* Unsigned integer division with remainder */
	uidiv_return(*uidivmod) (unsigned numerator, unsigned denominator);
} LPC_ROM_DIV_STRUCT;

/*	The value at this address is the entry to ROM Division API.
 	Once it is dereferenced, individual API functions can be used*/
#define LPC_122x_DIVROM_LOC (0x1FFC0000)

#endif//LPC122x_DIVROM_H
