/***********************************************************************
 * $Id: spifi_test.c 6475 2011-02-16 19:09:07Z nxp27266 $
 *
 * Project: LPC18xx Rev '-' SPIFI Example
 *
 * Description: SPIFI example project.
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/              
#include "LPC18xx.H"            
#include "type.h"
#include "uart.h"
#include "scu.h"
#include "config.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "spifi_rom_api.h"

#define SPIFI_PROGRAMMER 1
#define SPIFI_BOOTLOADER 0

#if SPIFI_PROGRAMMER
//#include "nxp_evb_blinky_image.c"
//#include "blinky_binary_image.c"
#include "spifi_bootloader_image.c"
#endif

/* This is the header for SPIFI boot. Add to the binary data generated by the perl script. */
/* If a boot is attempted without a header, the ROM will use execute-in-place which is
   likely to fail in rev '-' */
/*char bin_data_header[] =
{
0x1A, 0x00, (sizeof(bin_data)/512)+1, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
*/

#if SPIFI_PROGRAMMER
#if SPIFI_BOOTLOADER
#error no good!
#endif
#endif

SPIFIobj obj;

/**********************************************************************
 ** Function prototypes
 **********************************************************************/
void UARTIOInit(void);

long myblock[64*16];

void mycpy(unsigned long *dest, unsigned long *src, unsigned long bytes)
{
	unsigned long l = bytes / 4;

	if((l*4)!=bytes)
		while(1); // not a multiple of 4

	while(l)
	{
		*dest++ = *src++;
		l--;
	}
}

/**********************************************************************
 ** Function name:		
 **
 ** Description:		
 **						
 ** Parameters:			
 **
 ** Returned value:		
 **********************************************************************/
int main (void) 
{
	int rc, i;
	
	SystemInit();

#if USE_XTAL // Select XTAL or IRC in config.h
 	/* Set the XTAL oscillator frequency to 12MHz*/
	SetClock(XTAL, (CLKSRC_Type)12000000UL, DIV1);
	
	#if	defined(HITEX_BOARD)
		/* Set PL160M @ 10*15=150 MHz */
		SetPL160M(SRC_XTAL, 15);
	#elif defined (NXP_EVAL_BOARD)
	     /* NXP board does not have buffers on data/address bus lines so must run slower */
		/* Set PL160M @ 6*10=60 MHz */
		SetPL160M(SRC_XTAL, 6);
	#else /* Validation Board */
		/* Set PL160M @ 6*10=60 MHz */
		SetPL160M(SRC_XTAL, 6);
	#endif

	/* Run base M3 clock from PL160M, no division */
	SetClock(BASE_M3_CLK, SRC_PL160M_0, DIV1);
	/* Show base out clock on output */
	SetClock(BASE_OUT_CLK, SRC_XTAL, DIV1);
#else // USE IRC

	#if	defined(HITEX_BOARD)
		/* Set PL160M @ 10*12=120MHz */
		SetPL160M(SRC_IRC, 10);
    #elif defined (NXP_EVAL_BOARD)
	    /* NXP board does not have buffers on data/address bus lines so must run slower */
		/* Set PL160M @ 6*12=72MHz */
		SetPL160M(SRC_IRC, 6);
	#else /* Validation board */
		/* Set PL160M @ 6*12=72MHz */
		SetPL160M(SRC_IRC, 6);
	#endif

	/* Run base M3 clock from PL160M, div by 1 = no division */
	SetClock(BASE_M3_CLK, SRC_PL160M_0, DIV1);
	/* Show base out clock on output */
	SetClock(BASE_OUT_CLK, SRC_IRC, DIV1);
#endif

	/* Configure the external memory controller for SDRAM */
//	vEMC_InitSRDRAM(SDRAM_BASE_ADDR, SDRAM_WIDTH, SDRAM_SIZE_MBITS, SDRAM_DATA_BUS_BITS, SDRAM_COL_ADDR_BITS);

	/* Configure the IO's for the UART */
//	UARTIOInit();
	
	SetClock(BASE_UART1_CLK, SRC_PL160M_0, DIV1);

	UARTInit(1, 115200);	/* baud rate setting */

#if SPIFI_PROGRAMMER
	printf("Hello from the SPIFI_Programmer.\r\n");
	printf("The SPIFI flash will now be programmed with the SPIFI_Bootloader.\r\n");
#endif
#if SPIFI_BOOTLOADER
	printf("Hello from the SPIFI_Bootloader.\r\n");
	printf("The SPIFI flash will now be verified.\r\n");
#endif

	// Reset SPIFI peripheral
	*(unsigned long *)0x40053104 = 1<<21;

	rc = spifi_init(&obj, 1,1,1,1,0,0,0);
	if (rc)
	{
		printf ("spifi_init status = %d", rc);
		while(1);
	}

#if SPIFI_PROGRAMMER

	printf("Erasing SPIFI...");
	rc = spifi_erase(&obj, (char *)SPIFI_MEM_BASE, sizeof(bin_data_with_header) + (100*1024) + (128*64*4*16), NULL, 0);
	if (rc) {
		printf ("erase status = %d\n", rc);
		while(1);
	}

	printf("OK!\r\nProgramming bootloader image into SPIFI...");
	rc = spifi_program (&obj, (char *)bin_data_with_header, (char *)SPIFI_MEM_BASE,
               sizeof(bin_data_with_header), NULL, 0, 0);
	           /* 1 here forces erase ^ */
	if (rc) {
		printf ("program status = %d\n", rc);
		while(1);
	}
	printf("Success!\r\n");

	printf("Programming test sectors into SPIFI...\r\n");
	printf("Block ");
	for(i=0;i<128;i++)
	{
		volatile int j;

		for(j=0;j<64*16;j++)
			myblock[j] = i<<24 | j;

		printf("%d ", i);
		rc = spifi_program (&obj, (char *)myblock, (char *)(SPIFI_MEM_BASE+(100*1024)+(i*64*4*16)),
               sizeof(myblock), NULL, 0, 0);
		if(rc)
		{
			printf("Error rc=%d\r\n", rc);
			while(1);
		}
		for(j=0;j<1000000;j++)
			;
	}
	printf("Done!\r\n");
#endif

#if SPIFI_BOOTLOADER
	printf("Verifying test sectors in SPIFI...\r\n");
	printf("Block ");
	while(1)
	{
		int j;
		i = rand() % 128;

		printf("%d ", i);
		mycpy((unsigned long *)myblock, (unsigned long *)(SPIFI_MEM_BASE+(100*1024)+(i*64*4*16)), sizeof(myblock));

		for(j=0;j<64*16;j++)
		{
			if(myblock[j] != (i<<24 | j))
			{
				printf("Error\r\n");
				while(1);
			}
		}
	}
//	printf("Done!\r\n");
#endif

	while(1);
}

/*----------------------------------------------------------------------------
  Initialize Eagle validation board specific IO
 *----------------------------------------------------------------------------*/
void UARTIOInit(void)
{
	LPC_SCU->SFSP9_2 =  (0x3<<2) | 0x0;	/*	GPIO4_14: LD11 */
	LPC_SCU->SFSP6_10 = (0x3<<2) | 0x3;	/*	GPIO3_6: button 0 */
	LPC_SCU->SFSP4_0 =  (0x3<<2) | 0x0;	/*	GPIO2_0: button 1 */	

	LPC_GPIO4->DIR |= (1<<14);			// LD11 = output
	LPC_GPIO4->DIR |= (1<<11);			// LD11 = output
	LPC_GPIO3->DIR &= ~(1<<6);			// Button 0 = input
	LPC_GPIO2->DIR &= ~(1<<0);			// Button 1 = input
}

/**********************************************************************
 **                            End Of File
 **********************************************************************/
