/***********************************************************************
 * $Id:: application.h 3871 2010-07-16 11:50:22Z gerritdewaard         $
 *
 * Project: LPC1100 BLDC Motor Control AN  
 *
 * Description:
 *			
 *     
 *
 ***********************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 **********************************************************************/

#ifndef __APPLICATION_H 
#define __APPLICATION_H

#include <stdio.h>
#include <string.h>

/* Chip level includes */
#include <LPC11xx.h>
#include "driver_config.h"
#include "target_config.h"
#include "core_cm0.h"
#include "gpio.h"
#include "clkconfig.h"
#include "timer16.h"
#include "timer32.h"
#include "uart.h"
#include "i2c.h"
#include "rom_drivers.h"

/* Board level includes */
#include "oled.h"
#include "joystick.h"
#include "lm75a.h"

/* Application level includes */
#include "BLDC.h"
#include "PID.h"
#include "gui.h"
#ifdef __LPC11C2x
#include "can_romhandlers.h"
#endif
#include "comms.h"


#include "nxp_image.h"
#include "ea_image.h"

//#define __LPC111x
//#define __LPC11C2x

/****************************************************
	SOFTWARE VERSION STRING (max 16 chars/row, max 1 rows)
*****************************************************/
#define SW_VERSION_STRING "BLDC demo appl.\n20110223 rev A"

/****************************************************  
	SYSTEM PINOUT 
*****************************************************/

/****************************************************/
/* System setup										*/
/* Please see also driver_config.h for driver inits */
/****************************************************/
#ifdef __LPC11C2x // See Project properties-> Settings -> Symbols
#define USE_CAN 1					/* Enable (1)/ Disable (0) CAN  */
#else
#define USE_CAN 0					/* Enable (1)/ Disable (0) CAN  */
#endif

#define USE_UART 			1		/* Enable (1)/ Disable (0) UART */
#define USE_STARTUP_GUI 	0		/* Enable the startup graphics */

/* LPCXpresso Motor control peripherals */
#define MC_BOARD_ENABLE_OLED 			1
#define MC_BOARD_ENABLE_JOYSTICK		1
#define MC_BOARD_ENABLE_LM75			1
#define MC_BOARD_ENABLE_EEPROM			0


/****************************************************/
/* Systick definitions								*/
/****************************************************/
#define SysTick_VALUE		SystemCoreClock / 1000

/****************************************************/
/* Generic definitions 								*/
/****************************************************/

#ifndef NULL
#define NULL    ((void *)0)
#endif

#ifndef FALSE
#define FALSE   (0)
#endif

#ifndef TRUE
#define TRUE    (1)
#endif

/****************************************************/
/* TIMER related macros								*/
/****************************************************/
#define EMC0	4
#define EMC1	6
#define EMC2	8
#define EMC3	10

#define TIMER1	1
#define TIMER0	0

#define CAP_ENABLE 1
#define CAP_DISABLE 0
#define CAP_RISING 1
#define CAP_FALLING 2
#define CAP_EVENT 4

#define MATCH0	(1<<0)
#define MATCH1	(1<<1)
#define MATCH2	(1<<2)
#define MATCH3	(1<<3)

#define TEST_TIMER_NUM		1		/* 0 or 1 for 16-bit timers only */

/****************************************************/
/* BUTTON definitions  								*/
/****************************************************
	PIO0_4		BUT1		STOP
	PIO0_5		BUT2		START
	PIO0_6		BUT3		UP
	PIO0_7		BUT4		DOWN
*****************************************************/
#define BTN_STOP_PORT 	0
#define BTN_STOP_PIN  	4
#define BTN_START_PORT 	0
#define BTN_START_PIN  	5
#define BTN_UP_PORT 	0
#define BTN_UP_PIN  	6
#define BTN_DOWN_PORT 	0
#define BTN_DOWN_PIN  	7

#endif /* end __APPLICATION_H */

/*****************************************************************************
**                            End Of File
******************************************************************************/
